/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"fmt"
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const EipConnectionRequest_PROTOCOLVERSION uint16 = 0x01
const EipConnectionRequest_FLAGS uint16 = 0x00

// The data-structure of this message
type EipConnectionRequest struct {
	Parent *EipPacket
}

// The corresponding interface
type IEipConnectionRequest interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

///////////////////////////////////////////////////////////
// Accessors for discriminator values.
///////////////////////////////////////////////////////////
func (m *EipConnectionRequest) Command() uint16 {
	return 0x0065
}

func (m *EipConnectionRequest) InitializeParent(parent *EipPacket, sessionHandle uint32, status uint32, senderContext []uint8, options uint32) {
	m.Parent.SessionHandle = sessionHandle
	m.Parent.Status = status
	m.Parent.SenderContext = senderContext
	m.Parent.Options = options
}

func NewEipConnectionRequest(sessionHandle uint32, status uint32, senderContext []uint8, options uint32) *EipPacket {
	child := &EipConnectionRequest{
		Parent: NewEipPacket(sessionHandle, status, senderContext, options),
	}
	child.Parent.Child = child
	return child.Parent
}

func CastEipConnectionRequest(structType interface{}) *EipConnectionRequest {
	castFunc := func(typ interface{}) *EipConnectionRequest {
		if casted, ok := typ.(EipConnectionRequest); ok {
			return &casted
		}
		if casted, ok := typ.(*EipConnectionRequest); ok {
			return casted
		}
		if casted, ok := typ.(EipPacket); ok {
			return CastEipConnectionRequest(casted.Child)
		}
		if casted, ok := typ.(*EipPacket); ok {
			return CastEipConnectionRequest(casted.Child)
		}
		return nil
	}
	return castFunc(structType)
}

func (m *EipConnectionRequest) GetTypeName() string {
	return "EipConnectionRequest"
}

func (m *EipConnectionRequest) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *EipConnectionRequest) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.Parent.ParentLengthInBits())

	// Const Field (protocolVersion)
	lengthInBits += 16

	// Const Field (flags)
	lengthInBits += 16

	return lengthInBits
}

func (m *EipConnectionRequest) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func EipConnectionRequestParse(readBuffer utils.ReadBuffer) (*EipPacket, error) {
	if pullErr := readBuffer.PullContext("EipConnectionRequest"); pullErr != nil {
		return nil, pullErr
	}

	// Const Field (protocolVersion)
	protocolVersion, _protocolVersionErr := readBuffer.ReadUint16("protocolVersion", 16)
	if _protocolVersionErr != nil {
		return nil, errors.Wrap(_protocolVersionErr, "Error parsing 'protocolVersion' field")
	}
	if protocolVersion != EipConnectionRequest_PROTOCOLVERSION {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", EipConnectionRequest_PROTOCOLVERSION) + " but got " + fmt.Sprintf("%d", protocolVersion))
	}

	// Const Field (flags)
	flags, _flagsErr := readBuffer.ReadUint16("flags", 16)
	if _flagsErr != nil {
		return nil, errors.Wrap(_flagsErr, "Error parsing 'flags' field")
	}
	if flags != EipConnectionRequest_FLAGS {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", EipConnectionRequest_FLAGS) + " but got " + fmt.Sprintf("%d", flags))
	}

	if closeErr := readBuffer.CloseContext("EipConnectionRequest"); closeErr != nil {
		return nil, closeErr
	}

	// Create a partially initialized instance
	_child := &EipConnectionRequest{
		Parent: &EipPacket{},
	}
	_child.Parent.Child = _child
	return _child.Parent, nil
}

func (m *EipConnectionRequest) Serialize(writeBuffer utils.WriteBuffer) error {
	ser := func() error {
		if pushErr := writeBuffer.PushContext("EipConnectionRequest"); pushErr != nil {
			return pushErr
		}

		// Const Field (protocolVersion)
		_protocolVersionErr := writeBuffer.WriteUint16("protocolVersion", 16, 0x01)
		if _protocolVersionErr != nil {
			return errors.Wrap(_protocolVersionErr, "Error serializing 'protocolVersion' field")
		}

		// Const Field (flags)
		_flagsErr := writeBuffer.WriteUint16("flags", 16, 0x00)
		if _flagsErr != nil {
			return errors.Wrap(_flagsErr, "Error serializing 'flags' field")
		}

		if popErr := writeBuffer.PopContext("EipConnectionRequest"); popErr != nil {
			return popErr
		}
		return nil
	}
	return m.Parent.SerializeParent(writeBuffer, m, ser)
}

func (m *EipConnectionRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
