/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/internal/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// The data-structure of this message
type BACnetAddress struct {
	Address []uint8
	Port    uint16
}

// The corresponding interface
type IBACnetAddress interface {
	LengthInBytes() uint16
	LengthInBits() uint16
	Serialize(writeBuffer utils.WriteBuffer) error
}

func NewBACnetAddress(address []uint8, port uint16) *BACnetAddress {
	return &BACnetAddress{Address: address, Port: port}
}

func CastBACnetAddress(structType interface{}) *BACnetAddress {
	castFunc := func(typ interface{}) *BACnetAddress {
		if casted, ok := typ.(BACnetAddress); ok {
			return &casted
		}
		if casted, ok := typ.(*BACnetAddress); ok {
			return casted
		}
		return nil
	}
	return castFunc(structType)
}

func (m *BACnetAddress) GetTypeName() string {
	return "BACnetAddress"
}

func (m *BACnetAddress) LengthInBits() uint16 {
	return m.LengthInBitsConditional(false)
}

func (m *BACnetAddress) LengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	// Array field
	if len(m.Address) > 0 {
		lengthInBits += 8 * uint16(len(m.Address))
	}

	// Simple field (port)
	lengthInBits += 16

	return lengthInBits
}

func (m *BACnetAddress) LengthInBytes() uint16 {
	return m.LengthInBits() / 8
}

func BACnetAddressParse(readBuffer utils.ReadBuffer) (*BACnetAddress, error) {
	if pullErr := readBuffer.PullContext("BACnetAddress"); pullErr != nil {
		return nil, pullErr
	}

	// Array field (address)
	if pullErr := readBuffer.PullContext("address", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, pullErr
	}
	// Count array
	address := make([]uint8, uint16(4))
	for curItem := uint16(0); curItem < uint16(uint16(4)); curItem++ {
		_item, _err := readBuffer.ReadUint8("", 8)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'address' field")
		}
		address[curItem] = _item
	}
	if closeErr := readBuffer.CloseContext("address", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, closeErr
	}

	// Simple Field (port)
	port, _portErr := readBuffer.ReadUint16("port", 16)
	if _portErr != nil {
		return nil, errors.Wrap(_portErr, "Error parsing 'port' field")
	}

	if closeErr := readBuffer.CloseContext("BACnetAddress"); closeErr != nil {
		return nil, closeErr
	}

	// Create the instance
	return NewBACnetAddress(address, port), nil
}

func (m *BACnetAddress) Serialize(writeBuffer utils.WriteBuffer) error {
	if pushErr := writeBuffer.PushContext("BACnetAddress"); pushErr != nil {
		return pushErr
	}

	// Array Field (address)
	if m.Address != nil {
		if pushErr := writeBuffer.PushContext("address", utils.WithRenderAsList(true)); pushErr != nil {
			return pushErr
		}
		for _, _element := range m.Address {
			_elementErr := writeBuffer.WriteUint8("", 8, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'address' field")
			}
		}
		if popErr := writeBuffer.PopContext("address", utils.WithRenderAsList(true)); popErr != nil {
			return popErr
		}
	}

	// Simple Field (port)
	port := uint16(m.Port)
	_portErr := writeBuffer.WriteUint16("port", 16, (port))
	if _portErr != nil {
		return errors.Wrap(_portErr, "Error serializing 'port' field")
	}

	if popErr := writeBuffer.PopContext("BACnetAddress"); popErr != nil {
		return popErr
	}
	return nil
}

func (m *BACnetAddress) String() string {
	if m == nil {
		return "<nil>"
	}
	buffer := utils.NewBoxedWriteBufferWithOptions(true, true)
	m.Serialize(buffer)
	return buffer.GetBox().String()
}
