/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef PLC4C_S7_READ_WRITE_SYNTAX_ID_TYPE_H_
#define PLC4C_S7_READ_WRITE_SYNTAX_ID_TYPE_H_

#include <stdbool.h>
#include <stdint.h>
#include <plc4c/driver_s7_static.h>
#include <plc4c/spi/read_buffer.h>
#include <plc4c/spi/write_buffer.h>

// Code generated by code-generation. DO NOT EDIT.


#ifdef __cplusplus
extern "C" {
#endif

enum plc4c_s7_read_write_syntax_id_type {
  plc4c_s7_read_write_syntax_id_type_S7ANY = 0x01,
  plc4c_s7_read_write_syntax_id_type_PBC_ID = 0x13,
  plc4c_s7_read_write_syntax_id_type_ALARM_LOCKFREESET = 0x15,
  plc4c_s7_read_write_syntax_id_type_ALARM_INDSET = 0x16,
  plc4c_s7_read_write_syntax_id_type_ALARM_ACKSET = 0x19,
  plc4c_s7_read_write_syntax_id_type_ALARM_QUERYREQSET = 0x1A,
  plc4c_s7_read_write_syntax_id_type_NOTIFY_INDSET = 0x1C,
  plc4c_s7_read_write_syntax_id_type_NCK = 0x82,
  plc4c_s7_read_write_syntax_id_type_NCK_METRIC = 0x83,
  plc4c_s7_read_write_syntax_id_type_NCK_INCH = 0x84,
  plc4c_s7_read_write_syntax_id_type_DRIVEESANY = 0xA2,
  plc4c_s7_read_write_syntax_id_type_SYM1200 = 0xB2,
  plc4c_s7_read_write_syntax_id_type_DBREAD = 0xB0
};
typedef enum plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type;

// Get an empty NULL-struct
plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type_null();

plc4c_return_code plc4c_s7_read_write_syntax_id_type_parse(plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_syntax_id_type** message);

plc4c_return_code plc4c_s7_read_write_syntax_id_type_serialize(plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_syntax_id_type* message);

plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type_value_of(char* value_string);

int plc4c_s7_read_write_syntax_id_type_num_values();

plc4c_s7_read_write_syntax_id_type plc4c_s7_read_write_syntax_id_type_value_for_index(int index);

uint16_t plc4c_s7_read_write_syntax_id_type_length_in_bytes(plc4c_s7_read_write_syntax_id_type* message);

uint16_t plc4c_s7_read_write_syntax_id_type_length_in_bits(plc4c_s7_read_write_syntax_id_type* message);

#ifdef __cplusplus
}
#endif

#endif  // PLC4C_S7_READ_WRITE_SYNTAX_ID_TYPE_H_
