/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/
package org.apache.plc4x.java.knxnetip.ets5.model;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.plc4x.java.ets5.passive.KNXGroupAddress;

import java.util.Map;

public class Ets5Model {

    private final byte groupAddressType;
    private final Map<KNXGroupAddress, GroupAddress> groupAddresses;

    public Ets5Model(byte groupAddressType, Map<KNXGroupAddress, GroupAddress> groupAddresses) {
        this.groupAddressType = groupAddressType;
        this.groupAddresses = groupAddresses;
    }

    public byte getGroupAddressType() {
        return groupAddressType;
    }

    public Map<KNXGroupAddress, GroupAddress> getGroupAddresses() {
        return groupAddresses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof Ets5Model)) {
            return false;
        }

        Ets5Model ets5Model = (Ets5Model) o;

        return new EqualsBuilder()
            .append(getGroupAddressType(), ets5Model.getGroupAddressType())
            .append(getGroupAddresses(), ets5Model.getGroupAddresses())
            .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37)
            .append(getGroupAddressType())
            .append(getGroupAddresses())
            .toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE)
            .append("groupAddressType", groupAddressType)
            .append("groupAddresses", groupAddresses)
            .toString();
    }

}
