/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/
package org.apache.plc4x.java.mock.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.apache.plc4x.java.base.connection.ChannelFactory;

public class TestChannelFactory implements ChannelFactory {

    private EmbeddedChannel channel;

    @Override
    public Channel createChannel(ChannelHandler channelHandler) {
        channel = new EmbeddedChannel(channelHandler);
        return channel;
    }

    @Override
    public void ping() {
        // Ignore ...
    }

    public EmbeddedChannel getChannel() {
        return channel;
    }

}
