/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
*/

namespace org.apache.plc4net.messages
{
    /// <summary>
    /// Builds requests for reading values from a PLC
    /// </summary>
    public interface IPlcReadRequestBuilder: IPlcRequestBuilder<IPlcReadRequest>
    {
        /// <summary>
        /// Add an item to the request
        /// </summary>
        /// <param name="name">Name of the field to add</param>
        /// <param name="fieldQuery">Query string for the field parameter</param>
        /// <returns>Request builder to allow fluent API calls</returns>
        IPlcReadRequestBuilder AddItem(string name, string fieldQuery);
    }
}