/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BACnetLiftCarMode {
  UNKNOWN((int) 0),
  NORMAL((int) 1),
  VIP((int) 2),
  HOMING((int) 3),
  PARKING((int) 4),
  ATTENDANT_CONTROL((int) 5),
  FIREFIGHTER_CONTROL((int) 6),
  EMERGENCY_POWER((int) 7),
  INSPECTION((int) 8),
  CABINET_RECALL((int) 9),
  EARTHQUAKE_OPERATION((int) 10),
  FIRE_OPERATION((int) 11),
  OUT_OF_SERVICE((int) 12),
  OCCUPANT_EVACUATION((int) 13),
  VENDOR_PROPRIETARY_VALUE((int) 0XFFFF);
  private static final Map<Integer, BACnetLiftCarMode> map;

  static {
    map = new HashMap<>();
    for (BACnetLiftCarMode value : BACnetLiftCarMode.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  BACnetLiftCarMode(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static BACnetLiftCarMode enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
