/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsMultiRequestItemReadWrite extends AdsMultiRequestItem implements Message {

  // Accessors for discriminator values.
  public Long getIndexGroup() {
    return (long) 61570L;
  }

  // Properties.
  protected final long itemIndexGroup;
  protected final long itemIndexOffset;
  protected final long itemReadLength;
  protected final long itemWriteLength;

  public AdsMultiRequestItemReadWrite(
      long itemIndexGroup, long itemIndexOffset, long itemReadLength, long itemWriteLength) {
    super();
    this.itemIndexGroup = itemIndexGroup;
    this.itemIndexOffset = itemIndexOffset;
    this.itemReadLength = itemReadLength;
    this.itemWriteLength = itemWriteLength;
  }

  public long getItemIndexGroup() {
    return itemIndexGroup;
  }

  public long getItemIndexOffset() {
    return itemIndexOffset;
  }

  public long getItemReadLength() {
    return itemReadLength;
  }

  public long getItemWriteLength() {
    return itemWriteLength;
  }

  @Override
  protected void serializeAdsMultiRequestItemChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AdsMultiRequestItemReadWrite");

    // Simple Field (itemIndexGroup)
    writeSimpleField("itemIndexGroup", itemIndexGroup, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (itemIndexOffset)
    writeSimpleField("itemIndexOffset", itemIndexOffset, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (itemReadLength)
    writeSimpleField("itemReadLength", itemReadLength, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (itemWriteLength)
    writeSimpleField("itemWriteLength", itemWriteLength, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("AdsMultiRequestItemReadWrite");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AdsMultiRequestItemReadWrite _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (itemIndexGroup)
    lengthInBits += 32;

    // Simple field (itemIndexOffset)
    lengthInBits += 32;

    // Simple field (itemReadLength)
    lengthInBits += 32;

    // Simple field (itemWriteLength)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static AdsMultiRequestItemBuilder staticParseAdsMultiRequestItemBuilder(
      ReadBuffer readBuffer, Long indexGroup) throws ParseException {
    readBuffer.pullContext("AdsMultiRequestItemReadWrite");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long itemIndexGroup = readSimpleField("itemIndexGroup", readUnsignedLong(readBuffer, 32));

    long itemIndexOffset = readSimpleField("itemIndexOffset", readUnsignedLong(readBuffer, 32));

    long itemReadLength = readSimpleField("itemReadLength", readUnsignedLong(readBuffer, 32));

    long itemWriteLength = readSimpleField("itemWriteLength", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("AdsMultiRequestItemReadWrite");
    // Create the instance
    return new AdsMultiRequestItemReadWriteBuilderImpl(
        itemIndexGroup, itemIndexOffset, itemReadLength, itemWriteLength);
  }

  public static class AdsMultiRequestItemReadWriteBuilderImpl
      implements AdsMultiRequestItem.AdsMultiRequestItemBuilder {
    private final long itemIndexGroup;
    private final long itemIndexOffset;
    private final long itemReadLength;
    private final long itemWriteLength;

    public AdsMultiRequestItemReadWriteBuilderImpl(
        long itemIndexGroup, long itemIndexOffset, long itemReadLength, long itemWriteLength) {
      this.itemIndexGroup = itemIndexGroup;
      this.itemIndexOffset = itemIndexOffset;
      this.itemReadLength = itemReadLength;
      this.itemWriteLength = itemWriteLength;
    }

    public AdsMultiRequestItemReadWrite build() {
      AdsMultiRequestItemReadWrite adsMultiRequestItemReadWrite =
          new AdsMultiRequestItemReadWrite(
              itemIndexGroup, itemIndexOffset, itemReadLength, itemWriteLength);
      return adsMultiRequestItemReadWrite;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsMultiRequestItemReadWrite)) {
      return false;
    }
    AdsMultiRequestItemReadWrite that = (AdsMultiRequestItemReadWrite) o;
    return (getItemIndexGroup() == that.getItemIndexGroup())
        && (getItemIndexOffset() == that.getItemIndexOffset())
        && (getItemReadLength() == that.getItemReadLength())
        && (getItemWriteLength() == that.getItemWriteLength())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getItemIndexGroup(),
        getItemIndexOffset(),
        getItemReadLength(),
        getItemWriteLength());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
