/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableL is an enum
type OpcuaNodeIdServicesVariableL int32

type IOpcuaNodeIdServicesVariableL interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_LastChangeTime             OpcuaNodeIdServicesVariableL = 18960
	OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteInserts              OpcuaNodeIdServicesVariableL = 18961
	OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDeletes              OpcuaNodeIdServicesVariableL = 18962
	OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDrops                OpcuaNodeIdServicesVariableL = 18963
	OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteAgeouts              OpcuaNodeIdServicesVariableL = 18964
	OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisIdSubtype            OpcuaNodeIdServicesVariableL = 18966
	OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisId                   OpcuaNodeIdServicesVariableL = 18967
	OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemName                  OpcuaNodeIdServicesVariableL = 18968
	OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemDescription           OpcuaNodeIdServicesVariableL = 18969
	OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesSupported OpcuaNodeIdServicesVariableL = 18970
	OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesEnabled   OpcuaNodeIdServicesVariableL = 18971
)

var OpcuaNodeIdServicesVariableLValues []OpcuaNodeIdServicesVariableL

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableLValues = []OpcuaNodeIdServicesVariableL{
		OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_LastChangeTime,
		OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteInserts,
		OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDeletes,
		OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDrops,
		OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteAgeouts,
		OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisIdSubtype,
		OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisId,
		OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemName,
		OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemDescription,
		OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesSupported,
		OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesEnabled,
	}
}

func OpcuaNodeIdServicesVariableLByValue(value int32) (enum OpcuaNodeIdServicesVariableL, ok bool) {
	switch value {
	case 18960:
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_LastChangeTime, true
	case 18961:
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteInserts, true
	case 18962:
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDeletes, true
	case 18963:
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDrops, true
	case 18964:
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteAgeouts, true
	case 18966:
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisIdSubtype, true
	case 18967:
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisId, true
	case 18968:
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemName, true
	case 18969:
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemDescription, true
	case 18970:
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesSupported, true
	case 18971:
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesEnabled, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableLByName(value string) (enum OpcuaNodeIdServicesVariableL, ok bool) {
	switch value {
	case "LLDP_RemoteStatistics_LastChangeTime":
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_LastChangeTime, true
	case "LLDP_RemoteStatistics_RemoteInserts":
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteInserts, true
	case "LLDP_RemoteStatistics_RemoteDeletes":
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDeletes, true
	case "LLDP_RemoteStatistics_RemoteDrops":
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDrops, true
	case "LLDP_RemoteStatistics_RemoteAgeouts":
		return OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteAgeouts, true
	case "LLDP_LocalSystemData_ChassisIdSubtype":
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisIdSubtype, true
	case "LLDP_LocalSystemData_ChassisId":
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisId, true
	case "LLDP_LocalSystemData_SystemName":
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemName, true
	case "LLDP_LocalSystemData_SystemDescription":
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemDescription, true
	case "LLDP_LocalSystemData_SystemCapabilitiesSupported":
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesSupported, true
	case "LLDP_LocalSystemData_SystemCapabilitiesEnabled":
		return OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesEnabled, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableLKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableLValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableL(structType any) OpcuaNodeIdServicesVariableL {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableL {
		if sOpcuaNodeIdServicesVariableL, ok := typ.(OpcuaNodeIdServicesVariableL); ok {
			return sOpcuaNodeIdServicesVariableL
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableL) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableL) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableLParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableL, error) {
	return OpcuaNodeIdServicesVariableLParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableLParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableL, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableL", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableL")
	}
	if enum, ok := OpcuaNodeIdServicesVariableLByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableL")
		return OpcuaNodeIdServicesVariableL(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableL) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableL) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableL", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableL) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableL) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_LastChangeTime:
		return "LLDP_RemoteStatistics_LastChangeTime"
	case OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteInserts:
		return "LLDP_RemoteStatistics_RemoteInserts"
	case OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDeletes:
		return "LLDP_RemoteStatistics_RemoteDeletes"
	case OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteDrops:
		return "LLDP_RemoteStatistics_RemoteDrops"
	case OpcuaNodeIdServicesVariableL_LLDP_RemoteStatistics_RemoteAgeouts:
		return "LLDP_RemoteStatistics_RemoteAgeouts"
	case OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisIdSubtype:
		return "LLDP_LocalSystemData_ChassisIdSubtype"
	case OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_ChassisId:
		return "LLDP_LocalSystemData_ChassisId"
	case OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemName:
		return "LLDP_LocalSystemData_SystemName"
	case OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemDescription:
		return "LLDP_LocalSystemData_SystemDescription"
	case OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesSupported:
		return "LLDP_LocalSystemData_SystemCapabilitiesSupported"
	case OpcuaNodeIdServicesVariableL_LLDP_LocalSystemData_SystemCapabilitiesEnabled:
		return "LLDP_LocalSystemData_SystemCapabilitiesEnabled"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableL) String() string {
	return e.PLC4XEnumName()
}
