/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAudit is an enum
type OpcuaNodeIdServicesVariableAudit int32

type IOpcuaNodeIdServicesVariableAudit interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp                              OpcuaNodeIdServicesVariableAudit = 2053
	OpcuaNodeIdServicesVariableAudit_AuditEventType_Status                                       OpcuaNodeIdServicesVariableAudit = 2054
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId                                     OpcuaNodeIdServicesVariableAudit = 2055
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId                           OpcuaNodeIdServicesVariableAudit = 2056
	OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId                                 OpcuaNodeIdServicesVariableAudit = 2057
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate           OpcuaNodeIdServicesVariableAudit = 2061
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType                 OpcuaNodeIdServicesVariableAudit = 2062
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri           OpcuaNodeIdServicesVariableAudit = 2063
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode                OpcuaNodeIdServicesVariableAudit = 2065
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime           OpcuaNodeIdServicesVariableAudit = 2066
	OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId                             OpcuaNodeIdServicesVariableAudit = 2070
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId                 OpcuaNodeIdServicesVariableAudit = 2072
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate               OpcuaNodeIdServicesVariableAudit = 2073
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout           OpcuaNodeIdServicesVariableAudit = 2074
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates    OpcuaNodeIdServicesVariableAudit = 2076
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken             OpcuaNodeIdServicesVariableAudit = 2077
	OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle                          OpcuaNodeIdServicesVariableAudit = 2079
	OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate                       OpcuaNodeIdServicesVariableAudit = 2081
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname       OpcuaNodeIdServicesVariableAudit = 2083
	OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri            OpcuaNodeIdServicesVariableAudit = 2084
	OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd                           OpcuaNodeIdServicesVariableAudit = 2092
	OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete                     OpcuaNodeIdServicesVariableAudit = 2094
	OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd                 OpcuaNodeIdServicesVariableAudit = 2096
	OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete           OpcuaNodeIdServicesVariableAudit = 2098
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange                        OpcuaNodeIdServicesVariableAudit = 2101
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue                          OpcuaNodeIdServicesVariableAudit = 2102
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue                          OpcuaNodeIdServicesVariableAudit = 2103
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId                         OpcuaNodeIdServicesVariableAudit = 2128
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments                   OpcuaNodeIdServicesVariableAudit = 2129
	OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId                       OpcuaNodeIdServicesVariableAudit = 2745
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint OpcuaNodeIdServicesVariableAudit = 2746
	OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint     OpcuaNodeIdServicesVariableAudit = 2747
	OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl                       OpcuaNodeIdServicesVariableAudit = 2749
	OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId                       OpcuaNodeIdServicesVariableAudit = 2750
	OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId             OpcuaNodeIdServicesVariableAudit = 2751
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId                        OpcuaNodeIdServicesVariableAudit = 2777
	OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId                        OpcuaNodeIdServicesVariableAudit = 2778
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter                     OpcuaNodeIdServicesVariableAudit = 3003
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified       OpcuaNodeIdServicesVariableAudit = 3015
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime              OpcuaNodeIdServicesVariableAudit = 3016
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime                OpcuaNodeIdServicesVariableAudit = 3017
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes                  OpcuaNodeIdServicesVariableAudit = 3020
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues                 OpcuaNodeIdServicesVariableAudit = 3021
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds                   OpcuaNodeIdServicesVariableAudit = 3023
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues                  OpcuaNodeIdServicesVariableAudit = 3024
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode                OpcuaNodeIdServicesVariableAudit = 3025
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode                OpcuaNodeIdServicesVariableAudit = 3026
	OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode                     OpcuaNodeIdServicesVariableAudit = 3027
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace       OpcuaNodeIdServicesVariableAudit = 3028
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues                  OpcuaNodeIdServicesVariableAudit = 3029
	OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues                  OpcuaNodeIdServicesVariableAudit = 3030
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace       OpcuaNodeIdServicesVariableAudit = 3031
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues                  OpcuaNodeIdServicesVariableAudit = 3032
	OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues                  OpcuaNodeIdServicesVariableAudit = 3033
	OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues              OpcuaNodeIdServicesVariableAudit = 3034
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId               OpcuaNodeIdServicesVariableAudit = 11485
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment                      OpcuaNodeIdServicesVariableAudit = 11851
	OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse             OpcuaNodeIdServicesVariableAudit = 11852
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment                  OpcuaNodeIdServicesVariableAudit = 11853
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment                      OpcuaNodeIdServicesVariableAudit = 11854
	OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime                OpcuaNodeIdServicesVariableAudit = 11855
	OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber            OpcuaNodeIdServicesVariableAudit = 11875
	OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId             OpcuaNodeIdServicesVariableAudit = 17222
	OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId         OpcuaNodeIdServicesVariableAudit = 17223
	OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId             OpcuaNodeIdServicesVariableAudit = 17224
	OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId                         OpcuaNodeIdServicesVariableAudit = 17615
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace  OpcuaNodeIdServicesVariableAudit = 19293
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues             OpcuaNodeIdServicesVariableAudit = 19294
	OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues             OpcuaNodeIdServicesVariableAudit = 19295
	OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_CurrentRoleIds                OpcuaNodeIdServicesVariableAudit = 19304
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_StatusCodeId                     OpcuaNodeIdServicesVariableAudit = 19305
	OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_OutputArguments                  OpcuaNodeIdServicesVariableAudit = 19306
	OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri                              OpcuaNodeIdServicesVariableAudit = 23908
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId             OpcuaNodeIdServicesVariableAudit = 23994
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId             OpcuaNodeIdServicesVariableAudit = 23995
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId         OpcuaNodeIdServicesVariableAudit = 23998
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments       OpcuaNodeIdServicesVariableAudit = 23999
	OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId     OpcuaNodeIdServicesVariableAudit = 24135
	OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments      OpcuaNodeIdServicesVariableAudit = 25684
	OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_UpdatedNode                 OpcuaNodeIdServicesVariableAudit = 32821
	OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_StartTime                   OpcuaNodeIdServicesVariableAudit = 32822
	OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_EndTime                     OpcuaNodeIdServicesVariableAudit = 32823
)

var OpcuaNodeIdServicesVariableAuditValues []OpcuaNodeIdServicesVariableAudit

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAuditValues = []OpcuaNodeIdServicesVariableAudit{
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_Status,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId,
		OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime,
		OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken,
		OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname,
		OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri,
		OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete,
		OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd,
		OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint,
		OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint,
		OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl,
		OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment,
		OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment,
		OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime,
		OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber,
		OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId,
		OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId,
		OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues,
		OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_CurrentRoleIds,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_OutputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId,
		OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_UpdatedNode,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_StartTime,
		OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_EndTime,
	}
}

func OpcuaNodeIdServicesVariableAuditByValue(value int32) (enum OpcuaNodeIdServicesVariableAudit, ok bool) {
	switch value {
	case 11485:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId, true
	case 11851:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment, true
	case 11852:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse, true
	case 11853:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment, true
	case 11854:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment, true
	case 11855:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime, true
	case 11875:
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber, true
	case 17222:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId, true
	case 17223:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId, true
	case 17224:
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId, true
	case 17615:
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId, true
	case 19293:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace, true
	case 19294:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues, true
	case 19295:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues, true
	case 19304:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_CurrentRoleIds, true
	case 19305:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_StatusCodeId, true
	case 19306:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_OutputArguments, true
	case 2053:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp, true
	case 2054:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Status, true
	case 2055:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId, true
	case 2056:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId, true
	case 2057:
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId, true
	case 2061:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate, true
	case 2062:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType, true
	case 2063:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri, true
	case 2065:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode, true
	case 2066:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime, true
	case 2070:
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId, true
	case 2072:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId, true
	case 2073:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate, true
	case 2074:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout, true
	case 2076:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates, true
	case 2077:
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken, true
	case 2079:
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle, true
	case 2081:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate, true
	case 2083:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname, true
	case 2084:
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri, true
	case 2092:
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd, true
	case 2094:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete, true
	case 2096:
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd, true
	case 2098:
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete, true
	case 2101:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange, true
	case 2102:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue, true
	case 2103:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue, true
	case 2128:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId, true
	case 2129:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments, true
	case 23908:
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri, true
	case 23994:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId, true
	case 23995:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId, true
	case 23998:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId, true
	case 23999:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments, true
	case 24135:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId, true
	case 25684:
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments, true
	case 2745:
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId, true
	case 2746:
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint, true
	case 2747:
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint, true
	case 2749:
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl, true
	case 2750:
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId, true
	case 2751:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId, true
	case 2777:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId, true
	case 2778:
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId, true
	case 3003:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter, true
	case 3015:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified, true
	case 3016:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime, true
	case 3017:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime, true
	case 3020:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes, true
	case 3021:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues, true
	case 3023:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds, true
	case 3024:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues, true
	case 3025:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode, true
	case 3026:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode, true
	case 3027:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode, true
	case 3028:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace, true
	case 3029:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues, true
	case 3030:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues, true
	case 3031:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace, true
	case 3032:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues, true
	case 3033:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues, true
	case 3034:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues, true
	case 32821:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_UpdatedNode, true
	case 32822:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_StartTime, true
	case 32823:
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_EndTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAuditByName(value string) (enum OpcuaNodeIdServicesVariableAudit, ok bool) {
	switch value {
	case "AuditActivateSessionEventType_SecureChannelId":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId, true
	case "AuditConditionCommentEventType_Comment":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment, true
	case "AuditConditionRespondEventType_SelectedResponse":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse, true
	case "AuditConditionAcknowledgeEventType_Comment":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment, true
	case "AuditConditionConfirmEventType_Comment":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment, true
	case "AuditConditionShelvingEventType_ShelvingTime":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime, true
	case "AuditProgramTransitionEventType_TransitionNumber":
		return OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber, true
	case "AuditConditionCommentEventType_ConditionEventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId, true
	case "AuditConditionAcknowledgeEventType_ConditionEventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId, true
	case "AuditConditionConfirmEventType_ConditionEventId":
		return OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId, true
	case "AuditSecurityEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId, true
	case "AuditHistoryAnnotationUpdateEventType_PerformInsertReplace":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace, true
	case "AuditHistoryAnnotationUpdateEventType_NewValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues, true
	case "AuditHistoryAnnotationUpdateEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues, true
	case "AuditActivateSessionEventType_CurrentRoleIds":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_CurrentRoleIds, true
	case "AuditUpdateMethodEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_StatusCodeId, true
	case "AuditUpdateMethodEventType_OutputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_OutputArguments, true
	case "AuditEventType_ActionTimeStamp":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp, true
	case "AuditEventType_Status":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_Status, true
	case "AuditEventType_ServerId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId, true
	case "AuditEventType_ClientAuditEntryId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId, true
	case "AuditEventType_ClientUserId":
		return OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId, true
	case "AuditOpenSecureChannelEventType_ClientCertificate":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate, true
	case "AuditOpenSecureChannelEventType_RequestType":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType, true
	case "AuditOpenSecureChannelEventType_SecurityPolicyUri":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri, true
	case "AuditOpenSecureChannelEventType_SecurityMode":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode, true
	case "AuditOpenSecureChannelEventType_RequestedLifetime":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime, true
	case "AuditSessionEventType_SessionId":
		return OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId, true
	case "AuditCreateSessionEventType_SecureChannelId":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId, true
	case "AuditCreateSessionEventType_ClientCertificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate, true
	case "AuditCreateSessionEventType_RevisedSessionTimeout":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout, true
	case "AuditActivateSessionEventType_ClientSoftwareCertificates":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates, true
	case "AuditActivateSessionEventType_UserIdentityToken":
		return OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken, true
	case "AuditCancelEventType_RequestHandle":
		return OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle, true
	case "AuditCertificateEventType_Certificate":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate, true
	case "AuditCertificateDataMismatchEventType_InvalidHostname":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname, true
	case "AuditCertificateDataMismatchEventType_InvalidUri":
		return OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri, true
	case "AuditAddNodesEventType_NodesToAdd":
		return OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd, true
	case "AuditDeleteNodesEventType_NodesToDelete":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete, true
	case "AuditAddReferencesEventType_ReferencesToAdd":
		return OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd, true
	case "AuditDeleteReferencesEventType_ReferencesToDelete":
		return OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete, true
	case "AuditWriteUpdateEventType_IndexRange":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange, true
	case "AuditWriteUpdateEventType_OldValue":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue, true
	case "AuditWriteUpdateEventType_NewValue":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue, true
	case "AuditUpdateMethodEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId, true
	case "AuditUpdateMethodEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments, true
	case "AuditClientEventType_ServerUri":
		return OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri, true
	case "AuditClientUpdateMethodResultEventType_ObjectId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId, true
	case "AuditClientUpdateMethodResultEventType_MethodId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId, true
	case "AuditClientUpdateMethodResultEventType_StatusCodeId":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId, true
	case "AuditClientUpdateMethodResultEventType_InputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments, true
	case "AuditOpenSecureChannelEventType_CertificateErrorEventId":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId, true
	case "AuditClientUpdateMethodResultEventType_OutputArguments":
		return OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments, true
	case "AuditChannelEventType_SecureChannelId":
		return OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId, true
	case "AuditOpenSecureChannelEventType_ClientCertificateThumbprint":
		return OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint, true
	case "AuditCreateSessionEventType_ClientCertificateThumbprint":
		return OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint, true
	case "AuditUrlMismatchEventType_EndpointUrl":
		return OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl, true
	case "AuditWriteUpdateEventType_AttributeId":
		return OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId, true
	case "AuditHistoryUpdateEventType_ParameterDataTypeId":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId, true
	case "AuditUpdateStateEventType_OldStateId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId, true
	case "AuditUpdateStateEventType_NewStateId":
		return OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId, true
	case "AuditHistoryEventUpdateEventType_Filter":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter, true
	case "AuditHistoryRawModifyDeleteEventType_IsDeleteModified":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified, true
	case "AuditHistoryRawModifyDeleteEventType_StartTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime, true
	case "AuditHistoryRawModifyDeleteEventType_EndTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime, true
	case "AuditHistoryAtTimeDeleteEventType_ReqTimes":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes, true
	case "AuditHistoryAtTimeDeleteEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues, true
	case "AuditHistoryEventDeleteEventType_EventIds":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds, true
	case "AuditHistoryEventDeleteEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues, true
	case "AuditHistoryEventUpdateEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode, true
	case "AuditHistoryValueUpdateEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode, true
	case "AuditHistoryDeleteEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode, true
	case "AuditHistoryEventUpdateEventType_PerformInsertReplace":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace, true
	case "AuditHistoryEventUpdateEventType_NewValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues, true
	case "AuditHistoryEventUpdateEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues, true
	case "AuditHistoryValueUpdateEventType_PerformInsertReplace":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace, true
	case "AuditHistoryValueUpdateEventType_NewValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues, true
	case "AuditHistoryValueUpdateEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues, true
	case "AuditHistoryRawModifyDeleteEventType_OldValues":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues, true
	case "AuditHistoryBulkInsertEventType_UpdatedNode":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_UpdatedNode, true
	case "AuditHistoryBulkInsertEventType_StartTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_StartTime, true
	case "AuditHistoryBulkInsertEventType_EndTime":
		return OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_EndTime, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAuditKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAuditValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAudit(structType any) OpcuaNodeIdServicesVariableAudit {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAudit {
		if sOpcuaNodeIdServicesVariableAudit, ok := typ.(OpcuaNodeIdServicesVariableAudit); ok {
			return sOpcuaNodeIdServicesVariableAudit
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAudit) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAudit) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAuditParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAudit, error) {
	return OpcuaNodeIdServicesVariableAuditParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAuditParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAudit, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAudit", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAudit")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAuditByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAudit")
		return OpcuaNodeIdServicesVariableAudit(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAudit) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAudit) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAudit", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableAudit) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAudit) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_SecureChannelId:
		return "AuditActivateSessionEventType_SecureChannelId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_Comment:
		return "AuditConditionCommentEventType_Comment"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionRespondEventType_SelectedResponse:
		return "AuditConditionRespondEventType_SelectedResponse"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_Comment:
		return "AuditConditionAcknowledgeEventType_Comment"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_Comment:
		return "AuditConditionConfirmEventType_Comment"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionShelvingEventType_ShelvingTime:
		return "AuditConditionShelvingEventType_ShelvingTime"
	case OpcuaNodeIdServicesVariableAudit_AuditProgramTransitionEventType_TransitionNumber:
		return "AuditProgramTransitionEventType_TransitionNumber"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionCommentEventType_ConditionEventId:
		return "AuditConditionCommentEventType_ConditionEventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionAcknowledgeEventType_ConditionEventId:
		return "AuditConditionAcknowledgeEventType_ConditionEventId"
	case OpcuaNodeIdServicesVariableAudit_AuditConditionConfirmEventType_ConditionEventId:
		return "AuditConditionConfirmEventType_ConditionEventId"
	case OpcuaNodeIdServicesVariableAudit_AuditSecurityEventType_StatusCodeId:
		return "AuditSecurityEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_PerformInsertReplace:
		return "AuditHistoryAnnotationUpdateEventType_PerformInsertReplace"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_NewValues:
		return "AuditHistoryAnnotationUpdateEventType_NewValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAnnotationUpdateEventType_OldValues:
		return "AuditHistoryAnnotationUpdateEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_CurrentRoleIds:
		return "AuditActivateSessionEventType_CurrentRoleIds"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_StatusCodeId:
		return "AuditUpdateMethodEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_OutputArguments:
		return "AuditUpdateMethodEventType_OutputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ActionTimeStamp:
		return "AuditEventType_ActionTimeStamp"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_Status:
		return "AuditEventType_Status"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ServerId:
		return "AuditEventType_ServerId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientAuditEntryId:
		return "AuditEventType_ClientAuditEntryId"
	case OpcuaNodeIdServicesVariableAudit_AuditEventType_ClientUserId:
		return "AuditEventType_ClientUserId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificate:
		return "AuditOpenSecureChannelEventType_ClientCertificate"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestType:
		return "AuditOpenSecureChannelEventType_RequestType"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityPolicyUri:
		return "AuditOpenSecureChannelEventType_SecurityPolicyUri"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_SecurityMode:
		return "AuditOpenSecureChannelEventType_SecurityMode"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_RequestedLifetime:
		return "AuditOpenSecureChannelEventType_RequestedLifetime"
	case OpcuaNodeIdServicesVariableAudit_AuditSessionEventType_SessionId:
		return "AuditSessionEventType_SessionId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_SecureChannelId:
		return "AuditCreateSessionEventType_SecureChannelId"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificate:
		return "AuditCreateSessionEventType_ClientCertificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_RevisedSessionTimeout:
		return "AuditCreateSessionEventType_RevisedSessionTimeout"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_ClientSoftwareCertificates:
		return "AuditActivateSessionEventType_ClientSoftwareCertificates"
	case OpcuaNodeIdServicesVariableAudit_AuditActivateSessionEventType_UserIdentityToken:
		return "AuditActivateSessionEventType_UserIdentityToken"
	case OpcuaNodeIdServicesVariableAudit_AuditCancelEventType_RequestHandle:
		return "AuditCancelEventType_RequestHandle"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateEventType_Certificate:
		return "AuditCertificateEventType_Certificate"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidHostname:
		return "AuditCertificateDataMismatchEventType_InvalidHostname"
	case OpcuaNodeIdServicesVariableAudit_AuditCertificateDataMismatchEventType_InvalidUri:
		return "AuditCertificateDataMismatchEventType_InvalidUri"
	case OpcuaNodeIdServicesVariableAudit_AuditAddNodesEventType_NodesToAdd:
		return "AuditAddNodesEventType_NodesToAdd"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteNodesEventType_NodesToDelete:
		return "AuditDeleteNodesEventType_NodesToDelete"
	case OpcuaNodeIdServicesVariableAudit_AuditAddReferencesEventType_ReferencesToAdd:
		return "AuditAddReferencesEventType_ReferencesToAdd"
	case OpcuaNodeIdServicesVariableAudit_AuditDeleteReferencesEventType_ReferencesToDelete:
		return "AuditDeleteReferencesEventType_ReferencesToDelete"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_IndexRange:
		return "AuditWriteUpdateEventType_IndexRange"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_OldValue:
		return "AuditWriteUpdateEventType_OldValue"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_NewValue:
		return "AuditWriteUpdateEventType_NewValue"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_MethodId:
		return "AuditUpdateMethodEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateMethodEventType_InputArguments:
		return "AuditUpdateMethodEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditClientEventType_ServerUri:
		return "AuditClientEventType_ServerUri"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_ObjectId:
		return "AuditClientUpdateMethodResultEventType_ObjectId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_MethodId:
		return "AuditClientUpdateMethodResultEventType_MethodId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_StatusCodeId:
		return "AuditClientUpdateMethodResultEventType_StatusCodeId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_InputArguments:
		return "AuditClientUpdateMethodResultEventType_InputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_CertificateErrorEventId:
		return "AuditOpenSecureChannelEventType_CertificateErrorEventId"
	case OpcuaNodeIdServicesVariableAudit_AuditClientUpdateMethodResultEventType_OutputArguments:
		return "AuditClientUpdateMethodResultEventType_OutputArguments"
	case OpcuaNodeIdServicesVariableAudit_AuditChannelEventType_SecureChannelId:
		return "AuditChannelEventType_SecureChannelId"
	case OpcuaNodeIdServicesVariableAudit_AuditOpenSecureChannelEventType_ClientCertificateThumbprint:
		return "AuditOpenSecureChannelEventType_ClientCertificateThumbprint"
	case OpcuaNodeIdServicesVariableAudit_AuditCreateSessionEventType_ClientCertificateThumbprint:
		return "AuditCreateSessionEventType_ClientCertificateThumbprint"
	case OpcuaNodeIdServicesVariableAudit_AuditUrlMismatchEventType_EndpointUrl:
		return "AuditUrlMismatchEventType_EndpointUrl"
	case OpcuaNodeIdServicesVariableAudit_AuditWriteUpdateEventType_AttributeId:
		return "AuditWriteUpdateEventType_AttributeId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryUpdateEventType_ParameterDataTypeId:
		return "AuditHistoryUpdateEventType_ParameterDataTypeId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_OldStateId:
		return "AuditUpdateStateEventType_OldStateId"
	case OpcuaNodeIdServicesVariableAudit_AuditUpdateStateEventType_NewStateId:
		return "AuditUpdateStateEventType_NewStateId"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_Filter:
		return "AuditHistoryEventUpdateEventType_Filter"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_IsDeleteModified:
		return "AuditHistoryRawModifyDeleteEventType_IsDeleteModified"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_StartTime:
		return "AuditHistoryRawModifyDeleteEventType_StartTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_EndTime:
		return "AuditHistoryRawModifyDeleteEventType_EndTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_ReqTimes:
		return "AuditHistoryAtTimeDeleteEventType_ReqTimes"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryAtTimeDeleteEventType_OldValues:
		return "AuditHistoryAtTimeDeleteEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_EventIds:
		return "AuditHistoryEventDeleteEventType_EventIds"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventDeleteEventType_OldValues:
		return "AuditHistoryEventDeleteEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_UpdatedNode:
		return "AuditHistoryEventUpdateEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_UpdatedNode:
		return "AuditHistoryValueUpdateEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryDeleteEventType_UpdatedNode:
		return "AuditHistoryDeleteEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_PerformInsertReplace:
		return "AuditHistoryEventUpdateEventType_PerformInsertReplace"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_NewValues:
		return "AuditHistoryEventUpdateEventType_NewValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryEventUpdateEventType_OldValues:
		return "AuditHistoryEventUpdateEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_PerformInsertReplace:
		return "AuditHistoryValueUpdateEventType_PerformInsertReplace"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_NewValues:
		return "AuditHistoryValueUpdateEventType_NewValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryValueUpdateEventType_OldValues:
		return "AuditHistoryValueUpdateEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryRawModifyDeleteEventType_OldValues:
		return "AuditHistoryRawModifyDeleteEventType_OldValues"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_UpdatedNode:
		return "AuditHistoryBulkInsertEventType_UpdatedNode"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_StartTime:
		return "AuditHistoryBulkInsertEventType_StartTime"
	case OpcuaNodeIdServicesVariableAudit_AuditHistoryBulkInsertEventType_EndTime:
		return "AuditHistoryBulkInsertEventType_EndTime"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAudit) String() string {
	return e.PLC4XEnumName()
}
