/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtLinkRead is the corresponding interface of ApduDataExtLinkRead
type ApduDataExtLinkRead interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtLinkRead is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtLinkRead()
	// CreateBuilder creates a ApduDataExtLinkReadBuilder
	CreateApduDataExtLinkReadBuilder() ApduDataExtLinkReadBuilder
}

// _ApduDataExtLinkRead is the data-structure of this message
type _ApduDataExtLinkRead struct {
	ApduDataExtContract
}

var _ ApduDataExtLinkRead = (*_ApduDataExtLinkRead)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtLinkRead)(nil)

// NewApduDataExtLinkRead factory function for _ApduDataExtLinkRead
func NewApduDataExtLinkRead(length uint8) *_ApduDataExtLinkRead {
	_result := &_ApduDataExtLinkRead{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtLinkReadBuilder is a builder for ApduDataExtLinkRead
type ApduDataExtLinkReadBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtLinkReadBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtLinkRead or returns an error if something is wrong
	Build() (ApduDataExtLinkRead, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtLinkRead
}

// NewApduDataExtLinkReadBuilder() creates a ApduDataExtLinkReadBuilder
func NewApduDataExtLinkReadBuilder() ApduDataExtLinkReadBuilder {
	return &_ApduDataExtLinkReadBuilder{_ApduDataExtLinkRead: new(_ApduDataExtLinkRead)}
}

type _ApduDataExtLinkReadBuilder struct {
	*_ApduDataExtLinkRead

	parentBuilder *_ApduDataExtBuilder

	collectedErr []error
}

var _ (ApduDataExtLinkReadBuilder) = (*_ApduDataExtLinkReadBuilder)(nil)

func (b *_ApduDataExtLinkReadBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtLinkRead
}

func (b *_ApduDataExtLinkReadBuilder) WithMandatoryFields() ApduDataExtLinkReadBuilder {
	return b
}

func (b *_ApduDataExtLinkReadBuilder) Build() (ApduDataExtLinkRead, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataExtLinkRead.deepCopy(), nil
}

func (b *_ApduDataExtLinkReadBuilder) MustBuild() ApduDataExtLinkRead {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtLinkReadBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtLinkReadBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtLinkReadBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtLinkReadBuilder().(*_ApduDataExtLinkReadBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataExtLinkReadBuilder creates a ApduDataExtLinkReadBuilder
func (b *_ApduDataExtLinkRead) CreateApduDataExtLinkReadBuilder() ApduDataExtLinkReadBuilder {
	if b == nil {
		return NewApduDataExtLinkReadBuilder()
	}
	return &_ApduDataExtLinkReadBuilder{_ApduDataExtLinkRead: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtLinkRead) GetExtApciType() uint8 {
	return 0x25
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtLinkRead) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtLinkRead(structType any) ApduDataExtLinkRead {
	if casted, ok := structType.(ApduDataExtLinkRead); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtLinkRead); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtLinkRead) GetTypeName() string {
	return "ApduDataExtLinkRead"
}

func (m *_ApduDataExtLinkRead) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtLinkRead) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtLinkRead) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtLinkRead ApduDataExtLinkRead, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtLinkRead"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtLinkRead")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtLinkRead"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtLinkRead")
	}

	return m, nil
}

func (m *_ApduDataExtLinkRead) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtLinkRead) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtLinkRead"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtLinkRead")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtLinkRead"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtLinkRead")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtLinkRead) IsApduDataExtLinkRead() {}

func (m *_ApduDataExtLinkRead) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtLinkRead) deepCopy() *_ApduDataExtLinkRead {
	if m == nil {
		return nil
	}
	_ApduDataExtLinkReadCopy := &_ApduDataExtLinkRead{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtLinkReadCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtLinkReadCopy
}

func (m *_ApduDataExtLinkRead) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
