/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetApplicationTagUnsignedInteger is the corresponding interface of BACnetApplicationTagUnsignedInteger
type BACnetApplicationTagUnsignedInteger interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetApplicationTag
	// GetPayload returns Payload (property field)
	GetPayload() BACnetTagPayloadUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() uint64
	// IsBACnetApplicationTagUnsignedInteger is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetApplicationTagUnsignedInteger()
	// CreateBuilder creates a BACnetApplicationTagUnsignedIntegerBuilder
	CreateBACnetApplicationTagUnsignedIntegerBuilder() BACnetApplicationTagUnsignedIntegerBuilder
}

// _BACnetApplicationTagUnsignedInteger is the data-structure of this message
type _BACnetApplicationTagUnsignedInteger struct {
	BACnetApplicationTagContract
	Payload BACnetTagPayloadUnsignedInteger
}

var _ BACnetApplicationTagUnsignedInteger = (*_BACnetApplicationTagUnsignedInteger)(nil)
var _ BACnetApplicationTagRequirements = (*_BACnetApplicationTagUnsignedInteger)(nil)

// NewBACnetApplicationTagUnsignedInteger factory function for _BACnetApplicationTagUnsignedInteger
func NewBACnetApplicationTagUnsignedInteger(header BACnetTagHeader, payload BACnetTagPayloadUnsignedInteger) *_BACnetApplicationTagUnsignedInteger {
	if payload == nil {
		panic("payload of type BACnetTagPayloadUnsignedInteger for BACnetApplicationTagUnsignedInteger must not be nil")
	}
	_result := &_BACnetApplicationTagUnsignedInteger{
		BACnetApplicationTagContract: NewBACnetApplicationTag(header),
		Payload:                      payload,
	}
	_result.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetApplicationTagUnsignedIntegerBuilder is a builder for BACnetApplicationTagUnsignedInteger
type BACnetApplicationTagUnsignedIntegerBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(payload BACnetTagPayloadUnsignedInteger) BACnetApplicationTagUnsignedIntegerBuilder
	// WithPayload adds Payload (property field)
	WithPayload(BACnetTagPayloadUnsignedInteger) BACnetApplicationTagUnsignedIntegerBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(BACnetTagPayloadUnsignedIntegerBuilder) BACnetTagPayloadUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetApplicationTagBuilder
	// Build builds the BACnetApplicationTagUnsignedInteger or returns an error if something is wrong
	Build() (BACnetApplicationTagUnsignedInteger, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetApplicationTagUnsignedInteger
}

// NewBACnetApplicationTagUnsignedIntegerBuilder() creates a BACnetApplicationTagUnsignedIntegerBuilder
func NewBACnetApplicationTagUnsignedIntegerBuilder() BACnetApplicationTagUnsignedIntegerBuilder {
	return &_BACnetApplicationTagUnsignedIntegerBuilder{_BACnetApplicationTagUnsignedInteger: new(_BACnetApplicationTagUnsignedInteger)}
}

type _BACnetApplicationTagUnsignedIntegerBuilder struct {
	*_BACnetApplicationTagUnsignedInteger

	parentBuilder *_BACnetApplicationTagBuilder

	collectedErr []error
}

var _ (BACnetApplicationTagUnsignedIntegerBuilder) = (*_BACnetApplicationTagUnsignedIntegerBuilder)(nil)

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) setParent(contract BACnetApplicationTagContract) {
	b.BACnetApplicationTagContract = contract
	contract.(*_BACnetApplicationTag)._SubType = b._BACnetApplicationTagUnsignedInteger
}

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) WithMandatoryFields(payload BACnetTagPayloadUnsignedInteger) BACnetApplicationTagUnsignedIntegerBuilder {
	return b.WithPayload(payload)
}

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) WithPayload(payload BACnetTagPayloadUnsignedInteger) BACnetApplicationTagUnsignedIntegerBuilder {
	b.Payload = payload
	return b
}

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) WithPayloadBuilder(builderSupplier func(BACnetTagPayloadUnsignedIntegerBuilder) BACnetTagPayloadUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder {
	builder := builderSupplier(b.Payload.CreateBACnetTagPayloadUnsignedIntegerBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagPayloadUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) Build() (BACnetApplicationTagUnsignedInteger, error) {
	if b.Payload == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'payload' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetApplicationTagUnsignedInteger.deepCopy(), nil
}

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) MustBuild() BACnetApplicationTagUnsignedInteger {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) Done() BACnetApplicationTagBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetApplicationTagBuilder().(*_BACnetApplicationTagBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) buildForBACnetApplicationTag() (BACnetApplicationTag, error) {
	return b.Build()
}

func (b *_BACnetApplicationTagUnsignedIntegerBuilder) DeepCopy() any {
	_copy := b.CreateBACnetApplicationTagUnsignedIntegerBuilder().(*_BACnetApplicationTagUnsignedIntegerBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetApplicationTagUnsignedIntegerBuilder creates a BACnetApplicationTagUnsignedIntegerBuilder
func (b *_BACnetApplicationTagUnsignedInteger) CreateBACnetApplicationTagUnsignedIntegerBuilder() BACnetApplicationTagUnsignedIntegerBuilder {
	if b == nil {
		return NewBACnetApplicationTagUnsignedIntegerBuilder()
	}
	return &_BACnetApplicationTagUnsignedIntegerBuilder{_BACnetApplicationTagUnsignedInteger: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetApplicationTagUnsignedInteger) GetParent() BACnetApplicationTagContract {
	return m.BACnetApplicationTagContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetApplicationTagUnsignedInteger) GetPayload() BACnetTagPayloadUnsignedInteger {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetApplicationTagUnsignedInteger) GetActualValue() uint64 {
	ctx := context.Background()
	_ = ctx
	return uint64(m.GetPayload().GetActualValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetApplicationTagUnsignedInteger(structType any) BACnetApplicationTagUnsignedInteger {
	if casted, ok := structType.(BACnetApplicationTagUnsignedInteger); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetApplicationTagUnsignedInteger); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetApplicationTagUnsignedInteger) GetTypeName() string {
	return "BACnetApplicationTagUnsignedInteger"
}

func (m *_BACnetApplicationTagUnsignedInteger) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetApplicationTagContract.(*_BACnetApplicationTag).getLengthInBits(ctx))

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetApplicationTagUnsignedInteger) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetApplicationTagUnsignedInteger) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetApplicationTag, header BACnetTagHeader) (__bACnetApplicationTagUnsignedInteger BACnetApplicationTagUnsignedInteger, err error) {
	m.BACnetApplicationTagContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetApplicationTagUnsignedInteger"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetApplicationTagUnsignedInteger")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	payload, err := ReadSimpleField[BACnetTagPayloadUnsignedInteger](ctx, "payload", ReadComplex[BACnetTagPayloadUnsignedInteger](BACnetTagPayloadUnsignedIntegerParseWithBufferProducer((uint32)(header.GetActualLength())), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	actualValue, err := ReadVirtualField[uint64](ctx, "actualValue", (*uint64)(nil), payload.GetActualValue())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetApplicationTagUnsignedInteger"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetApplicationTagUnsignedInteger")
	}

	return m, nil
}

func (m *_BACnetApplicationTagUnsignedInteger) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetApplicationTagUnsignedInteger) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetApplicationTagUnsignedInteger"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetApplicationTagUnsignedInteger")
		}

		if err := WriteSimpleField[BACnetTagPayloadUnsignedInteger](ctx, "payload", m.GetPayload(), WriteComplex[BACnetTagPayloadUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetApplicationTagUnsignedInteger"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetApplicationTagUnsignedInteger")
		}
		return nil
	}
	return m.BACnetApplicationTagContract.(*_BACnetApplicationTag).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetApplicationTagUnsignedInteger) IsBACnetApplicationTagUnsignedInteger() {}

func (m *_BACnetApplicationTagUnsignedInteger) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetApplicationTagUnsignedInteger) deepCopy() *_BACnetApplicationTagUnsignedInteger {
	if m == nil {
		return nil
	}
	_BACnetApplicationTagUnsignedIntegerCopy := &_BACnetApplicationTagUnsignedInteger{
		m.BACnetApplicationTagContract.(*_BACnetApplicationTag).deepCopy(),
		utils.DeepCopy[BACnetTagPayloadUnsignedInteger](m.Payload),
	}
	_BACnetApplicationTagUnsignedIntegerCopy.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = m
	return _BACnetApplicationTagUnsignedIntegerCopy
}

func (m *_BACnetApplicationTagUnsignedInteger) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
