/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7VarRequestParameterItem is the corresponding interface of S7VarRequestParameterItem
type S7VarRequestParameterItem interface {
	S7VarRequestParameterItemContract
	S7VarRequestParameterItemRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsS7VarRequestParameterItem is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7VarRequestParameterItem()
	// CreateBuilder creates a S7VarRequestParameterItemBuilder
	CreateS7VarRequestParameterItemBuilder() S7VarRequestParameterItemBuilder
}

// S7VarRequestParameterItemContract provides a set of functions which can be overwritten by a sub struct
type S7VarRequestParameterItemContract interface {
	// IsS7VarRequestParameterItem is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7VarRequestParameterItem()
	// CreateBuilder creates a S7VarRequestParameterItemBuilder
	CreateS7VarRequestParameterItemBuilder() S7VarRequestParameterItemBuilder
}

// S7VarRequestParameterItemRequirements provides a set of functions which need to be implemented by a sub struct
type S7VarRequestParameterItemRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetItemType returns ItemType (discriminator field)
	GetItemType() uint8
}

// _S7VarRequestParameterItem is the data-structure of this message
type _S7VarRequestParameterItem struct {
	_SubType interface {
		S7VarRequestParameterItemContract
		S7VarRequestParameterItemRequirements
	}
}

var _ S7VarRequestParameterItemContract = (*_S7VarRequestParameterItem)(nil)

// NewS7VarRequestParameterItem factory function for _S7VarRequestParameterItem
func NewS7VarRequestParameterItem() *_S7VarRequestParameterItem {
	return &_S7VarRequestParameterItem{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7VarRequestParameterItemBuilder is a builder for S7VarRequestParameterItem
type S7VarRequestParameterItemBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() S7VarRequestParameterItemBuilder
	// AsS7VarRequestParameterItemAddress converts this build to a subType of S7VarRequestParameterItem. It is always possible to return to current builder using Done()
	AsS7VarRequestParameterItemAddress() S7VarRequestParameterItemAddressBuilder
	// Build builds the S7VarRequestParameterItem or returns an error if something is wrong
	PartialBuild() (S7VarRequestParameterItemContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() S7VarRequestParameterItemContract
	// Build builds the S7VarRequestParameterItem or returns an error if something is wrong
	Build() (S7VarRequestParameterItem, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7VarRequestParameterItem
}

// NewS7VarRequestParameterItemBuilder() creates a S7VarRequestParameterItemBuilder
func NewS7VarRequestParameterItemBuilder() S7VarRequestParameterItemBuilder {
	return &_S7VarRequestParameterItemBuilder{_S7VarRequestParameterItem: new(_S7VarRequestParameterItem)}
}

type _S7VarRequestParameterItemChildBuilder interface {
	utils.Copyable
	setParent(S7VarRequestParameterItemContract)
	buildForS7VarRequestParameterItem() (S7VarRequestParameterItem, error)
}

type _S7VarRequestParameterItemBuilder struct {
	*_S7VarRequestParameterItem

	childBuilder _S7VarRequestParameterItemChildBuilder

	err *utils.MultiError
}

var _ (S7VarRequestParameterItemBuilder) = (*_S7VarRequestParameterItemBuilder)(nil)

func (b *_S7VarRequestParameterItemBuilder) WithMandatoryFields() S7VarRequestParameterItemBuilder {
	return b
}

func (b *_S7VarRequestParameterItemBuilder) PartialBuild() (S7VarRequestParameterItemContract, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._S7VarRequestParameterItem.deepCopy(), nil
}

func (b *_S7VarRequestParameterItemBuilder) PartialMustBuild() S7VarRequestParameterItemContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7VarRequestParameterItemBuilder) AsS7VarRequestParameterItemAddress() S7VarRequestParameterItemAddressBuilder {
	if cb, ok := b.childBuilder.(S7VarRequestParameterItemAddressBuilder); ok {
		return cb
	}
	cb := NewS7VarRequestParameterItemAddressBuilder().(*_S7VarRequestParameterItemAddressBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_S7VarRequestParameterItemBuilder) Build() (S7VarRequestParameterItem, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForS7VarRequestParameterItem()
}

func (b *_S7VarRequestParameterItemBuilder) MustBuild() S7VarRequestParameterItem {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7VarRequestParameterItemBuilder) DeepCopy() any {
	_copy := b.CreateS7VarRequestParameterItemBuilder().(*_S7VarRequestParameterItemBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_S7VarRequestParameterItemChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateS7VarRequestParameterItemBuilder creates a S7VarRequestParameterItemBuilder
func (b *_S7VarRequestParameterItem) CreateS7VarRequestParameterItemBuilder() S7VarRequestParameterItemBuilder {
	if b == nil {
		return NewS7VarRequestParameterItemBuilder()
	}
	return &_S7VarRequestParameterItemBuilder{_S7VarRequestParameterItem: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastS7VarRequestParameterItem(structType any) S7VarRequestParameterItem {
	if casted, ok := structType.(S7VarRequestParameterItem); ok {
		return casted
	}
	if casted, ok := structType.(*S7VarRequestParameterItem); ok {
		return *casted
	}
	return nil
}

func (m *_S7VarRequestParameterItem) GetTypeName() string {
	return "S7VarRequestParameterItem"
}

func (m *_S7VarRequestParameterItem) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (itemType)
	lengthInBits += 8

	return lengthInBits
}

func (m *_S7VarRequestParameterItem) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_S7VarRequestParameterItem) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func S7VarRequestParameterItemParse[T S7VarRequestParameterItem](ctx context.Context, theBytes []byte) (T, error) {
	return S7VarRequestParameterItemParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func S7VarRequestParameterItemParseWithBufferProducer[T S7VarRequestParameterItem]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := S7VarRequestParameterItemParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func S7VarRequestParameterItemParseWithBuffer[T S7VarRequestParameterItem](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_S7VarRequestParameterItem{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_S7VarRequestParameterItem) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__s7VarRequestParameterItem S7VarRequestParameterItem, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7VarRequestParameterItem"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7VarRequestParameterItem")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	itemType, err := ReadDiscriminatorField[uint8](ctx, "itemType", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'itemType' field"))
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child S7VarRequestParameterItem
	switch {
	case itemType == 0x12: // S7VarRequestParameterItemAddress
		if _child, err = new(_S7VarRequestParameterItemAddress).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type S7VarRequestParameterItemAddress for type-switch of S7VarRequestParameterItem")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [itemType=%v]", itemType)
	}

	if closeErr := readBuffer.CloseContext("S7VarRequestParameterItem"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7VarRequestParameterItem")
	}

	return _child, nil
}

func (pm *_S7VarRequestParameterItem) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child S7VarRequestParameterItem, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("S7VarRequestParameterItem"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for S7VarRequestParameterItem")
	}

	if err := WriteDiscriminatorField(ctx, "itemType", m.GetItemType(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'itemType' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("S7VarRequestParameterItem"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for S7VarRequestParameterItem")
	}
	return nil
}

func (m *_S7VarRequestParameterItem) IsS7VarRequestParameterItem() {}

func (m *_S7VarRequestParameterItem) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7VarRequestParameterItem) deepCopy() *_S7VarRequestParameterItem {
	if m == nil {
		return nil
	}
	_S7VarRequestParameterItemCopy := &_S7VarRequestParameterItem{
		nil, // will be set by child
	}
	return _S7VarRequestParameterItemCopy
}
