/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7PayloadUserDataItemCyclicServicesErrorResponse is the corresponding interface of S7PayloadUserDataItemCyclicServicesErrorResponse
type S7PayloadUserDataItemCyclicServicesErrorResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	S7PayloadUserDataItem
	// IsS7PayloadUserDataItemCyclicServicesErrorResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7PayloadUserDataItemCyclicServicesErrorResponse()
	// CreateBuilder creates a S7PayloadUserDataItemCyclicServicesErrorResponseBuilder
	CreateS7PayloadUserDataItemCyclicServicesErrorResponseBuilder() S7PayloadUserDataItemCyclicServicesErrorResponseBuilder
}

// _S7PayloadUserDataItemCyclicServicesErrorResponse is the data-structure of this message
type _S7PayloadUserDataItemCyclicServicesErrorResponse struct {
	S7PayloadUserDataItemContract
}

var _ S7PayloadUserDataItemCyclicServicesErrorResponse = (*_S7PayloadUserDataItemCyclicServicesErrorResponse)(nil)
var _ S7PayloadUserDataItemRequirements = (*_S7PayloadUserDataItemCyclicServicesErrorResponse)(nil)

// NewS7PayloadUserDataItemCyclicServicesErrorResponse factory function for _S7PayloadUserDataItemCyclicServicesErrorResponse
func NewS7PayloadUserDataItemCyclicServicesErrorResponse(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16) *_S7PayloadUserDataItemCyclicServicesErrorResponse {
	_result := &_S7PayloadUserDataItemCyclicServicesErrorResponse{
		S7PayloadUserDataItemContract: NewS7PayloadUserDataItem(returnCode, transportSize, dataLength),
	}
	_result.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7PayloadUserDataItemCyclicServicesErrorResponseBuilder is a builder for S7PayloadUserDataItemCyclicServicesErrorResponse
type S7PayloadUserDataItemCyclicServicesErrorResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() S7PayloadUserDataItemCyclicServicesErrorResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() S7PayloadUserDataItemBuilder
	// Build builds the S7PayloadUserDataItemCyclicServicesErrorResponse or returns an error if something is wrong
	Build() (S7PayloadUserDataItemCyclicServicesErrorResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7PayloadUserDataItemCyclicServicesErrorResponse
}

// NewS7PayloadUserDataItemCyclicServicesErrorResponseBuilder() creates a S7PayloadUserDataItemCyclicServicesErrorResponseBuilder
func NewS7PayloadUserDataItemCyclicServicesErrorResponseBuilder() S7PayloadUserDataItemCyclicServicesErrorResponseBuilder {
	return &_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder{_S7PayloadUserDataItemCyclicServicesErrorResponse: new(_S7PayloadUserDataItemCyclicServicesErrorResponse)}
}

type _S7PayloadUserDataItemCyclicServicesErrorResponseBuilder struct {
	*_S7PayloadUserDataItemCyclicServicesErrorResponse

	parentBuilder *_S7PayloadUserDataItemBuilder

	err *utils.MultiError
}

var _ (S7PayloadUserDataItemCyclicServicesErrorResponseBuilder) = (*_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder)(nil)

func (b *_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder) setParent(contract S7PayloadUserDataItemContract) {
	b.S7PayloadUserDataItemContract = contract
	contract.(*_S7PayloadUserDataItem)._SubType = b._S7PayloadUserDataItemCyclicServicesErrorResponse
}

func (b *_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder) WithMandatoryFields() S7PayloadUserDataItemCyclicServicesErrorResponseBuilder {
	return b
}

func (b *_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder) Build() (S7PayloadUserDataItemCyclicServicesErrorResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._S7PayloadUserDataItemCyclicServicesErrorResponse.deepCopy(), nil
}

func (b *_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder) MustBuild() S7PayloadUserDataItemCyclicServicesErrorResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder) Done() S7PayloadUserDataItemBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewS7PayloadUserDataItemBuilder().(*_S7PayloadUserDataItemBuilder)
	}
	return b.parentBuilder
}

func (b *_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder) buildForS7PayloadUserDataItem() (S7PayloadUserDataItem, error) {
	return b.Build()
}

func (b *_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder) DeepCopy() any {
	_copy := b.CreateS7PayloadUserDataItemCyclicServicesErrorResponseBuilder().(*_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateS7PayloadUserDataItemCyclicServicesErrorResponseBuilder creates a S7PayloadUserDataItemCyclicServicesErrorResponseBuilder
func (b *_S7PayloadUserDataItemCyclicServicesErrorResponse) CreateS7PayloadUserDataItemCyclicServicesErrorResponseBuilder() S7PayloadUserDataItemCyclicServicesErrorResponseBuilder {
	if b == nil {
		return NewS7PayloadUserDataItemCyclicServicesErrorResponseBuilder()
	}
	return &_S7PayloadUserDataItemCyclicServicesErrorResponseBuilder{_S7PayloadUserDataItemCyclicServicesErrorResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) GetCpuFunctionGroup() uint8 {
	return 0x02
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) GetCpuFunctionType() uint8 {
	return 0x08
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) GetCpuSubfunction() uint8 {
	return 0x05
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) GetParent() S7PayloadUserDataItemContract {
	return m.S7PayloadUserDataItemContract
}

// Deprecated: use the interface for direct cast
func CastS7PayloadUserDataItemCyclicServicesErrorResponse(structType any) S7PayloadUserDataItemCyclicServicesErrorResponse {
	if casted, ok := structType.(S7PayloadUserDataItemCyclicServicesErrorResponse); ok {
		return casted
	}
	if casted, ok := structType.(*S7PayloadUserDataItemCyclicServicesErrorResponse); ok {
		return *casted
	}
	return nil
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) GetTypeName() string {
	return "S7PayloadUserDataItemCyclicServicesErrorResponse"
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_S7PayloadUserDataItem, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (__s7PayloadUserDataItemCyclicServicesErrorResponse S7PayloadUserDataItemCyclicServicesErrorResponse, err error) {
	m.S7PayloadUserDataItemContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7PayloadUserDataItemCyclicServicesErrorResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7PayloadUserDataItemCyclicServicesErrorResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("S7PayloadUserDataItemCyclicServicesErrorResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7PayloadUserDataItemCyclicServicesErrorResponse")
	}

	return m, nil
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7PayloadUserDataItemCyclicServicesErrorResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7PayloadUserDataItemCyclicServicesErrorResponse")
		}

		if popErr := writeBuffer.PopContext("S7PayloadUserDataItemCyclicServicesErrorResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7PayloadUserDataItemCyclicServicesErrorResponse")
		}
		return nil
	}
	return m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) IsS7PayloadUserDataItemCyclicServicesErrorResponse() {
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) deepCopy() *_S7PayloadUserDataItemCyclicServicesErrorResponse {
	if m == nil {
		return nil
	}
	_S7PayloadUserDataItemCyclicServicesErrorResponseCopy := &_S7PayloadUserDataItemCyclicServicesErrorResponse{
		m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).deepCopy(),
	}
	_S7PayloadUserDataItemCyclicServicesErrorResponseCopy.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = m
	return _S7PayloadUserDataItemCyclicServicesErrorResponseCopy
}

func (m *_S7PayloadUserDataItemCyclicServicesErrorResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
