/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7PayloadAlarmSQ is the corresponding interface of S7PayloadAlarmSQ
type S7PayloadAlarmSQ interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	S7PayloadUserDataItem
	// GetAlarmMessage returns AlarmMessage (property field)
	GetAlarmMessage() AlarmMessagePushType
	// IsS7PayloadAlarmSQ is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7PayloadAlarmSQ()
	// CreateBuilder creates a S7PayloadAlarmSQBuilder
	CreateS7PayloadAlarmSQBuilder() S7PayloadAlarmSQBuilder
}

// _S7PayloadAlarmSQ is the data-structure of this message
type _S7PayloadAlarmSQ struct {
	S7PayloadUserDataItemContract
	AlarmMessage AlarmMessagePushType
}

var _ S7PayloadAlarmSQ = (*_S7PayloadAlarmSQ)(nil)
var _ S7PayloadUserDataItemRequirements = (*_S7PayloadAlarmSQ)(nil)

// NewS7PayloadAlarmSQ factory function for _S7PayloadAlarmSQ
func NewS7PayloadAlarmSQ(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16, alarmMessage AlarmMessagePushType) *_S7PayloadAlarmSQ {
	if alarmMessage == nil {
		panic("alarmMessage of type AlarmMessagePushType for S7PayloadAlarmSQ must not be nil")
	}
	_result := &_S7PayloadAlarmSQ{
		S7PayloadUserDataItemContract: NewS7PayloadUserDataItem(returnCode, transportSize, dataLength),
		AlarmMessage:                  alarmMessage,
	}
	_result.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7PayloadAlarmSQBuilder is a builder for S7PayloadAlarmSQ
type S7PayloadAlarmSQBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(alarmMessage AlarmMessagePushType) S7PayloadAlarmSQBuilder
	// WithAlarmMessage adds AlarmMessage (property field)
	WithAlarmMessage(AlarmMessagePushType) S7PayloadAlarmSQBuilder
	// WithAlarmMessageBuilder adds AlarmMessage (property field) which is build by the builder
	WithAlarmMessageBuilder(func(AlarmMessagePushTypeBuilder) AlarmMessagePushTypeBuilder) S7PayloadAlarmSQBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() S7PayloadUserDataItemBuilder
	// Build builds the S7PayloadAlarmSQ or returns an error if something is wrong
	Build() (S7PayloadAlarmSQ, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7PayloadAlarmSQ
}

// NewS7PayloadAlarmSQBuilder() creates a S7PayloadAlarmSQBuilder
func NewS7PayloadAlarmSQBuilder() S7PayloadAlarmSQBuilder {
	return &_S7PayloadAlarmSQBuilder{_S7PayloadAlarmSQ: new(_S7PayloadAlarmSQ)}
}

type _S7PayloadAlarmSQBuilder struct {
	*_S7PayloadAlarmSQ

	parentBuilder *_S7PayloadUserDataItemBuilder

	err *utils.MultiError
}

var _ (S7PayloadAlarmSQBuilder) = (*_S7PayloadAlarmSQBuilder)(nil)

func (b *_S7PayloadAlarmSQBuilder) setParent(contract S7PayloadUserDataItemContract) {
	b.S7PayloadUserDataItemContract = contract
	contract.(*_S7PayloadUserDataItem)._SubType = b._S7PayloadAlarmSQ
}

func (b *_S7PayloadAlarmSQBuilder) WithMandatoryFields(alarmMessage AlarmMessagePushType) S7PayloadAlarmSQBuilder {
	return b.WithAlarmMessage(alarmMessage)
}

func (b *_S7PayloadAlarmSQBuilder) WithAlarmMessage(alarmMessage AlarmMessagePushType) S7PayloadAlarmSQBuilder {
	b.AlarmMessage = alarmMessage
	return b
}

func (b *_S7PayloadAlarmSQBuilder) WithAlarmMessageBuilder(builderSupplier func(AlarmMessagePushTypeBuilder) AlarmMessagePushTypeBuilder) S7PayloadAlarmSQBuilder {
	builder := builderSupplier(b.AlarmMessage.CreateAlarmMessagePushTypeBuilder())
	var err error
	b.AlarmMessage, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "AlarmMessagePushTypeBuilder failed"))
	}
	return b
}

func (b *_S7PayloadAlarmSQBuilder) Build() (S7PayloadAlarmSQ, error) {
	if b.AlarmMessage == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'alarmMessage' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._S7PayloadAlarmSQ.deepCopy(), nil
}

func (b *_S7PayloadAlarmSQBuilder) MustBuild() S7PayloadAlarmSQ {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7PayloadAlarmSQBuilder) Done() S7PayloadUserDataItemBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewS7PayloadUserDataItemBuilder().(*_S7PayloadUserDataItemBuilder)
	}
	return b.parentBuilder
}

func (b *_S7PayloadAlarmSQBuilder) buildForS7PayloadUserDataItem() (S7PayloadUserDataItem, error) {
	return b.Build()
}

func (b *_S7PayloadAlarmSQBuilder) DeepCopy() any {
	_copy := b.CreateS7PayloadAlarmSQBuilder().(*_S7PayloadAlarmSQBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateS7PayloadAlarmSQBuilder creates a S7PayloadAlarmSQBuilder
func (b *_S7PayloadAlarmSQ) CreateS7PayloadAlarmSQBuilder() S7PayloadAlarmSQBuilder {
	if b == nil {
		return NewS7PayloadAlarmSQBuilder()
	}
	return &_S7PayloadAlarmSQBuilder{_S7PayloadAlarmSQ: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7PayloadAlarmSQ) GetCpuFunctionGroup() uint8 {
	return 0x04
}

func (m *_S7PayloadAlarmSQ) GetCpuFunctionType() uint8 {
	return 0x00
}

func (m *_S7PayloadAlarmSQ) GetCpuSubfunction() uint8 {
	return 0x11
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7PayloadAlarmSQ) GetParent() S7PayloadUserDataItemContract {
	return m.S7PayloadUserDataItemContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_S7PayloadAlarmSQ) GetAlarmMessage() AlarmMessagePushType {
	return m.AlarmMessage
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastS7PayloadAlarmSQ(structType any) S7PayloadAlarmSQ {
	if casted, ok := structType.(S7PayloadAlarmSQ); ok {
		return casted
	}
	if casted, ok := structType.(*S7PayloadAlarmSQ); ok {
		return *casted
	}
	return nil
}

func (m *_S7PayloadAlarmSQ) GetTypeName() string {
	return "S7PayloadAlarmSQ"
}

func (m *_S7PayloadAlarmSQ) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).getLengthInBits(ctx))

	// Simple field (alarmMessage)
	lengthInBits += m.AlarmMessage.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_S7PayloadAlarmSQ) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_S7PayloadAlarmSQ) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_S7PayloadUserDataItem, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (__s7PayloadAlarmSQ S7PayloadAlarmSQ, err error) {
	m.S7PayloadUserDataItemContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7PayloadAlarmSQ"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7PayloadAlarmSQ")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	alarmMessage, err := ReadSimpleField[AlarmMessagePushType](ctx, "alarmMessage", ReadComplex[AlarmMessagePushType](AlarmMessagePushTypeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'alarmMessage' field"))
	}
	m.AlarmMessage = alarmMessage

	if closeErr := readBuffer.CloseContext("S7PayloadAlarmSQ"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7PayloadAlarmSQ")
	}

	return m, nil
}

func (m *_S7PayloadAlarmSQ) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7PayloadAlarmSQ) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7PayloadAlarmSQ"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7PayloadAlarmSQ")
		}

		if err := WriteSimpleField[AlarmMessagePushType](ctx, "alarmMessage", m.GetAlarmMessage(), WriteComplex[AlarmMessagePushType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'alarmMessage' field")
		}

		if popErr := writeBuffer.PopContext("S7PayloadAlarmSQ"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7PayloadAlarmSQ")
		}
		return nil
	}
	return m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7PayloadAlarmSQ) IsS7PayloadAlarmSQ() {}

func (m *_S7PayloadAlarmSQ) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7PayloadAlarmSQ) deepCopy() *_S7PayloadAlarmSQ {
	if m == nil {
		return nil
	}
	_S7PayloadAlarmSQCopy := &_S7PayloadAlarmSQ{
		m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).deepCopy(),
		utils.DeepCopy[AlarmMessagePushType](m.AlarmMessage),
	}
	_S7PayloadAlarmSQCopy.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = m
	return _S7PayloadAlarmSQCopy
}

func (m *_S7PayloadAlarmSQ) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
