/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const AlarmMessageQueryType_DATALENGTH uint16 = 0xFFFF

// AlarmMessageQueryType is the corresponding interface of AlarmMessageQueryType
type AlarmMessageQueryType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetFunctionId returns FunctionId (property field)
	GetFunctionId() uint8
	// GetNumberOfObjects returns NumberOfObjects (property field)
	GetNumberOfObjects() uint8
	// GetReturnCode returns ReturnCode (property field)
	GetReturnCode() DataTransportErrorCode
	// GetTransportSize returns TransportSize (property field)
	GetTransportSize() DataTransportSize
	// GetMessageObjects returns MessageObjects (property field)
	GetMessageObjects() []AlarmMessageObjectQueryType
	// IsAlarmMessageQueryType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAlarmMessageQueryType()
	// CreateBuilder creates a AlarmMessageQueryTypeBuilder
	CreateAlarmMessageQueryTypeBuilder() AlarmMessageQueryTypeBuilder
}

// _AlarmMessageQueryType is the data-structure of this message
type _AlarmMessageQueryType struct {
	FunctionId      uint8
	NumberOfObjects uint8
	ReturnCode      DataTransportErrorCode
	TransportSize   DataTransportSize
	MessageObjects  []AlarmMessageObjectQueryType
}

var _ AlarmMessageQueryType = (*_AlarmMessageQueryType)(nil)

// NewAlarmMessageQueryType factory function for _AlarmMessageQueryType
func NewAlarmMessageQueryType(functionId uint8, numberOfObjects uint8, returnCode DataTransportErrorCode, transportSize DataTransportSize, messageObjects []AlarmMessageObjectQueryType) *_AlarmMessageQueryType {
	return &_AlarmMessageQueryType{FunctionId: functionId, NumberOfObjects: numberOfObjects, ReturnCode: returnCode, TransportSize: transportSize, MessageObjects: messageObjects}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AlarmMessageQueryTypeBuilder is a builder for AlarmMessageQueryType
type AlarmMessageQueryTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(functionId uint8, numberOfObjects uint8, returnCode DataTransportErrorCode, transportSize DataTransportSize, messageObjects []AlarmMessageObjectQueryType) AlarmMessageQueryTypeBuilder
	// WithFunctionId adds FunctionId (property field)
	WithFunctionId(uint8) AlarmMessageQueryTypeBuilder
	// WithNumberOfObjects adds NumberOfObjects (property field)
	WithNumberOfObjects(uint8) AlarmMessageQueryTypeBuilder
	// WithReturnCode adds ReturnCode (property field)
	WithReturnCode(DataTransportErrorCode) AlarmMessageQueryTypeBuilder
	// WithTransportSize adds TransportSize (property field)
	WithTransportSize(DataTransportSize) AlarmMessageQueryTypeBuilder
	// WithMessageObjects adds MessageObjects (property field)
	WithMessageObjects(...AlarmMessageObjectQueryType) AlarmMessageQueryTypeBuilder
	// Build builds the AlarmMessageQueryType or returns an error if something is wrong
	Build() (AlarmMessageQueryType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AlarmMessageQueryType
}

// NewAlarmMessageQueryTypeBuilder() creates a AlarmMessageQueryTypeBuilder
func NewAlarmMessageQueryTypeBuilder() AlarmMessageQueryTypeBuilder {
	return &_AlarmMessageQueryTypeBuilder{_AlarmMessageQueryType: new(_AlarmMessageQueryType)}
}

type _AlarmMessageQueryTypeBuilder struct {
	*_AlarmMessageQueryType

	err *utils.MultiError
}

var _ (AlarmMessageQueryTypeBuilder) = (*_AlarmMessageQueryTypeBuilder)(nil)

func (b *_AlarmMessageQueryTypeBuilder) WithMandatoryFields(functionId uint8, numberOfObjects uint8, returnCode DataTransportErrorCode, transportSize DataTransportSize, messageObjects []AlarmMessageObjectQueryType) AlarmMessageQueryTypeBuilder {
	return b.WithFunctionId(functionId).WithNumberOfObjects(numberOfObjects).WithReturnCode(returnCode).WithTransportSize(transportSize).WithMessageObjects(messageObjects...)
}

func (b *_AlarmMessageQueryTypeBuilder) WithFunctionId(functionId uint8) AlarmMessageQueryTypeBuilder {
	b.FunctionId = functionId
	return b
}

func (b *_AlarmMessageQueryTypeBuilder) WithNumberOfObjects(numberOfObjects uint8) AlarmMessageQueryTypeBuilder {
	b.NumberOfObjects = numberOfObjects
	return b
}

func (b *_AlarmMessageQueryTypeBuilder) WithReturnCode(returnCode DataTransportErrorCode) AlarmMessageQueryTypeBuilder {
	b.ReturnCode = returnCode
	return b
}

func (b *_AlarmMessageQueryTypeBuilder) WithTransportSize(transportSize DataTransportSize) AlarmMessageQueryTypeBuilder {
	b.TransportSize = transportSize
	return b
}

func (b *_AlarmMessageQueryTypeBuilder) WithMessageObjects(messageObjects ...AlarmMessageObjectQueryType) AlarmMessageQueryTypeBuilder {
	b.MessageObjects = messageObjects
	return b
}

func (b *_AlarmMessageQueryTypeBuilder) Build() (AlarmMessageQueryType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AlarmMessageQueryType.deepCopy(), nil
}

func (b *_AlarmMessageQueryTypeBuilder) MustBuild() AlarmMessageQueryType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AlarmMessageQueryTypeBuilder) DeepCopy() any {
	_copy := b.CreateAlarmMessageQueryTypeBuilder().(*_AlarmMessageQueryTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAlarmMessageQueryTypeBuilder creates a AlarmMessageQueryTypeBuilder
func (b *_AlarmMessageQueryType) CreateAlarmMessageQueryTypeBuilder() AlarmMessageQueryTypeBuilder {
	if b == nil {
		return NewAlarmMessageQueryTypeBuilder()
	}
	return &_AlarmMessageQueryTypeBuilder{_AlarmMessageQueryType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AlarmMessageQueryType) GetFunctionId() uint8 {
	return m.FunctionId
}

func (m *_AlarmMessageQueryType) GetNumberOfObjects() uint8 {
	return m.NumberOfObjects
}

func (m *_AlarmMessageQueryType) GetReturnCode() DataTransportErrorCode {
	return m.ReturnCode
}

func (m *_AlarmMessageQueryType) GetTransportSize() DataTransportSize {
	return m.TransportSize
}

func (m *_AlarmMessageQueryType) GetMessageObjects() []AlarmMessageObjectQueryType {
	return m.MessageObjects
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_AlarmMessageQueryType) GetDataLength() uint16 {
	return AlarmMessageQueryType_DATALENGTH
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAlarmMessageQueryType(structType any) AlarmMessageQueryType {
	if casted, ok := structType.(AlarmMessageQueryType); ok {
		return casted
	}
	if casted, ok := structType.(*AlarmMessageQueryType); ok {
		return *casted
	}
	return nil
}

func (m *_AlarmMessageQueryType) GetTypeName() string {
	return "AlarmMessageQueryType"
}

func (m *_AlarmMessageQueryType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (functionId)
	lengthInBits += 8

	// Simple field (numberOfObjects)
	lengthInBits += 8

	// Simple field (returnCode)
	lengthInBits += 8

	// Simple field (transportSize)
	lengthInBits += 8

	// Const Field (dataLength)
	lengthInBits += 16

	// Array field
	if len(m.MessageObjects) > 0 {
		for _curItem, element := range m.MessageObjects {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.MessageObjects), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_AlarmMessageQueryType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AlarmMessageQueryTypeParse(ctx context.Context, theBytes []byte) (AlarmMessageQueryType, error) {
	return AlarmMessageQueryTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AlarmMessageQueryTypeParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageQueryType, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageQueryType, error) {
		return AlarmMessageQueryTypeParseWithBuffer(ctx, readBuffer)
	}
}

func AlarmMessageQueryTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AlarmMessageQueryType, error) {
	v, err := (&_AlarmMessageQueryType{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_AlarmMessageQueryType) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__alarmMessageQueryType AlarmMessageQueryType, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AlarmMessageQueryType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AlarmMessageQueryType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	functionId, err := ReadSimpleField(ctx, "functionId", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'functionId' field"))
	}
	m.FunctionId = functionId

	numberOfObjects, err := ReadSimpleField(ctx, "numberOfObjects", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfObjects' field"))
	}
	m.NumberOfObjects = numberOfObjects

	returnCode, err := ReadEnumField[DataTransportErrorCode](ctx, "returnCode", "DataTransportErrorCode", ReadEnum(DataTransportErrorCodeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'returnCode' field"))
	}
	m.ReturnCode = returnCode

	transportSize, err := ReadEnumField[DataTransportSize](ctx, "transportSize", "DataTransportSize", ReadEnum(DataTransportSizeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transportSize' field"))
	}
	m.TransportSize = transportSize

	dataLength, err := ReadConstField[uint16](ctx, "dataLength", ReadUnsignedShort(readBuffer, uint8(16)), AlarmMessageQueryType_DATALENGTH)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataLength' field"))
	}
	_ = dataLength

	messageObjects, err := ReadCountArrayField[AlarmMessageObjectQueryType](ctx, "messageObjects", ReadComplex[AlarmMessageObjectQueryType](AlarmMessageObjectQueryTypeParseWithBuffer, readBuffer), uint64(numberOfObjects))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageObjects' field"))
	}
	m.MessageObjects = messageObjects

	if closeErr := readBuffer.CloseContext("AlarmMessageQueryType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AlarmMessageQueryType")
	}

	return m, nil
}

func (m *_AlarmMessageQueryType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AlarmMessageQueryType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AlarmMessageQueryType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AlarmMessageQueryType")
	}

	if err := WriteSimpleField[uint8](ctx, "functionId", m.GetFunctionId(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'functionId' field")
	}

	if err := WriteSimpleField[uint8](ctx, "numberOfObjects", m.GetNumberOfObjects(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'numberOfObjects' field")
	}

	if err := WriteSimpleEnumField[DataTransportErrorCode](ctx, "returnCode", "DataTransportErrorCode", m.GetReturnCode(), WriteEnum[DataTransportErrorCode, uint8](DataTransportErrorCode.GetValue, DataTransportErrorCode.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'returnCode' field")
	}

	if err := WriteSimpleEnumField[DataTransportSize](ctx, "transportSize", "DataTransportSize", m.GetTransportSize(), WriteEnum[DataTransportSize, uint8](DataTransportSize.GetValue, DataTransportSize.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'transportSize' field")
	}

	if err := WriteConstField(ctx, "dataLength", AlarmMessageQueryType_DATALENGTH, WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'dataLength' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "messageObjects", m.GetMessageObjects(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'messageObjects' field")
	}

	if popErr := writeBuffer.PopContext("AlarmMessageQueryType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AlarmMessageQueryType")
	}
	return nil
}

func (m *_AlarmMessageQueryType) IsAlarmMessageQueryType() {}

func (m *_AlarmMessageQueryType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AlarmMessageQueryType) deepCopy() *_AlarmMessageQueryType {
	if m == nil {
		return nil
	}
	_AlarmMessageQueryTypeCopy := &_AlarmMessageQueryType{
		m.FunctionId,
		m.NumberOfObjects,
		m.ReturnCode,
		m.TransportSize,
		utils.DeepCopySlice[AlarmMessageObjectQueryType, AlarmMessageObjectQueryType](m.MessageObjects),
	}
	return _AlarmMessageQueryTypeCopy
}

func (m *_AlarmMessageQueryType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
