/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Alarm8MessageQueryType is the corresponding interface of Alarm8MessageQueryType
type Alarm8MessageQueryType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetFunctionId returns FunctionId (property field)
	GetFunctionId() uint8
	// GetNumberOfObjects returns NumberOfObjects (property field)
	GetNumberOfObjects() uint8
	// GetReturnCode returns ReturnCode (property field)
	GetReturnCode() DataTransportErrorCode
	// GetTransportSize returns TransportSize (property field)
	GetTransportSize() DataTransportSize
	// GetByteCount returns ByteCount (property field)
	GetByteCount() uint16
	// GetMessageObjects returns MessageObjects (property field)
	GetMessageObjects() []AlarmMessageObjectQueryType
	// IsAlarm8MessageQueryType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAlarm8MessageQueryType()
	// CreateBuilder creates a Alarm8MessageQueryTypeBuilder
	CreateAlarm8MessageQueryTypeBuilder() Alarm8MessageQueryTypeBuilder
}

// _Alarm8MessageQueryType is the data-structure of this message
type _Alarm8MessageQueryType struct {
	FunctionId      uint8
	NumberOfObjects uint8
	ReturnCode      DataTransportErrorCode
	TransportSize   DataTransportSize
	ByteCount       uint16
	MessageObjects  []AlarmMessageObjectQueryType
}

var _ Alarm8MessageQueryType = (*_Alarm8MessageQueryType)(nil)

// NewAlarm8MessageQueryType factory function for _Alarm8MessageQueryType
func NewAlarm8MessageQueryType(functionId uint8, numberOfObjects uint8, returnCode DataTransportErrorCode, transportSize DataTransportSize, byteCount uint16, messageObjects []AlarmMessageObjectQueryType) *_Alarm8MessageQueryType {
	return &_Alarm8MessageQueryType{FunctionId: functionId, NumberOfObjects: numberOfObjects, ReturnCode: returnCode, TransportSize: transportSize, ByteCount: byteCount, MessageObjects: messageObjects}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// Alarm8MessageQueryTypeBuilder is a builder for Alarm8MessageQueryType
type Alarm8MessageQueryTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(functionId uint8, numberOfObjects uint8, returnCode DataTransportErrorCode, transportSize DataTransportSize, byteCount uint16, messageObjects []AlarmMessageObjectQueryType) Alarm8MessageQueryTypeBuilder
	// WithFunctionId adds FunctionId (property field)
	WithFunctionId(uint8) Alarm8MessageQueryTypeBuilder
	// WithNumberOfObjects adds NumberOfObjects (property field)
	WithNumberOfObjects(uint8) Alarm8MessageQueryTypeBuilder
	// WithReturnCode adds ReturnCode (property field)
	WithReturnCode(DataTransportErrorCode) Alarm8MessageQueryTypeBuilder
	// WithTransportSize adds TransportSize (property field)
	WithTransportSize(DataTransportSize) Alarm8MessageQueryTypeBuilder
	// WithByteCount adds ByteCount (property field)
	WithByteCount(uint16) Alarm8MessageQueryTypeBuilder
	// WithMessageObjects adds MessageObjects (property field)
	WithMessageObjects(...AlarmMessageObjectQueryType) Alarm8MessageQueryTypeBuilder
	// Build builds the Alarm8MessageQueryType or returns an error if something is wrong
	Build() (Alarm8MessageQueryType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() Alarm8MessageQueryType
}

// NewAlarm8MessageQueryTypeBuilder() creates a Alarm8MessageQueryTypeBuilder
func NewAlarm8MessageQueryTypeBuilder() Alarm8MessageQueryTypeBuilder {
	return &_Alarm8MessageQueryTypeBuilder{_Alarm8MessageQueryType: new(_Alarm8MessageQueryType)}
}

type _Alarm8MessageQueryTypeBuilder struct {
	*_Alarm8MessageQueryType

	err *utils.MultiError
}

var _ (Alarm8MessageQueryTypeBuilder) = (*_Alarm8MessageQueryTypeBuilder)(nil)

func (b *_Alarm8MessageQueryTypeBuilder) WithMandatoryFields(functionId uint8, numberOfObjects uint8, returnCode DataTransportErrorCode, transportSize DataTransportSize, byteCount uint16, messageObjects []AlarmMessageObjectQueryType) Alarm8MessageQueryTypeBuilder {
	return b.WithFunctionId(functionId).WithNumberOfObjects(numberOfObjects).WithReturnCode(returnCode).WithTransportSize(transportSize).WithByteCount(byteCount).WithMessageObjects(messageObjects...)
}

func (b *_Alarm8MessageQueryTypeBuilder) WithFunctionId(functionId uint8) Alarm8MessageQueryTypeBuilder {
	b.FunctionId = functionId
	return b
}

func (b *_Alarm8MessageQueryTypeBuilder) WithNumberOfObjects(numberOfObjects uint8) Alarm8MessageQueryTypeBuilder {
	b.NumberOfObjects = numberOfObjects
	return b
}

func (b *_Alarm8MessageQueryTypeBuilder) WithReturnCode(returnCode DataTransportErrorCode) Alarm8MessageQueryTypeBuilder {
	b.ReturnCode = returnCode
	return b
}

func (b *_Alarm8MessageQueryTypeBuilder) WithTransportSize(transportSize DataTransportSize) Alarm8MessageQueryTypeBuilder {
	b.TransportSize = transportSize
	return b
}

func (b *_Alarm8MessageQueryTypeBuilder) WithByteCount(byteCount uint16) Alarm8MessageQueryTypeBuilder {
	b.ByteCount = byteCount
	return b
}

func (b *_Alarm8MessageQueryTypeBuilder) WithMessageObjects(messageObjects ...AlarmMessageObjectQueryType) Alarm8MessageQueryTypeBuilder {
	b.MessageObjects = messageObjects
	return b
}

func (b *_Alarm8MessageQueryTypeBuilder) Build() (Alarm8MessageQueryType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._Alarm8MessageQueryType.deepCopy(), nil
}

func (b *_Alarm8MessageQueryTypeBuilder) MustBuild() Alarm8MessageQueryType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_Alarm8MessageQueryTypeBuilder) DeepCopy() any {
	_copy := b.CreateAlarm8MessageQueryTypeBuilder().(*_Alarm8MessageQueryTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAlarm8MessageQueryTypeBuilder creates a Alarm8MessageQueryTypeBuilder
func (b *_Alarm8MessageQueryType) CreateAlarm8MessageQueryTypeBuilder() Alarm8MessageQueryTypeBuilder {
	if b == nil {
		return NewAlarm8MessageQueryTypeBuilder()
	}
	return &_Alarm8MessageQueryTypeBuilder{_Alarm8MessageQueryType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_Alarm8MessageQueryType) GetFunctionId() uint8 {
	return m.FunctionId
}

func (m *_Alarm8MessageQueryType) GetNumberOfObjects() uint8 {
	return m.NumberOfObjects
}

func (m *_Alarm8MessageQueryType) GetReturnCode() DataTransportErrorCode {
	return m.ReturnCode
}

func (m *_Alarm8MessageQueryType) GetTransportSize() DataTransportSize {
	return m.TransportSize
}

func (m *_Alarm8MessageQueryType) GetByteCount() uint16 {
	return m.ByteCount
}

func (m *_Alarm8MessageQueryType) GetMessageObjects() []AlarmMessageObjectQueryType {
	return m.MessageObjects
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAlarm8MessageQueryType(structType any) Alarm8MessageQueryType {
	if casted, ok := structType.(Alarm8MessageQueryType); ok {
		return casted
	}
	if casted, ok := structType.(*Alarm8MessageQueryType); ok {
		return *casted
	}
	return nil
}

func (m *_Alarm8MessageQueryType) GetTypeName() string {
	return "Alarm8MessageQueryType"
}

func (m *_Alarm8MessageQueryType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (functionId)
	lengthInBits += 8

	// Simple field (numberOfObjects)
	lengthInBits += 8

	// Simple field (returnCode)
	lengthInBits += 8

	// Simple field (transportSize)
	lengthInBits += 8

	// Simple field (byteCount)
	lengthInBits += 16

	// Array field
	if len(m.MessageObjects) > 0 {
		for _curItem, element := range m.MessageObjects {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.MessageObjects), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_Alarm8MessageQueryType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func Alarm8MessageQueryTypeParse(ctx context.Context, theBytes []byte) (Alarm8MessageQueryType, error) {
	return Alarm8MessageQueryTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func Alarm8MessageQueryTypeParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (Alarm8MessageQueryType, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (Alarm8MessageQueryType, error) {
		return Alarm8MessageQueryTypeParseWithBuffer(ctx, readBuffer)
	}
}

func Alarm8MessageQueryTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (Alarm8MessageQueryType, error) {
	v, err := (&_Alarm8MessageQueryType{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_Alarm8MessageQueryType) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__alarm8MessageQueryType Alarm8MessageQueryType, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("Alarm8MessageQueryType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Alarm8MessageQueryType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	functionId, err := ReadSimpleField(ctx, "functionId", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'functionId' field"))
	}
	m.FunctionId = functionId

	numberOfObjects, err := ReadSimpleField(ctx, "numberOfObjects", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfObjects' field"))
	}
	m.NumberOfObjects = numberOfObjects

	returnCode, err := ReadEnumField[DataTransportErrorCode](ctx, "returnCode", "DataTransportErrorCode", ReadEnum(DataTransportErrorCodeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'returnCode' field"))
	}
	m.ReturnCode = returnCode

	transportSize, err := ReadEnumField[DataTransportSize](ctx, "transportSize", "DataTransportSize", ReadEnum(DataTransportSizeByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transportSize' field"))
	}
	m.TransportSize = transportSize

	byteCount, err := ReadSimpleField(ctx, "byteCount", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'byteCount' field"))
	}
	m.ByteCount = byteCount

	messageObjects, err := ReadCountArrayField[AlarmMessageObjectQueryType](ctx, "messageObjects", ReadComplex[AlarmMessageObjectQueryType](AlarmMessageObjectQueryTypeParseWithBuffer, readBuffer), uint64(int32(byteCount)/int32(int32(12))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageObjects' field"))
	}
	m.MessageObjects = messageObjects

	if closeErr := readBuffer.CloseContext("Alarm8MessageQueryType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Alarm8MessageQueryType")
	}

	return m, nil
}

func (m *_Alarm8MessageQueryType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Alarm8MessageQueryType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Alarm8MessageQueryType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Alarm8MessageQueryType")
	}

	if err := WriteSimpleField[uint8](ctx, "functionId", m.GetFunctionId(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'functionId' field")
	}

	if err := WriteSimpleField[uint8](ctx, "numberOfObjects", m.GetNumberOfObjects(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'numberOfObjects' field")
	}

	if err := WriteSimpleEnumField[DataTransportErrorCode](ctx, "returnCode", "DataTransportErrorCode", m.GetReturnCode(), WriteEnum[DataTransportErrorCode, uint8](DataTransportErrorCode.GetValue, DataTransportErrorCode.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'returnCode' field")
	}

	if err := WriteSimpleEnumField[DataTransportSize](ctx, "transportSize", "DataTransportSize", m.GetTransportSize(), WriteEnum[DataTransportSize, uint8](DataTransportSize.GetValue, DataTransportSize.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
		return errors.Wrap(err, "Error serializing 'transportSize' field")
	}

	if err := WriteSimpleField[uint16](ctx, "byteCount", m.GetByteCount(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'byteCount' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "messageObjects", m.GetMessageObjects(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'messageObjects' field")
	}

	if popErr := writeBuffer.PopContext("Alarm8MessageQueryType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Alarm8MessageQueryType")
	}
	return nil
}

func (m *_Alarm8MessageQueryType) IsAlarm8MessageQueryType() {}

func (m *_Alarm8MessageQueryType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_Alarm8MessageQueryType) deepCopy() *_Alarm8MessageQueryType {
	if m == nil {
		return nil
	}
	_Alarm8MessageQueryTypeCopy := &_Alarm8MessageQueryType{
		m.FunctionId,
		m.NumberOfObjects,
		m.ReturnCode,
		m.TransportSize,
		m.ByteCount,
		utils.DeepCopySlice[AlarmMessageObjectQueryType, AlarmMessageObjectQueryType](m.MessageObjects),
	}
	return _Alarm8MessageQueryTypeCopy
}

func (m *_Alarm8MessageQueryType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
