/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ViewDescription is the corresponding interface of ViewDescription
type ViewDescription interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetViewId returns ViewId (property field)
	GetViewId() NodeId
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetViewVersion returns ViewVersion (property field)
	GetViewVersion() uint32
	// IsViewDescription is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsViewDescription()
	// CreateBuilder creates a ViewDescriptionBuilder
	CreateViewDescriptionBuilder() ViewDescriptionBuilder
}

// _ViewDescription is the data-structure of this message
type _ViewDescription struct {
	ExtensionObjectDefinitionContract
	ViewId      NodeId
	Timestamp   int64
	ViewVersion uint32
}

var _ ViewDescription = (*_ViewDescription)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ViewDescription)(nil)

// NewViewDescription factory function for _ViewDescription
func NewViewDescription(viewId NodeId, timestamp int64, viewVersion uint32) *_ViewDescription {
	if viewId == nil {
		panic("viewId of type NodeId for ViewDescription must not be nil")
	}
	_result := &_ViewDescription{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ViewId:                            viewId,
		Timestamp:                         timestamp,
		ViewVersion:                       viewVersion,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ViewDescriptionBuilder is a builder for ViewDescription
type ViewDescriptionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(viewId NodeId, timestamp int64, viewVersion uint32) ViewDescriptionBuilder
	// WithViewId adds ViewId (property field)
	WithViewId(NodeId) ViewDescriptionBuilder
	// WithViewIdBuilder adds ViewId (property field) which is build by the builder
	WithViewIdBuilder(func(NodeIdBuilder) NodeIdBuilder) ViewDescriptionBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) ViewDescriptionBuilder
	// WithViewVersion adds ViewVersion (property field)
	WithViewVersion(uint32) ViewDescriptionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ViewDescription or returns an error if something is wrong
	Build() (ViewDescription, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ViewDescription
}

// NewViewDescriptionBuilder() creates a ViewDescriptionBuilder
func NewViewDescriptionBuilder() ViewDescriptionBuilder {
	return &_ViewDescriptionBuilder{_ViewDescription: new(_ViewDescription)}
}

type _ViewDescriptionBuilder struct {
	*_ViewDescription

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ViewDescriptionBuilder) = (*_ViewDescriptionBuilder)(nil)

func (b *_ViewDescriptionBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ViewDescription
}

func (b *_ViewDescriptionBuilder) WithMandatoryFields(viewId NodeId, timestamp int64, viewVersion uint32) ViewDescriptionBuilder {
	return b.WithViewId(viewId).WithTimestamp(timestamp).WithViewVersion(viewVersion)
}

func (b *_ViewDescriptionBuilder) WithViewId(viewId NodeId) ViewDescriptionBuilder {
	b.ViewId = viewId
	return b
}

func (b *_ViewDescriptionBuilder) WithViewIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) ViewDescriptionBuilder {
	builder := builderSupplier(b.ViewId.CreateNodeIdBuilder())
	var err error
	b.ViewId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_ViewDescriptionBuilder) WithTimestamp(timestamp int64) ViewDescriptionBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_ViewDescriptionBuilder) WithViewVersion(viewVersion uint32) ViewDescriptionBuilder {
	b.ViewVersion = viewVersion
	return b
}

func (b *_ViewDescriptionBuilder) Build() (ViewDescription, error) {
	if b.ViewId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'viewId' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ViewDescription.deepCopy(), nil
}

func (b *_ViewDescriptionBuilder) MustBuild() ViewDescription {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ViewDescriptionBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ViewDescriptionBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ViewDescriptionBuilder) DeepCopy() any {
	_copy := b.CreateViewDescriptionBuilder().(*_ViewDescriptionBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateViewDescriptionBuilder creates a ViewDescriptionBuilder
func (b *_ViewDescription) CreateViewDescriptionBuilder() ViewDescriptionBuilder {
	if b == nil {
		return NewViewDescriptionBuilder()
	}
	return &_ViewDescriptionBuilder{_ViewDescription: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ViewDescription) GetExtensionId() int32 {
	return int32(513)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ViewDescription) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ViewDescription) GetViewId() NodeId {
	return m.ViewId
}

func (m *_ViewDescription) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_ViewDescription) GetViewVersion() uint32 {
	return m.ViewVersion
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastViewDescription(structType any) ViewDescription {
	if casted, ok := structType.(ViewDescription); ok {
		return casted
	}
	if casted, ok := structType.(*ViewDescription); ok {
		return *casted
	}
	return nil
}

func (m *_ViewDescription) GetTypeName() string {
	return "ViewDescription"
}

func (m *_ViewDescription) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (viewId)
	lengthInBits += m.ViewId.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += 64

	// Simple field (viewVersion)
	lengthInBits += 32

	return lengthInBits
}

func (m *_ViewDescription) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ViewDescription) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__viewDescription ViewDescription, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ViewDescription"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ViewDescription")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	viewId, err := ReadSimpleField[NodeId](ctx, "viewId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'viewId' field"))
	}
	m.ViewId = viewId

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	viewVersion, err := ReadSimpleField(ctx, "viewVersion", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'viewVersion' field"))
	}
	m.ViewVersion = viewVersion

	if closeErr := readBuffer.CloseContext("ViewDescription"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ViewDescription")
	}

	return m, nil
}

func (m *_ViewDescription) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ViewDescription) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ViewDescription"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ViewDescription")
		}

		if err := WriteSimpleField[NodeId](ctx, "viewId", m.GetViewId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'viewId' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[uint32](ctx, "viewVersion", m.GetViewVersion(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'viewVersion' field")
		}

		if popErr := writeBuffer.PopContext("ViewDescription"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ViewDescription")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ViewDescription) IsViewDescription() {}

func (m *_ViewDescription) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ViewDescription) deepCopy() *_ViewDescription {
	if m == nil {
		return nil
	}
	_ViewDescriptionCopy := &_ViewDescription{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.ViewId),
		m.Timestamp,
		m.ViewVersion,
	}
	_ViewDescriptionCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ViewDescriptionCopy
}

func (m *_ViewDescription) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
