/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VariantExpandedNodeId is the corresponding interface of VariantExpandedNodeId
type VariantExpandedNodeId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Variant
	// GetArrayLength returns ArrayLength (property field)
	GetArrayLength() *int32
	// GetValue returns Value (property field)
	GetValue() []ExpandedNodeId
	// IsVariantExpandedNodeId is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVariantExpandedNodeId()
	// CreateBuilder creates a VariantExpandedNodeIdBuilder
	CreateVariantExpandedNodeIdBuilder() VariantExpandedNodeIdBuilder
}

// _VariantExpandedNodeId is the data-structure of this message
type _VariantExpandedNodeId struct {
	VariantContract
	ArrayLength *int32
	Value       []ExpandedNodeId
}

var _ VariantExpandedNodeId = (*_VariantExpandedNodeId)(nil)
var _ VariantRequirements = (*_VariantExpandedNodeId)(nil)

// NewVariantExpandedNodeId factory function for _VariantExpandedNodeId
func NewVariantExpandedNodeId(arrayLengthSpecified bool, arrayDimensionsSpecified bool, noOfArrayDimensions *int32, arrayDimensions []bool, arrayLength *int32, value []ExpandedNodeId) *_VariantExpandedNodeId {
	_result := &_VariantExpandedNodeId{
		VariantContract: NewVariant(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions),
		ArrayLength:     arrayLength,
		Value:           value,
	}
	_result.VariantContract.(*_Variant)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VariantExpandedNodeIdBuilder is a builder for VariantExpandedNodeId
type VariantExpandedNodeIdBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value []ExpandedNodeId) VariantExpandedNodeIdBuilder
	// WithArrayLength adds ArrayLength (property field)
	WithOptionalArrayLength(int32) VariantExpandedNodeIdBuilder
	// WithValue adds Value (property field)
	WithValue(...ExpandedNodeId) VariantExpandedNodeIdBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() VariantBuilder
	// Build builds the VariantExpandedNodeId or returns an error if something is wrong
	Build() (VariantExpandedNodeId, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VariantExpandedNodeId
}

// NewVariantExpandedNodeIdBuilder() creates a VariantExpandedNodeIdBuilder
func NewVariantExpandedNodeIdBuilder() VariantExpandedNodeIdBuilder {
	return &_VariantExpandedNodeIdBuilder{_VariantExpandedNodeId: new(_VariantExpandedNodeId)}
}

type _VariantExpandedNodeIdBuilder struct {
	*_VariantExpandedNodeId

	parentBuilder *_VariantBuilder

	err *utils.MultiError
}

var _ (VariantExpandedNodeIdBuilder) = (*_VariantExpandedNodeIdBuilder)(nil)

func (b *_VariantExpandedNodeIdBuilder) setParent(contract VariantContract) {
	b.VariantContract = contract
	contract.(*_Variant)._SubType = b._VariantExpandedNodeId
}

func (b *_VariantExpandedNodeIdBuilder) WithMandatoryFields(value []ExpandedNodeId) VariantExpandedNodeIdBuilder {
	return b.WithValue(value...)
}

func (b *_VariantExpandedNodeIdBuilder) WithOptionalArrayLength(arrayLength int32) VariantExpandedNodeIdBuilder {
	b.ArrayLength = &arrayLength
	return b
}

func (b *_VariantExpandedNodeIdBuilder) WithValue(value ...ExpandedNodeId) VariantExpandedNodeIdBuilder {
	b.Value = value
	return b
}

func (b *_VariantExpandedNodeIdBuilder) Build() (VariantExpandedNodeId, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._VariantExpandedNodeId.deepCopy(), nil
}

func (b *_VariantExpandedNodeIdBuilder) MustBuild() VariantExpandedNodeId {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VariantExpandedNodeIdBuilder) Done() VariantBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewVariantBuilder().(*_VariantBuilder)
	}
	return b.parentBuilder
}

func (b *_VariantExpandedNodeIdBuilder) buildForVariant() (Variant, error) {
	return b.Build()
}

func (b *_VariantExpandedNodeIdBuilder) DeepCopy() any {
	_copy := b.CreateVariantExpandedNodeIdBuilder().(*_VariantExpandedNodeIdBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateVariantExpandedNodeIdBuilder creates a VariantExpandedNodeIdBuilder
func (b *_VariantExpandedNodeId) CreateVariantExpandedNodeIdBuilder() VariantExpandedNodeIdBuilder {
	if b == nil {
		return NewVariantExpandedNodeIdBuilder()
	}
	return &_VariantExpandedNodeIdBuilder{_VariantExpandedNodeId: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_VariantExpandedNodeId) GetVariantType() uint8 {
	return uint8(18)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_VariantExpandedNodeId) GetParent() VariantContract {
	return m.VariantContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VariantExpandedNodeId) GetArrayLength() *int32 {
	return m.ArrayLength
}

func (m *_VariantExpandedNodeId) GetValue() []ExpandedNodeId {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVariantExpandedNodeId(structType any) VariantExpandedNodeId {
	if casted, ok := structType.(VariantExpandedNodeId); ok {
		return casted
	}
	if casted, ok := structType.(*VariantExpandedNodeId); ok {
		return *casted
	}
	return nil
}

func (m *_VariantExpandedNodeId) GetTypeName() string {
	return "VariantExpandedNodeId"
}

func (m *_VariantExpandedNodeId) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.VariantContract.(*_Variant).getLengthInBits(ctx))

	// Optional Field (arrayLength)
	if m.ArrayLength != nil {
		lengthInBits += 32
	}

	// Array field
	if len(m.Value) > 0 {
		for _curItem, element := range m.Value {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Value), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_VariantExpandedNodeId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_VariantExpandedNodeId) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Variant, arrayLengthSpecified bool) (__variantExpandedNodeId VariantExpandedNodeId, err error) {
	m.VariantContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VariantExpandedNodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VariantExpandedNodeId")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	var arrayLength *int32
	arrayLength, err = ReadOptionalField[int32](ctx, "arrayLength", ReadSignedInt(readBuffer, uint8(32)), arrayLengthSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'arrayLength' field"))
	}
	m.ArrayLength = arrayLength

	value, err := ReadCountArrayField[ExpandedNodeId](ctx, "value", ReadComplex[ExpandedNodeId](ExpandedNodeIdParseWithBuffer, readBuffer), uint64(utils.InlineIf(bool((arrayLength) == (nil)), func() any { return int32(int32(1)) }, func() any { return int32((*arrayLength)) }).(int32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("VariantExpandedNodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VariantExpandedNodeId")
	}

	return m, nil
}

func (m *_VariantExpandedNodeId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VariantExpandedNodeId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("VariantExpandedNodeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for VariantExpandedNodeId")
		}

		if err := WriteOptionalField[int32](ctx, "arrayLength", m.GetArrayLength(), WriteSignedInt(writeBuffer, 32), true); err != nil {
			return errors.Wrap(err, "Error serializing 'arrayLength' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "value", m.GetValue(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("VariantExpandedNodeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for VariantExpandedNodeId")
		}
		return nil
	}
	return m.VariantContract.(*_Variant).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_VariantExpandedNodeId) IsVariantExpandedNodeId() {}

func (m *_VariantExpandedNodeId) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VariantExpandedNodeId) deepCopy() *_VariantExpandedNodeId {
	if m == nil {
		return nil
	}
	_VariantExpandedNodeIdCopy := &_VariantExpandedNodeId{
		m.VariantContract.(*_Variant).deepCopy(),
		utils.CopyPtr[int32](m.ArrayLength),
		utils.DeepCopySlice[ExpandedNodeId, ExpandedNodeId](m.Value),
	}
	_VariantExpandedNodeIdCopy.VariantContract.(*_Variant)._SubType = m
	return _VariantExpandedNodeIdCopy
}

func (m *_VariantExpandedNodeId) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
