/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// UnsignedRationalNumber is the corresponding interface of UnsignedRationalNumber
type UnsignedRationalNumber interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetNumerator returns Numerator (property field)
	GetNumerator() uint32
	// GetDenominator returns Denominator (property field)
	GetDenominator() uint32
	// IsUnsignedRationalNumber is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsUnsignedRationalNumber()
	// CreateBuilder creates a UnsignedRationalNumberBuilder
	CreateUnsignedRationalNumberBuilder() UnsignedRationalNumberBuilder
}

// _UnsignedRationalNumber is the data-structure of this message
type _UnsignedRationalNumber struct {
	ExtensionObjectDefinitionContract
	Numerator   uint32
	Denominator uint32
}

var _ UnsignedRationalNumber = (*_UnsignedRationalNumber)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_UnsignedRationalNumber)(nil)

// NewUnsignedRationalNumber factory function for _UnsignedRationalNumber
func NewUnsignedRationalNumber(numerator uint32, denominator uint32) *_UnsignedRationalNumber {
	_result := &_UnsignedRationalNumber{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Numerator:                         numerator,
		Denominator:                       denominator,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// UnsignedRationalNumberBuilder is a builder for UnsignedRationalNumber
type UnsignedRationalNumberBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(numerator uint32, denominator uint32) UnsignedRationalNumberBuilder
	// WithNumerator adds Numerator (property field)
	WithNumerator(uint32) UnsignedRationalNumberBuilder
	// WithDenominator adds Denominator (property field)
	WithDenominator(uint32) UnsignedRationalNumberBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the UnsignedRationalNumber or returns an error if something is wrong
	Build() (UnsignedRationalNumber, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() UnsignedRationalNumber
}

// NewUnsignedRationalNumberBuilder() creates a UnsignedRationalNumberBuilder
func NewUnsignedRationalNumberBuilder() UnsignedRationalNumberBuilder {
	return &_UnsignedRationalNumberBuilder{_UnsignedRationalNumber: new(_UnsignedRationalNumber)}
}

type _UnsignedRationalNumberBuilder struct {
	*_UnsignedRationalNumber

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (UnsignedRationalNumberBuilder) = (*_UnsignedRationalNumberBuilder)(nil)

func (b *_UnsignedRationalNumberBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._UnsignedRationalNumber
}

func (b *_UnsignedRationalNumberBuilder) WithMandatoryFields(numerator uint32, denominator uint32) UnsignedRationalNumberBuilder {
	return b.WithNumerator(numerator).WithDenominator(denominator)
}

func (b *_UnsignedRationalNumberBuilder) WithNumerator(numerator uint32) UnsignedRationalNumberBuilder {
	b.Numerator = numerator
	return b
}

func (b *_UnsignedRationalNumberBuilder) WithDenominator(denominator uint32) UnsignedRationalNumberBuilder {
	b.Denominator = denominator
	return b
}

func (b *_UnsignedRationalNumberBuilder) Build() (UnsignedRationalNumber, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._UnsignedRationalNumber.deepCopy(), nil
}

func (b *_UnsignedRationalNumberBuilder) MustBuild() UnsignedRationalNumber {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_UnsignedRationalNumberBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_UnsignedRationalNumberBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_UnsignedRationalNumberBuilder) DeepCopy() any {
	_copy := b.CreateUnsignedRationalNumberBuilder().(*_UnsignedRationalNumberBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateUnsignedRationalNumberBuilder creates a UnsignedRationalNumberBuilder
func (b *_UnsignedRationalNumber) CreateUnsignedRationalNumberBuilder() UnsignedRationalNumberBuilder {
	if b == nil {
		return NewUnsignedRationalNumberBuilder()
	}
	return &_UnsignedRationalNumberBuilder{_UnsignedRationalNumber: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_UnsignedRationalNumber) GetExtensionId() int32 {
	return int32(24109)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_UnsignedRationalNumber) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_UnsignedRationalNumber) GetNumerator() uint32 {
	return m.Numerator
}

func (m *_UnsignedRationalNumber) GetDenominator() uint32 {
	return m.Denominator
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastUnsignedRationalNumber(structType any) UnsignedRationalNumber {
	if casted, ok := structType.(UnsignedRationalNumber); ok {
		return casted
	}
	if casted, ok := structType.(*UnsignedRationalNumber); ok {
		return *casted
	}
	return nil
}

func (m *_UnsignedRationalNumber) GetTypeName() string {
	return "UnsignedRationalNumber"
}

func (m *_UnsignedRationalNumber) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (numerator)
	lengthInBits += 32

	// Simple field (denominator)
	lengthInBits += 32

	return lengthInBits
}

func (m *_UnsignedRationalNumber) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_UnsignedRationalNumber) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__unsignedRationalNumber UnsignedRationalNumber, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("UnsignedRationalNumber"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UnsignedRationalNumber")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	numerator, err := ReadSimpleField(ctx, "numerator", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numerator' field"))
	}
	m.Numerator = numerator

	denominator, err := ReadSimpleField(ctx, "denominator", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'denominator' field"))
	}
	m.Denominator = denominator

	if closeErr := readBuffer.CloseContext("UnsignedRationalNumber"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UnsignedRationalNumber")
	}

	return m, nil
}

func (m *_UnsignedRationalNumber) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UnsignedRationalNumber) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("UnsignedRationalNumber"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for UnsignedRationalNumber")
		}

		if err := WriteSimpleField[uint32](ctx, "numerator", m.GetNumerator(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'numerator' field")
		}

		if err := WriteSimpleField[uint32](ctx, "denominator", m.GetDenominator(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'denominator' field")
		}

		if popErr := writeBuffer.PopContext("UnsignedRationalNumber"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for UnsignedRationalNumber")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_UnsignedRationalNumber) IsUnsignedRationalNumber() {}

func (m *_UnsignedRationalNumber) DeepCopy() any {
	return m.deepCopy()
}

func (m *_UnsignedRationalNumber) deepCopy() *_UnsignedRationalNumber {
	if m == nil {
		return nil
	}
	_UnsignedRationalNumberCopy := &_UnsignedRationalNumber{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.Numerator,
		m.Denominator,
	}
	_UnsignedRationalNumberCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _UnsignedRationalNumberCopy
}

func (m *_UnsignedRationalNumber) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
