/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// StandaloneSubscribedDataSetRefDataType is the corresponding interface of StandaloneSubscribedDataSetRefDataType
type StandaloneSubscribedDataSetRefDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetDataSetName returns DataSetName (property field)
	GetDataSetName() PascalString
	// IsStandaloneSubscribedDataSetRefDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsStandaloneSubscribedDataSetRefDataType()
	// CreateBuilder creates a StandaloneSubscribedDataSetRefDataTypeBuilder
	CreateStandaloneSubscribedDataSetRefDataTypeBuilder() StandaloneSubscribedDataSetRefDataTypeBuilder
}

// _StandaloneSubscribedDataSetRefDataType is the data-structure of this message
type _StandaloneSubscribedDataSetRefDataType struct {
	ExtensionObjectDefinitionContract
	DataSetName PascalString
}

var _ StandaloneSubscribedDataSetRefDataType = (*_StandaloneSubscribedDataSetRefDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_StandaloneSubscribedDataSetRefDataType)(nil)

// NewStandaloneSubscribedDataSetRefDataType factory function for _StandaloneSubscribedDataSetRefDataType
func NewStandaloneSubscribedDataSetRefDataType(dataSetName PascalString) *_StandaloneSubscribedDataSetRefDataType {
	if dataSetName == nil {
		panic("dataSetName of type PascalString for StandaloneSubscribedDataSetRefDataType must not be nil")
	}
	_result := &_StandaloneSubscribedDataSetRefDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		DataSetName:                       dataSetName,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// StandaloneSubscribedDataSetRefDataTypeBuilder is a builder for StandaloneSubscribedDataSetRefDataType
type StandaloneSubscribedDataSetRefDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataSetName PascalString) StandaloneSubscribedDataSetRefDataTypeBuilder
	// WithDataSetName adds DataSetName (property field)
	WithDataSetName(PascalString) StandaloneSubscribedDataSetRefDataTypeBuilder
	// WithDataSetNameBuilder adds DataSetName (property field) which is build by the builder
	WithDataSetNameBuilder(func(PascalStringBuilder) PascalStringBuilder) StandaloneSubscribedDataSetRefDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the StandaloneSubscribedDataSetRefDataType or returns an error if something is wrong
	Build() (StandaloneSubscribedDataSetRefDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() StandaloneSubscribedDataSetRefDataType
}

// NewStandaloneSubscribedDataSetRefDataTypeBuilder() creates a StandaloneSubscribedDataSetRefDataTypeBuilder
func NewStandaloneSubscribedDataSetRefDataTypeBuilder() StandaloneSubscribedDataSetRefDataTypeBuilder {
	return &_StandaloneSubscribedDataSetRefDataTypeBuilder{_StandaloneSubscribedDataSetRefDataType: new(_StandaloneSubscribedDataSetRefDataType)}
}

type _StandaloneSubscribedDataSetRefDataTypeBuilder struct {
	*_StandaloneSubscribedDataSetRefDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (StandaloneSubscribedDataSetRefDataTypeBuilder) = (*_StandaloneSubscribedDataSetRefDataTypeBuilder)(nil)

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._StandaloneSubscribedDataSetRefDataType
}

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) WithMandatoryFields(dataSetName PascalString) StandaloneSubscribedDataSetRefDataTypeBuilder {
	return b.WithDataSetName(dataSetName)
}

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) WithDataSetName(dataSetName PascalString) StandaloneSubscribedDataSetRefDataTypeBuilder {
	b.DataSetName = dataSetName
	return b
}

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) WithDataSetNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) StandaloneSubscribedDataSetRefDataTypeBuilder {
	builder := builderSupplier(b.DataSetName.CreatePascalStringBuilder())
	var err error
	b.DataSetName, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) Build() (StandaloneSubscribedDataSetRefDataType, error) {
	if b.DataSetName == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dataSetName' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._StandaloneSubscribedDataSetRefDataType.deepCopy(), nil
}

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) MustBuild() StandaloneSubscribedDataSetRefDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_StandaloneSubscribedDataSetRefDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateStandaloneSubscribedDataSetRefDataTypeBuilder().(*_StandaloneSubscribedDataSetRefDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateStandaloneSubscribedDataSetRefDataTypeBuilder creates a StandaloneSubscribedDataSetRefDataTypeBuilder
func (b *_StandaloneSubscribedDataSetRefDataType) CreateStandaloneSubscribedDataSetRefDataTypeBuilder() StandaloneSubscribedDataSetRefDataTypeBuilder {
	if b == nil {
		return NewStandaloneSubscribedDataSetRefDataTypeBuilder()
	}
	return &_StandaloneSubscribedDataSetRefDataTypeBuilder{_StandaloneSubscribedDataSetRefDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_StandaloneSubscribedDataSetRefDataType) GetExtensionId() int32 {
	return int32(23601)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_StandaloneSubscribedDataSetRefDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_StandaloneSubscribedDataSetRefDataType) GetDataSetName() PascalString {
	return m.DataSetName
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastStandaloneSubscribedDataSetRefDataType(structType any) StandaloneSubscribedDataSetRefDataType {
	if casted, ok := structType.(StandaloneSubscribedDataSetRefDataType); ok {
		return casted
	}
	if casted, ok := structType.(*StandaloneSubscribedDataSetRefDataType); ok {
		return *casted
	}
	return nil
}

func (m *_StandaloneSubscribedDataSetRefDataType) GetTypeName() string {
	return "StandaloneSubscribedDataSetRefDataType"
}

func (m *_StandaloneSubscribedDataSetRefDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (dataSetName)
	lengthInBits += m.DataSetName.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_StandaloneSubscribedDataSetRefDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_StandaloneSubscribedDataSetRefDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__standaloneSubscribedDataSetRefDataType StandaloneSubscribedDataSetRefDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("StandaloneSubscribedDataSetRefDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for StandaloneSubscribedDataSetRefDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataSetName, err := ReadSimpleField[PascalString](ctx, "dataSetName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetName' field"))
	}
	m.DataSetName = dataSetName

	if closeErr := readBuffer.CloseContext("StandaloneSubscribedDataSetRefDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for StandaloneSubscribedDataSetRefDataType")
	}

	return m, nil
}

func (m *_StandaloneSubscribedDataSetRefDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_StandaloneSubscribedDataSetRefDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("StandaloneSubscribedDataSetRefDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for StandaloneSubscribedDataSetRefDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "dataSetName", m.GetDataSetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetName' field")
		}

		if popErr := writeBuffer.PopContext("StandaloneSubscribedDataSetRefDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for StandaloneSubscribedDataSetRefDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_StandaloneSubscribedDataSetRefDataType) IsStandaloneSubscribedDataSetRefDataType() {}

func (m *_StandaloneSubscribedDataSetRefDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_StandaloneSubscribedDataSetRefDataType) deepCopy() *_StandaloneSubscribedDataSetRefDataType {
	if m == nil {
		return nil
	}
	_StandaloneSubscribedDataSetRefDataTypeCopy := &_StandaloneSubscribedDataSetRefDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.DataSetName),
	}
	_StandaloneSubscribedDataSetRefDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _StandaloneSubscribedDataSetRefDataTypeCopy
}

func (m *_StandaloneSubscribedDataSetRefDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
