/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SessionlessInvokeResponseType is the corresponding interface of SessionlessInvokeResponseType
type SessionlessInvokeResponseType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetNamespaceUris returns NamespaceUris (property field)
	GetNamespaceUris() []PascalString
	// GetServerUris returns ServerUris (property field)
	GetServerUris() []PascalString
	// GetServiceId returns ServiceId (property field)
	GetServiceId() uint32
	// IsSessionlessInvokeResponseType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSessionlessInvokeResponseType()
	// CreateBuilder creates a SessionlessInvokeResponseTypeBuilder
	CreateSessionlessInvokeResponseTypeBuilder() SessionlessInvokeResponseTypeBuilder
}

// _SessionlessInvokeResponseType is the data-structure of this message
type _SessionlessInvokeResponseType struct {
	ExtensionObjectDefinitionContract
	NamespaceUris []PascalString
	ServerUris    []PascalString
	ServiceId     uint32
}

var _ SessionlessInvokeResponseType = (*_SessionlessInvokeResponseType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_SessionlessInvokeResponseType)(nil)

// NewSessionlessInvokeResponseType factory function for _SessionlessInvokeResponseType
func NewSessionlessInvokeResponseType(namespaceUris []PascalString, serverUris []PascalString, serviceId uint32) *_SessionlessInvokeResponseType {
	_result := &_SessionlessInvokeResponseType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		NamespaceUris:                     namespaceUris,
		ServerUris:                        serverUris,
		ServiceId:                         serviceId,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SessionlessInvokeResponseTypeBuilder is a builder for SessionlessInvokeResponseType
type SessionlessInvokeResponseTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(namespaceUris []PascalString, serverUris []PascalString, serviceId uint32) SessionlessInvokeResponseTypeBuilder
	// WithNamespaceUris adds NamespaceUris (property field)
	WithNamespaceUris(...PascalString) SessionlessInvokeResponseTypeBuilder
	// WithServerUris adds ServerUris (property field)
	WithServerUris(...PascalString) SessionlessInvokeResponseTypeBuilder
	// WithServiceId adds ServiceId (property field)
	WithServiceId(uint32) SessionlessInvokeResponseTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the SessionlessInvokeResponseType or returns an error if something is wrong
	Build() (SessionlessInvokeResponseType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SessionlessInvokeResponseType
}

// NewSessionlessInvokeResponseTypeBuilder() creates a SessionlessInvokeResponseTypeBuilder
func NewSessionlessInvokeResponseTypeBuilder() SessionlessInvokeResponseTypeBuilder {
	return &_SessionlessInvokeResponseTypeBuilder{_SessionlessInvokeResponseType: new(_SessionlessInvokeResponseType)}
}

type _SessionlessInvokeResponseTypeBuilder struct {
	*_SessionlessInvokeResponseType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (SessionlessInvokeResponseTypeBuilder) = (*_SessionlessInvokeResponseTypeBuilder)(nil)

func (b *_SessionlessInvokeResponseTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._SessionlessInvokeResponseType
}

func (b *_SessionlessInvokeResponseTypeBuilder) WithMandatoryFields(namespaceUris []PascalString, serverUris []PascalString, serviceId uint32) SessionlessInvokeResponseTypeBuilder {
	return b.WithNamespaceUris(namespaceUris...).WithServerUris(serverUris...).WithServiceId(serviceId)
}

func (b *_SessionlessInvokeResponseTypeBuilder) WithNamespaceUris(namespaceUris ...PascalString) SessionlessInvokeResponseTypeBuilder {
	b.NamespaceUris = namespaceUris
	return b
}

func (b *_SessionlessInvokeResponseTypeBuilder) WithServerUris(serverUris ...PascalString) SessionlessInvokeResponseTypeBuilder {
	b.ServerUris = serverUris
	return b
}

func (b *_SessionlessInvokeResponseTypeBuilder) WithServiceId(serviceId uint32) SessionlessInvokeResponseTypeBuilder {
	b.ServiceId = serviceId
	return b
}

func (b *_SessionlessInvokeResponseTypeBuilder) Build() (SessionlessInvokeResponseType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SessionlessInvokeResponseType.deepCopy(), nil
}

func (b *_SessionlessInvokeResponseTypeBuilder) MustBuild() SessionlessInvokeResponseType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SessionlessInvokeResponseTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_SessionlessInvokeResponseTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_SessionlessInvokeResponseTypeBuilder) DeepCopy() any {
	_copy := b.CreateSessionlessInvokeResponseTypeBuilder().(*_SessionlessInvokeResponseTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSessionlessInvokeResponseTypeBuilder creates a SessionlessInvokeResponseTypeBuilder
func (b *_SessionlessInvokeResponseType) CreateSessionlessInvokeResponseTypeBuilder() SessionlessInvokeResponseTypeBuilder {
	if b == nil {
		return NewSessionlessInvokeResponseTypeBuilder()
	}
	return &_SessionlessInvokeResponseTypeBuilder{_SessionlessInvokeResponseType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SessionlessInvokeResponseType) GetExtensionId() int32 {
	return int32(21001)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SessionlessInvokeResponseType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SessionlessInvokeResponseType) GetNamespaceUris() []PascalString {
	return m.NamespaceUris
}

func (m *_SessionlessInvokeResponseType) GetServerUris() []PascalString {
	return m.ServerUris
}

func (m *_SessionlessInvokeResponseType) GetServiceId() uint32 {
	return m.ServiceId
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSessionlessInvokeResponseType(structType any) SessionlessInvokeResponseType {
	if casted, ok := structType.(SessionlessInvokeResponseType); ok {
		return casted
	}
	if casted, ok := structType.(*SessionlessInvokeResponseType); ok {
		return *casted
	}
	return nil
}

func (m *_SessionlessInvokeResponseType) GetTypeName() string {
	return "SessionlessInvokeResponseType"
}

func (m *_SessionlessInvokeResponseType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Implicit Field (noOfNamespaceUris)
	lengthInBits += 32

	// Array field
	if len(m.NamespaceUris) > 0 {
		for _curItem, element := range m.NamespaceUris {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.NamespaceUris), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfServerUris)
	lengthInBits += 32

	// Array field
	if len(m.ServerUris) > 0 {
		for _curItem, element := range m.ServerUris {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ServerUris), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (serviceId)
	lengthInBits += 32

	return lengthInBits
}

func (m *_SessionlessInvokeResponseType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SessionlessInvokeResponseType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__sessionlessInvokeResponseType SessionlessInvokeResponseType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SessionlessInvokeResponseType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SessionlessInvokeResponseType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	noOfNamespaceUris, err := ReadImplicitField[int32](ctx, "noOfNamespaceUris", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfNamespaceUris' field"))
	}
	_ = noOfNamespaceUris

	namespaceUris, err := ReadCountArrayField[PascalString](ctx, "namespaceUris", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfNamespaceUris))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'namespaceUris' field"))
	}
	m.NamespaceUris = namespaceUris

	noOfServerUris, err := ReadImplicitField[int32](ctx, "noOfServerUris", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfServerUris' field"))
	}
	_ = noOfServerUris

	serverUris, err := ReadCountArrayField[PascalString](ctx, "serverUris", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfServerUris))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverUris' field"))
	}
	m.ServerUris = serverUris

	serviceId, err := ReadSimpleField(ctx, "serviceId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serviceId' field"))
	}
	m.ServiceId = serviceId

	if closeErr := readBuffer.CloseContext("SessionlessInvokeResponseType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SessionlessInvokeResponseType")
	}

	return m, nil
}

func (m *_SessionlessInvokeResponseType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SessionlessInvokeResponseType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SessionlessInvokeResponseType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SessionlessInvokeResponseType")
		}
		noOfNamespaceUris := int32(utils.InlineIf(bool((m.GetNamespaceUris()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetNamespaceUris()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfNamespaceUris", noOfNamespaceUris, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfNamespaceUris' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "namespaceUris", m.GetNamespaceUris(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'namespaceUris' field")
		}
		noOfServerUris := int32(utils.InlineIf(bool((m.GetServerUris()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetServerUris()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfServerUris", noOfServerUris, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfServerUris' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "serverUris", m.GetServerUris(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'serverUris' field")
		}

		if err := WriteSimpleField[uint32](ctx, "serviceId", m.GetServiceId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'serviceId' field")
		}

		if popErr := writeBuffer.PopContext("SessionlessInvokeResponseType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SessionlessInvokeResponseType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SessionlessInvokeResponseType) IsSessionlessInvokeResponseType() {}

func (m *_SessionlessInvokeResponseType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SessionlessInvokeResponseType) deepCopy() *_SessionlessInvokeResponseType {
	if m == nil {
		return nil
	}
	_SessionlessInvokeResponseTypeCopy := &_SessionlessInvokeResponseType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopySlice[PascalString, PascalString](m.NamespaceUris),
		utils.DeepCopySlice[PascalString, PascalString](m.ServerUris),
		m.ServiceId,
	}
	_SessionlessInvokeResponseTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _SessionlessInvokeResponseTypeCopy
}

func (m *_SessionlessInvokeResponseType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
