/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SessionDiagnosticsDataType is the corresponding interface of SessionDiagnosticsDataType
type SessionDiagnosticsDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetSessionId returns SessionId (property field)
	GetSessionId() NodeId
	// GetSessionName returns SessionName (property field)
	GetSessionName() PascalString
	// GetClientDescription returns ClientDescription (property field)
	GetClientDescription() ApplicationDescription
	// GetServerUri returns ServerUri (property field)
	GetServerUri() PascalString
	// GetEndpointUrl returns EndpointUrl (property field)
	GetEndpointUrl() PascalString
	// GetLocaleIds returns LocaleIds (property field)
	GetLocaleIds() []PascalString
	// GetActualSessionTimeout returns ActualSessionTimeout (property field)
	GetActualSessionTimeout() float64
	// GetMaxResponseMessageSize returns MaxResponseMessageSize (property field)
	GetMaxResponseMessageSize() uint32
	// GetClientConnectionTime returns ClientConnectionTime (property field)
	GetClientConnectionTime() int64
	// GetClientLastContactTime returns ClientLastContactTime (property field)
	GetClientLastContactTime() int64
	// GetCurrentSubscriptionsCount returns CurrentSubscriptionsCount (property field)
	GetCurrentSubscriptionsCount() uint32
	// GetCurrentMonitoredItemsCount returns CurrentMonitoredItemsCount (property field)
	GetCurrentMonitoredItemsCount() uint32
	// GetCurrentPublishRequestsInQueue returns CurrentPublishRequestsInQueue (property field)
	GetCurrentPublishRequestsInQueue() uint32
	// GetTotalRequestCount returns TotalRequestCount (property field)
	GetTotalRequestCount() ServiceCounterDataType
	// GetUnauthorizedRequestCount returns UnauthorizedRequestCount (property field)
	GetUnauthorizedRequestCount() uint32
	// GetReadCount returns ReadCount (property field)
	GetReadCount() ServiceCounterDataType
	// GetHistoryReadCount returns HistoryReadCount (property field)
	GetHistoryReadCount() ServiceCounterDataType
	// GetWriteCount returns WriteCount (property field)
	GetWriteCount() ServiceCounterDataType
	// GetHistoryUpdateCount returns HistoryUpdateCount (property field)
	GetHistoryUpdateCount() ServiceCounterDataType
	// GetCallCount returns CallCount (property field)
	GetCallCount() ServiceCounterDataType
	// GetCreateMonitoredItemsCount returns CreateMonitoredItemsCount (property field)
	GetCreateMonitoredItemsCount() ServiceCounterDataType
	// GetModifyMonitoredItemsCount returns ModifyMonitoredItemsCount (property field)
	GetModifyMonitoredItemsCount() ServiceCounterDataType
	// GetSetMonitoringModeCount returns SetMonitoringModeCount (property field)
	GetSetMonitoringModeCount() ServiceCounterDataType
	// GetSetTriggeringCount returns SetTriggeringCount (property field)
	GetSetTriggeringCount() ServiceCounterDataType
	// GetDeleteMonitoredItemsCount returns DeleteMonitoredItemsCount (property field)
	GetDeleteMonitoredItemsCount() ServiceCounterDataType
	// GetCreateSubscriptionCount returns CreateSubscriptionCount (property field)
	GetCreateSubscriptionCount() ServiceCounterDataType
	// GetModifySubscriptionCount returns ModifySubscriptionCount (property field)
	GetModifySubscriptionCount() ServiceCounterDataType
	// GetSetPublishingModeCount returns SetPublishingModeCount (property field)
	GetSetPublishingModeCount() ServiceCounterDataType
	// GetPublishCount returns PublishCount (property field)
	GetPublishCount() ServiceCounterDataType
	// GetRepublishCount returns RepublishCount (property field)
	GetRepublishCount() ServiceCounterDataType
	// GetTransferSubscriptionsCount returns TransferSubscriptionsCount (property field)
	GetTransferSubscriptionsCount() ServiceCounterDataType
	// GetDeleteSubscriptionsCount returns DeleteSubscriptionsCount (property field)
	GetDeleteSubscriptionsCount() ServiceCounterDataType
	// GetAddNodesCount returns AddNodesCount (property field)
	GetAddNodesCount() ServiceCounterDataType
	// GetAddReferencesCount returns AddReferencesCount (property field)
	GetAddReferencesCount() ServiceCounterDataType
	// GetDeleteNodesCount returns DeleteNodesCount (property field)
	GetDeleteNodesCount() ServiceCounterDataType
	// GetDeleteReferencesCount returns DeleteReferencesCount (property field)
	GetDeleteReferencesCount() ServiceCounterDataType
	// GetBrowseCount returns BrowseCount (property field)
	GetBrowseCount() ServiceCounterDataType
	// GetBrowseNextCount returns BrowseNextCount (property field)
	GetBrowseNextCount() ServiceCounterDataType
	// GetTranslateBrowsePathsToNodeIdsCount returns TranslateBrowsePathsToNodeIdsCount (property field)
	GetTranslateBrowsePathsToNodeIdsCount() ServiceCounterDataType
	// GetQueryFirstCount returns QueryFirstCount (property field)
	GetQueryFirstCount() ServiceCounterDataType
	// GetQueryNextCount returns QueryNextCount (property field)
	GetQueryNextCount() ServiceCounterDataType
	// GetRegisterNodesCount returns RegisterNodesCount (property field)
	GetRegisterNodesCount() ServiceCounterDataType
	// GetUnregisterNodesCount returns UnregisterNodesCount (property field)
	GetUnregisterNodesCount() ServiceCounterDataType
	// IsSessionDiagnosticsDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSessionDiagnosticsDataType()
	// CreateBuilder creates a SessionDiagnosticsDataTypeBuilder
	CreateSessionDiagnosticsDataTypeBuilder() SessionDiagnosticsDataTypeBuilder
}

// _SessionDiagnosticsDataType is the data-structure of this message
type _SessionDiagnosticsDataType struct {
	ExtensionObjectDefinitionContract
	SessionId                          NodeId
	SessionName                        PascalString
	ClientDescription                  ApplicationDescription
	ServerUri                          PascalString
	EndpointUrl                        PascalString
	LocaleIds                          []PascalString
	ActualSessionTimeout               float64
	MaxResponseMessageSize             uint32
	ClientConnectionTime               int64
	ClientLastContactTime              int64
	CurrentSubscriptionsCount          uint32
	CurrentMonitoredItemsCount         uint32
	CurrentPublishRequestsInQueue      uint32
	TotalRequestCount                  ServiceCounterDataType
	UnauthorizedRequestCount           uint32
	ReadCount                          ServiceCounterDataType
	HistoryReadCount                   ServiceCounterDataType
	WriteCount                         ServiceCounterDataType
	HistoryUpdateCount                 ServiceCounterDataType
	CallCount                          ServiceCounterDataType
	CreateMonitoredItemsCount          ServiceCounterDataType
	ModifyMonitoredItemsCount          ServiceCounterDataType
	SetMonitoringModeCount             ServiceCounterDataType
	SetTriggeringCount                 ServiceCounterDataType
	DeleteMonitoredItemsCount          ServiceCounterDataType
	CreateSubscriptionCount            ServiceCounterDataType
	ModifySubscriptionCount            ServiceCounterDataType
	SetPublishingModeCount             ServiceCounterDataType
	PublishCount                       ServiceCounterDataType
	RepublishCount                     ServiceCounterDataType
	TransferSubscriptionsCount         ServiceCounterDataType
	DeleteSubscriptionsCount           ServiceCounterDataType
	AddNodesCount                      ServiceCounterDataType
	AddReferencesCount                 ServiceCounterDataType
	DeleteNodesCount                   ServiceCounterDataType
	DeleteReferencesCount              ServiceCounterDataType
	BrowseCount                        ServiceCounterDataType
	BrowseNextCount                    ServiceCounterDataType
	TranslateBrowsePathsToNodeIdsCount ServiceCounterDataType
	QueryFirstCount                    ServiceCounterDataType
	QueryNextCount                     ServiceCounterDataType
	RegisterNodesCount                 ServiceCounterDataType
	UnregisterNodesCount               ServiceCounterDataType
}

var _ SessionDiagnosticsDataType = (*_SessionDiagnosticsDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_SessionDiagnosticsDataType)(nil)

// NewSessionDiagnosticsDataType factory function for _SessionDiagnosticsDataType
func NewSessionDiagnosticsDataType(sessionId NodeId, sessionName PascalString, clientDescription ApplicationDescription, serverUri PascalString, endpointUrl PascalString, localeIds []PascalString, actualSessionTimeout float64, maxResponseMessageSize uint32, clientConnectionTime int64, clientLastContactTime int64, currentSubscriptionsCount uint32, currentMonitoredItemsCount uint32, currentPublishRequestsInQueue uint32, totalRequestCount ServiceCounterDataType, unauthorizedRequestCount uint32, readCount ServiceCounterDataType, historyReadCount ServiceCounterDataType, writeCount ServiceCounterDataType, historyUpdateCount ServiceCounterDataType, callCount ServiceCounterDataType, createMonitoredItemsCount ServiceCounterDataType, modifyMonitoredItemsCount ServiceCounterDataType, setMonitoringModeCount ServiceCounterDataType, setTriggeringCount ServiceCounterDataType, deleteMonitoredItemsCount ServiceCounterDataType, createSubscriptionCount ServiceCounterDataType, modifySubscriptionCount ServiceCounterDataType, setPublishingModeCount ServiceCounterDataType, publishCount ServiceCounterDataType, republishCount ServiceCounterDataType, transferSubscriptionsCount ServiceCounterDataType, deleteSubscriptionsCount ServiceCounterDataType, addNodesCount ServiceCounterDataType, addReferencesCount ServiceCounterDataType, deleteNodesCount ServiceCounterDataType, deleteReferencesCount ServiceCounterDataType, browseCount ServiceCounterDataType, browseNextCount ServiceCounterDataType, translateBrowsePathsToNodeIdsCount ServiceCounterDataType, queryFirstCount ServiceCounterDataType, queryNextCount ServiceCounterDataType, registerNodesCount ServiceCounterDataType, unregisterNodesCount ServiceCounterDataType) *_SessionDiagnosticsDataType {
	if sessionId == nil {
		panic("sessionId of type NodeId for SessionDiagnosticsDataType must not be nil")
	}
	if sessionName == nil {
		panic("sessionName of type PascalString for SessionDiagnosticsDataType must not be nil")
	}
	if clientDescription == nil {
		panic("clientDescription of type ApplicationDescription for SessionDiagnosticsDataType must not be nil")
	}
	if serverUri == nil {
		panic("serverUri of type PascalString for SessionDiagnosticsDataType must not be nil")
	}
	if endpointUrl == nil {
		panic("endpointUrl of type PascalString for SessionDiagnosticsDataType must not be nil")
	}
	if totalRequestCount == nil {
		panic("totalRequestCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if readCount == nil {
		panic("readCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if historyReadCount == nil {
		panic("historyReadCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if writeCount == nil {
		panic("writeCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if historyUpdateCount == nil {
		panic("historyUpdateCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if callCount == nil {
		panic("callCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if createMonitoredItemsCount == nil {
		panic("createMonitoredItemsCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if modifyMonitoredItemsCount == nil {
		panic("modifyMonitoredItemsCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if setMonitoringModeCount == nil {
		panic("setMonitoringModeCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if setTriggeringCount == nil {
		panic("setTriggeringCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if deleteMonitoredItemsCount == nil {
		panic("deleteMonitoredItemsCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if createSubscriptionCount == nil {
		panic("createSubscriptionCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if modifySubscriptionCount == nil {
		panic("modifySubscriptionCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if setPublishingModeCount == nil {
		panic("setPublishingModeCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if publishCount == nil {
		panic("publishCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if republishCount == nil {
		panic("republishCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if transferSubscriptionsCount == nil {
		panic("transferSubscriptionsCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if deleteSubscriptionsCount == nil {
		panic("deleteSubscriptionsCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if addNodesCount == nil {
		panic("addNodesCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if addReferencesCount == nil {
		panic("addReferencesCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if deleteNodesCount == nil {
		panic("deleteNodesCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if deleteReferencesCount == nil {
		panic("deleteReferencesCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if browseCount == nil {
		panic("browseCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if browseNextCount == nil {
		panic("browseNextCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if translateBrowsePathsToNodeIdsCount == nil {
		panic("translateBrowsePathsToNodeIdsCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if queryFirstCount == nil {
		panic("queryFirstCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if queryNextCount == nil {
		panic("queryNextCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if registerNodesCount == nil {
		panic("registerNodesCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	if unregisterNodesCount == nil {
		panic("unregisterNodesCount of type ServiceCounterDataType for SessionDiagnosticsDataType must not be nil")
	}
	_result := &_SessionDiagnosticsDataType{
		ExtensionObjectDefinitionContract:  NewExtensionObjectDefinition(),
		SessionId:                          sessionId,
		SessionName:                        sessionName,
		ClientDescription:                  clientDescription,
		ServerUri:                          serverUri,
		EndpointUrl:                        endpointUrl,
		LocaleIds:                          localeIds,
		ActualSessionTimeout:               actualSessionTimeout,
		MaxResponseMessageSize:             maxResponseMessageSize,
		ClientConnectionTime:               clientConnectionTime,
		ClientLastContactTime:              clientLastContactTime,
		CurrentSubscriptionsCount:          currentSubscriptionsCount,
		CurrentMonitoredItemsCount:         currentMonitoredItemsCount,
		CurrentPublishRequestsInQueue:      currentPublishRequestsInQueue,
		TotalRequestCount:                  totalRequestCount,
		UnauthorizedRequestCount:           unauthorizedRequestCount,
		ReadCount:                          readCount,
		HistoryReadCount:                   historyReadCount,
		WriteCount:                         writeCount,
		HistoryUpdateCount:                 historyUpdateCount,
		CallCount:                          callCount,
		CreateMonitoredItemsCount:          createMonitoredItemsCount,
		ModifyMonitoredItemsCount:          modifyMonitoredItemsCount,
		SetMonitoringModeCount:             setMonitoringModeCount,
		SetTriggeringCount:                 setTriggeringCount,
		DeleteMonitoredItemsCount:          deleteMonitoredItemsCount,
		CreateSubscriptionCount:            createSubscriptionCount,
		ModifySubscriptionCount:            modifySubscriptionCount,
		SetPublishingModeCount:             setPublishingModeCount,
		PublishCount:                       publishCount,
		RepublishCount:                     republishCount,
		TransferSubscriptionsCount:         transferSubscriptionsCount,
		DeleteSubscriptionsCount:           deleteSubscriptionsCount,
		AddNodesCount:                      addNodesCount,
		AddReferencesCount:                 addReferencesCount,
		DeleteNodesCount:                   deleteNodesCount,
		DeleteReferencesCount:              deleteReferencesCount,
		BrowseCount:                        browseCount,
		BrowseNextCount:                    browseNextCount,
		TranslateBrowsePathsToNodeIdsCount: translateBrowsePathsToNodeIdsCount,
		QueryFirstCount:                    queryFirstCount,
		QueryNextCount:                     queryNextCount,
		RegisterNodesCount:                 registerNodesCount,
		UnregisterNodesCount:               unregisterNodesCount,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SessionDiagnosticsDataTypeBuilder is a builder for SessionDiagnosticsDataType
type SessionDiagnosticsDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(sessionId NodeId, sessionName PascalString, clientDescription ApplicationDescription, serverUri PascalString, endpointUrl PascalString, localeIds []PascalString, actualSessionTimeout float64, maxResponseMessageSize uint32, clientConnectionTime int64, clientLastContactTime int64, currentSubscriptionsCount uint32, currentMonitoredItemsCount uint32, currentPublishRequestsInQueue uint32, totalRequestCount ServiceCounterDataType, unauthorizedRequestCount uint32, readCount ServiceCounterDataType, historyReadCount ServiceCounterDataType, writeCount ServiceCounterDataType, historyUpdateCount ServiceCounterDataType, callCount ServiceCounterDataType, createMonitoredItemsCount ServiceCounterDataType, modifyMonitoredItemsCount ServiceCounterDataType, setMonitoringModeCount ServiceCounterDataType, setTriggeringCount ServiceCounterDataType, deleteMonitoredItemsCount ServiceCounterDataType, createSubscriptionCount ServiceCounterDataType, modifySubscriptionCount ServiceCounterDataType, setPublishingModeCount ServiceCounterDataType, publishCount ServiceCounterDataType, republishCount ServiceCounterDataType, transferSubscriptionsCount ServiceCounterDataType, deleteSubscriptionsCount ServiceCounterDataType, addNodesCount ServiceCounterDataType, addReferencesCount ServiceCounterDataType, deleteNodesCount ServiceCounterDataType, deleteReferencesCount ServiceCounterDataType, browseCount ServiceCounterDataType, browseNextCount ServiceCounterDataType, translateBrowsePathsToNodeIdsCount ServiceCounterDataType, queryFirstCount ServiceCounterDataType, queryNextCount ServiceCounterDataType, registerNodesCount ServiceCounterDataType, unregisterNodesCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithSessionId adds SessionId (property field)
	WithSessionId(NodeId) SessionDiagnosticsDataTypeBuilder
	// WithSessionIdBuilder adds SessionId (property field) which is build by the builder
	WithSessionIdBuilder(func(NodeIdBuilder) NodeIdBuilder) SessionDiagnosticsDataTypeBuilder
	// WithSessionName adds SessionName (property field)
	WithSessionName(PascalString) SessionDiagnosticsDataTypeBuilder
	// WithSessionNameBuilder adds SessionName (property field) which is build by the builder
	WithSessionNameBuilder(func(PascalStringBuilder) PascalStringBuilder) SessionDiagnosticsDataTypeBuilder
	// WithClientDescription adds ClientDescription (property field)
	WithClientDescription(ApplicationDescription) SessionDiagnosticsDataTypeBuilder
	// WithClientDescriptionBuilder adds ClientDescription (property field) which is build by the builder
	WithClientDescriptionBuilder(func(ApplicationDescriptionBuilder) ApplicationDescriptionBuilder) SessionDiagnosticsDataTypeBuilder
	// WithServerUri adds ServerUri (property field)
	WithServerUri(PascalString) SessionDiagnosticsDataTypeBuilder
	// WithServerUriBuilder adds ServerUri (property field) which is build by the builder
	WithServerUriBuilder(func(PascalStringBuilder) PascalStringBuilder) SessionDiagnosticsDataTypeBuilder
	// WithEndpointUrl adds EndpointUrl (property field)
	WithEndpointUrl(PascalString) SessionDiagnosticsDataTypeBuilder
	// WithEndpointUrlBuilder adds EndpointUrl (property field) which is build by the builder
	WithEndpointUrlBuilder(func(PascalStringBuilder) PascalStringBuilder) SessionDiagnosticsDataTypeBuilder
	// WithLocaleIds adds LocaleIds (property field)
	WithLocaleIds(...PascalString) SessionDiagnosticsDataTypeBuilder
	// WithActualSessionTimeout adds ActualSessionTimeout (property field)
	WithActualSessionTimeout(float64) SessionDiagnosticsDataTypeBuilder
	// WithMaxResponseMessageSize adds MaxResponseMessageSize (property field)
	WithMaxResponseMessageSize(uint32) SessionDiagnosticsDataTypeBuilder
	// WithClientConnectionTime adds ClientConnectionTime (property field)
	WithClientConnectionTime(int64) SessionDiagnosticsDataTypeBuilder
	// WithClientLastContactTime adds ClientLastContactTime (property field)
	WithClientLastContactTime(int64) SessionDiagnosticsDataTypeBuilder
	// WithCurrentSubscriptionsCount adds CurrentSubscriptionsCount (property field)
	WithCurrentSubscriptionsCount(uint32) SessionDiagnosticsDataTypeBuilder
	// WithCurrentMonitoredItemsCount adds CurrentMonitoredItemsCount (property field)
	WithCurrentMonitoredItemsCount(uint32) SessionDiagnosticsDataTypeBuilder
	// WithCurrentPublishRequestsInQueue adds CurrentPublishRequestsInQueue (property field)
	WithCurrentPublishRequestsInQueue(uint32) SessionDiagnosticsDataTypeBuilder
	// WithTotalRequestCount adds TotalRequestCount (property field)
	WithTotalRequestCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithTotalRequestCountBuilder adds TotalRequestCount (property field) which is build by the builder
	WithTotalRequestCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithUnauthorizedRequestCount adds UnauthorizedRequestCount (property field)
	WithUnauthorizedRequestCount(uint32) SessionDiagnosticsDataTypeBuilder
	// WithReadCount adds ReadCount (property field)
	WithReadCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithReadCountBuilder adds ReadCount (property field) which is build by the builder
	WithReadCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithHistoryReadCount adds HistoryReadCount (property field)
	WithHistoryReadCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithHistoryReadCountBuilder adds HistoryReadCount (property field) which is build by the builder
	WithHistoryReadCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithWriteCount adds WriteCount (property field)
	WithWriteCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithWriteCountBuilder adds WriteCount (property field) which is build by the builder
	WithWriteCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithHistoryUpdateCount adds HistoryUpdateCount (property field)
	WithHistoryUpdateCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithHistoryUpdateCountBuilder adds HistoryUpdateCount (property field) which is build by the builder
	WithHistoryUpdateCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithCallCount adds CallCount (property field)
	WithCallCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithCallCountBuilder adds CallCount (property field) which is build by the builder
	WithCallCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithCreateMonitoredItemsCount adds CreateMonitoredItemsCount (property field)
	WithCreateMonitoredItemsCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithCreateMonitoredItemsCountBuilder adds CreateMonitoredItemsCount (property field) which is build by the builder
	WithCreateMonitoredItemsCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithModifyMonitoredItemsCount adds ModifyMonitoredItemsCount (property field)
	WithModifyMonitoredItemsCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithModifyMonitoredItemsCountBuilder adds ModifyMonitoredItemsCount (property field) which is build by the builder
	WithModifyMonitoredItemsCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithSetMonitoringModeCount adds SetMonitoringModeCount (property field)
	WithSetMonitoringModeCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithSetMonitoringModeCountBuilder adds SetMonitoringModeCount (property field) which is build by the builder
	WithSetMonitoringModeCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithSetTriggeringCount adds SetTriggeringCount (property field)
	WithSetTriggeringCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithSetTriggeringCountBuilder adds SetTriggeringCount (property field) which is build by the builder
	WithSetTriggeringCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithDeleteMonitoredItemsCount adds DeleteMonitoredItemsCount (property field)
	WithDeleteMonitoredItemsCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithDeleteMonitoredItemsCountBuilder adds DeleteMonitoredItemsCount (property field) which is build by the builder
	WithDeleteMonitoredItemsCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithCreateSubscriptionCount adds CreateSubscriptionCount (property field)
	WithCreateSubscriptionCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithCreateSubscriptionCountBuilder adds CreateSubscriptionCount (property field) which is build by the builder
	WithCreateSubscriptionCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithModifySubscriptionCount adds ModifySubscriptionCount (property field)
	WithModifySubscriptionCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithModifySubscriptionCountBuilder adds ModifySubscriptionCount (property field) which is build by the builder
	WithModifySubscriptionCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithSetPublishingModeCount adds SetPublishingModeCount (property field)
	WithSetPublishingModeCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithSetPublishingModeCountBuilder adds SetPublishingModeCount (property field) which is build by the builder
	WithSetPublishingModeCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithPublishCount adds PublishCount (property field)
	WithPublishCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithPublishCountBuilder adds PublishCount (property field) which is build by the builder
	WithPublishCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithRepublishCount adds RepublishCount (property field)
	WithRepublishCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithRepublishCountBuilder adds RepublishCount (property field) which is build by the builder
	WithRepublishCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithTransferSubscriptionsCount adds TransferSubscriptionsCount (property field)
	WithTransferSubscriptionsCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithTransferSubscriptionsCountBuilder adds TransferSubscriptionsCount (property field) which is build by the builder
	WithTransferSubscriptionsCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithDeleteSubscriptionsCount adds DeleteSubscriptionsCount (property field)
	WithDeleteSubscriptionsCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithDeleteSubscriptionsCountBuilder adds DeleteSubscriptionsCount (property field) which is build by the builder
	WithDeleteSubscriptionsCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithAddNodesCount adds AddNodesCount (property field)
	WithAddNodesCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithAddNodesCountBuilder adds AddNodesCount (property field) which is build by the builder
	WithAddNodesCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithAddReferencesCount adds AddReferencesCount (property field)
	WithAddReferencesCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithAddReferencesCountBuilder adds AddReferencesCount (property field) which is build by the builder
	WithAddReferencesCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithDeleteNodesCount adds DeleteNodesCount (property field)
	WithDeleteNodesCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithDeleteNodesCountBuilder adds DeleteNodesCount (property field) which is build by the builder
	WithDeleteNodesCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithDeleteReferencesCount adds DeleteReferencesCount (property field)
	WithDeleteReferencesCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithDeleteReferencesCountBuilder adds DeleteReferencesCount (property field) which is build by the builder
	WithDeleteReferencesCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithBrowseCount adds BrowseCount (property field)
	WithBrowseCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithBrowseCountBuilder adds BrowseCount (property field) which is build by the builder
	WithBrowseCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithBrowseNextCount adds BrowseNextCount (property field)
	WithBrowseNextCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithBrowseNextCountBuilder adds BrowseNextCount (property field) which is build by the builder
	WithBrowseNextCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithTranslateBrowsePathsToNodeIdsCount adds TranslateBrowsePathsToNodeIdsCount (property field)
	WithTranslateBrowsePathsToNodeIdsCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithTranslateBrowsePathsToNodeIdsCountBuilder adds TranslateBrowsePathsToNodeIdsCount (property field) which is build by the builder
	WithTranslateBrowsePathsToNodeIdsCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithQueryFirstCount adds QueryFirstCount (property field)
	WithQueryFirstCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithQueryFirstCountBuilder adds QueryFirstCount (property field) which is build by the builder
	WithQueryFirstCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithQueryNextCount adds QueryNextCount (property field)
	WithQueryNextCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithQueryNextCountBuilder adds QueryNextCount (property field) which is build by the builder
	WithQueryNextCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithRegisterNodesCount adds RegisterNodesCount (property field)
	WithRegisterNodesCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithRegisterNodesCountBuilder adds RegisterNodesCount (property field) which is build by the builder
	WithRegisterNodesCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// WithUnregisterNodesCount adds UnregisterNodesCount (property field)
	WithUnregisterNodesCount(ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder
	// WithUnregisterNodesCountBuilder adds UnregisterNodesCount (property field) which is build by the builder
	WithUnregisterNodesCountBuilder(func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the SessionDiagnosticsDataType or returns an error if something is wrong
	Build() (SessionDiagnosticsDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SessionDiagnosticsDataType
}

// NewSessionDiagnosticsDataTypeBuilder() creates a SessionDiagnosticsDataTypeBuilder
func NewSessionDiagnosticsDataTypeBuilder() SessionDiagnosticsDataTypeBuilder {
	return &_SessionDiagnosticsDataTypeBuilder{_SessionDiagnosticsDataType: new(_SessionDiagnosticsDataType)}
}

type _SessionDiagnosticsDataTypeBuilder struct {
	*_SessionDiagnosticsDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (SessionDiagnosticsDataTypeBuilder) = (*_SessionDiagnosticsDataTypeBuilder)(nil)

func (b *_SessionDiagnosticsDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._SessionDiagnosticsDataType
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithMandatoryFields(sessionId NodeId, sessionName PascalString, clientDescription ApplicationDescription, serverUri PascalString, endpointUrl PascalString, localeIds []PascalString, actualSessionTimeout float64, maxResponseMessageSize uint32, clientConnectionTime int64, clientLastContactTime int64, currentSubscriptionsCount uint32, currentMonitoredItemsCount uint32, currentPublishRequestsInQueue uint32, totalRequestCount ServiceCounterDataType, unauthorizedRequestCount uint32, readCount ServiceCounterDataType, historyReadCount ServiceCounterDataType, writeCount ServiceCounterDataType, historyUpdateCount ServiceCounterDataType, callCount ServiceCounterDataType, createMonitoredItemsCount ServiceCounterDataType, modifyMonitoredItemsCount ServiceCounterDataType, setMonitoringModeCount ServiceCounterDataType, setTriggeringCount ServiceCounterDataType, deleteMonitoredItemsCount ServiceCounterDataType, createSubscriptionCount ServiceCounterDataType, modifySubscriptionCount ServiceCounterDataType, setPublishingModeCount ServiceCounterDataType, publishCount ServiceCounterDataType, republishCount ServiceCounterDataType, transferSubscriptionsCount ServiceCounterDataType, deleteSubscriptionsCount ServiceCounterDataType, addNodesCount ServiceCounterDataType, addReferencesCount ServiceCounterDataType, deleteNodesCount ServiceCounterDataType, deleteReferencesCount ServiceCounterDataType, browseCount ServiceCounterDataType, browseNextCount ServiceCounterDataType, translateBrowsePathsToNodeIdsCount ServiceCounterDataType, queryFirstCount ServiceCounterDataType, queryNextCount ServiceCounterDataType, registerNodesCount ServiceCounterDataType, unregisterNodesCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	return b.WithSessionId(sessionId).WithSessionName(sessionName).WithClientDescription(clientDescription).WithServerUri(serverUri).WithEndpointUrl(endpointUrl).WithLocaleIds(localeIds...).WithActualSessionTimeout(actualSessionTimeout).WithMaxResponseMessageSize(maxResponseMessageSize).WithClientConnectionTime(clientConnectionTime).WithClientLastContactTime(clientLastContactTime).WithCurrentSubscriptionsCount(currentSubscriptionsCount).WithCurrentMonitoredItemsCount(currentMonitoredItemsCount).WithCurrentPublishRequestsInQueue(currentPublishRequestsInQueue).WithTotalRequestCount(totalRequestCount).WithUnauthorizedRequestCount(unauthorizedRequestCount).WithReadCount(readCount).WithHistoryReadCount(historyReadCount).WithWriteCount(writeCount).WithHistoryUpdateCount(historyUpdateCount).WithCallCount(callCount).WithCreateMonitoredItemsCount(createMonitoredItemsCount).WithModifyMonitoredItemsCount(modifyMonitoredItemsCount).WithSetMonitoringModeCount(setMonitoringModeCount).WithSetTriggeringCount(setTriggeringCount).WithDeleteMonitoredItemsCount(deleteMonitoredItemsCount).WithCreateSubscriptionCount(createSubscriptionCount).WithModifySubscriptionCount(modifySubscriptionCount).WithSetPublishingModeCount(setPublishingModeCount).WithPublishCount(publishCount).WithRepublishCount(republishCount).WithTransferSubscriptionsCount(transferSubscriptionsCount).WithDeleteSubscriptionsCount(deleteSubscriptionsCount).WithAddNodesCount(addNodesCount).WithAddReferencesCount(addReferencesCount).WithDeleteNodesCount(deleteNodesCount).WithDeleteReferencesCount(deleteReferencesCount).WithBrowseCount(browseCount).WithBrowseNextCount(browseNextCount).WithTranslateBrowsePathsToNodeIdsCount(translateBrowsePathsToNodeIdsCount).WithQueryFirstCount(queryFirstCount).WithQueryNextCount(queryNextCount).WithRegisterNodesCount(registerNodesCount).WithUnregisterNodesCount(unregisterNodesCount)
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSessionId(sessionId NodeId) SessionDiagnosticsDataTypeBuilder {
	b.SessionId = sessionId
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSessionIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.SessionId.CreateNodeIdBuilder())
	var err error
	b.SessionId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSessionName(sessionName PascalString) SessionDiagnosticsDataTypeBuilder {
	b.SessionName = sessionName
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSessionNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.SessionName.CreatePascalStringBuilder())
	var err error
	b.SessionName, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithClientDescription(clientDescription ApplicationDescription) SessionDiagnosticsDataTypeBuilder {
	b.ClientDescription = clientDescription
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithClientDescriptionBuilder(builderSupplier func(ApplicationDescriptionBuilder) ApplicationDescriptionBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.ClientDescription.CreateApplicationDescriptionBuilder())
	var err error
	b.ClientDescription, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ApplicationDescriptionBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithServerUri(serverUri PascalString) SessionDiagnosticsDataTypeBuilder {
	b.ServerUri = serverUri
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithServerUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.ServerUri.CreatePascalStringBuilder())
	var err error
	b.ServerUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithEndpointUrl(endpointUrl PascalString) SessionDiagnosticsDataTypeBuilder {
	b.EndpointUrl = endpointUrl
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithEndpointUrlBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.EndpointUrl.CreatePascalStringBuilder())
	var err error
	b.EndpointUrl, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithLocaleIds(localeIds ...PascalString) SessionDiagnosticsDataTypeBuilder {
	b.LocaleIds = localeIds
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithActualSessionTimeout(actualSessionTimeout float64) SessionDiagnosticsDataTypeBuilder {
	b.ActualSessionTimeout = actualSessionTimeout
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithMaxResponseMessageSize(maxResponseMessageSize uint32) SessionDiagnosticsDataTypeBuilder {
	b.MaxResponseMessageSize = maxResponseMessageSize
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithClientConnectionTime(clientConnectionTime int64) SessionDiagnosticsDataTypeBuilder {
	b.ClientConnectionTime = clientConnectionTime
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithClientLastContactTime(clientLastContactTime int64) SessionDiagnosticsDataTypeBuilder {
	b.ClientLastContactTime = clientLastContactTime
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCurrentSubscriptionsCount(currentSubscriptionsCount uint32) SessionDiagnosticsDataTypeBuilder {
	b.CurrentSubscriptionsCount = currentSubscriptionsCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCurrentMonitoredItemsCount(currentMonitoredItemsCount uint32) SessionDiagnosticsDataTypeBuilder {
	b.CurrentMonitoredItemsCount = currentMonitoredItemsCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCurrentPublishRequestsInQueue(currentPublishRequestsInQueue uint32) SessionDiagnosticsDataTypeBuilder {
	b.CurrentPublishRequestsInQueue = currentPublishRequestsInQueue
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithTotalRequestCount(totalRequestCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.TotalRequestCount = totalRequestCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithTotalRequestCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.TotalRequestCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.TotalRequestCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithUnauthorizedRequestCount(unauthorizedRequestCount uint32) SessionDiagnosticsDataTypeBuilder {
	b.UnauthorizedRequestCount = unauthorizedRequestCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithReadCount(readCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.ReadCount = readCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithReadCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.ReadCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.ReadCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithHistoryReadCount(historyReadCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.HistoryReadCount = historyReadCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithHistoryReadCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.HistoryReadCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.HistoryReadCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithWriteCount(writeCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.WriteCount = writeCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithWriteCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.WriteCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.WriteCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithHistoryUpdateCount(historyUpdateCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.HistoryUpdateCount = historyUpdateCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithHistoryUpdateCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.HistoryUpdateCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.HistoryUpdateCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCallCount(callCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.CallCount = callCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCallCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.CallCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.CallCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCreateMonitoredItemsCount(createMonitoredItemsCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.CreateMonitoredItemsCount = createMonitoredItemsCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCreateMonitoredItemsCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.CreateMonitoredItemsCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.CreateMonitoredItemsCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithModifyMonitoredItemsCount(modifyMonitoredItemsCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.ModifyMonitoredItemsCount = modifyMonitoredItemsCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithModifyMonitoredItemsCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.ModifyMonitoredItemsCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.ModifyMonitoredItemsCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSetMonitoringModeCount(setMonitoringModeCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.SetMonitoringModeCount = setMonitoringModeCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSetMonitoringModeCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.SetMonitoringModeCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.SetMonitoringModeCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSetTriggeringCount(setTriggeringCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.SetTriggeringCount = setTriggeringCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSetTriggeringCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.SetTriggeringCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.SetTriggeringCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithDeleteMonitoredItemsCount(deleteMonitoredItemsCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.DeleteMonitoredItemsCount = deleteMonitoredItemsCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithDeleteMonitoredItemsCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.DeleteMonitoredItemsCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.DeleteMonitoredItemsCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCreateSubscriptionCount(createSubscriptionCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.CreateSubscriptionCount = createSubscriptionCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithCreateSubscriptionCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.CreateSubscriptionCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.CreateSubscriptionCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithModifySubscriptionCount(modifySubscriptionCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.ModifySubscriptionCount = modifySubscriptionCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithModifySubscriptionCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.ModifySubscriptionCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.ModifySubscriptionCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSetPublishingModeCount(setPublishingModeCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.SetPublishingModeCount = setPublishingModeCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithSetPublishingModeCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.SetPublishingModeCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.SetPublishingModeCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithPublishCount(publishCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.PublishCount = publishCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithPublishCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.PublishCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.PublishCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithRepublishCount(republishCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.RepublishCount = republishCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithRepublishCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.RepublishCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.RepublishCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithTransferSubscriptionsCount(transferSubscriptionsCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.TransferSubscriptionsCount = transferSubscriptionsCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithTransferSubscriptionsCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.TransferSubscriptionsCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.TransferSubscriptionsCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithDeleteSubscriptionsCount(deleteSubscriptionsCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.DeleteSubscriptionsCount = deleteSubscriptionsCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithDeleteSubscriptionsCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.DeleteSubscriptionsCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.DeleteSubscriptionsCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithAddNodesCount(addNodesCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.AddNodesCount = addNodesCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithAddNodesCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.AddNodesCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.AddNodesCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithAddReferencesCount(addReferencesCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.AddReferencesCount = addReferencesCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithAddReferencesCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.AddReferencesCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.AddReferencesCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithDeleteNodesCount(deleteNodesCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.DeleteNodesCount = deleteNodesCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithDeleteNodesCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.DeleteNodesCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.DeleteNodesCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithDeleteReferencesCount(deleteReferencesCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.DeleteReferencesCount = deleteReferencesCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithDeleteReferencesCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.DeleteReferencesCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.DeleteReferencesCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithBrowseCount(browseCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.BrowseCount = browseCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithBrowseCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.BrowseCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.BrowseCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithBrowseNextCount(browseNextCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.BrowseNextCount = browseNextCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithBrowseNextCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.BrowseNextCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.BrowseNextCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithTranslateBrowsePathsToNodeIdsCount(translateBrowsePathsToNodeIdsCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.TranslateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithTranslateBrowsePathsToNodeIdsCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.TranslateBrowsePathsToNodeIdsCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.TranslateBrowsePathsToNodeIdsCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithQueryFirstCount(queryFirstCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.QueryFirstCount = queryFirstCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithQueryFirstCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.QueryFirstCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.QueryFirstCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithQueryNextCount(queryNextCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.QueryNextCount = queryNextCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithQueryNextCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.QueryNextCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.QueryNextCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithRegisterNodesCount(registerNodesCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.RegisterNodesCount = registerNodesCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithRegisterNodesCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.RegisterNodesCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.RegisterNodesCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithUnregisterNodesCount(unregisterNodesCount ServiceCounterDataType) SessionDiagnosticsDataTypeBuilder {
	b.UnregisterNodesCount = unregisterNodesCount
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) WithUnregisterNodesCountBuilder(builderSupplier func(ServiceCounterDataTypeBuilder) ServiceCounterDataTypeBuilder) SessionDiagnosticsDataTypeBuilder {
	builder := builderSupplier(b.UnregisterNodesCount.CreateServiceCounterDataTypeBuilder())
	var err error
	b.UnregisterNodesCount, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ServiceCounterDataTypeBuilder failed"))
	}
	return b
}

func (b *_SessionDiagnosticsDataTypeBuilder) Build() (SessionDiagnosticsDataType, error) {
	if b.SessionId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'sessionId' not set"))
	}
	if b.SessionName == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'sessionName' not set"))
	}
	if b.ClientDescription == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'clientDescription' not set"))
	}
	if b.ServerUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'serverUri' not set"))
	}
	if b.EndpointUrl == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'endpointUrl' not set"))
	}
	if b.TotalRequestCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'totalRequestCount' not set"))
	}
	if b.ReadCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'readCount' not set"))
	}
	if b.HistoryReadCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'historyReadCount' not set"))
	}
	if b.WriteCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'writeCount' not set"))
	}
	if b.HistoryUpdateCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'historyUpdateCount' not set"))
	}
	if b.CallCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'callCount' not set"))
	}
	if b.CreateMonitoredItemsCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'createMonitoredItemsCount' not set"))
	}
	if b.ModifyMonitoredItemsCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'modifyMonitoredItemsCount' not set"))
	}
	if b.SetMonitoringModeCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'setMonitoringModeCount' not set"))
	}
	if b.SetTriggeringCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'setTriggeringCount' not set"))
	}
	if b.DeleteMonitoredItemsCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'deleteMonitoredItemsCount' not set"))
	}
	if b.CreateSubscriptionCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'createSubscriptionCount' not set"))
	}
	if b.ModifySubscriptionCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'modifySubscriptionCount' not set"))
	}
	if b.SetPublishingModeCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'setPublishingModeCount' not set"))
	}
	if b.PublishCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'publishCount' not set"))
	}
	if b.RepublishCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'republishCount' not set"))
	}
	if b.TransferSubscriptionsCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'transferSubscriptionsCount' not set"))
	}
	if b.DeleteSubscriptionsCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'deleteSubscriptionsCount' not set"))
	}
	if b.AddNodesCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'addNodesCount' not set"))
	}
	if b.AddReferencesCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'addReferencesCount' not set"))
	}
	if b.DeleteNodesCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'deleteNodesCount' not set"))
	}
	if b.DeleteReferencesCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'deleteReferencesCount' not set"))
	}
	if b.BrowseCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'browseCount' not set"))
	}
	if b.BrowseNextCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'browseNextCount' not set"))
	}
	if b.TranslateBrowsePathsToNodeIdsCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'translateBrowsePathsToNodeIdsCount' not set"))
	}
	if b.QueryFirstCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'queryFirstCount' not set"))
	}
	if b.QueryNextCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'queryNextCount' not set"))
	}
	if b.RegisterNodesCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'registerNodesCount' not set"))
	}
	if b.UnregisterNodesCount == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'unregisterNodesCount' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._SessionDiagnosticsDataType.deepCopy(), nil
}

func (b *_SessionDiagnosticsDataTypeBuilder) MustBuild() SessionDiagnosticsDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SessionDiagnosticsDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_SessionDiagnosticsDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_SessionDiagnosticsDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateSessionDiagnosticsDataTypeBuilder().(*_SessionDiagnosticsDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateSessionDiagnosticsDataTypeBuilder creates a SessionDiagnosticsDataTypeBuilder
func (b *_SessionDiagnosticsDataType) CreateSessionDiagnosticsDataTypeBuilder() SessionDiagnosticsDataTypeBuilder {
	if b == nil {
		return NewSessionDiagnosticsDataTypeBuilder()
	}
	return &_SessionDiagnosticsDataTypeBuilder{_SessionDiagnosticsDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_SessionDiagnosticsDataType) GetExtensionId() int32 {
	return int32(867)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SessionDiagnosticsDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SessionDiagnosticsDataType) GetSessionId() NodeId {
	return m.SessionId
}

func (m *_SessionDiagnosticsDataType) GetSessionName() PascalString {
	return m.SessionName
}

func (m *_SessionDiagnosticsDataType) GetClientDescription() ApplicationDescription {
	return m.ClientDescription
}

func (m *_SessionDiagnosticsDataType) GetServerUri() PascalString {
	return m.ServerUri
}

func (m *_SessionDiagnosticsDataType) GetEndpointUrl() PascalString {
	return m.EndpointUrl
}

func (m *_SessionDiagnosticsDataType) GetLocaleIds() []PascalString {
	return m.LocaleIds
}

func (m *_SessionDiagnosticsDataType) GetActualSessionTimeout() float64 {
	return m.ActualSessionTimeout
}

func (m *_SessionDiagnosticsDataType) GetMaxResponseMessageSize() uint32 {
	return m.MaxResponseMessageSize
}

func (m *_SessionDiagnosticsDataType) GetClientConnectionTime() int64 {
	return m.ClientConnectionTime
}

func (m *_SessionDiagnosticsDataType) GetClientLastContactTime() int64 {
	return m.ClientLastContactTime
}

func (m *_SessionDiagnosticsDataType) GetCurrentSubscriptionsCount() uint32 {
	return m.CurrentSubscriptionsCount
}

func (m *_SessionDiagnosticsDataType) GetCurrentMonitoredItemsCount() uint32 {
	return m.CurrentMonitoredItemsCount
}

func (m *_SessionDiagnosticsDataType) GetCurrentPublishRequestsInQueue() uint32 {
	return m.CurrentPublishRequestsInQueue
}

func (m *_SessionDiagnosticsDataType) GetTotalRequestCount() ServiceCounterDataType {
	return m.TotalRequestCount
}

func (m *_SessionDiagnosticsDataType) GetUnauthorizedRequestCount() uint32 {
	return m.UnauthorizedRequestCount
}

func (m *_SessionDiagnosticsDataType) GetReadCount() ServiceCounterDataType {
	return m.ReadCount
}

func (m *_SessionDiagnosticsDataType) GetHistoryReadCount() ServiceCounterDataType {
	return m.HistoryReadCount
}

func (m *_SessionDiagnosticsDataType) GetWriteCount() ServiceCounterDataType {
	return m.WriteCount
}

func (m *_SessionDiagnosticsDataType) GetHistoryUpdateCount() ServiceCounterDataType {
	return m.HistoryUpdateCount
}

func (m *_SessionDiagnosticsDataType) GetCallCount() ServiceCounterDataType {
	return m.CallCount
}

func (m *_SessionDiagnosticsDataType) GetCreateMonitoredItemsCount() ServiceCounterDataType {
	return m.CreateMonitoredItemsCount
}

func (m *_SessionDiagnosticsDataType) GetModifyMonitoredItemsCount() ServiceCounterDataType {
	return m.ModifyMonitoredItemsCount
}

func (m *_SessionDiagnosticsDataType) GetSetMonitoringModeCount() ServiceCounterDataType {
	return m.SetMonitoringModeCount
}

func (m *_SessionDiagnosticsDataType) GetSetTriggeringCount() ServiceCounterDataType {
	return m.SetTriggeringCount
}

func (m *_SessionDiagnosticsDataType) GetDeleteMonitoredItemsCount() ServiceCounterDataType {
	return m.DeleteMonitoredItemsCount
}

func (m *_SessionDiagnosticsDataType) GetCreateSubscriptionCount() ServiceCounterDataType {
	return m.CreateSubscriptionCount
}

func (m *_SessionDiagnosticsDataType) GetModifySubscriptionCount() ServiceCounterDataType {
	return m.ModifySubscriptionCount
}

func (m *_SessionDiagnosticsDataType) GetSetPublishingModeCount() ServiceCounterDataType {
	return m.SetPublishingModeCount
}

func (m *_SessionDiagnosticsDataType) GetPublishCount() ServiceCounterDataType {
	return m.PublishCount
}

func (m *_SessionDiagnosticsDataType) GetRepublishCount() ServiceCounterDataType {
	return m.RepublishCount
}

func (m *_SessionDiagnosticsDataType) GetTransferSubscriptionsCount() ServiceCounterDataType {
	return m.TransferSubscriptionsCount
}

func (m *_SessionDiagnosticsDataType) GetDeleteSubscriptionsCount() ServiceCounterDataType {
	return m.DeleteSubscriptionsCount
}

func (m *_SessionDiagnosticsDataType) GetAddNodesCount() ServiceCounterDataType {
	return m.AddNodesCount
}

func (m *_SessionDiagnosticsDataType) GetAddReferencesCount() ServiceCounterDataType {
	return m.AddReferencesCount
}

func (m *_SessionDiagnosticsDataType) GetDeleteNodesCount() ServiceCounterDataType {
	return m.DeleteNodesCount
}

func (m *_SessionDiagnosticsDataType) GetDeleteReferencesCount() ServiceCounterDataType {
	return m.DeleteReferencesCount
}

func (m *_SessionDiagnosticsDataType) GetBrowseCount() ServiceCounterDataType {
	return m.BrowseCount
}

func (m *_SessionDiagnosticsDataType) GetBrowseNextCount() ServiceCounterDataType {
	return m.BrowseNextCount
}

func (m *_SessionDiagnosticsDataType) GetTranslateBrowsePathsToNodeIdsCount() ServiceCounterDataType {
	return m.TranslateBrowsePathsToNodeIdsCount
}

func (m *_SessionDiagnosticsDataType) GetQueryFirstCount() ServiceCounterDataType {
	return m.QueryFirstCount
}

func (m *_SessionDiagnosticsDataType) GetQueryNextCount() ServiceCounterDataType {
	return m.QueryNextCount
}

func (m *_SessionDiagnosticsDataType) GetRegisterNodesCount() ServiceCounterDataType {
	return m.RegisterNodesCount
}

func (m *_SessionDiagnosticsDataType) GetUnregisterNodesCount() ServiceCounterDataType {
	return m.UnregisterNodesCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSessionDiagnosticsDataType(structType any) SessionDiagnosticsDataType {
	if casted, ok := structType.(SessionDiagnosticsDataType); ok {
		return casted
	}
	if casted, ok := structType.(*SessionDiagnosticsDataType); ok {
		return *casted
	}
	return nil
}

func (m *_SessionDiagnosticsDataType) GetTypeName() string {
	return "SessionDiagnosticsDataType"
}

func (m *_SessionDiagnosticsDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (sessionId)
	lengthInBits += m.SessionId.GetLengthInBits(ctx)

	// Simple field (sessionName)
	lengthInBits += m.SessionName.GetLengthInBits(ctx)

	// Simple field (clientDescription)
	lengthInBits += m.ClientDescription.GetLengthInBits(ctx)

	// Simple field (serverUri)
	lengthInBits += m.ServerUri.GetLengthInBits(ctx)

	// Simple field (endpointUrl)
	lengthInBits += m.EndpointUrl.GetLengthInBits(ctx)

	// Implicit Field (noOfLocaleIds)
	lengthInBits += 32

	// Array field
	if len(m.LocaleIds) > 0 {
		for _curItem, element := range m.LocaleIds {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.LocaleIds), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (actualSessionTimeout)
	lengthInBits += 64

	// Simple field (maxResponseMessageSize)
	lengthInBits += 32

	// Simple field (clientConnectionTime)
	lengthInBits += 64

	// Simple field (clientLastContactTime)
	lengthInBits += 64

	// Simple field (currentSubscriptionsCount)
	lengthInBits += 32

	// Simple field (currentMonitoredItemsCount)
	lengthInBits += 32

	// Simple field (currentPublishRequestsInQueue)
	lengthInBits += 32

	// Simple field (totalRequestCount)
	lengthInBits += m.TotalRequestCount.GetLengthInBits(ctx)

	// Simple field (unauthorizedRequestCount)
	lengthInBits += 32

	// Simple field (readCount)
	lengthInBits += m.ReadCount.GetLengthInBits(ctx)

	// Simple field (historyReadCount)
	lengthInBits += m.HistoryReadCount.GetLengthInBits(ctx)

	// Simple field (writeCount)
	lengthInBits += m.WriteCount.GetLengthInBits(ctx)

	// Simple field (historyUpdateCount)
	lengthInBits += m.HistoryUpdateCount.GetLengthInBits(ctx)

	// Simple field (callCount)
	lengthInBits += m.CallCount.GetLengthInBits(ctx)

	// Simple field (createMonitoredItemsCount)
	lengthInBits += m.CreateMonitoredItemsCount.GetLengthInBits(ctx)

	// Simple field (modifyMonitoredItemsCount)
	lengthInBits += m.ModifyMonitoredItemsCount.GetLengthInBits(ctx)

	// Simple field (setMonitoringModeCount)
	lengthInBits += m.SetMonitoringModeCount.GetLengthInBits(ctx)

	// Simple field (setTriggeringCount)
	lengthInBits += m.SetTriggeringCount.GetLengthInBits(ctx)

	// Simple field (deleteMonitoredItemsCount)
	lengthInBits += m.DeleteMonitoredItemsCount.GetLengthInBits(ctx)

	// Simple field (createSubscriptionCount)
	lengthInBits += m.CreateSubscriptionCount.GetLengthInBits(ctx)

	// Simple field (modifySubscriptionCount)
	lengthInBits += m.ModifySubscriptionCount.GetLengthInBits(ctx)

	// Simple field (setPublishingModeCount)
	lengthInBits += m.SetPublishingModeCount.GetLengthInBits(ctx)

	// Simple field (publishCount)
	lengthInBits += m.PublishCount.GetLengthInBits(ctx)

	// Simple field (republishCount)
	lengthInBits += m.RepublishCount.GetLengthInBits(ctx)

	// Simple field (transferSubscriptionsCount)
	lengthInBits += m.TransferSubscriptionsCount.GetLengthInBits(ctx)

	// Simple field (deleteSubscriptionsCount)
	lengthInBits += m.DeleteSubscriptionsCount.GetLengthInBits(ctx)

	// Simple field (addNodesCount)
	lengthInBits += m.AddNodesCount.GetLengthInBits(ctx)

	// Simple field (addReferencesCount)
	lengthInBits += m.AddReferencesCount.GetLengthInBits(ctx)

	// Simple field (deleteNodesCount)
	lengthInBits += m.DeleteNodesCount.GetLengthInBits(ctx)

	// Simple field (deleteReferencesCount)
	lengthInBits += m.DeleteReferencesCount.GetLengthInBits(ctx)

	// Simple field (browseCount)
	lengthInBits += m.BrowseCount.GetLengthInBits(ctx)

	// Simple field (browseNextCount)
	lengthInBits += m.BrowseNextCount.GetLengthInBits(ctx)

	// Simple field (translateBrowsePathsToNodeIdsCount)
	lengthInBits += m.TranslateBrowsePathsToNodeIdsCount.GetLengthInBits(ctx)

	// Simple field (queryFirstCount)
	lengthInBits += m.QueryFirstCount.GetLengthInBits(ctx)

	// Simple field (queryNextCount)
	lengthInBits += m.QueryNextCount.GetLengthInBits(ctx)

	// Simple field (registerNodesCount)
	lengthInBits += m.RegisterNodesCount.GetLengthInBits(ctx)

	// Simple field (unregisterNodesCount)
	lengthInBits += m.UnregisterNodesCount.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_SessionDiagnosticsDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SessionDiagnosticsDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__sessionDiagnosticsDataType SessionDiagnosticsDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SessionDiagnosticsDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SessionDiagnosticsDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	sessionId, err := ReadSimpleField[NodeId](ctx, "sessionId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sessionId' field"))
	}
	m.SessionId = sessionId

	sessionName, err := ReadSimpleField[PascalString](ctx, "sessionName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sessionName' field"))
	}
	m.SessionName = sessionName

	clientDescription, err := ReadSimpleField[ApplicationDescription](ctx, "clientDescription", ReadComplex[ApplicationDescription](ExtensionObjectDefinitionParseWithBufferProducer[ApplicationDescription]((int32)(int32(310))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'clientDescription' field"))
	}
	m.ClientDescription = clientDescription

	serverUri, err := ReadSimpleField[PascalString](ctx, "serverUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverUri' field"))
	}
	m.ServerUri = serverUri

	endpointUrl, err := ReadSimpleField[PascalString](ctx, "endpointUrl", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'endpointUrl' field"))
	}
	m.EndpointUrl = endpointUrl

	noOfLocaleIds, err := ReadImplicitField[int32](ctx, "noOfLocaleIds", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfLocaleIds' field"))
	}
	_ = noOfLocaleIds

	localeIds, err := ReadCountArrayField[PascalString](ctx, "localeIds", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfLocaleIds))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'localeIds' field"))
	}
	m.LocaleIds = localeIds

	actualSessionTimeout, err := ReadSimpleField(ctx, "actualSessionTimeout", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualSessionTimeout' field"))
	}
	m.ActualSessionTimeout = actualSessionTimeout

	maxResponseMessageSize, err := ReadSimpleField(ctx, "maxResponseMessageSize", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'maxResponseMessageSize' field"))
	}
	m.MaxResponseMessageSize = maxResponseMessageSize

	clientConnectionTime, err := ReadSimpleField(ctx, "clientConnectionTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'clientConnectionTime' field"))
	}
	m.ClientConnectionTime = clientConnectionTime

	clientLastContactTime, err := ReadSimpleField(ctx, "clientLastContactTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'clientLastContactTime' field"))
	}
	m.ClientLastContactTime = clientLastContactTime

	currentSubscriptionsCount, err := ReadSimpleField(ctx, "currentSubscriptionsCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'currentSubscriptionsCount' field"))
	}
	m.CurrentSubscriptionsCount = currentSubscriptionsCount

	currentMonitoredItemsCount, err := ReadSimpleField(ctx, "currentMonitoredItemsCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'currentMonitoredItemsCount' field"))
	}
	m.CurrentMonitoredItemsCount = currentMonitoredItemsCount

	currentPublishRequestsInQueue, err := ReadSimpleField(ctx, "currentPublishRequestsInQueue", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'currentPublishRequestsInQueue' field"))
	}
	m.CurrentPublishRequestsInQueue = currentPublishRequestsInQueue

	totalRequestCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "totalRequestCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'totalRequestCount' field"))
	}
	m.TotalRequestCount = totalRequestCount

	unauthorizedRequestCount, err := ReadSimpleField(ctx, "unauthorizedRequestCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unauthorizedRequestCount' field"))
	}
	m.UnauthorizedRequestCount = unauthorizedRequestCount

	readCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "readCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'readCount' field"))
	}
	m.ReadCount = readCount

	historyReadCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "historyReadCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'historyReadCount' field"))
	}
	m.HistoryReadCount = historyReadCount

	writeCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "writeCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeCount' field"))
	}
	m.WriteCount = writeCount

	historyUpdateCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "historyUpdateCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'historyUpdateCount' field"))
	}
	m.HistoryUpdateCount = historyUpdateCount

	callCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "callCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'callCount' field"))
	}
	m.CallCount = callCount

	createMonitoredItemsCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "createMonitoredItemsCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'createMonitoredItemsCount' field"))
	}
	m.CreateMonitoredItemsCount = createMonitoredItemsCount

	modifyMonitoredItemsCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "modifyMonitoredItemsCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'modifyMonitoredItemsCount' field"))
	}
	m.ModifyMonitoredItemsCount = modifyMonitoredItemsCount

	setMonitoringModeCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "setMonitoringModeCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'setMonitoringModeCount' field"))
	}
	m.SetMonitoringModeCount = setMonitoringModeCount

	setTriggeringCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "setTriggeringCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'setTriggeringCount' field"))
	}
	m.SetTriggeringCount = setTriggeringCount

	deleteMonitoredItemsCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "deleteMonitoredItemsCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deleteMonitoredItemsCount' field"))
	}
	m.DeleteMonitoredItemsCount = deleteMonitoredItemsCount

	createSubscriptionCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "createSubscriptionCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'createSubscriptionCount' field"))
	}
	m.CreateSubscriptionCount = createSubscriptionCount

	modifySubscriptionCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "modifySubscriptionCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'modifySubscriptionCount' field"))
	}
	m.ModifySubscriptionCount = modifySubscriptionCount

	setPublishingModeCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "setPublishingModeCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'setPublishingModeCount' field"))
	}
	m.SetPublishingModeCount = setPublishingModeCount

	publishCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "publishCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publishCount' field"))
	}
	m.PublishCount = publishCount

	republishCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "republishCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'republishCount' field"))
	}
	m.RepublishCount = republishCount

	transferSubscriptionsCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "transferSubscriptionsCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transferSubscriptionsCount' field"))
	}
	m.TransferSubscriptionsCount = transferSubscriptionsCount

	deleteSubscriptionsCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "deleteSubscriptionsCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deleteSubscriptionsCount' field"))
	}
	m.DeleteSubscriptionsCount = deleteSubscriptionsCount

	addNodesCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "addNodesCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'addNodesCount' field"))
	}
	m.AddNodesCount = addNodesCount

	addReferencesCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "addReferencesCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'addReferencesCount' field"))
	}
	m.AddReferencesCount = addReferencesCount

	deleteNodesCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "deleteNodesCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deleteNodesCount' field"))
	}
	m.DeleteNodesCount = deleteNodesCount

	deleteReferencesCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "deleteReferencesCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'deleteReferencesCount' field"))
	}
	m.DeleteReferencesCount = deleteReferencesCount

	browseCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "browseCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'browseCount' field"))
	}
	m.BrowseCount = browseCount

	browseNextCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "browseNextCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'browseNextCount' field"))
	}
	m.BrowseNextCount = browseNextCount

	translateBrowsePathsToNodeIdsCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "translateBrowsePathsToNodeIdsCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'translateBrowsePathsToNodeIdsCount' field"))
	}
	m.TranslateBrowsePathsToNodeIdsCount = translateBrowsePathsToNodeIdsCount

	queryFirstCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "queryFirstCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'queryFirstCount' field"))
	}
	m.QueryFirstCount = queryFirstCount

	queryNextCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "queryNextCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'queryNextCount' field"))
	}
	m.QueryNextCount = queryNextCount

	registerNodesCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "registerNodesCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'registerNodesCount' field"))
	}
	m.RegisterNodesCount = registerNodesCount

	unregisterNodesCount, err := ReadSimpleField[ServiceCounterDataType](ctx, "unregisterNodesCount", ReadComplex[ServiceCounterDataType](ExtensionObjectDefinitionParseWithBufferProducer[ServiceCounterDataType]((int32)(int32(873))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unregisterNodesCount' field"))
	}
	m.UnregisterNodesCount = unregisterNodesCount

	if closeErr := readBuffer.CloseContext("SessionDiagnosticsDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SessionDiagnosticsDataType")
	}

	return m, nil
}

func (m *_SessionDiagnosticsDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SessionDiagnosticsDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SessionDiagnosticsDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SessionDiagnosticsDataType")
		}

		if err := WriteSimpleField[NodeId](ctx, "sessionId", m.GetSessionId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'sessionId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "sessionName", m.GetSessionName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'sessionName' field")
		}

		if err := WriteSimpleField[ApplicationDescription](ctx, "clientDescription", m.GetClientDescription(), WriteComplex[ApplicationDescription](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'clientDescription' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "serverUri", m.GetServerUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'serverUri' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "endpointUrl", m.GetEndpointUrl(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'endpointUrl' field")
		}
		noOfLocaleIds := int32(utils.InlineIf(bool((m.GetLocaleIds()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetLocaleIds()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfLocaleIds", noOfLocaleIds, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfLocaleIds' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "localeIds", m.GetLocaleIds(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'localeIds' field")
		}

		if err := WriteSimpleField[float64](ctx, "actualSessionTimeout", m.GetActualSessionTimeout(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'actualSessionTimeout' field")
		}

		if err := WriteSimpleField[uint32](ctx, "maxResponseMessageSize", m.GetMaxResponseMessageSize(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'maxResponseMessageSize' field")
		}

		if err := WriteSimpleField[int64](ctx, "clientConnectionTime", m.GetClientConnectionTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'clientConnectionTime' field")
		}

		if err := WriteSimpleField[int64](ctx, "clientLastContactTime", m.GetClientLastContactTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'clientLastContactTime' field")
		}

		if err := WriteSimpleField[uint32](ctx, "currentSubscriptionsCount", m.GetCurrentSubscriptionsCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'currentSubscriptionsCount' field")
		}

		if err := WriteSimpleField[uint32](ctx, "currentMonitoredItemsCount", m.GetCurrentMonitoredItemsCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'currentMonitoredItemsCount' field")
		}

		if err := WriteSimpleField[uint32](ctx, "currentPublishRequestsInQueue", m.GetCurrentPublishRequestsInQueue(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'currentPublishRequestsInQueue' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "totalRequestCount", m.GetTotalRequestCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'totalRequestCount' field")
		}

		if err := WriteSimpleField[uint32](ctx, "unauthorizedRequestCount", m.GetUnauthorizedRequestCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'unauthorizedRequestCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "readCount", m.GetReadCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'readCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "historyReadCount", m.GetHistoryReadCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'historyReadCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "writeCount", m.GetWriteCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'writeCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "historyUpdateCount", m.GetHistoryUpdateCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'historyUpdateCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "callCount", m.GetCallCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'callCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "createMonitoredItemsCount", m.GetCreateMonitoredItemsCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'createMonitoredItemsCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "modifyMonitoredItemsCount", m.GetModifyMonitoredItemsCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'modifyMonitoredItemsCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "setMonitoringModeCount", m.GetSetMonitoringModeCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'setMonitoringModeCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "setTriggeringCount", m.GetSetTriggeringCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'setTriggeringCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "deleteMonitoredItemsCount", m.GetDeleteMonitoredItemsCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'deleteMonitoredItemsCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "createSubscriptionCount", m.GetCreateSubscriptionCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'createSubscriptionCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "modifySubscriptionCount", m.GetModifySubscriptionCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'modifySubscriptionCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "setPublishingModeCount", m.GetSetPublishingModeCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'setPublishingModeCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "publishCount", m.GetPublishCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publishCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "republishCount", m.GetRepublishCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'republishCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "transferSubscriptionsCount", m.GetTransferSubscriptionsCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'transferSubscriptionsCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "deleteSubscriptionsCount", m.GetDeleteSubscriptionsCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'deleteSubscriptionsCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "addNodesCount", m.GetAddNodesCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'addNodesCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "addReferencesCount", m.GetAddReferencesCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'addReferencesCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "deleteNodesCount", m.GetDeleteNodesCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'deleteNodesCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "deleteReferencesCount", m.GetDeleteReferencesCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'deleteReferencesCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "browseCount", m.GetBrowseCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'browseCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "browseNextCount", m.GetBrowseNextCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'browseNextCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "translateBrowsePathsToNodeIdsCount", m.GetTranslateBrowsePathsToNodeIdsCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'translateBrowsePathsToNodeIdsCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "queryFirstCount", m.GetQueryFirstCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'queryFirstCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "queryNextCount", m.GetQueryNextCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'queryNextCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "registerNodesCount", m.GetRegisterNodesCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'registerNodesCount' field")
		}

		if err := WriteSimpleField[ServiceCounterDataType](ctx, "unregisterNodesCount", m.GetUnregisterNodesCount(), WriteComplex[ServiceCounterDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'unregisterNodesCount' field")
		}

		if popErr := writeBuffer.PopContext("SessionDiagnosticsDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SessionDiagnosticsDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SessionDiagnosticsDataType) IsSessionDiagnosticsDataType() {}

func (m *_SessionDiagnosticsDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SessionDiagnosticsDataType) deepCopy() *_SessionDiagnosticsDataType {
	if m == nil {
		return nil
	}
	_SessionDiagnosticsDataTypeCopy := &_SessionDiagnosticsDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.SessionId),
		utils.DeepCopy[PascalString](m.SessionName),
		utils.DeepCopy[ApplicationDescription](m.ClientDescription),
		utils.DeepCopy[PascalString](m.ServerUri),
		utils.DeepCopy[PascalString](m.EndpointUrl),
		utils.DeepCopySlice[PascalString, PascalString](m.LocaleIds),
		m.ActualSessionTimeout,
		m.MaxResponseMessageSize,
		m.ClientConnectionTime,
		m.ClientLastContactTime,
		m.CurrentSubscriptionsCount,
		m.CurrentMonitoredItemsCount,
		m.CurrentPublishRequestsInQueue,
		utils.DeepCopy[ServiceCounterDataType](m.TotalRequestCount),
		m.UnauthorizedRequestCount,
		utils.DeepCopy[ServiceCounterDataType](m.ReadCount),
		utils.DeepCopy[ServiceCounterDataType](m.HistoryReadCount),
		utils.DeepCopy[ServiceCounterDataType](m.WriteCount),
		utils.DeepCopy[ServiceCounterDataType](m.HistoryUpdateCount),
		utils.DeepCopy[ServiceCounterDataType](m.CallCount),
		utils.DeepCopy[ServiceCounterDataType](m.CreateMonitoredItemsCount),
		utils.DeepCopy[ServiceCounterDataType](m.ModifyMonitoredItemsCount),
		utils.DeepCopy[ServiceCounterDataType](m.SetMonitoringModeCount),
		utils.DeepCopy[ServiceCounterDataType](m.SetTriggeringCount),
		utils.DeepCopy[ServiceCounterDataType](m.DeleteMonitoredItemsCount),
		utils.DeepCopy[ServiceCounterDataType](m.CreateSubscriptionCount),
		utils.DeepCopy[ServiceCounterDataType](m.ModifySubscriptionCount),
		utils.DeepCopy[ServiceCounterDataType](m.SetPublishingModeCount),
		utils.DeepCopy[ServiceCounterDataType](m.PublishCount),
		utils.DeepCopy[ServiceCounterDataType](m.RepublishCount),
		utils.DeepCopy[ServiceCounterDataType](m.TransferSubscriptionsCount),
		utils.DeepCopy[ServiceCounterDataType](m.DeleteSubscriptionsCount),
		utils.DeepCopy[ServiceCounterDataType](m.AddNodesCount),
		utils.DeepCopy[ServiceCounterDataType](m.AddReferencesCount),
		utils.DeepCopy[ServiceCounterDataType](m.DeleteNodesCount),
		utils.DeepCopy[ServiceCounterDataType](m.DeleteReferencesCount),
		utils.DeepCopy[ServiceCounterDataType](m.BrowseCount),
		utils.DeepCopy[ServiceCounterDataType](m.BrowseNextCount),
		utils.DeepCopy[ServiceCounterDataType](m.TranslateBrowsePathsToNodeIdsCount),
		utils.DeepCopy[ServiceCounterDataType](m.QueryFirstCount),
		utils.DeepCopy[ServiceCounterDataType](m.QueryNextCount),
		utils.DeepCopy[ServiceCounterDataType](m.RegisterNodesCount),
		utils.DeepCopy[ServiceCounterDataType](m.UnregisterNodesCount),
	}
	_SessionDiagnosticsDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _SessionDiagnosticsDataTypeCopy
}

func (m *_SessionDiagnosticsDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
