/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReceiveQosPriorityDataType is the corresponding interface of ReceiveQosPriorityDataType
type ReceiveQosPriorityDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetPriorityLabel returns PriorityLabel (property field)
	GetPriorityLabel() PascalString
	// IsReceiveQosPriorityDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReceiveQosPriorityDataType()
	// CreateBuilder creates a ReceiveQosPriorityDataTypeBuilder
	CreateReceiveQosPriorityDataTypeBuilder() ReceiveQosPriorityDataTypeBuilder
}

// _ReceiveQosPriorityDataType is the data-structure of this message
type _ReceiveQosPriorityDataType struct {
	ExtensionObjectDefinitionContract
	PriorityLabel PascalString
}

var _ ReceiveQosPriorityDataType = (*_ReceiveQosPriorityDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ReceiveQosPriorityDataType)(nil)

// NewReceiveQosPriorityDataType factory function for _ReceiveQosPriorityDataType
func NewReceiveQosPriorityDataType(priorityLabel PascalString) *_ReceiveQosPriorityDataType {
	if priorityLabel == nil {
		panic("priorityLabel of type PascalString for ReceiveQosPriorityDataType must not be nil")
	}
	_result := &_ReceiveQosPriorityDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		PriorityLabel:                     priorityLabel,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReceiveQosPriorityDataTypeBuilder is a builder for ReceiveQosPriorityDataType
type ReceiveQosPriorityDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(priorityLabel PascalString) ReceiveQosPriorityDataTypeBuilder
	// WithPriorityLabel adds PriorityLabel (property field)
	WithPriorityLabel(PascalString) ReceiveQosPriorityDataTypeBuilder
	// WithPriorityLabelBuilder adds PriorityLabel (property field) which is build by the builder
	WithPriorityLabelBuilder(func(PascalStringBuilder) PascalStringBuilder) ReceiveQosPriorityDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ReceiveQosPriorityDataType or returns an error if something is wrong
	Build() (ReceiveQosPriorityDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReceiveQosPriorityDataType
}

// NewReceiveQosPriorityDataTypeBuilder() creates a ReceiveQosPriorityDataTypeBuilder
func NewReceiveQosPriorityDataTypeBuilder() ReceiveQosPriorityDataTypeBuilder {
	return &_ReceiveQosPriorityDataTypeBuilder{_ReceiveQosPriorityDataType: new(_ReceiveQosPriorityDataType)}
}

type _ReceiveQosPriorityDataTypeBuilder struct {
	*_ReceiveQosPriorityDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ReceiveQosPriorityDataTypeBuilder) = (*_ReceiveQosPriorityDataTypeBuilder)(nil)

func (b *_ReceiveQosPriorityDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ReceiveQosPriorityDataType
}

func (b *_ReceiveQosPriorityDataTypeBuilder) WithMandatoryFields(priorityLabel PascalString) ReceiveQosPriorityDataTypeBuilder {
	return b.WithPriorityLabel(priorityLabel)
}

func (b *_ReceiveQosPriorityDataTypeBuilder) WithPriorityLabel(priorityLabel PascalString) ReceiveQosPriorityDataTypeBuilder {
	b.PriorityLabel = priorityLabel
	return b
}

func (b *_ReceiveQosPriorityDataTypeBuilder) WithPriorityLabelBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ReceiveQosPriorityDataTypeBuilder {
	builder := builderSupplier(b.PriorityLabel.CreatePascalStringBuilder())
	var err error
	b.PriorityLabel, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ReceiveQosPriorityDataTypeBuilder) Build() (ReceiveQosPriorityDataType, error) {
	if b.PriorityLabel == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'priorityLabel' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ReceiveQosPriorityDataType.deepCopy(), nil
}

func (b *_ReceiveQosPriorityDataTypeBuilder) MustBuild() ReceiveQosPriorityDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReceiveQosPriorityDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ReceiveQosPriorityDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ReceiveQosPriorityDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateReceiveQosPriorityDataTypeBuilder().(*_ReceiveQosPriorityDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateReceiveQosPriorityDataTypeBuilder creates a ReceiveQosPriorityDataTypeBuilder
func (b *_ReceiveQosPriorityDataType) CreateReceiveQosPriorityDataTypeBuilder() ReceiveQosPriorityDataTypeBuilder {
	if b == nil {
		return NewReceiveQosPriorityDataTypeBuilder()
	}
	return &_ReceiveQosPriorityDataTypeBuilder{_ReceiveQosPriorityDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReceiveQosPriorityDataType) GetExtensionId() int32 {
	return int32(23611)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReceiveQosPriorityDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReceiveQosPriorityDataType) GetPriorityLabel() PascalString {
	return m.PriorityLabel
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReceiveQosPriorityDataType(structType any) ReceiveQosPriorityDataType {
	if casted, ok := structType.(ReceiveQosPriorityDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ReceiveQosPriorityDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ReceiveQosPriorityDataType) GetTypeName() string {
	return "ReceiveQosPriorityDataType"
}

func (m *_ReceiveQosPriorityDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (priorityLabel)
	lengthInBits += m.PriorityLabel.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ReceiveQosPriorityDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ReceiveQosPriorityDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__receiveQosPriorityDataType ReceiveQosPriorityDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReceiveQosPriorityDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReceiveQosPriorityDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	priorityLabel, err := ReadSimpleField[PascalString](ctx, "priorityLabel", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'priorityLabel' field"))
	}
	m.PriorityLabel = priorityLabel

	if closeErr := readBuffer.CloseContext("ReceiveQosPriorityDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReceiveQosPriorityDataType")
	}

	return m, nil
}

func (m *_ReceiveQosPriorityDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReceiveQosPriorityDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReceiveQosPriorityDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReceiveQosPriorityDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "priorityLabel", m.GetPriorityLabel(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'priorityLabel' field")
		}

		if popErr := writeBuffer.PopContext("ReceiveQosPriorityDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReceiveQosPriorityDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReceiveQosPriorityDataType) IsReceiveQosPriorityDataType() {}

func (m *_ReceiveQosPriorityDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReceiveQosPriorityDataType) deepCopy() *_ReceiveQosPriorityDataType {
	if m == nil {
		return nil
	}
	_ReceiveQosPriorityDataTypeCopy := &_ReceiveQosPriorityDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.PriorityLabel),
	}
	_ReceiveQosPriorityDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ReceiveQosPriorityDataTypeCopy
}

func (m *_ReceiveQosPriorityDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
