/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReadRawModifiedDetails is the corresponding interface of ReadRawModifiedDetails
type ReadRawModifiedDetails interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetIsReadModified returns IsReadModified (property field)
	GetIsReadModified() bool
	// GetStartTime returns StartTime (property field)
	GetStartTime() int64
	// GetEndTime returns EndTime (property field)
	GetEndTime() int64
	// GetNumValuesPerNode returns NumValuesPerNode (property field)
	GetNumValuesPerNode() uint32
	// GetReturnBounds returns ReturnBounds (property field)
	GetReturnBounds() bool
	// IsReadRawModifiedDetails is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReadRawModifiedDetails()
	// CreateBuilder creates a ReadRawModifiedDetailsBuilder
	CreateReadRawModifiedDetailsBuilder() ReadRawModifiedDetailsBuilder
}

// _ReadRawModifiedDetails is the data-structure of this message
type _ReadRawModifiedDetails struct {
	ExtensionObjectDefinitionContract
	IsReadModified   bool
	StartTime        int64
	EndTime          int64
	NumValuesPerNode uint32
	ReturnBounds     bool
	// Reserved Fields
	reservedField0 *uint8
	reservedField1 *uint8
}

var _ ReadRawModifiedDetails = (*_ReadRawModifiedDetails)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ReadRawModifiedDetails)(nil)

// NewReadRawModifiedDetails factory function for _ReadRawModifiedDetails
func NewReadRawModifiedDetails(isReadModified bool, startTime int64, endTime int64, numValuesPerNode uint32, returnBounds bool) *_ReadRawModifiedDetails {
	_result := &_ReadRawModifiedDetails{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		IsReadModified:                    isReadModified,
		StartTime:                         startTime,
		EndTime:                           endTime,
		NumValuesPerNode:                  numValuesPerNode,
		ReturnBounds:                      returnBounds,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReadRawModifiedDetailsBuilder is a builder for ReadRawModifiedDetails
type ReadRawModifiedDetailsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(isReadModified bool, startTime int64, endTime int64, numValuesPerNode uint32, returnBounds bool) ReadRawModifiedDetailsBuilder
	// WithIsReadModified adds IsReadModified (property field)
	WithIsReadModified(bool) ReadRawModifiedDetailsBuilder
	// WithStartTime adds StartTime (property field)
	WithStartTime(int64) ReadRawModifiedDetailsBuilder
	// WithEndTime adds EndTime (property field)
	WithEndTime(int64) ReadRawModifiedDetailsBuilder
	// WithNumValuesPerNode adds NumValuesPerNode (property field)
	WithNumValuesPerNode(uint32) ReadRawModifiedDetailsBuilder
	// WithReturnBounds adds ReturnBounds (property field)
	WithReturnBounds(bool) ReadRawModifiedDetailsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ReadRawModifiedDetails or returns an error if something is wrong
	Build() (ReadRawModifiedDetails, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReadRawModifiedDetails
}

// NewReadRawModifiedDetailsBuilder() creates a ReadRawModifiedDetailsBuilder
func NewReadRawModifiedDetailsBuilder() ReadRawModifiedDetailsBuilder {
	return &_ReadRawModifiedDetailsBuilder{_ReadRawModifiedDetails: new(_ReadRawModifiedDetails)}
}

type _ReadRawModifiedDetailsBuilder struct {
	*_ReadRawModifiedDetails

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ReadRawModifiedDetailsBuilder) = (*_ReadRawModifiedDetailsBuilder)(nil)

func (b *_ReadRawModifiedDetailsBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ReadRawModifiedDetails
}

func (b *_ReadRawModifiedDetailsBuilder) WithMandatoryFields(isReadModified bool, startTime int64, endTime int64, numValuesPerNode uint32, returnBounds bool) ReadRawModifiedDetailsBuilder {
	return b.WithIsReadModified(isReadModified).WithStartTime(startTime).WithEndTime(endTime).WithNumValuesPerNode(numValuesPerNode).WithReturnBounds(returnBounds)
}

func (b *_ReadRawModifiedDetailsBuilder) WithIsReadModified(isReadModified bool) ReadRawModifiedDetailsBuilder {
	b.IsReadModified = isReadModified
	return b
}

func (b *_ReadRawModifiedDetailsBuilder) WithStartTime(startTime int64) ReadRawModifiedDetailsBuilder {
	b.StartTime = startTime
	return b
}

func (b *_ReadRawModifiedDetailsBuilder) WithEndTime(endTime int64) ReadRawModifiedDetailsBuilder {
	b.EndTime = endTime
	return b
}

func (b *_ReadRawModifiedDetailsBuilder) WithNumValuesPerNode(numValuesPerNode uint32) ReadRawModifiedDetailsBuilder {
	b.NumValuesPerNode = numValuesPerNode
	return b
}

func (b *_ReadRawModifiedDetailsBuilder) WithReturnBounds(returnBounds bool) ReadRawModifiedDetailsBuilder {
	b.ReturnBounds = returnBounds
	return b
}

func (b *_ReadRawModifiedDetailsBuilder) Build() (ReadRawModifiedDetails, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ReadRawModifiedDetails.deepCopy(), nil
}

func (b *_ReadRawModifiedDetailsBuilder) MustBuild() ReadRawModifiedDetails {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReadRawModifiedDetailsBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ReadRawModifiedDetailsBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ReadRawModifiedDetailsBuilder) DeepCopy() any {
	_copy := b.CreateReadRawModifiedDetailsBuilder().(*_ReadRawModifiedDetailsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateReadRawModifiedDetailsBuilder creates a ReadRawModifiedDetailsBuilder
func (b *_ReadRawModifiedDetails) CreateReadRawModifiedDetailsBuilder() ReadRawModifiedDetailsBuilder {
	if b == nil {
		return NewReadRawModifiedDetailsBuilder()
	}
	return &_ReadRawModifiedDetailsBuilder{_ReadRawModifiedDetails: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReadRawModifiedDetails) GetExtensionId() int32 {
	return int32(649)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReadRawModifiedDetails) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReadRawModifiedDetails) GetIsReadModified() bool {
	return m.IsReadModified
}

func (m *_ReadRawModifiedDetails) GetStartTime() int64 {
	return m.StartTime
}

func (m *_ReadRawModifiedDetails) GetEndTime() int64 {
	return m.EndTime
}

func (m *_ReadRawModifiedDetails) GetNumValuesPerNode() uint32 {
	return m.NumValuesPerNode
}

func (m *_ReadRawModifiedDetails) GetReturnBounds() bool {
	return m.ReturnBounds
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReadRawModifiedDetails(structType any) ReadRawModifiedDetails {
	if casted, ok := structType.(ReadRawModifiedDetails); ok {
		return casted
	}
	if casted, ok := structType.(*ReadRawModifiedDetails); ok {
		return *casted
	}
	return nil
}

func (m *_ReadRawModifiedDetails) GetTypeName() string {
	return "ReadRawModifiedDetails"
}

func (m *_ReadRawModifiedDetails) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (isReadModified)
	lengthInBits += 1

	// Simple field (startTime)
	lengthInBits += 64

	// Simple field (endTime)
	lengthInBits += 64

	// Simple field (numValuesPerNode)
	lengthInBits += 32

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (returnBounds)
	lengthInBits += 1

	return lengthInBits
}

func (m *_ReadRawModifiedDetails) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ReadRawModifiedDetails) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__readRawModifiedDetails ReadRawModifiedDetails, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReadRawModifiedDetails"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReadRawModifiedDetails")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	isReadModified, err := ReadSimpleField(ctx, "isReadModified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isReadModified' field"))
	}
	m.IsReadModified = isReadModified

	startTime, err := ReadSimpleField(ctx, "startTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'startTime' field"))
	}
	m.StartTime = startTime

	endTime, err := ReadSimpleField(ctx, "endTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'endTime' field"))
	}
	m.EndTime = endTime

	numValuesPerNode, err := ReadSimpleField(ctx, "numValuesPerNode", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numValuesPerNode' field"))
	}
	m.NumValuesPerNode = numValuesPerNode

	reservedField1, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField1 = reservedField1

	returnBounds, err := ReadSimpleField(ctx, "returnBounds", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'returnBounds' field"))
	}
	m.ReturnBounds = returnBounds

	if closeErr := readBuffer.CloseContext("ReadRawModifiedDetails"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReadRawModifiedDetails")
	}

	return m, nil
}

func (m *_ReadRawModifiedDetails) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReadRawModifiedDetails) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReadRawModifiedDetails"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReadRawModifiedDetails")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "isReadModified", m.GetIsReadModified(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'isReadModified' field")
		}

		if err := WriteSimpleField[int64](ctx, "startTime", m.GetStartTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'startTime' field")
		}

		if err := WriteSimpleField[int64](ctx, "endTime", m.GetEndTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'endTime' field")
		}

		if err := WriteSimpleField[uint32](ctx, "numValuesPerNode", m.GetNumValuesPerNode(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'numValuesPerNode' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 2")
		}

		if err := WriteSimpleField[bool](ctx, "returnBounds", m.GetReturnBounds(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'returnBounds' field")
		}

		if popErr := writeBuffer.PopContext("ReadRawModifiedDetails"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReadRawModifiedDetails")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReadRawModifiedDetails) IsReadRawModifiedDetails() {}

func (m *_ReadRawModifiedDetails) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReadRawModifiedDetails) deepCopy() *_ReadRawModifiedDetails {
	if m == nil {
		return nil
	}
	_ReadRawModifiedDetailsCopy := &_ReadRawModifiedDetails{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.IsReadModified,
		m.StartTime,
		m.EndTime,
		m.NumValuesPerNode,
		m.ReturnBounds,
		m.reservedField0,
		m.reservedField1,
	}
	_ReadRawModifiedDetailsCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ReadRawModifiedDetailsCopy
}

func (m *_ReadRawModifiedDetails) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
