/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ReadEventDetails is the corresponding interface of ReadEventDetails
type ReadEventDetails interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetNumValuesPerNode returns NumValuesPerNode (property field)
	GetNumValuesPerNode() uint32
	// GetStartTime returns StartTime (property field)
	GetStartTime() int64
	// GetEndTime returns EndTime (property field)
	GetEndTime() int64
	// GetFilter returns Filter (property field)
	GetFilter() EventFilter
	// IsReadEventDetails is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsReadEventDetails()
	// CreateBuilder creates a ReadEventDetailsBuilder
	CreateReadEventDetailsBuilder() ReadEventDetailsBuilder
}

// _ReadEventDetails is the data-structure of this message
type _ReadEventDetails struct {
	ExtensionObjectDefinitionContract
	NumValuesPerNode uint32
	StartTime        int64
	EndTime          int64
	Filter           EventFilter
}

var _ ReadEventDetails = (*_ReadEventDetails)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ReadEventDetails)(nil)

// NewReadEventDetails factory function for _ReadEventDetails
func NewReadEventDetails(numValuesPerNode uint32, startTime int64, endTime int64, filter EventFilter) *_ReadEventDetails {
	if filter == nil {
		panic("filter of type EventFilter for ReadEventDetails must not be nil")
	}
	_result := &_ReadEventDetails{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		NumValuesPerNode:                  numValuesPerNode,
		StartTime:                         startTime,
		EndTime:                           endTime,
		Filter:                            filter,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ReadEventDetailsBuilder is a builder for ReadEventDetails
type ReadEventDetailsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(numValuesPerNode uint32, startTime int64, endTime int64, filter EventFilter) ReadEventDetailsBuilder
	// WithNumValuesPerNode adds NumValuesPerNode (property field)
	WithNumValuesPerNode(uint32) ReadEventDetailsBuilder
	// WithStartTime adds StartTime (property field)
	WithStartTime(int64) ReadEventDetailsBuilder
	// WithEndTime adds EndTime (property field)
	WithEndTime(int64) ReadEventDetailsBuilder
	// WithFilter adds Filter (property field)
	WithFilter(EventFilter) ReadEventDetailsBuilder
	// WithFilterBuilder adds Filter (property field) which is build by the builder
	WithFilterBuilder(func(EventFilterBuilder) EventFilterBuilder) ReadEventDetailsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ReadEventDetails or returns an error if something is wrong
	Build() (ReadEventDetails, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ReadEventDetails
}

// NewReadEventDetailsBuilder() creates a ReadEventDetailsBuilder
func NewReadEventDetailsBuilder() ReadEventDetailsBuilder {
	return &_ReadEventDetailsBuilder{_ReadEventDetails: new(_ReadEventDetails)}
}

type _ReadEventDetailsBuilder struct {
	*_ReadEventDetails

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ReadEventDetailsBuilder) = (*_ReadEventDetailsBuilder)(nil)

func (b *_ReadEventDetailsBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ReadEventDetails
}

func (b *_ReadEventDetailsBuilder) WithMandatoryFields(numValuesPerNode uint32, startTime int64, endTime int64, filter EventFilter) ReadEventDetailsBuilder {
	return b.WithNumValuesPerNode(numValuesPerNode).WithStartTime(startTime).WithEndTime(endTime).WithFilter(filter)
}

func (b *_ReadEventDetailsBuilder) WithNumValuesPerNode(numValuesPerNode uint32) ReadEventDetailsBuilder {
	b.NumValuesPerNode = numValuesPerNode
	return b
}

func (b *_ReadEventDetailsBuilder) WithStartTime(startTime int64) ReadEventDetailsBuilder {
	b.StartTime = startTime
	return b
}

func (b *_ReadEventDetailsBuilder) WithEndTime(endTime int64) ReadEventDetailsBuilder {
	b.EndTime = endTime
	return b
}

func (b *_ReadEventDetailsBuilder) WithFilter(filter EventFilter) ReadEventDetailsBuilder {
	b.Filter = filter
	return b
}

func (b *_ReadEventDetailsBuilder) WithFilterBuilder(builderSupplier func(EventFilterBuilder) EventFilterBuilder) ReadEventDetailsBuilder {
	builder := builderSupplier(b.Filter.CreateEventFilterBuilder())
	var err error
	b.Filter, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "EventFilterBuilder failed"))
	}
	return b
}

func (b *_ReadEventDetailsBuilder) Build() (ReadEventDetails, error) {
	if b.Filter == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'filter' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ReadEventDetails.deepCopy(), nil
}

func (b *_ReadEventDetailsBuilder) MustBuild() ReadEventDetails {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ReadEventDetailsBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ReadEventDetailsBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ReadEventDetailsBuilder) DeepCopy() any {
	_copy := b.CreateReadEventDetailsBuilder().(*_ReadEventDetailsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateReadEventDetailsBuilder creates a ReadEventDetailsBuilder
func (b *_ReadEventDetails) CreateReadEventDetailsBuilder() ReadEventDetailsBuilder {
	if b == nil {
		return NewReadEventDetailsBuilder()
	}
	return &_ReadEventDetailsBuilder{_ReadEventDetails: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ReadEventDetails) GetExtensionId() int32 {
	return int32(646)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ReadEventDetails) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ReadEventDetails) GetNumValuesPerNode() uint32 {
	return m.NumValuesPerNode
}

func (m *_ReadEventDetails) GetStartTime() int64 {
	return m.StartTime
}

func (m *_ReadEventDetails) GetEndTime() int64 {
	return m.EndTime
}

func (m *_ReadEventDetails) GetFilter() EventFilter {
	return m.Filter
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastReadEventDetails(structType any) ReadEventDetails {
	if casted, ok := structType.(ReadEventDetails); ok {
		return casted
	}
	if casted, ok := structType.(*ReadEventDetails); ok {
		return *casted
	}
	return nil
}

func (m *_ReadEventDetails) GetTypeName() string {
	return "ReadEventDetails"
}

func (m *_ReadEventDetails) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (numValuesPerNode)
	lengthInBits += 32

	// Simple field (startTime)
	lengthInBits += 64

	// Simple field (endTime)
	lengthInBits += 64

	// Simple field (filter)
	lengthInBits += m.Filter.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ReadEventDetails) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ReadEventDetails) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__readEventDetails ReadEventDetails, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ReadEventDetails"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ReadEventDetails")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	numValuesPerNode, err := ReadSimpleField(ctx, "numValuesPerNode", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numValuesPerNode' field"))
	}
	m.NumValuesPerNode = numValuesPerNode

	startTime, err := ReadSimpleField(ctx, "startTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'startTime' field"))
	}
	m.StartTime = startTime

	endTime, err := ReadSimpleField(ctx, "endTime", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'endTime' field"))
	}
	m.EndTime = endTime

	filter, err := ReadSimpleField[EventFilter](ctx, "filter", ReadComplex[EventFilter](ExtensionObjectDefinitionParseWithBufferProducer[EventFilter]((int32)(int32(727))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'filter' field"))
	}
	m.Filter = filter

	if closeErr := readBuffer.CloseContext("ReadEventDetails"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ReadEventDetails")
	}

	return m, nil
}

func (m *_ReadEventDetails) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ReadEventDetails) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ReadEventDetails"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ReadEventDetails")
		}

		if err := WriteSimpleField[uint32](ctx, "numValuesPerNode", m.GetNumValuesPerNode(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'numValuesPerNode' field")
		}

		if err := WriteSimpleField[int64](ctx, "startTime", m.GetStartTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'startTime' field")
		}

		if err := WriteSimpleField[int64](ctx, "endTime", m.GetEndTime(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'endTime' field")
		}

		if err := WriteSimpleField[EventFilter](ctx, "filter", m.GetFilter(), WriteComplex[EventFilter](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'filter' field")
		}

		if popErr := writeBuffer.PopContext("ReadEventDetails"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ReadEventDetails")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ReadEventDetails) IsReadEventDetails() {}

func (m *_ReadEventDetails) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ReadEventDetails) deepCopy() *_ReadEventDetails {
	if m == nil {
		return nil
	}
	_ReadEventDetailsCopy := &_ReadEventDetails{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.NumValuesPerNode,
		m.StartTime,
		m.EndTime,
		utils.DeepCopy[EventFilter](m.Filter),
	}
	_ReadEventDetailsCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ReadEventDetailsCopy
}

func (m *_ReadEventDetails) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
