/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// QueryFirstResponse is the corresponding interface of QueryFirstResponse
type QueryFirstResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetResponseHeader returns ResponseHeader (property field)
	GetResponseHeader() ResponseHeader
	// GetQueryDataSets returns QueryDataSets (property field)
	GetQueryDataSets() []QueryDataSet
	// GetContinuationPoint returns ContinuationPoint (property field)
	GetContinuationPoint() PascalByteString
	// GetParsingResults returns ParsingResults (property field)
	GetParsingResults() []ParsingResult
	// GetDiagnosticInfos returns DiagnosticInfos (property field)
	GetDiagnosticInfos() []DiagnosticInfo
	// GetFilterResult returns FilterResult (property field)
	GetFilterResult() ContentFilterResult
	// IsQueryFirstResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsQueryFirstResponse()
	// CreateBuilder creates a QueryFirstResponseBuilder
	CreateQueryFirstResponseBuilder() QueryFirstResponseBuilder
}

// _QueryFirstResponse is the data-structure of this message
type _QueryFirstResponse struct {
	ExtensionObjectDefinitionContract
	ResponseHeader    ResponseHeader
	QueryDataSets     []QueryDataSet
	ContinuationPoint PascalByteString
	ParsingResults    []ParsingResult
	DiagnosticInfos   []DiagnosticInfo
	FilterResult      ContentFilterResult
}

var _ QueryFirstResponse = (*_QueryFirstResponse)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_QueryFirstResponse)(nil)

// NewQueryFirstResponse factory function for _QueryFirstResponse
func NewQueryFirstResponse(responseHeader ResponseHeader, queryDataSets []QueryDataSet, continuationPoint PascalByteString, parsingResults []ParsingResult, diagnosticInfos []DiagnosticInfo, filterResult ContentFilterResult) *_QueryFirstResponse {
	if responseHeader == nil {
		panic("responseHeader of type ResponseHeader for QueryFirstResponse must not be nil")
	}
	if continuationPoint == nil {
		panic("continuationPoint of type PascalByteString for QueryFirstResponse must not be nil")
	}
	if filterResult == nil {
		panic("filterResult of type ContentFilterResult for QueryFirstResponse must not be nil")
	}
	_result := &_QueryFirstResponse{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ResponseHeader:                    responseHeader,
		QueryDataSets:                     queryDataSets,
		ContinuationPoint:                 continuationPoint,
		ParsingResults:                    parsingResults,
		DiagnosticInfos:                   diagnosticInfos,
		FilterResult:                      filterResult,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// QueryFirstResponseBuilder is a builder for QueryFirstResponse
type QueryFirstResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(responseHeader ResponseHeader, queryDataSets []QueryDataSet, continuationPoint PascalByteString, parsingResults []ParsingResult, diagnosticInfos []DiagnosticInfo, filterResult ContentFilterResult) QueryFirstResponseBuilder
	// WithResponseHeader adds ResponseHeader (property field)
	WithResponseHeader(ResponseHeader) QueryFirstResponseBuilder
	// WithResponseHeaderBuilder adds ResponseHeader (property field) which is build by the builder
	WithResponseHeaderBuilder(func(ResponseHeaderBuilder) ResponseHeaderBuilder) QueryFirstResponseBuilder
	// WithQueryDataSets adds QueryDataSets (property field)
	WithQueryDataSets(...QueryDataSet) QueryFirstResponseBuilder
	// WithContinuationPoint adds ContinuationPoint (property field)
	WithContinuationPoint(PascalByteString) QueryFirstResponseBuilder
	// WithContinuationPointBuilder adds ContinuationPoint (property field) which is build by the builder
	WithContinuationPointBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) QueryFirstResponseBuilder
	// WithParsingResults adds ParsingResults (property field)
	WithParsingResults(...ParsingResult) QueryFirstResponseBuilder
	// WithDiagnosticInfos adds DiagnosticInfos (property field)
	WithDiagnosticInfos(...DiagnosticInfo) QueryFirstResponseBuilder
	// WithFilterResult adds FilterResult (property field)
	WithFilterResult(ContentFilterResult) QueryFirstResponseBuilder
	// WithFilterResultBuilder adds FilterResult (property field) which is build by the builder
	WithFilterResultBuilder(func(ContentFilterResultBuilder) ContentFilterResultBuilder) QueryFirstResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the QueryFirstResponse or returns an error if something is wrong
	Build() (QueryFirstResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() QueryFirstResponse
}

// NewQueryFirstResponseBuilder() creates a QueryFirstResponseBuilder
func NewQueryFirstResponseBuilder() QueryFirstResponseBuilder {
	return &_QueryFirstResponseBuilder{_QueryFirstResponse: new(_QueryFirstResponse)}
}

type _QueryFirstResponseBuilder struct {
	*_QueryFirstResponse

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (QueryFirstResponseBuilder) = (*_QueryFirstResponseBuilder)(nil)

func (b *_QueryFirstResponseBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._QueryFirstResponse
}

func (b *_QueryFirstResponseBuilder) WithMandatoryFields(responseHeader ResponseHeader, queryDataSets []QueryDataSet, continuationPoint PascalByteString, parsingResults []ParsingResult, diagnosticInfos []DiagnosticInfo, filterResult ContentFilterResult) QueryFirstResponseBuilder {
	return b.WithResponseHeader(responseHeader).WithQueryDataSets(queryDataSets...).WithContinuationPoint(continuationPoint).WithParsingResults(parsingResults...).WithDiagnosticInfos(diagnosticInfos...).WithFilterResult(filterResult)
}

func (b *_QueryFirstResponseBuilder) WithResponseHeader(responseHeader ResponseHeader) QueryFirstResponseBuilder {
	b.ResponseHeader = responseHeader
	return b
}

func (b *_QueryFirstResponseBuilder) WithResponseHeaderBuilder(builderSupplier func(ResponseHeaderBuilder) ResponseHeaderBuilder) QueryFirstResponseBuilder {
	builder := builderSupplier(b.ResponseHeader.CreateResponseHeaderBuilder())
	var err error
	b.ResponseHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ResponseHeaderBuilder failed"))
	}
	return b
}

func (b *_QueryFirstResponseBuilder) WithQueryDataSets(queryDataSets ...QueryDataSet) QueryFirstResponseBuilder {
	b.QueryDataSets = queryDataSets
	return b
}

func (b *_QueryFirstResponseBuilder) WithContinuationPoint(continuationPoint PascalByteString) QueryFirstResponseBuilder {
	b.ContinuationPoint = continuationPoint
	return b
}

func (b *_QueryFirstResponseBuilder) WithContinuationPointBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) QueryFirstResponseBuilder {
	builder := builderSupplier(b.ContinuationPoint.CreatePascalByteStringBuilder())
	var err error
	b.ContinuationPoint, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_QueryFirstResponseBuilder) WithParsingResults(parsingResults ...ParsingResult) QueryFirstResponseBuilder {
	b.ParsingResults = parsingResults
	return b
}

func (b *_QueryFirstResponseBuilder) WithDiagnosticInfos(diagnosticInfos ...DiagnosticInfo) QueryFirstResponseBuilder {
	b.DiagnosticInfos = diagnosticInfos
	return b
}

func (b *_QueryFirstResponseBuilder) WithFilterResult(filterResult ContentFilterResult) QueryFirstResponseBuilder {
	b.FilterResult = filterResult
	return b
}

func (b *_QueryFirstResponseBuilder) WithFilterResultBuilder(builderSupplier func(ContentFilterResultBuilder) ContentFilterResultBuilder) QueryFirstResponseBuilder {
	builder := builderSupplier(b.FilterResult.CreateContentFilterResultBuilder())
	var err error
	b.FilterResult, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ContentFilterResultBuilder failed"))
	}
	return b
}

func (b *_QueryFirstResponseBuilder) Build() (QueryFirstResponse, error) {
	if b.ResponseHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'responseHeader' not set"))
	}
	if b.ContinuationPoint == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'continuationPoint' not set"))
	}
	if b.FilterResult == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'filterResult' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._QueryFirstResponse.deepCopy(), nil
}

func (b *_QueryFirstResponseBuilder) MustBuild() QueryFirstResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_QueryFirstResponseBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_QueryFirstResponseBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_QueryFirstResponseBuilder) DeepCopy() any {
	_copy := b.CreateQueryFirstResponseBuilder().(*_QueryFirstResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateQueryFirstResponseBuilder creates a QueryFirstResponseBuilder
func (b *_QueryFirstResponse) CreateQueryFirstResponseBuilder() QueryFirstResponseBuilder {
	if b == nil {
		return NewQueryFirstResponseBuilder()
	}
	return &_QueryFirstResponseBuilder{_QueryFirstResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_QueryFirstResponse) GetExtensionId() int32 {
	return int32(618)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_QueryFirstResponse) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_QueryFirstResponse) GetResponseHeader() ResponseHeader {
	return m.ResponseHeader
}

func (m *_QueryFirstResponse) GetQueryDataSets() []QueryDataSet {
	return m.QueryDataSets
}

func (m *_QueryFirstResponse) GetContinuationPoint() PascalByteString {
	return m.ContinuationPoint
}

func (m *_QueryFirstResponse) GetParsingResults() []ParsingResult {
	return m.ParsingResults
}

func (m *_QueryFirstResponse) GetDiagnosticInfos() []DiagnosticInfo {
	return m.DiagnosticInfos
}

func (m *_QueryFirstResponse) GetFilterResult() ContentFilterResult {
	return m.FilterResult
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastQueryFirstResponse(structType any) QueryFirstResponse {
	if casted, ok := structType.(QueryFirstResponse); ok {
		return casted
	}
	if casted, ok := structType.(*QueryFirstResponse); ok {
		return *casted
	}
	return nil
}

func (m *_QueryFirstResponse) GetTypeName() string {
	return "QueryFirstResponse"
}

func (m *_QueryFirstResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (responseHeader)
	lengthInBits += m.ResponseHeader.GetLengthInBits(ctx)

	// Implicit Field (noOfQueryDataSets)
	lengthInBits += 32

	// Array field
	if len(m.QueryDataSets) > 0 {
		for _curItem, element := range m.QueryDataSets {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.QueryDataSets), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (continuationPoint)
	lengthInBits += m.ContinuationPoint.GetLengthInBits(ctx)

	// Implicit Field (noOfParsingResults)
	lengthInBits += 32

	// Array field
	if len(m.ParsingResults) > 0 {
		for _curItem, element := range m.ParsingResults {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ParsingResults), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfDiagnosticInfos)
	lengthInBits += 32

	// Array field
	if len(m.DiagnosticInfos) > 0 {
		for _curItem, element := range m.DiagnosticInfos {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DiagnosticInfos), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (filterResult)
	lengthInBits += m.FilterResult.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_QueryFirstResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_QueryFirstResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__queryFirstResponse QueryFirstResponse, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("QueryFirstResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for QueryFirstResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	responseHeader, err := ReadSimpleField[ResponseHeader](ctx, "responseHeader", ReadComplex[ResponseHeader](ExtensionObjectDefinitionParseWithBufferProducer[ResponseHeader]((int32)(int32(394))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'responseHeader' field"))
	}
	m.ResponseHeader = responseHeader

	noOfQueryDataSets, err := ReadImplicitField[int32](ctx, "noOfQueryDataSets", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfQueryDataSets' field"))
	}
	_ = noOfQueryDataSets

	queryDataSets, err := ReadCountArrayField[QueryDataSet](ctx, "queryDataSets", ReadComplex[QueryDataSet](ExtensionObjectDefinitionParseWithBufferProducer[QueryDataSet]((int32)(int32(579))), readBuffer), uint64(noOfQueryDataSets))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'queryDataSets' field"))
	}
	m.QueryDataSets = queryDataSets

	continuationPoint, err := ReadSimpleField[PascalByteString](ctx, "continuationPoint", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'continuationPoint' field"))
	}
	m.ContinuationPoint = continuationPoint

	noOfParsingResults, err := ReadImplicitField[int32](ctx, "noOfParsingResults", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfParsingResults' field"))
	}
	_ = noOfParsingResults

	parsingResults, err := ReadCountArrayField[ParsingResult](ctx, "parsingResults", ReadComplex[ParsingResult](ExtensionObjectDefinitionParseWithBufferProducer[ParsingResult]((int32)(int32(612))), readBuffer), uint64(noOfParsingResults))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'parsingResults' field"))
	}
	m.ParsingResults = parsingResults

	noOfDiagnosticInfos, err := ReadImplicitField[int32](ctx, "noOfDiagnosticInfos", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfDiagnosticInfos' field"))
	}
	_ = noOfDiagnosticInfos

	diagnosticInfos, err := ReadCountArrayField[DiagnosticInfo](ctx, "diagnosticInfos", ReadComplex[DiagnosticInfo](DiagnosticInfoParseWithBuffer, readBuffer), uint64(noOfDiagnosticInfos))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'diagnosticInfos' field"))
	}
	m.DiagnosticInfos = diagnosticInfos

	filterResult, err := ReadSimpleField[ContentFilterResult](ctx, "filterResult", ReadComplex[ContentFilterResult](ExtensionObjectDefinitionParseWithBufferProducer[ContentFilterResult]((int32)(int32(609))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'filterResult' field"))
	}
	m.FilterResult = filterResult

	if closeErr := readBuffer.CloseContext("QueryFirstResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for QueryFirstResponse")
	}

	return m, nil
}

func (m *_QueryFirstResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_QueryFirstResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("QueryFirstResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for QueryFirstResponse")
		}

		if err := WriteSimpleField[ResponseHeader](ctx, "responseHeader", m.GetResponseHeader(), WriteComplex[ResponseHeader](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'responseHeader' field")
		}
		noOfQueryDataSets := int32(utils.InlineIf(bool((m.GetQueryDataSets()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetQueryDataSets()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfQueryDataSets", noOfQueryDataSets, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfQueryDataSets' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "queryDataSets", m.GetQueryDataSets(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'queryDataSets' field")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "continuationPoint", m.GetContinuationPoint(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'continuationPoint' field")
		}
		noOfParsingResults := int32(utils.InlineIf(bool((m.GetParsingResults()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetParsingResults()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfParsingResults", noOfParsingResults, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfParsingResults' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "parsingResults", m.GetParsingResults(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'parsingResults' field")
		}
		noOfDiagnosticInfos := int32(utils.InlineIf(bool((m.GetDiagnosticInfos()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetDiagnosticInfos()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfDiagnosticInfos", noOfDiagnosticInfos, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfDiagnosticInfos' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "diagnosticInfos", m.GetDiagnosticInfos(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'diagnosticInfos' field")
		}

		if err := WriteSimpleField[ContentFilterResult](ctx, "filterResult", m.GetFilterResult(), WriteComplex[ContentFilterResult](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'filterResult' field")
		}

		if popErr := writeBuffer.PopContext("QueryFirstResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for QueryFirstResponse")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_QueryFirstResponse) IsQueryFirstResponse() {}

func (m *_QueryFirstResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_QueryFirstResponse) deepCopy() *_QueryFirstResponse {
	if m == nil {
		return nil
	}
	_QueryFirstResponseCopy := &_QueryFirstResponse{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[ResponseHeader](m.ResponseHeader),
		utils.DeepCopySlice[QueryDataSet, QueryDataSet](m.QueryDataSets),
		utils.DeepCopy[PascalByteString](m.ContinuationPoint),
		utils.DeepCopySlice[ParsingResult, ParsingResult](m.ParsingResults),
		utils.DeepCopySlice[DiagnosticInfo, DiagnosticInfo](m.DiagnosticInfos),
		utils.DeepCopy[ContentFilterResult](m.FilterResult),
	}
	_QueryFirstResponseCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _QueryFirstResponseCopy
}

func (m *_QueryFirstResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
