/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// QueryDataDescription is the corresponding interface of QueryDataDescription
type QueryDataDescription interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetRelativePath returns RelativePath (property field)
	GetRelativePath() RelativePath
	// GetAttributeId returns AttributeId (property field)
	GetAttributeId() uint32
	// GetIndexRange returns IndexRange (property field)
	GetIndexRange() PascalString
	// IsQueryDataDescription is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsQueryDataDescription()
	// CreateBuilder creates a QueryDataDescriptionBuilder
	CreateQueryDataDescriptionBuilder() QueryDataDescriptionBuilder
}

// _QueryDataDescription is the data-structure of this message
type _QueryDataDescription struct {
	ExtensionObjectDefinitionContract
	RelativePath RelativePath
	AttributeId  uint32
	IndexRange   PascalString
}

var _ QueryDataDescription = (*_QueryDataDescription)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_QueryDataDescription)(nil)

// NewQueryDataDescription factory function for _QueryDataDescription
func NewQueryDataDescription(relativePath RelativePath, attributeId uint32, indexRange PascalString) *_QueryDataDescription {
	if relativePath == nil {
		panic("relativePath of type RelativePath for QueryDataDescription must not be nil")
	}
	if indexRange == nil {
		panic("indexRange of type PascalString for QueryDataDescription must not be nil")
	}
	_result := &_QueryDataDescription{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		RelativePath:                      relativePath,
		AttributeId:                       attributeId,
		IndexRange:                        indexRange,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// QueryDataDescriptionBuilder is a builder for QueryDataDescription
type QueryDataDescriptionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(relativePath RelativePath, attributeId uint32, indexRange PascalString) QueryDataDescriptionBuilder
	// WithRelativePath adds RelativePath (property field)
	WithRelativePath(RelativePath) QueryDataDescriptionBuilder
	// WithRelativePathBuilder adds RelativePath (property field) which is build by the builder
	WithRelativePathBuilder(func(RelativePathBuilder) RelativePathBuilder) QueryDataDescriptionBuilder
	// WithAttributeId adds AttributeId (property field)
	WithAttributeId(uint32) QueryDataDescriptionBuilder
	// WithIndexRange adds IndexRange (property field)
	WithIndexRange(PascalString) QueryDataDescriptionBuilder
	// WithIndexRangeBuilder adds IndexRange (property field) which is build by the builder
	WithIndexRangeBuilder(func(PascalStringBuilder) PascalStringBuilder) QueryDataDescriptionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the QueryDataDescription or returns an error if something is wrong
	Build() (QueryDataDescription, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() QueryDataDescription
}

// NewQueryDataDescriptionBuilder() creates a QueryDataDescriptionBuilder
func NewQueryDataDescriptionBuilder() QueryDataDescriptionBuilder {
	return &_QueryDataDescriptionBuilder{_QueryDataDescription: new(_QueryDataDescription)}
}

type _QueryDataDescriptionBuilder struct {
	*_QueryDataDescription

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (QueryDataDescriptionBuilder) = (*_QueryDataDescriptionBuilder)(nil)

func (b *_QueryDataDescriptionBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._QueryDataDescription
}

func (b *_QueryDataDescriptionBuilder) WithMandatoryFields(relativePath RelativePath, attributeId uint32, indexRange PascalString) QueryDataDescriptionBuilder {
	return b.WithRelativePath(relativePath).WithAttributeId(attributeId).WithIndexRange(indexRange)
}

func (b *_QueryDataDescriptionBuilder) WithRelativePath(relativePath RelativePath) QueryDataDescriptionBuilder {
	b.RelativePath = relativePath
	return b
}

func (b *_QueryDataDescriptionBuilder) WithRelativePathBuilder(builderSupplier func(RelativePathBuilder) RelativePathBuilder) QueryDataDescriptionBuilder {
	builder := builderSupplier(b.RelativePath.CreateRelativePathBuilder())
	var err error
	b.RelativePath, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "RelativePathBuilder failed"))
	}
	return b
}

func (b *_QueryDataDescriptionBuilder) WithAttributeId(attributeId uint32) QueryDataDescriptionBuilder {
	b.AttributeId = attributeId
	return b
}

func (b *_QueryDataDescriptionBuilder) WithIndexRange(indexRange PascalString) QueryDataDescriptionBuilder {
	b.IndexRange = indexRange
	return b
}

func (b *_QueryDataDescriptionBuilder) WithIndexRangeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) QueryDataDescriptionBuilder {
	builder := builderSupplier(b.IndexRange.CreatePascalStringBuilder())
	var err error
	b.IndexRange, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_QueryDataDescriptionBuilder) Build() (QueryDataDescription, error) {
	if b.RelativePath == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'relativePath' not set"))
	}
	if b.IndexRange == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'indexRange' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._QueryDataDescription.deepCopy(), nil
}

func (b *_QueryDataDescriptionBuilder) MustBuild() QueryDataDescription {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_QueryDataDescriptionBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_QueryDataDescriptionBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_QueryDataDescriptionBuilder) DeepCopy() any {
	_copy := b.CreateQueryDataDescriptionBuilder().(*_QueryDataDescriptionBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateQueryDataDescriptionBuilder creates a QueryDataDescriptionBuilder
func (b *_QueryDataDescription) CreateQueryDataDescriptionBuilder() QueryDataDescriptionBuilder {
	if b == nil {
		return NewQueryDataDescriptionBuilder()
	}
	return &_QueryDataDescriptionBuilder{_QueryDataDescription: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_QueryDataDescription) GetExtensionId() int32 {
	return int32(572)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_QueryDataDescription) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_QueryDataDescription) GetRelativePath() RelativePath {
	return m.RelativePath
}

func (m *_QueryDataDescription) GetAttributeId() uint32 {
	return m.AttributeId
}

func (m *_QueryDataDescription) GetIndexRange() PascalString {
	return m.IndexRange
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastQueryDataDescription(structType any) QueryDataDescription {
	if casted, ok := structType.(QueryDataDescription); ok {
		return casted
	}
	if casted, ok := structType.(*QueryDataDescription); ok {
		return *casted
	}
	return nil
}

func (m *_QueryDataDescription) GetTypeName() string {
	return "QueryDataDescription"
}

func (m *_QueryDataDescription) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (relativePath)
	lengthInBits += m.RelativePath.GetLengthInBits(ctx)

	// Simple field (attributeId)
	lengthInBits += 32

	// Simple field (indexRange)
	lengthInBits += m.IndexRange.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_QueryDataDescription) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_QueryDataDescription) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__queryDataDescription QueryDataDescription, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("QueryDataDescription"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for QueryDataDescription")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	relativePath, err := ReadSimpleField[RelativePath](ctx, "relativePath", ReadComplex[RelativePath](ExtensionObjectDefinitionParseWithBufferProducer[RelativePath]((int32)(int32(542))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'relativePath' field"))
	}
	m.RelativePath = relativePath

	attributeId, err := ReadSimpleField(ctx, "attributeId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'attributeId' field"))
	}
	m.AttributeId = attributeId

	indexRange, err := ReadSimpleField[PascalString](ctx, "indexRange", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'indexRange' field"))
	}
	m.IndexRange = indexRange

	if closeErr := readBuffer.CloseContext("QueryDataDescription"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for QueryDataDescription")
	}

	return m, nil
}

func (m *_QueryDataDescription) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_QueryDataDescription) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("QueryDataDescription"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for QueryDataDescription")
		}

		if err := WriteSimpleField[RelativePath](ctx, "relativePath", m.GetRelativePath(), WriteComplex[RelativePath](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'relativePath' field")
		}

		if err := WriteSimpleField[uint32](ctx, "attributeId", m.GetAttributeId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'attributeId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "indexRange", m.GetIndexRange(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'indexRange' field")
		}

		if popErr := writeBuffer.PopContext("QueryDataDescription"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for QueryDataDescription")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_QueryDataDescription) IsQueryDataDescription() {}

func (m *_QueryDataDescription) DeepCopy() any {
	return m.deepCopy()
}

func (m *_QueryDataDescription) deepCopy() *_QueryDataDescription {
	if m == nil {
		return nil
	}
	_QueryDataDescriptionCopy := &_QueryDataDescription{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[RelativePath](m.RelativePath),
		m.AttributeId,
		utils.DeepCopy[PascalString](m.IndexRange),
	}
	_QueryDataDescriptionCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _QueryDataDescriptionCopy
}

func (m *_QueryDataDescription) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
