/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesObject is an enum
type OpcuaNodeIdServicesObject int32

type IOpcuaNodeIdServicesObject interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesObject_ModellingRule_Mandatory                                                                                                                   OpcuaNodeIdServicesObject = 78
	OpcuaNodeIdServicesObject_ModellingRule_Optional                                                                                                                    OpcuaNodeIdServicesObject = 80
	OpcuaNodeIdServicesObject_ModellingRule_ExposesItsArray                                                                                                             OpcuaNodeIdServicesObject = 83
	OpcuaNodeIdServicesObject_RootFolder                                                                                                                                OpcuaNodeIdServicesObject = 84
	OpcuaNodeIdServicesObject_ObjectsFolder                                                                                                                             OpcuaNodeIdServicesObject = 85
	OpcuaNodeIdServicesObject_TypesFolder                                                                                                                               OpcuaNodeIdServicesObject = 86
	OpcuaNodeIdServicesObject_ViewsFolder                                                                                                                               OpcuaNodeIdServicesObject = 87
	OpcuaNodeIdServicesObject_ObjectTypesFolder                                                                                                                         OpcuaNodeIdServicesObject = 88
	OpcuaNodeIdServicesObject_VariableTypesFolder                                                                                                                       OpcuaNodeIdServicesObject = 89
	OpcuaNodeIdServicesObject_DataTypesFolder                                                                                                                           OpcuaNodeIdServicesObject = 90
	OpcuaNodeIdServicesObject_ReferenceTypesFolder                                                                                                                      OpcuaNodeIdServicesObject = 91
	OpcuaNodeIdServicesObject_XmlSchema_TypeSystem                                                                                                                      OpcuaNodeIdServicesObject = 92
	OpcuaNodeIdServicesObject_OPCBinarySchema_TypeSystem                                                                                                                OpcuaNodeIdServicesObject = 93
	OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 121
	OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 122
	OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 123
	OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 124
	OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 125
	OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 126
	OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 127
	OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 128
	OpcuaNodeIdServicesObject_Node_Encoding_DefaultXml                                                                                                                  OpcuaNodeIdServicesObject = 259
	OpcuaNodeIdServicesObject_Node_Encoding_DefaultBinary                                                                                                               OpcuaNodeIdServicesObject = 260
	OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultXml                                                                                                            OpcuaNodeIdServicesObject = 262
	OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultBinary                                                                                                         OpcuaNodeIdServicesObject = 263
	OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 265
	OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 266
	OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 268
	OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 269
	OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 271
	OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 272
	OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 274
	OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 275
	OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultXml                                                                                                            OpcuaNodeIdServicesObject = 277
	OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultBinary                                                                                                         OpcuaNodeIdServicesObject = 278
	OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultXml                                                                                                              OpcuaNodeIdServicesObject = 280
	OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultBinary                                                                                                           OpcuaNodeIdServicesObject = 281
	OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 283
	OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 284
	OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 286
	OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 287
	OpcuaNodeIdServicesObject_Argument_Encoding_DefaultXml                                                                                                              OpcuaNodeIdServicesObject = 297
	OpcuaNodeIdServicesObject_Argument_Encoding_DefaultBinary                                                                                                           OpcuaNodeIdServicesObject = 298
	OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 300
	OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 301
	OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 305
	OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 306
	OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 309
	OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 310
	OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 313
	OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 314
	OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 317
	OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 318
	OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 320
	OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 321
	OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 323
	OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 324
	OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 326
	OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 327
	OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 332
	OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 333
	OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultXml                                                                                                             OpcuaNodeIdServicesObject = 339
	OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultBinary                                                                                                          OpcuaNodeIdServicesObject = 340
	OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 345
	OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 346
	OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 350
	OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 351
	OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 353
	OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 354
	OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 356
	OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 357
	OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 359
	OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 360
	OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 362
	OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 363
	OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 365
	OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 366
	OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 368
	OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 369
	OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 371
	OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 372
	OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 374
	OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 375
	OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 377
	OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 378
	OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 380
	OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 381
	OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 383
	OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 384
	OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 386
	OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 387
	OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 390
	OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 391
	OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 393
	OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 394
	OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 396
	OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 397
	OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 421
	OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 422
	OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 424
	OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 425
	OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 427
	OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 428
	OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 430
	OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 431
	OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 433
	OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 434
	OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 436
	OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 437
	OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 439
	OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 440
	OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 442
	OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 443
	OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 445
	OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 446
	OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 448
	OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 449
	OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 451
	OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 452
	OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 454
	OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 455
	OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 457
	OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 458
	OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 460
	OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 461
	OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 463
	OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 464
	OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 466
	OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 467
	OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 469
	OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 470
	OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 472
	OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 473
	OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 475
	OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 476
	OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 478
	OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 479
	OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 481
	OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 482
	OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 484
	OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 485
	OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 487
	OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 488
	OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 490
	OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 491
	OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 493
	OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 494
	OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 496
	OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 497
	OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 499
	OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 500
	OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 502
	OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 503
	OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 505
	OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 506
	OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 508
	OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 509
	OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 512
	OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 513
	OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 515
	OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 516
	OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 519
	OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 520
	OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 523
	OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 524
	OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 526
	OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 527
	OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 529
	OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 530
	OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 532
	OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 533
	OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 535
	OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 536
	OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 538
	OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 539
	OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 541
	OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 542
	OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultXml                                                                                                            OpcuaNodeIdServicesObject = 544
	OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultBinary                                                                                                         OpcuaNodeIdServicesObject = 545
	OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 547
	OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 548
	OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 550
	OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 551
	OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml                                                                                  OpcuaNodeIdServicesObject = 553
	OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary                                                                               OpcuaNodeIdServicesObject = 554
	OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml                                                                                 OpcuaNodeIdServicesObject = 556
	OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary                                                                              OpcuaNodeIdServicesObject = 557
	OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 559
	OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 560
	OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 562
	OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 563
	OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 565
	OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 566
	OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 568
	OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 569
	OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 571
	OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 572
	OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 574
	OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 575
	OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 578
	OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 579
	OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 581
	OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 582
	OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 584
	OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 585
	OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 587
	OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 588
	OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 590
	OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 591
	OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 593
	OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 594
	OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 596
	OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 597
	OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 599
	OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 600
	OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 602
	OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 603
	OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 605
	OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 606
	OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 608
	OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 609
	OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 611
	OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 612
	OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 614
	OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 615
	OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 617
	OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 618
	OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 620
	OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 621
	OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 623
	OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 624
	OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 627
	OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 628
	OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 630
	OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 631
	OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 633
	OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 634
	OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 636
	OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 637
	OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 639
	OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 640
	OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 642
	OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 643
	OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 645
	OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 646
	OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 648
	OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 649
	OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 651
	OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 652
	OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 654
	OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 655
	OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 657
	OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 658
	OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 660
	OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 661
	OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 663
	OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 664
	OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 666
	OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 667
	OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultXml                                                                                                            OpcuaNodeIdServicesObject = 669
	OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultBinary                                                                                                         OpcuaNodeIdServicesObject = 670
	OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 672
	OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 673
	OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 675
	OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 676
	OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 678
	OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 679
	OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 681
	OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 682
	OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 684
	OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 685
	OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 687
	OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 688
	OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 690
	OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 691
	OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 693
	OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 694
	OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 696
	OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 697
	OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 699
	OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 700
	OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 702
	OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 703
	OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 705
	OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 706
	OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 708
	OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 709
	OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 711
	OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 712
	OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 714
	OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 715
	OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 720
	OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 721
	OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 723
	OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 724
	OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 726
	OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 727
	OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 729
	OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 730
	OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 732
	OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 733
	OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 735
	OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 736
	OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 738
	OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 739
	OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 741
	OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 742
	OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 744
	OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 745
	OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 747
	OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 748
	OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 750
	OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 751
	OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 753
	OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 754
	OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 756
	OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 757
	OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 759
	OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 760
	OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 762
	OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 763
	OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 765
	OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 766
	OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 768
	OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 769
	OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 771
	OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 772
	OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 774
	OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 775
	OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 777
	OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 778
	OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 780
	OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 781
	OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 783
	OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 784
	OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 786
	OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 787
	OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 789
	OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 790
	OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 792
	OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 793
	OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 795
	OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 796
	OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 798
	OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 799
	OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 801
	OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 802
	OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 804
	OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 805
	OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 807
	OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 808
	OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 810
	OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 811
	OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 819
	OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 820
	OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 822
	OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 823
	OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 825
	OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 826
	OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 828
	OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 829
	OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 831
	OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 832
	OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 834
	OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 835
	OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 837
	OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 838
	OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 840
	OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 841
	OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultXml                                                                                         OpcuaNodeIdServicesObject = 843
	OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultBinary                                                                                      OpcuaNodeIdServicesObject = 844
	OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 846
	OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 847
	OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 849
	OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 850
	OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 854
	OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 855
	OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml                                                                                   OpcuaNodeIdServicesObject = 857
	OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary                                                                                OpcuaNodeIdServicesObject = 858
	OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultXml                                                                                      OpcuaNodeIdServicesObject = 860
	OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary                                                                                   OpcuaNodeIdServicesObject = 861
	OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 863
	OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 864
	OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 866
	OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 867
	OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultXml                                                                                    OpcuaNodeIdServicesObject = 869
	OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary                                                                                 OpcuaNodeIdServicesObject = 870
	OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 872
	OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 873
	OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultXml                                                                                       OpcuaNodeIdServicesObject = 875
	OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultBinary                                                                                    OpcuaNodeIdServicesObject = 876
	OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 878
	OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 879
	OpcuaNodeIdServicesObject_Range_Encoding_DefaultXml                                                                                                                 OpcuaNodeIdServicesObject = 885
	OpcuaNodeIdServicesObject_Range_Encoding_DefaultBinary                                                                                                              OpcuaNodeIdServicesObject = 886
	OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 888
	OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 889
	OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultXml                                                                                                            OpcuaNodeIdServicesObject = 892
	OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultBinary                                                                                                         OpcuaNodeIdServicesObject = 893
	OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 895
	OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 896
	OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultXml                                                                                       OpcuaNodeIdServicesObject = 898
	OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultBinary                                                                                    OpcuaNodeIdServicesObject = 899
	OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 915
	OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 916
	OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 918
	OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 919
	OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 921
	OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 922
	OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 939
	OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 940
	OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 946
	OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 947
	OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 949
	OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 950
	OpcuaNodeIdServicesObject_ServerType_ServerCapabilities                                                                                                             OpcuaNodeIdServicesObject = 2009
	OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics                                                                                                              OpcuaNodeIdServicesObject = 2010
	OpcuaNodeIdServicesObject_ServerType_VendorServerInfo                                                                                                               OpcuaNodeIdServicesObject = 2011
	OpcuaNodeIdServicesObject_ServerType_ServerRedundancy                                                                                                               OpcuaNodeIdServicesObject = 2012
	OpcuaNodeIdServicesObject_ServerCapabilitiesType_ModellingRules                                                                                                     OpcuaNodeIdServicesObject = 2019
	OpcuaNodeIdServicesObject_Server                                                                                                                                    OpcuaNodeIdServicesObject = 2253
	OpcuaNodeIdServicesObject_Server_ServerCapabilities                                                                                                                 OpcuaNodeIdServicesObject = 2268
	OpcuaNodeIdServicesObject_Server_ServerDiagnostics                                                                                                                  OpcuaNodeIdServicesObject = 2274
	OpcuaNodeIdServicesObject_Server_VendorServerInfo                                                                                                                   OpcuaNodeIdServicesObject = 2295
	OpcuaNodeIdServicesObject_Server_ServerRedundancy                                                                                                                   OpcuaNodeIdServicesObject = 2296
	OpcuaNodeIdServicesObject_AggregateFunction_Interpolative                                                                                                           OpcuaNodeIdServicesObject = 2341
	OpcuaNodeIdServicesObject_AggregateFunction_Average                                                                                                                 OpcuaNodeIdServicesObject = 2342
	OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage                                                                                                             OpcuaNodeIdServicesObject = 2343
	OpcuaNodeIdServicesObject_AggregateFunction_Total                                                                                                                   OpcuaNodeIdServicesObject = 2344
	OpcuaNodeIdServicesObject_AggregateFunction_Minimum                                                                                                                 OpcuaNodeIdServicesObject = 2346
	OpcuaNodeIdServicesObject_AggregateFunction_Maximum                                                                                                                 OpcuaNodeIdServicesObject = 2347
	OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime                                                                                                       OpcuaNodeIdServicesObject = 2348
	OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime                                                                                                       OpcuaNodeIdServicesObject = 2349
	OpcuaNodeIdServicesObject_AggregateFunction_Range                                                                                                                   OpcuaNodeIdServicesObject = 2350
	OpcuaNodeIdServicesObject_AggregateFunction_AnnotationCount                                                                                                         OpcuaNodeIdServicesObject = 2351
	OpcuaNodeIdServicesObject_AggregateFunction_Count                                                                                                                   OpcuaNodeIdServicesObject = 2352
	OpcuaNodeIdServicesObject_AggregateFunction_NumberOfTransitions                                                                                                     OpcuaNodeIdServicesObject = 2355
	OpcuaNodeIdServicesObject_AggregateFunction_Start                                                                                                                   OpcuaNodeIdServicesObject = 2357
	OpcuaNodeIdServicesObject_AggregateFunction_End                                                                                                                     OpcuaNodeIdServicesObject = 2358
	OpcuaNodeIdServicesObject_AggregateFunction_Delta                                                                                                                   OpcuaNodeIdServicesObject = 2359
	OpcuaNodeIdServicesObject_AggregateFunction_DurationGood                                                                                                            OpcuaNodeIdServicesObject = 2360
	OpcuaNodeIdServicesObject_AggregateFunction_DurationBad                                                                                                             OpcuaNodeIdServicesObject = 2361
	OpcuaNodeIdServicesObject_AggregateFunction_PercentGood                                                                                                             OpcuaNodeIdServicesObject = 2362
	OpcuaNodeIdServicesObject_AggregateFunction_PercentBad                                                                                                              OpcuaNodeIdServicesObject = 2363
	OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality                                                                                                            OpcuaNodeIdServicesObject = 2364
	OpcuaNodeIdServicesObject_ProgramStateMachineType_Ready                                                                                                             OpcuaNodeIdServicesObject = 2400
	OpcuaNodeIdServicesObject_ProgramStateMachineType_Running                                                                                                           OpcuaNodeIdServicesObject = 2402
	OpcuaNodeIdServicesObject_ProgramStateMachineType_Suspended                                                                                                         OpcuaNodeIdServicesObject = 2404
	OpcuaNodeIdServicesObject_ProgramStateMachineType_Halted                                                                                                            OpcuaNodeIdServicesObject = 2406
	OpcuaNodeIdServicesObject_ProgramStateMachineType_HaltedToReady                                                                                                     OpcuaNodeIdServicesObject = 2408
	OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToRunning                                                                                                    OpcuaNodeIdServicesObject = 2410
	OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToHalted                                                                                                   OpcuaNodeIdServicesObject = 2412
	OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToReady                                                                                                    OpcuaNodeIdServicesObject = 2414
	OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToSuspended                                                                                                OpcuaNodeIdServicesObject = 2416
	OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToRunning                                                                                                OpcuaNodeIdServicesObject = 2418
	OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToHalted                                                                                                 OpcuaNodeIdServicesObject = 2420
	OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToReady                                                                                                  OpcuaNodeIdServicesObject = 2422
	OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToHalted                                                                                                     OpcuaNodeIdServicesObject = 2424
	OpcuaNodeIdServicesObject_ServerDiagnosticsType_SessionsDiagnosticsSummary                                                                                          OpcuaNodeIdServicesObject = 2744
	OpcuaNodeIdServicesObject_ServerCapabilitiesType_AggregateFunctions                                                                                                 OpcuaNodeIdServicesObject = 2754
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_Unshelved                                                                                                         OpcuaNodeIdServicesObject = 2930
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelved                                                                                                      OpcuaNodeIdServicesObject = 2932
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelved                                                                                                    OpcuaNodeIdServicesObject = 2933
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToTimedShelved                                                                                           OpcuaNodeIdServicesObject = 2935
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToOneShotShelved                                                                                         OpcuaNodeIdServicesObject = 2936
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToUnshelved                                                                                           OpcuaNodeIdServicesObject = 2940
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToOneShotShelved                                                                                      OpcuaNodeIdServicesObject = 2942
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToUnshelved                                                                                         OpcuaNodeIdServicesObject = 2943
	OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToTimedShelved                                                                                      OpcuaNodeIdServicesObject = 2945
	OpcuaNodeIdServicesObject_Server_ServerCapabilities_ModellingRules                                                                                                  OpcuaNodeIdServicesObject = 2996
	OpcuaNodeIdServicesObject_Server_ServerCapabilities_AggregateFunctions                                                                                              OpcuaNodeIdServicesObject = 2997
	OpcuaNodeIdServicesObject_EventTypesFolder                                                                                                                          OpcuaNodeIdServicesObject = 3048
	OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateConfiguration                                                                                    OpcuaNodeIdServicesObject = 3059
	OpcuaNodeIdServicesObject_DefaultBinary                                                                                                                             OpcuaNodeIdServicesObject = 3062
	OpcuaNodeIdServicesObject_DefaultXml                                                                                                                                OpcuaNodeIdServicesObject = 3063
	OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_ModellingRules                                                                                              OpcuaNodeIdServicesObject = 3093
	OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_AggregateFunctions                                                                                          OpcuaNodeIdServicesObject = 3094
	OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary                                                                                   OpcuaNodeIdServicesObject = 3111
	OpcuaNodeIdServicesObject_Server_ServerDiagnostics_SessionsDiagnosticsSummary                                                                                       OpcuaNodeIdServicesObject = 3706
	OpcuaNodeIdServicesObject_ProgramStateMachineType_FinalResultData                                                                                                   OpcuaNodeIdServicesObject = 3850
	OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 7616
	OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 8251
	OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 8913
	OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 8917
	OpcuaNodeIdServicesObject_AlarmConditionType_ShelvingState                                                                                                          OpcuaNodeIdServicesObject = 9178
	OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighHigh                                                                                                   OpcuaNodeIdServicesObject = 9329
	OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_High                                                                                                       OpcuaNodeIdServicesObject = 9331
	OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_Low                                                                                                        OpcuaNodeIdServicesObject = 9333
	OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowLow                                                                                                     OpcuaNodeIdServicesObject = 9335
	OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowLowToLow                                                                                                OpcuaNodeIdServicesObject = 9337
	OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowToLowLow                                                                                                OpcuaNodeIdServicesObject = 9338
	OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighHighToHigh                                                                                             OpcuaNodeIdServicesObject = 9339
	OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighToHighHigh                                                                                             OpcuaNodeIdServicesObject = 9340
	OpcuaNodeIdServicesObject_ExclusiveLimitAlarmType_LimitState                                                                                                        OpcuaNodeIdServicesObject = 9455
	OpcuaNodeIdServicesObject_HistoryServerCapabilitiesType_AggregateFunctions                                                                                          OpcuaNodeIdServicesObject = 11172
	OpcuaNodeIdServicesObject_HistoryServerCapabilities                                                                                                                 OpcuaNodeIdServicesObject = 11192
	OpcuaNodeIdServicesObject_HistoryServerCapabilities_AggregateFunctions                                                                                              OpcuaNodeIdServicesObject = 11201
	OpcuaNodeIdServicesObject_HAConfiguration                                                                                                                           OpcuaNodeIdServicesObject = 11202
	OpcuaNodeIdServicesObject_HAConfiguration_AggregateConfiguration                                                                                                    OpcuaNodeIdServicesObject = 11203
	OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 11218
	OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 11219
	OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 11226
	OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 11227
	OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage2                                                                                                            OpcuaNodeIdServicesObject = 11285
	OpcuaNodeIdServicesObject_AggregateFunction_Minimum2                                                                                                                OpcuaNodeIdServicesObject = 11286
	OpcuaNodeIdServicesObject_AggregateFunction_Maximum2                                                                                                                OpcuaNodeIdServicesObject = 11287
	OpcuaNodeIdServicesObject_AggregateFunction_Range2                                                                                                                  OpcuaNodeIdServicesObject = 11288
	OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality2                                                                                                           OpcuaNodeIdServicesObject = 11292
	OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 11296
	OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 11300
	OpcuaNodeIdServicesObject_AggregateFunction_Total2                                                                                                                  OpcuaNodeIdServicesObject = 11304
	OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime2                                                                                                      OpcuaNodeIdServicesObject = 11305
	OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime2                                                                                                      OpcuaNodeIdServicesObject = 11306
	OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateZero                                                                                                     OpcuaNodeIdServicesObject = 11307
	OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateNonZero                                                                                                  OpcuaNodeIdServicesObject = 11308
	OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationSample                                                                                                 OpcuaNodeIdServicesObject = 11426
	OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationPopulation                                                                                             OpcuaNodeIdServicesObject = 11427
	OpcuaNodeIdServicesObject_AggregateFunction_VarianceSample                                                                                                          OpcuaNodeIdServicesObject = 11428
	OpcuaNodeIdServicesObject_AggregateFunction_VariancePopulation                                                                                                      OpcuaNodeIdServicesObject = 11429
	OpcuaNodeIdServicesObject_AggregateFunction_StartBound                                                                                                              OpcuaNodeIdServicesObject = 11505
	OpcuaNodeIdServicesObject_AggregateFunction_EndBound                                                                                                                OpcuaNodeIdServicesObject = 11506
	OpcuaNodeIdServicesObject_AggregateFunction_DeltaBounds                                                                                                             OpcuaNodeIdServicesObject = 11507
	OpcuaNodeIdServicesObject_ModellingRule_OptionalPlaceholder                                                                                                         OpcuaNodeIdServicesObject = 11508
	OpcuaNodeIdServicesObject_ModellingRule_MandatoryPlaceholder                                                                                                        OpcuaNodeIdServicesObject = 11510
	OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_OperationLimits                                                                                             OpcuaNodeIdServicesObject = 11516
	OpcuaNodeIdServicesObject_ServerType_Namespaces                                                                                                                     OpcuaNodeIdServicesObject = 11527
	OpcuaNodeIdServicesObject_ServerCapabilitiesType_OperationLimits                                                                                                    OpcuaNodeIdServicesObject = 11551
	OpcuaNodeIdServicesObject_NamespaceMetadataType_NamespaceFile                                                                                                       OpcuaNodeIdServicesObject = 11624
	OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder                                                                                            OpcuaNodeIdServicesObject = 11646
	OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile                                                                              OpcuaNodeIdServicesObject = 11654
	OpcuaNodeIdServicesObject_Server_ServerCapabilities_OperationLimits                                                                                                 OpcuaNodeIdServicesObject = 11704
	OpcuaNodeIdServicesObject_Server_Namespaces                                                                                                                         OpcuaNodeIdServicesObject = 11715
	OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateFunctions                                                                                        OpcuaNodeIdServicesObject = 11876
	OpcuaNodeIdServicesObject_HAConfiguration_AggregateFunctions                                                                                                        OpcuaNodeIdServicesObject = 11877
	OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 11887
	OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultXml                                                                                                              OpcuaNodeIdServicesObject = 11888
	OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 11889
	OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultBinary                                                                                                           OpcuaNodeIdServicesObject = 11890
	OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 11949
	OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 11950
	OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 11957
	OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 11958
	OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 12081
	OpcuaNodeIdServicesObject_XVType_Encoding_DefaultXml                                                                                                                OpcuaNodeIdServicesObject = 12082
	OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 12089
	OpcuaNodeIdServicesObject_XVType_Encoding_DefaultBinary                                                                                                             OpcuaNodeIdServicesObject = 12090
	OpcuaNodeIdServicesObject_SessionsDiagnosticsSummaryType_ClientName_Placeholder                                                                                     OpcuaNodeIdServicesObject = 12097
	OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 12173
	OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 12174
	OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 12181
	OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 12182
	OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 12195
	OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 12196
	OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 12197
	OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 12199
	OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 12200
	OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 12207
	OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 12208
	OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 12209
	OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 12211
	OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 12212
	OpcuaNodeIdServicesObject_ServerConfiguration                                                                                                                       OpcuaNodeIdServicesObject = 12637
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList                                                                   OpcuaNodeIdServicesObject = 12642
	OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 12676
	OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 12680
	OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultXml                                                                                                             OpcuaNodeIdServicesObject = 12757
	OpcuaNodeIdServicesObject_Union_Encoding_DefaultXml                                                                                                                 OpcuaNodeIdServicesObject = 12758
	OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultBinary                                                                                                          OpcuaNodeIdServicesObject = 12765
	OpcuaNodeIdServicesObject_Union_Encoding_DefaultBinary                                                                                                              OpcuaNodeIdServicesObject = 12766
	OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 12892
	OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 12893
	OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 12900
	OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 12901
	OpcuaNodeIdServicesObject_FileDirectoryType_FileDirectoryName_Placeholder                                                                                           OpcuaNodeIdServicesObject = 13354
	OpcuaNodeIdServicesObject_FileDirectoryType_FileName_Placeholder                                                                                                    OpcuaNodeIdServicesObject = 13366
	OpcuaNodeIdServicesObject_CertificateGroupType_TrustList                                                                                                            OpcuaNodeIdServicesObject = 13599
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup                                                                                        OpcuaNodeIdServicesObject = 13814
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustList                                                                              OpcuaNodeIdServicesObject = 13815
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup                                                                                              OpcuaNodeIdServicesObject = 13848
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustList                                                                                    OpcuaNodeIdServicesObject = 13849
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup                                                                                          OpcuaNodeIdServicesObject = 13882
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList                                                                                OpcuaNodeIdServicesObject = 13883
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder                                                                                    OpcuaNodeIdServicesObject = 13916
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList                                                                          OpcuaNodeIdServicesObject = 13917
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups                                                                                                 OpcuaNodeIdServicesObject = 13950
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup                                                                         OpcuaNodeIdServicesObject = 13951
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList                                                               OpcuaNodeIdServicesObject = 13952
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup                                                                               OpcuaNodeIdServicesObject = 13985
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList                                                                     OpcuaNodeIdServicesObject = 13986
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup                                                                           OpcuaNodeIdServicesObject = 14019
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList                                                                 OpcuaNodeIdServicesObject = 14020
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups                                                                                                     OpcuaNodeIdServicesObject = 14053
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup                                                                                   OpcuaNodeIdServicesObject = 14088
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList                                                                         OpcuaNodeIdServicesObject = 14089
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup                                                                               OpcuaNodeIdServicesObject = 14122
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList                                                                     OpcuaNodeIdServicesObject = 14123
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup                                                                             OpcuaNodeIdServicesObject = 14156
	OpcuaNodeIdServicesObject_PubSubConnectionType_Address                                                                                                              OpcuaNodeIdServicesObject = 14221
	OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 14319
	OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 14323
	OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder                                                                                           OpcuaNodeIdServicesObject = 14417
	OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Status                                                                                    OpcuaNodeIdServicesObject = 14419
	OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Address                                                                                   OpcuaNodeIdServicesObject = 14423
	OpcuaNodeIdServicesObject_PublishSubscribeType_PublishedDataSets                                                                                                    OpcuaNodeIdServicesObject = 14434
	OpcuaNodeIdServicesObject_PublishSubscribe                                                                                                                          OpcuaNodeIdServicesObject = 14443
	OpcuaNodeIdServicesObject_DataSetFolderType_DataSetFolderName_Placeholder                                                                                           OpcuaNodeIdServicesObject = 14478
	OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder                                                                                        OpcuaNodeIdServicesObject = 14487
	OpcuaNodeIdServicesObject_PubSubConnectionType_Status                                                                                                               OpcuaNodeIdServicesObject = 14600
	OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 14794
	OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 14795
	OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 14796
	OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 14797
	OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 14798
	OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 14799
	OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 14800
	OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultXml                                                                                                             OpcuaNodeIdServicesObject = 14801
	OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 14802
	OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 14803
	OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 14804
	OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 14839
	OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 14844
	OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultBinary                                                                                                          OpcuaNodeIdServicesObject = 14845
	OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 14846
	OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 14847
	OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 14848
	OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 15024
	OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 15025
	OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 15026
	OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15041
	OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15042
	OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15044
	OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15045
	OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 15049
	OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15050
	OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15051
	OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15057
	OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15058
	OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15059
	OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15060
	OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15061
	OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15062
	OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15063
	OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15065
	OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15066
	OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15067
	OpcuaNodeIdServicesObject_Node_Encoding_DefaultJson                                                                                                                 OpcuaNodeIdServicesObject = 15068
	OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15069
	OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultJson                                                                                                             OpcuaNodeIdServicesObject = 15070
	OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultJson                                                                                                           OpcuaNodeIdServicesObject = 15071
	OpcuaNodeIdServicesObject_DatagramConnectionTransportType_DiscoveryAddress                                                                                          OpcuaNodeIdServicesObject = 15072
	OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15073
	OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15074
	OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15075
	OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15076
	OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultJson                                                                                                           OpcuaNodeIdServicesObject = 15077
	OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultJson                                                                                                             OpcuaNodeIdServicesObject = 15078
	OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15079
	OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15080
	OpcuaNodeIdServicesObject_Argument_Encoding_DefaultJson                                                                                                             OpcuaNodeIdServicesObject = 15081
	OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15082
	OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultJson                                                                                                            OpcuaNodeIdServicesObject = 15083
	OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultJson                                                                                                            OpcuaNodeIdServicesObject = 15084
	OpcuaNodeIdServicesObject_Union_Encoding_DefaultJson                                                                                                                OpcuaNodeIdServicesObject = 15085
	OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15086
	OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15087
	OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15088
	OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15089
	OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15090
	OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 15091
	OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultJson                                                                                        OpcuaNodeIdServicesObject = 15092
	OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15093
	OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15094
	OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15095
	OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 15096
	OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 15097
	OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15098
	OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15099
	OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15100
	OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15101
	OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15102
	OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15103
	OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15104
	OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15105
	OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15106
	OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15107
	OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15130
	OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15131
	OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 15132
	OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15133
	OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15134
	OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15135
	OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15136
	OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15137
	OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15138
	OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15139
	OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15140
	OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15141
	OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15142
	OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15143
	OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15144
	OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15145
	OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15146
	OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15147
	OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15148
	OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15149
	OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15150
	OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15151
	OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15152
	OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15153
	OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15157
	OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15158
	OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15159
	OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15160
	OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15161
	OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15162
	OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15163
	OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15164
	OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15165
	OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15166
	OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15167
	OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15168
	OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15169
	OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15170
	OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15171
	OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15172
	OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15173
	OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15174
	OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15175
	OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15176
	OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 15177
	OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15179
	OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15180
	OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15182
	OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15183
	OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15184
	OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15185
	OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15186
	OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15187
	OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15188
	OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15189
	OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultJson                                                                                                           OpcuaNodeIdServicesObject = 15190
	OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15191
	OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15192
	OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson                                                                                 OpcuaNodeIdServicesObject = 15193
	OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson                                                                                OpcuaNodeIdServicesObject = 15194
	OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15195
	OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15196
	OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15197
	OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15198
	OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15199
	OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15200
	OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15201
	OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15202
	OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15203
	OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15204
	OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15205
	OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15206
	OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15207
	OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15208
	OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15209
	OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15210
	OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15211
	OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder                                                                                        OpcuaNodeIdServicesObject = 15222
	OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Status                                                                                 OpcuaNodeIdServicesObject = 15223
	OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings                                                                      OpcuaNodeIdServicesObject = 15227
	OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15228
	OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 15232
	OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 15233
	OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 15234
	OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15236
	OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15244
	OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15252
	OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15254
	OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15255
	OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 15256
	OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 15257
	OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15258
	OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15259
	OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15260
	OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15261
	OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15262
	OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15263
	OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15264
	OpcuaNodeIdServicesObject_PubSubGroupType_Status                                                                                                                    OpcuaNodeIdServicesObject = 15265
	OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15269
	OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 15270
	OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15271
	OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15272
	OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15273
	OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15274
	OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15275
	OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultJson                                                                                                           OpcuaNodeIdServicesObject = 15276
	OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15277
	OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15278
	OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15279
	OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15280
	OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15281
	OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15282
	OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 15283
	OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15284
	OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15285
	OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15286
	OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15287
	OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15288
	OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15289
	OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15290
	OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 15291
	OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15292
	OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15293
	OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15294
	OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 15295
	OpcuaNodeIdServicesObject_DataSetWriterType_Status                                                                                                                  OpcuaNodeIdServicesObject = 15299
	OpcuaNodeIdServicesObject_DataSetWriterType_TransportSettings                                                                                                       OpcuaNodeIdServicesObject = 15303
	OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15304
	OpcuaNodeIdServicesObject_DataSetReaderType_Status                                                                                                                  OpcuaNodeIdServicesObject = 15307
	OpcuaNodeIdServicesObject_DataSetReaderType_TransportSettings                                                                                                       OpcuaNodeIdServicesObject = 15311
	OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15312
	OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15313
	OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15314
	OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15315
	OpcuaNodeIdServicesObject_DataSetReaderType_SubscribedDataSet                                                                                                       OpcuaNodeIdServicesObject = 15316
	OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15320
	OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15321
	OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15322
	OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 15323
	OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 15324
	OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15325
	OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15326
	OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 15327
	OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 15328
	OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 15329
	OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15331
	OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15332
	OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15333
	OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 15335
	OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 15336
	OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15337
	OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15338
	OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15339
	OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15340
	OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 15341
	OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15342
	OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15343
	OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15344
	OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15345
	OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15346
	OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15347
	OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15348
	OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15349
	OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 15350
	OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 15351
	OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15352
	OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15353
	OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 15354
	OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15355
	OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 15356
	OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 15357
	OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultJson                                                                                        OpcuaNodeIdServicesObject = 15358
	OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15359
	OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 15360
	OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultJson                                                                                                            OpcuaNodeIdServicesObject = 15361
	OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15362
	OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15363
	OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15364
	OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson                                                                                  OpcuaNodeIdServicesObject = 15365
	OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultJson                                                                                     OpcuaNodeIdServicesObject = 15366
	OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15367
	OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 15368
	OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultJson                                                                                   OpcuaNodeIdServicesObject = 15369
	OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 15370
	OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 15371
	OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultJson                                                                                      OpcuaNodeIdServicesObject = 15372
	OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 15373
	OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultJson                                                                                      OpcuaNodeIdServicesObject = 15374
	OpcuaNodeIdServicesObject_Range_Encoding_DefaultJson                                                                                                                OpcuaNodeIdServicesObject = 15375
	OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15376
	OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 15377
	OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 15378
	OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 15379
	OpcuaNodeIdServicesObject_XVType_Encoding_DefaultJson                                                                                                               OpcuaNodeIdServicesObject = 15380
	OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 15381
	OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultJson                                                                                                           OpcuaNodeIdServicesObject = 15382
	OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 15396
	OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 15397
	OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 15398
	OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 15401
	OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 15402
	OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 15403
	OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 15404
	OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15405
	OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 15421
	OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 15422
	OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15431
	OpcuaNodeIdServicesObject_PublishSubscribe_SecurityGroups                                                                                                           OpcuaNodeIdServicesObject = 15443
	OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder                                                                               OpcuaNodeIdServicesObject = 15453
	OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupName_Placeholder                                                                                     OpcuaNodeIdServicesObject = 15459
	OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields                                                                        OpcuaNodeIdServicesObject = 15473
	OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultBinary                                                                                  OpcuaNodeIdServicesObject = 15479
	OpcuaNodeIdServicesObject_PublishedDataSetType_ExtensionFields                                                                                                      OpcuaNodeIdServicesObject = 15481
	OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 15529
	OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 15531
	OpcuaNodeIdServicesObject_ServerConfigurationType_ConfigurationFile                                                                                                 OpcuaNodeIdServicesObject = 15564
	OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultXml                                                                                     OpcuaNodeIdServicesObject = 15579
	OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 15589
	OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 15590
	OpcuaNodeIdServicesObject_Server_ServerCapabilities_RoleSet                                                                                                         OpcuaNodeIdServicesObject = 15606
	OpcuaNodeIdServicesObject_RoleSetType_RoleName_Placeholder                                                                                                          OpcuaNodeIdServicesObject = 15608
	OpcuaNodeIdServicesObject_WellKnownRole_Anonymous                                                                                                                   OpcuaNodeIdServicesObject = 15644
	OpcuaNodeIdServicesObject_WellKnownRole_AuthenticatedUser                                                                                                           OpcuaNodeIdServicesObject = 15656
	OpcuaNodeIdServicesObject_WellKnownRole_Observer                                                                                                                    OpcuaNodeIdServicesObject = 15668
	OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 15671
	OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 15676
	OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 15677
	OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultBinary                                                                                     OpcuaNodeIdServicesObject = 15678
	OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 15679
	OpcuaNodeIdServicesObject_WellKnownRole_Operator                                                                                                                    OpcuaNodeIdServicesObject = 15680
	OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 15681
	OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 15682
	OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultBinary                                                                                     OpcuaNodeIdServicesObject = 15683
	OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 15688
	OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 15689
	OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 15691
	OpcuaNodeIdServicesObject_WellKnownRole_Supervisor                                                                                                                  OpcuaNodeIdServicesObject = 15692
	OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 15693
	OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 15694
	OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 15695
	OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 15700
	OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 15701
	OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 15702
	OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 15703
	OpcuaNodeIdServicesObject_WellKnownRole_SecurityAdmin                                                                                                               OpcuaNodeIdServicesObject = 15704
	OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultBinary                                                                                     OpcuaNodeIdServicesObject = 15705
	OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 15706
	OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 15707
	OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 15712
	OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultBinary                                                                                    OpcuaNodeIdServicesObject = 15713
	OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 15714
	OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultBinary                                                                                     OpcuaNodeIdServicesObject = 15715
	OpcuaNodeIdServicesObject_WellKnownRole_ConfigureAdmin                                                                                                              OpcuaNodeIdServicesObject = 15716
	OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultBinary                                                                                   OpcuaNodeIdServicesObject = 15717
	OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultBinary                                                                                   OpcuaNodeIdServicesObject = 15718
	OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultBinary                                                                                     OpcuaNodeIdServicesObject = 15719
	OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultBinary                                                                                   OpcuaNodeIdServicesObject = 15724
	OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultBinary                                                                                   OpcuaNodeIdServicesObject = 15725
	OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultJson                                                                                    OpcuaNodeIdServicesObject = 15726
	OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultBinary                                                                                 OpcuaNodeIdServicesObject = 15727
	OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 15728
	OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary                                                                               OpcuaNodeIdServicesObject = 15729
	OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary                                                                               OpcuaNodeIdServicesObject = 15733
	OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 15736
	OpcuaNodeIdServicesObject_TemporaryFileTransferType_TransferState_Placeholder                                                                                       OpcuaNodeIdServicesObject = 15754
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_Idle                                                                                                         OpcuaNodeIdServicesObject = 15815
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepare                                                                                                  OpcuaNodeIdServicesObject = 15817
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransfer                                                                                                 OpcuaNodeIdServicesObject = 15819
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWrite                                                                                                   OpcuaNodeIdServicesObject = 15821
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_Error                                                                                                        OpcuaNodeIdServicesObject = 15823
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToReadPrepare                                                                                            OpcuaNodeIdServicesObject = 15825
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToReadTransfer                                                                                    OpcuaNodeIdServicesObject = 15827
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToIdle                                                                                           OpcuaNodeIdServicesObject = 15829
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToApplyWrite                                                                                             OpcuaNodeIdServicesObject = 15831
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToIdle                                                                                             OpcuaNodeIdServicesObject = 15833
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToError                                                                                           OpcuaNodeIdServicesObject = 15835
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToError                                                                                          OpcuaNodeIdServicesObject = 15837
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToError                                                                                            OpcuaNodeIdServicesObject = 15839
	OpcuaNodeIdServicesObject_FileTransferStateMachineType_ErrorToIdle                                                                                                  OpcuaNodeIdServicesObject = 15841
	OpcuaNodeIdServicesObject_PublishSubscribeType_Status                                                                                                               OpcuaNodeIdServicesObject = 15844
	OpcuaNodeIdServicesObject_ServerConfiguration_ConfigurationFile                                                                                                     OpcuaNodeIdServicesObject = 15892
	OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 15902
	OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 15903
	OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_TransportSettings                                                                         OpcuaNodeIdServicesObject = 15905
	OpcuaNodeIdServicesObject_PubSubKeyServiceType_SecurityGroups                                                                                                       OpcuaNodeIdServicesObject = 15913
	OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 15949
	OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 15950
	OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 15951
	OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultXml                                                                                        OpcuaNodeIdServicesObject = 15952
	OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 15953
	OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 15954
	OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 15955
	OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultXml                                                                                        OpcuaNodeIdServicesObject = 15956
	OpcuaNodeIdServicesObject_OPCUANamespaceMetadata                                                                                                                    OpcuaNodeIdServicesObject = 15957
	OpcuaNodeIdServicesObject_OPCUANamespaceMetadata_NamespaceFile                                                                                                      OpcuaNodeIdServicesObject = 15965
	OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 15987
	OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 15988
	OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 15990
	OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 15991
	OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 15992
	OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 15993
	OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 15995
	OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 15996
	OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 16007
	OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultXml                                                                                        OpcuaNodeIdServicesObject = 16008
	OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 16009
	OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 16010
	OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 16011
	OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultXml                                                                                       OpcuaNodeIdServicesObject = 16012
	OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultXml                                                                                        OpcuaNodeIdServicesObject = 16014
	OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultXml                                                                                      OpcuaNodeIdServicesObject = 16015
	OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultXml                                                                                      OpcuaNodeIdServicesObject = 16016
	OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultXml                                                                                        OpcuaNodeIdServicesObject = 16017
	OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultXml                                                                                      OpcuaNodeIdServicesObject = 16018
	OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultXml                                                                                      OpcuaNodeIdServicesObject = 16019
	OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultXml                                                                                    OpcuaNodeIdServicesObject = 16021
	OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultXml                                                                                  OpcuaNodeIdServicesObject = 16022
	OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultXml                                                                                  OpcuaNodeIdServicesObject = 16023
	OpcuaNodeIdServicesObject_WellKnownRole_Engineer                                                                                                                    OpcuaNodeIdServicesObject = 16036
	OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 16126
	OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 16150
	OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 16151
	OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 16152
	OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultJson                                                                                       OpcuaNodeIdServicesObject = 16153
	OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 16154
	OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 16155
	OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 16156
	OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultJson                                                                                       OpcuaNodeIdServicesObject = 16157
	OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 16158
	OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 16159
	OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 16161
	OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 16280
	OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 16281
	OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 16282
	OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 16284
	OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 16285
	OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 16286
	OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultJson                                                                                       OpcuaNodeIdServicesObject = 16287
	OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 16288
	OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_RoleSet                                                                                                     OpcuaNodeIdServicesObject = 16289
	OpcuaNodeIdServicesObject_ServerCapabilitiesType_RoleSet                                                                                                            OpcuaNodeIdServicesObject = 16295
	OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 16308
	OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 16310
	OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultJson                                                                                      OpcuaNodeIdServicesObject = 16311
	OpcuaNodeIdServicesObject_FileSystem                                                                                                                                OpcuaNodeIdServicesObject = 16314
	OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultJson                                                                                       OpcuaNodeIdServicesObject = 16323
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile                                                                     OpcuaNodeIdServicesObject = 16324
	OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultJson                                                                                     OpcuaNodeIdServicesObject = 16391
	OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultJson                                                                                     OpcuaNodeIdServicesObject = 16392
	OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultJson                                                                                       OpcuaNodeIdServicesObject = 16393
	OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultJson                                                                                     OpcuaNodeIdServicesObject = 16394
	OpcuaNodeIdServicesObject_AlarmConditionType_FirstInGroup                                                                                                           OpcuaNodeIdServicesObject = 16398
	OpcuaNodeIdServicesObject_AlarmConditionType_AlarmGroup_Placeholder                                                                                                 OpcuaNodeIdServicesObject = 16399
	OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultJson                                                                                     OpcuaNodeIdServicesObject = 16404
	OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder                                                                                         OpcuaNodeIdServicesObject = 16406
	OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState                                                                           OpcuaNodeIdServicesObject = 16502
	OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultJson                                                                                   OpcuaNodeIdServicesObject = 16524
	OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultJson                                                                                 OpcuaNodeIdServicesObject = 16525
	OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultJson                                                                                 OpcuaNodeIdServicesObject = 16526
	OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup                                                                            OpcuaNodeIdServicesObject = 16530
	OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 16538
	OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultBinary                                                                                    OpcuaNodeIdServicesObject = 16539
	OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 16540
	OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultBinary                                                                                      OpcuaNodeIdServicesObject = 16541
	OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultBinary                                                                                   OpcuaNodeIdServicesObject = 16542
	OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 16543
	OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 16544
	OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 16545
	OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 16546
	OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 16547
	OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 16587
	OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultXml                                                                                       OpcuaNodeIdServicesObject = 16588
	OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 16589
	OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultXml                                                                                         OpcuaNodeIdServicesObject = 16590
	OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultXml                                                                                      OpcuaNodeIdServicesObject = 16591
	OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 16592
	OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 16593
	OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 16594
	OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 16595
	OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 16596
	OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 16632
	OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultJson                                                                                      OpcuaNodeIdServicesObject = 16633
	OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 16634
	OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultJson                                                                                        OpcuaNodeIdServicesObject = 16635
	OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultJson                                                                                     OpcuaNodeIdServicesObject = 16636
	OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 16637
	OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 16642
	OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 16643
	OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 16644
	OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 16645
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder                                                                            OpcuaNodeIdServicesObject = 16663
	OpcuaNodeIdServicesObject_ManagedApplications                                                                                                                       OpcuaNodeIdServicesObject = 16706
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups                                                          OpcuaNodeIdServicesObject = 16707
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup                                  OpcuaNodeIdServicesObject = 16708
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList                        OpcuaNodeIdServicesObject = 16709
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired               OpcuaNodeIdServicesObject = 16754
	OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings                                                                        OpcuaNodeIdServicesObject = 16758
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState OpcuaNodeIdServicesObject = 16847
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup  OpcuaNodeIdServicesObject = 16898
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate               OpcuaNodeIdServicesObject = 16939
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState OpcuaNodeIdServicesObject = 17040
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup  OpcuaNodeIdServicesObject = 17091
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup                                        OpcuaNodeIdServicesObject = 17125
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList                              OpcuaNodeIdServicesObject = 17126
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired                     OpcuaNodeIdServicesObject = 17166
	OpcuaNodeIdServicesObject_PubSubConnectionType_TransportSettings                                                                                                    OpcuaNodeIdServicesObject = 17203
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState       OpcuaNodeIdServicesObject = 17271
	OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_TransportSettings                                                                        OpcuaNodeIdServicesObject = 17290
	OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_MessageSettings                                                                          OpcuaNodeIdServicesObject = 17291
	OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_TransportSettings                                                                        OpcuaNodeIdServicesObject = 17307
	OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_MessageSettings                                                                          OpcuaNodeIdServicesObject = 17308
	OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder                                                                                          OpcuaNodeIdServicesObject = 17310
	OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Status                                                                                   OpcuaNodeIdServicesObject = 17314
	OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder                                                                                          OpcuaNodeIdServicesObject = 17325
	OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Status                                                                                   OpcuaNodeIdServicesObject = 17329
	OpcuaNodeIdServicesObject_PublishSubscribe_PublishedDataSets                                                                                                        OpcuaNodeIdServicesObject = 17371
	OpcuaNodeIdServicesObject_PublishSubscribe_Status                                                                                                                   OpcuaNodeIdServicesObject = 17405
	OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics                                                                                                              OpcuaNodeIdServicesObject = 17409
	OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_Counters                                                                                                     OpcuaNodeIdServicesObject = 17423
	OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_LiveValues                                                                                                   OpcuaNodeIdServicesObject = 17457
	OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultBinary                                                                                OpcuaNodeIdServicesObject = 17468
	OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultXml                                                                                   OpcuaNodeIdServicesObject = 17472
	OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultJson                                                                                  OpcuaNodeIdServicesObject = 17476
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup        OpcuaNodeIdServicesObject = 17499
	OpcuaNodeIdServicesObject_KeyCredentialConfigurationFolderType_ServiceName_Placeholder                                                                              OpcuaNodeIdServicesObject = 17511
	OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 17537
	OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 17541
	OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 17547
	OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 17549
	OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 17553
	OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 17557
	OpcuaNodeIdServicesObject_DictionaryEntryType_DictionaryEntryName_Placeholder                                                                                       OpcuaNodeIdServicesObject = 17590
	OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryFolderName_Placeholder                                                                                     OpcuaNodeIdServicesObject = 17592
	OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryEntryName_Placeholder                                                                                      OpcuaNodeIdServicesObject = 17593
	OpcuaNodeIdServicesObject_Dictionaries                                                                                                                              OpcuaNodeIdServicesObject = 17594
	OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 17608
	OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 17609
	OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 17610
	OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 17611
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate                     OpcuaNodeIdServicesObject = 17629
	OpcuaNodeIdServicesObject_InterfaceTypes                                                                                                                            OpcuaNodeIdServicesObject = 17708
	OpcuaNodeIdServicesObject_AuthorizationServices                                                                                                                     OpcuaNodeIdServicesObject = 17732
	OpcuaNodeIdServicesObject_WriterGroupType_TransportSettings                                                                                                         OpcuaNodeIdServicesObject = 17741
	OpcuaNodeIdServicesObject_WriterGroupType_MessageSettings                                                                                                           OpcuaNodeIdServicesObject = 17742
	OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder                                                                                             OpcuaNodeIdServicesObject = 17743
	OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_TransportSettings                                                                           OpcuaNodeIdServicesObject = 17747
	OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_MessageSettings                                                                             OpcuaNodeIdServicesObject = 17748
	OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Status                                                                                      OpcuaNodeIdServicesObject = 17749
	OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics                                                                                 OpcuaNodeIdServicesObject = 17753
	OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters                                                                        OpcuaNodeIdServicesObject = 17767
	OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues                                                                      OpcuaNodeIdServicesObject = 17798
	OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics                                                                                                               OpcuaNodeIdServicesObject = 17812
	OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_Counters                                                                                                      OpcuaNodeIdServicesObject = 17826
	OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_LiveValues                                                                                                    OpcuaNodeIdServicesObject = 17858
	OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 17862
	OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 17863
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState       OpcuaNodeIdServicesObject = 17895
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup        OpcuaNodeIdServicesObject = 17951
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup                                    OpcuaNodeIdServicesObject = 18015
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList                          OpcuaNodeIdServicesObject = 18016
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired                 OpcuaNodeIdServicesObject = 18059
	OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder                                                                                             OpcuaNodeIdServicesObject = 18076
	OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_TransportSettings                                                                           OpcuaNodeIdServicesObject = 18086
	OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_MessageSettings                                                                             OpcuaNodeIdServicesObject = 18087
	OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Status                                                                                      OpcuaNodeIdServicesObject = 18088
	OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics                                                                                 OpcuaNodeIdServicesObject = 18092
	OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters                                                                        OpcuaNodeIdServicesObject = 18106
	OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues                                                                      OpcuaNodeIdServicesObject = 18137
	OpcuaNodeIdServicesObject_KeyCredentialConfiguration                                                                                                                OpcuaNodeIdServicesObject = 18155
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState   OpcuaNodeIdServicesObject = 18279
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup    OpcuaNodeIdServicesObject = 18323
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate                 OpcuaNodeIdServicesObject = 18359
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState   OpcuaNodeIdServicesObject = 18446
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup    OpcuaNodeIdServicesObject = 18490
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_TransactionDiagnostics                                                     OpcuaNodeIdServicesObject = 18547
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile                                                          OpcuaNodeIdServicesObject = 18554
	OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 18598
	OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultBinary                                                                                            OpcuaNodeIdServicesObject = 18599
	OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 18600
	OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 18610
	OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultXml                                                                                               OpcuaNodeIdServicesObject = 18611
	OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 18612
	OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 18622
	OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultJson                                                                                              OpcuaNodeIdServicesObject = 18623
	OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 18624
	OpcuaNodeIdServicesObject_WellKnownRole_TrustedApplication                                                                                                          OpcuaNodeIdServicesObject = 18625
	OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultBinary                                                                                                    OpcuaNodeIdServicesObject = 18650
	OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 18651
	OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultXml                                                                                                       OpcuaNodeIdServicesObject = 18652
	OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 18653
	OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultJson                                                                                                      OpcuaNodeIdServicesObject = 18654
	OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 18655
	OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics                                                                               OpcuaNodeIdServicesObject = 18667
	OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters                                                                      OpcuaNodeIdServicesObject = 18681
	OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues                                                                    OpcuaNodeIdServicesObject = 18712
	OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics                                                                                                          OpcuaNodeIdServicesObject = 18715
	OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_Counters                                                                                                 OpcuaNodeIdServicesObject = 18729
	OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_LiveValues                                                                                               OpcuaNodeIdServicesObject = 18760
	OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultBinary                                                                                      OpcuaNodeIdServicesObject = 18795
	OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 18815
	OpcuaNodeIdServicesObject_Vector_Encoding_DefaultBinary                                                                                                             OpcuaNodeIdServicesObject = 18816
	OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultBinary                                                                                                       OpcuaNodeIdServicesObject = 18817
	OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 18818
	OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 18819
	OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 18820
	OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 18821
	OpcuaNodeIdServicesObject_Frame_Encoding_DefaultBinary                                                                                                              OpcuaNodeIdServicesObject = 18822
	OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 18823
	OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 18851
	OpcuaNodeIdServicesObject_Vector_Encoding_DefaultXml                                                                                                                OpcuaNodeIdServicesObject = 18852
	OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultXml                                                                                                          OpcuaNodeIdServicesObject = 18853
	OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 18854
	OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 18855
	OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 18856
	OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 18857
	OpcuaNodeIdServicesObject_Frame_Encoding_DefaultXml                                                                                                                 OpcuaNodeIdServicesObject = 18858
	OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 18859
	OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics                                                                            OpcuaNodeIdServicesObject = 18871
	OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters                                                                   OpcuaNodeIdServicesObject = 18885
	OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues                                                                 OpcuaNodeIdServicesObject = 18916
	OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 18930
	OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultXml                                                                                         OpcuaNodeIdServicesObject = 18937
	OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 18938
	OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultJson                                                                                        OpcuaNodeIdServicesObject = 18945
	OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 18946
	OpcuaNodeIdServicesObject_LLDP                                                                                                                                      OpcuaNodeIdServicesObject = 18958
	OpcuaNodeIdServicesObject_LLDP_RemoteStatistics                                                                                                                     OpcuaNodeIdServicesObject = 18959
	OpcuaNodeIdServicesObject_LLDP_LocalSystemData                                                                                                                      OpcuaNodeIdServicesObject = 18965
	OpcuaNodeIdServicesObject_LLDP_Ports                                                                                                                                OpcuaNodeIdServicesObject = 18972
	OpcuaNodeIdServicesObject_LldpInformationType_RemoteStatistics                                                                                                      OpcuaNodeIdServicesObject = 18974
	OpcuaNodeIdServicesObject_LldpInformationType_LocalSystemData                                                                                                       OpcuaNodeIdServicesObject = 18980
	OpcuaNodeIdServicesObject_LldpInformationType_Ports                                                                                                                 OpcuaNodeIdServicesObject = 18987
	OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder                                                                                 OpcuaNodeIdServicesObject = 18988
	OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder_RemoteSystemsData                                                               OpcuaNodeIdServicesObject = 18995
	OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData                                                                                                 OpcuaNodeIdServicesObject = 19016
	OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder                                                                    OpcuaNodeIdServicesObject = 19017
	OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 19064
	OpcuaNodeIdServicesObject_Vector_Encoding_DefaultJson                                                                                                               OpcuaNodeIdServicesObject = 19065
	OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultJson                                                                                                         OpcuaNodeIdServicesObject = 19066
	OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 19067
	OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 19068
	OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 19069
	OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 19070
	OpcuaNodeIdServicesObject_Frame_Encoding_DefaultJson                                                                                                                OpcuaNodeIdServicesObject = 19071
	OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 19072
	OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultBinary                                                                                    OpcuaNodeIdServicesObject = 19079
	OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 19080
	OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 19081
	OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultXml                                                                                       OpcuaNodeIdServicesObject = 19100
	OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 19101
	OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 19102
	OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics                                                                              OpcuaNodeIdServicesObject = 19107
	OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters                                                                     OpcuaNodeIdServicesObject = 19121
	OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues                                                                   OpcuaNodeIdServicesObject = 19152
	OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics                                                                              OpcuaNodeIdServicesObject = 19176
	OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters                                                                     OpcuaNodeIdServicesObject = 19190
	OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues                                                                   OpcuaNodeIdServicesObject = 19221
	OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics                                                                                                          OpcuaNodeIdServicesObject = 19241
	OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_Counters                                                                                                 OpcuaNodeIdServicesObject = 19255
	OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_LiveValues                                                                                               OpcuaNodeIdServicesObject = 19286
	OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultJson                                                                                      OpcuaNodeIdServicesObject = 19299
	OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 19300
	OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 19301
	OpcuaNodeIdServicesObject_ServerLog                                                                                                                                 OpcuaNodeIdServicesObject = 19372
	OpcuaNodeIdServicesObject_Logs                                                                                                                                      OpcuaNodeIdServicesObject = 19378
	OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultBinary                                                                                                          OpcuaNodeIdServicesObject = 19379
	OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultXml                                                                                                             OpcuaNodeIdServicesObject = 19383
	OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultJson                                                                                                            OpcuaNodeIdServicesObject = 19387
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials                                                             OpcuaNodeIdServicesObject = 19409
	OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_AuthorizationServices                                                      OpcuaNodeIdServicesObject = 19413
	OpcuaNodeIdServicesObject_ApplicationConfigurationType_KeyCredentials                                                                                               OpcuaNodeIdServicesObject = 19423
	OpcuaNodeIdServicesObject_ApplicationConfigurationType_AuthorizationServices                                                                                        OpcuaNodeIdServicesObject = 19427
	OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultBinary                                                                                                          OpcuaNodeIdServicesObject = 19435
	OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 19436
	OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultXml                                                                                                             OpcuaNodeIdServicesObject = 19437
	OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 19438
	OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultJson                                                                                                            OpcuaNodeIdServicesObject = 19439
	OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 19440
	OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired                                                                                                   OpcuaNodeIdServicesObject = 19450
	OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_ShelvingState                                                                                     OpcuaNodeIdServicesObject = 19537
	OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics                                                                                                             OpcuaNodeIdServicesObject = 19550
	OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_Counters                                                                                                    OpcuaNodeIdServicesObject = 19564
	OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_LiveValues                                                                                                  OpcuaNodeIdServicesObject = 19595
	OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics                                                                                                             OpcuaNodeIdServicesObject = 19609
	OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_Counters                                                                                                    OpcuaNodeIdServicesObject = 19623
	OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_LiveValues                                                                                                  OpcuaNodeIdServicesObject = 19654
	OpcuaNodeIdServicesObject_PubSubDiagnosticsType_Counters                                                                                                            OpcuaNodeIdServicesObject = 19691
	OpcuaNodeIdServicesObject_PubSubDiagnosticsType_LiveValues                                                                                                          OpcuaNodeIdServicesObject = 19722
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials                                                                        OpcuaNodeIdServicesObject = 19739
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_AuthorizationServices                                                                 OpcuaNodeIdServicesObject = 19743
	OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultBinary                                                                          OpcuaNodeIdServicesObject = 19752
	OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 19753
	OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 19754
	OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 19755
	OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultBinary                                                                                                      OpcuaNodeIdServicesObject = 19756
	OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultXml                                                                             OpcuaNodeIdServicesObject = 19772
	OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 19773
	OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 19774
	OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 19775
	OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultXml                                                                                                         OpcuaNodeIdServicesObject = 19776
	OpcuaNodeIdServicesObject_PubSubDiagnosticsRootType_LiveValues                                                                                                      OpcuaNodeIdServicesObject = 19777
	OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultJson                                                                            OpcuaNodeIdServicesObject = 19802
	OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 19803
	OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 19804
	OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 19805
	OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultJson                                                                                                        OpcuaNodeIdServicesObject = 19806
	OpcuaNodeIdServicesObject_PubSubDiagnosticsConnectionType_LiveValues                                                                                                OpcuaNodeIdServicesObject = 19831
	OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_Counters                                                                                                 OpcuaNodeIdServicesObject = 19848
	OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_LiveValues                                                                                               OpcuaNodeIdServicesObject = 19879
	OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_Counters                                                                                                 OpcuaNodeIdServicesObject = 19917
	OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_LiveValues                                                                                               OpcuaNodeIdServicesObject = 19948
	OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_Counters                                                                                               OpcuaNodeIdServicesObject = 19982
	OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_LiveValues                                                                                             OpcuaNodeIdServicesObject = 20013
	OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_Counters                                                                                               OpcuaNodeIdServicesObject = 20041
	OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_LiveValues                                                                                             OpcuaNodeIdServicesObject = 20072
	OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_FirstInGroup                                                                                      OpcuaNodeIdServicesObject = 20120
	OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate                                                                                                   OpcuaNodeIdServicesObject = 20143
	OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_ShelvingState                                                                                     OpcuaNodeIdServicesObject = 20230
	OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_FirstInGroup                                                                                      OpcuaNodeIdServicesObject = 20268
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired                                                                     OpcuaNodeIdServicesObject = 20291
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState                                                       OpcuaNodeIdServicesObject = 20378
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroup                                                        OpcuaNodeIdServicesObject = 20418
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate                                                                     OpcuaNodeIdServicesObject = 20441
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState                                                       OpcuaNodeIdServicesObject = 20528
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup                                                        OpcuaNodeIdServicesObject = 20566
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired                                                                           OpcuaNodeIdServicesObject = 20589
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState                                                             OpcuaNodeIdServicesObject = 20676
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroup                                                              OpcuaNodeIdServicesObject = 20714
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate                                                                           OpcuaNodeIdServicesObject = 20737
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState                                                             OpcuaNodeIdServicesObject = 20824
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup                                                              OpcuaNodeIdServicesObject = 20862
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired                                                                       OpcuaNodeIdServicesObject = 20885
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState                                                         OpcuaNodeIdServicesObject = 20972
	OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultXml                                                                                         OpcuaNodeIdServicesObject = 21000
	OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultBinary                                                                                      OpcuaNodeIdServicesObject = 21001
	OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet                                                                           OpcuaNodeIdServicesObject = 21006
	OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics                                                                                                               OpcuaNodeIdServicesObject = 21015
	OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_Counters                                                                                                      OpcuaNodeIdServicesObject = 21029
	OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_LiveValues                                                                                                    OpcuaNodeIdServicesObject = 21060
	OpcuaNodeIdServicesObject_ReaderGroupType_TransportSettings                                                                                                         OpcuaNodeIdServicesObject = 21080
	OpcuaNodeIdServicesObject_ReaderGroupType_MessageSettings                                                                                                           OpcuaNodeIdServicesObject = 21081
	OpcuaNodeIdServicesObject_DataSetWriterType_MessageSettings                                                                                                         OpcuaNodeIdServicesObject = 21095
	OpcuaNodeIdServicesObject_DataSetReaderType_MessageSettings                                                                                                         OpcuaNodeIdServicesObject = 21103
	OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 21150
	OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 21151
	OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 21152
	OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 21153
	OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 21154
	OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultBinary                                                                               OpcuaNodeIdServicesObject = 21155
	OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 21174
	OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 21175
	OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 21176
	OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 21177
	OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 21178
	OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultXml                                                                                  OpcuaNodeIdServicesObject = 21179
	OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 21198
	OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 21199
	OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 21200
	OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 21201
	OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 21202
	OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultJson                                                                                 OpcuaNodeIdServicesObject = 21203
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroup                                                          OpcuaNodeIdServicesObject = 21213
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate                                                                       OpcuaNodeIdServicesObject = 21236
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState                                                         OpcuaNodeIdServicesObject = 21323
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup                                                          OpcuaNodeIdServicesObject = 21361
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired                                                                 OpcuaNodeIdServicesObject = 21384
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState                                                   OpcuaNodeIdServicesObject = 21471
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroup                                                    OpcuaNodeIdServicesObject = 21509
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate                                                                 OpcuaNodeIdServicesObject = 21532
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState                                                   OpcuaNodeIdServicesObject = 21619
	OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroup                                                    OpcuaNodeIdServicesObject = 21657
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired                                                      OpcuaNodeIdServicesObject = 21680
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState                                        OpcuaNodeIdServicesObject = 21767
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup                                         OpcuaNodeIdServicesObject = 21805
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate                                                      OpcuaNodeIdServicesObject = 21828
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState                                        OpcuaNodeIdServicesObject = 21915
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup                                         OpcuaNodeIdServicesObject = 21953
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired                                                            OpcuaNodeIdServicesObject = 21976
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState                                              OpcuaNodeIdServicesObject = 22063
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup                                               OpcuaNodeIdServicesObject = 22101
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate                                                            OpcuaNodeIdServicesObject = 22124
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState                                              OpcuaNodeIdServicesObject = 22211
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup                                               OpcuaNodeIdServicesObject = 22249
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired                                                        OpcuaNodeIdServicesObject = 22272
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState                                          OpcuaNodeIdServicesObject = 22359
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup                                           OpcuaNodeIdServicesObject = 22397
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate                                                        OpcuaNodeIdServicesObject = 22420
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState                                          OpcuaNodeIdServicesObject = 22507
	OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup                                           OpcuaNodeIdServicesObject = 22545
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired                                                          OpcuaNodeIdServicesObject = 22568
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState                                            OpcuaNodeIdServicesObject = 22655
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup                                             OpcuaNodeIdServicesObject = 22693
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate                                                          OpcuaNodeIdServicesObject = 22716
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState                                            OpcuaNodeIdServicesObject = 22803
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup                                             OpcuaNodeIdServicesObject = 22841
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired                                                                OpcuaNodeIdServicesObject = 22864
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState                                                  OpcuaNodeIdServicesObject = 22951
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup                                                   OpcuaNodeIdServicesObject = 22989
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate                                                                OpcuaNodeIdServicesObject = 23012
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState                                                  OpcuaNodeIdServicesObject = 23099
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup                                                   OpcuaNodeIdServicesObject = 23137
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired                                                            OpcuaNodeIdServicesObject = 23160
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState                                              OpcuaNodeIdServicesObject = 23247
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup                                               OpcuaNodeIdServicesObject = 23285
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate                                                            OpcuaNodeIdServicesObject = 23308
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState                                              OpcuaNodeIdServicesObject = 23395
	OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup                                               OpcuaNodeIdServicesObject = 23433
	OpcuaNodeIdServicesObject_AliasNameCategoryType_Alias_Placeholder                                                                                                   OpcuaNodeIdServicesObject = 23457
	OpcuaNodeIdServicesObject_AliasNameCategoryType_SubAliasNameCategories_Placeholder                                                                                  OpcuaNodeIdServicesObject = 23458
	OpcuaNodeIdServicesObject_Aliases                                                                                                                                   OpcuaNodeIdServicesObject = 23470
	OpcuaNodeIdServicesObject_TagVariables                                                                                                                              OpcuaNodeIdServicesObject = 23479
	OpcuaNodeIdServicesObject_Topics                                                                                                                                    OpcuaNodeIdServicesObject = 23488
	OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 23499
	OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultBinary                                                                                          OpcuaNodeIdServicesObject = 23500
	OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 23505
	OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultXml                                                                                             OpcuaNodeIdServicesObject = 23506
	OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultBinary                                                                                                   OpcuaNodeIdServicesObject = 23507
	OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 23511
	OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultJson                                                                                            OpcuaNodeIdServicesObject = 23512
	OpcuaNodeIdServicesObject_OrderedListType_OrderedObject_Placeholder                                                                                                 OpcuaNodeIdServicesObject = 23519
	OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultXml                                                                                                      OpcuaNodeIdServicesObject = 23520
	OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultJson                                                                                                     OpcuaNodeIdServicesObject = 23528
	OpcuaNodeIdServicesObject_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder                                                                      OpcuaNodeIdServicesObject = 23557
	OpcuaNodeIdServicesObject_PublishSubscribeType_SubscribedDataSets                                                                                                   OpcuaNodeIdServicesObject = 23622
	OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubCapablities                                                                                                    OpcuaNodeIdServicesObject = 23642
	OpcuaNodeIdServicesObject_PublishSubscribeType_DataSetClasses                                                                                                       OpcuaNodeIdServicesObject = 23649
	OpcuaNodeIdServicesObject_PublishSubscribe_SubscribedDataSets                                                                                                       OpcuaNodeIdServicesObject = 23658
	OpcuaNodeIdServicesObject_PublishSubscribe_PubSubCapablities                                                                                                        OpcuaNodeIdServicesObject = 23678
	OpcuaNodeIdServicesObject_PublishSubscribe_DataSetClasses                                                                                                           OpcuaNodeIdServicesObject = 23685
	OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder                                                                       OpcuaNodeIdServicesObject = 23796
	OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder                                                                   OpcuaNodeIdServicesObject = 23807
	OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet                                                 OpcuaNodeIdServicesObject = 23808
	OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetType_SubscribedDataSet                                                                                         OpcuaNodeIdServicesObject = 23829
	OpcuaNodeIdServicesObject_DatagramWriterGroupTransportType_Address                                                                                                  OpcuaNodeIdServicesObject = 23842
	OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary                                                                             OpcuaNodeIdServicesObject = 23851
	OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary                                                                                OpcuaNodeIdServicesObject = 23852
	OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 23853
	OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 23854
	OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultBinary                                                                                                        OpcuaNodeIdServicesObject = 23855
	OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultBinary                                                                                                OpcuaNodeIdServicesObject = 23856
	OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 23857
	OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 23860
	OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 23861
	OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultBinary                                                                               OpcuaNodeIdServicesObject = 23864
	OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary                                                                              OpcuaNodeIdServicesObject = 23865
	OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary                                                                             OpcuaNodeIdServicesObject = 23866
	OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml                                                                                OpcuaNodeIdServicesObject = 23919
	OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultXml                                                                                   OpcuaNodeIdServicesObject = 23920
	OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 23921
	OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 23922
	OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultXml                                                                                                           OpcuaNodeIdServicesObject = 23923
	OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultXml                                                                                                   OpcuaNodeIdServicesObject = 23924
	OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 23925
	OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 23928
	OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 23929
	OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultXml                                                                                  OpcuaNodeIdServicesObject = 23932
	OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultXml                                                                                 OpcuaNodeIdServicesObject = 23933
	OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultXml                                                                                OpcuaNodeIdServicesObject = 23934
	OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson                                                                               OpcuaNodeIdServicesObject = 23987
	OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultJson                                                                                  OpcuaNodeIdServicesObject = 23988
	OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 23989
	OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 23990
	OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultJson                                                                                                          OpcuaNodeIdServicesObject = 23991
	OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultJson                                                                                                  OpcuaNodeIdServicesObject = 23992
	OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 23993
	OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 23996
	OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 23997
	OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultJson                                                                                 OpcuaNodeIdServicesObject = 24000
	OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultJson                                                                                OpcuaNodeIdServicesObject = 24001
	OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultJson                                                                               OpcuaNodeIdServicesObject = 24002
	OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportType_Address                                                                                                OpcuaNodeIdServicesObject = 24017
	OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 24034
	OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 24038
	OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 24042
	OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultBinary                                                                                              OpcuaNodeIdServicesObject = 24108
	OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultBinary                                                                                                     OpcuaNodeIdServicesObject = 24109
	OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 24110
	OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultXml                                                                                                 OpcuaNodeIdServicesObject = 24120
	OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultXml                                                                                                        OpcuaNodeIdServicesObject = 24121
	OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 24122
	OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultJson                                                                                                OpcuaNodeIdServicesObject = 24132
	OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultJson                                                                                                       OpcuaNodeIdServicesObject = 24133
	OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 24134
	OpcuaNodeIdServicesObject_Resources                                                                                                                                 OpcuaNodeIdServicesObject = 24226
	OpcuaNodeIdServicesObject_Communication                                                                                                                             OpcuaNodeIdServicesObject = 24227
	OpcuaNodeIdServicesObject_MappingTables                                                                                                                             OpcuaNodeIdServicesObject = 24228
	OpcuaNodeIdServicesObject_NetworkInterfaces                                                                                                                         OpcuaNodeIdServicesObject = 24229
	OpcuaNodeIdServicesObject_Streams                                                                                                                                   OpcuaNodeIdServicesObject = 24230
	OpcuaNodeIdServicesObject_TalkerStreams                                                                                                                             OpcuaNodeIdServicesObject = 24231
	OpcuaNodeIdServicesObject_ListenerStreams                                                                                                                           OpcuaNodeIdServicesObject = 24232
	OpcuaNodeIdServicesObject_UserManagement                                                                                                                            OpcuaNodeIdServicesObject = 24290
	OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultBinary                                                                                             OpcuaNodeIdServicesObject = 24292
	OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultXml                                                                                                OpcuaNodeIdServicesObject = 24296
	OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultJson                                                                                               OpcuaNodeIdServicesObject = 24300
	OpcuaNodeIdServicesObject_IetfBaseNetworkInterfaceType_InterfaceName_Placeholder                                                                                    OpcuaNodeIdServicesObject = 25226
	OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 25239
	OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 25243
	OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 25247
	OpcuaNodeIdServicesObject_PubSubKeyServiceType_KeyPushTargets                                                                                                       OpcuaNodeIdServicesObject = 25277
	OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder                                                                            OpcuaNodeIdServicesObject = 25347
	OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder                                                                                  OpcuaNodeIdServicesObject = 25358
	OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubConfiguration                                                                                                  OpcuaNodeIdServicesObject = 25403
	OpcuaNodeIdServicesObject_PublishSubscribe_KeyPushTargets                                                                                                           OpcuaNodeIdServicesObject = 25440
	OpcuaNodeIdServicesObject_PublishSubscribe_PubSubConfiguration                                                                                                      OpcuaNodeIdServicesObject = 25451
	OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary                                                                               OpcuaNodeIdServicesObject = 25529
	OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultBinary                                                                                        OpcuaNodeIdServicesObject = 25530
	OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultBinary                                                                                     OpcuaNodeIdServicesObject = 25531
	OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultBinary                                                                                   OpcuaNodeIdServicesObject = 25532
	OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultXml                                                                                  OpcuaNodeIdServicesObject = 25545
	OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultXml                                                                                           OpcuaNodeIdServicesObject = 25546
	OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultXml                                                                                        OpcuaNodeIdServicesObject = 25547
	OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultXml                                                                                      OpcuaNodeIdServicesObject = 25548
	OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultJson                                                                                 OpcuaNodeIdServicesObject = 25561
	OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultJson                                                                                          OpcuaNodeIdServicesObject = 25562
	OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultJson                                                                                       OpcuaNodeIdServicesObject = 25563
	OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultJson                                                                                     OpcuaNodeIdServicesObject = 25564
	OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAdmin                                                                                                      OpcuaNodeIdServicesObject = 25565
	OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerPush                                                                                                       OpcuaNodeIdServicesObject = 25584
	OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAccess                                                                                                     OpcuaNodeIdServicesObject = 25603
	OpcuaNodeIdServicesObject_PubSubKeyPushTargetType_SecurityGroupName_Placeholder                                                                                     OpcuaNodeIdServicesObject = 25626
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder                                                                                       OpcuaNodeIdServicesObject = 26878
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups                                                                     OpcuaNodeIdServicesObject = 26879
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup                                             OpcuaNodeIdServicesObject = 26880
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList                                   OpcuaNodeIdServicesObject = 26881
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired                          OpcuaNodeIdServicesObject = 26921
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState            OpcuaNodeIdServicesObject = 27008
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup             OpcuaNodeIdServicesObject = 27052
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate                          OpcuaNodeIdServicesObject = 27087
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState            OpcuaNodeIdServicesObject = 27174
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup             OpcuaNodeIdServicesObject = 27218
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup                                                   OpcuaNodeIdServicesObject = 27252
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList                                         OpcuaNodeIdServicesObject = 27253
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired                                OpcuaNodeIdServicesObject = 27293
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState                  OpcuaNodeIdServicesObject = 27380
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup                   OpcuaNodeIdServicesObject = 27424
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate                                OpcuaNodeIdServicesObject = 27459
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState                  OpcuaNodeIdServicesObject = 27546
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup                   OpcuaNodeIdServicesObject = 27590
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup                                               OpcuaNodeIdServicesObject = 27624
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList                                     OpcuaNodeIdServicesObject = 27625
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired                            OpcuaNodeIdServicesObject = 27665
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState              OpcuaNodeIdServicesObject = 27752
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup               OpcuaNodeIdServicesObject = 27796
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate                            OpcuaNodeIdServicesObject = 27831
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState              OpcuaNodeIdServicesObject = 27918
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup               OpcuaNodeIdServicesObject = 27962
	OpcuaNodeIdServicesObject_ProvisionableDevice                                                                                                                       OpcuaNodeIdServicesObject = 29878
	OpcuaNodeIdServicesObject_Locations                                                                                                                                 OpcuaNodeIdServicesObject = 31915
	OpcuaNodeIdServicesObject_ServerConfigurationType_TransactionDiagnostics                                                                                            OpcuaNodeIdServicesObject = 32299
	OpcuaNodeIdServicesObject_ServerConfiguration_TransactionDiagnostics                                                                                                OpcuaNodeIdServicesObject = 32336
	OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics                                                                OpcuaNodeIdServicesObject = 32362
	OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 32382
	OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 32386
	OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 32390
	OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 32422
	OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 32426
	OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 32430
	OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits                                                                                                           OpcuaNodeIdServicesObject = 32452
	OpcuaNodeIdServicesObject_ServerUnitType_CoherentUnit                                                                                                               OpcuaNodeIdServicesObject = 32462
	OpcuaNodeIdServicesObject_QuantityType_ServerUnits                                                                                                                  OpcuaNodeIdServicesObject = 32481
	OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder                                                                                           OpcuaNodeIdServicesObject = 32482
	OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_AlternativeUnits                                                                          OpcuaNodeIdServicesObject = 32487
	OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit                                                                              OpcuaNodeIdServicesObject = 32497
	OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder                                                                                                 OpcuaNodeIdServicesObject = 32503
	OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder_ServerUnits                                                                                     OpcuaNodeIdServicesObject = 32509
	OpcuaNodeIdServicesObject_Quantities                                                                                                                                OpcuaNodeIdServicesObject = 32530
	OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultBinary                                                                                                 OpcuaNodeIdServicesObject = 32560
	OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultBinary                                                                                           OpcuaNodeIdServicesObject = 32561
	OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 32562
	OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultXml                                                                                                    OpcuaNodeIdServicesObject = 32572
	OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultXml                                                                                              OpcuaNodeIdServicesObject = 32573
	OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 32574
	OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultJson                                                                                                   OpcuaNodeIdServicesObject = 32584
	OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultJson                                                                                             OpcuaNodeIdServicesObject = 32585
	OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 32586
	OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits_AlternativeUnit_Placeholder                                                                               OpcuaNodeIdServicesObject = 32587
	OpcuaNodeIdServicesObject_HistoricalEventConfigurationType_EventTypes                                                                                               OpcuaNodeIdServicesObject = 32622
	OpcuaNodeIdServicesObject_DefaultHAConfiguration                                                                                                                    OpcuaNodeIdServicesObject = 32637
	OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateConfiguration                                                                                             OpcuaNodeIdServicesObject = 32638
	OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateFunctions                                                                                                 OpcuaNodeIdServicesObject = 32643
	OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultBinary                                                                                       OpcuaNodeIdServicesObject = 32661
	OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultBinary                                                                                         OpcuaNodeIdServicesObject = 32662
	OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultXml                                                                                          OpcuaNodeIdServicesObject = 32669
	OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultXml                                                                                            OpcuaNodeIdServicesObject = 32670
	OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultJson                                                                                         OpcuaNodeIdServicesObject = 32677
	OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultJson                                                                                           OpcuaNodeIdServicesObject = 32678
	OpcuaNodeIdServicesObject_DefaultHEConfiguration                                                                                                                    OpcuaNodeIdServicesObject = 32754
	OpcuaNodeIdServicesObject_DefaultHEConfiguration_EventTypes                                                                                                         OpcuaNodeIdServicesObject = 32755
	OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultBinary                                                                                                  OpcuaNodeIdServicesObject = 32800
	OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultXml                                                                                                     OpcuaNodeIdServicesObject = 32801
	OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultJson                                                                                                    OpcuaNodeIdServicesObject = 32802
	OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultBinary                                                                                               OpcuaNodeIdServicesObject = 32825
	OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultXml                                                                                                  OpcuaNodeIdServicesObject = 32829
	OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultJson                                                                                                 OpcuaNodeIdServicesObject = 32833
)

var OpcuaNodeIdServicesObjectValues []OpcuaNodeIdServicesObject

func init() {
	_ = errors.New
	OpcuaNodeIdServicesObjectValues = []OpcuaNodeIdServicesObject{
		OpcuaNodeIdServicesObject_ModellingRule_Mandatory,
		OpcuaNodeIdServicesObject_ModellingRule_Optional,
		OpcuaNodeIdServicesObject_ModellingRule_ExposesItsArray,
		OpcuaNodeIdServicesObject_RootFolder,
		OpcuaNodeIdServicesObject_ObjectsFolder,
		OpcuaNodeIdServicesObject_TypesFolder,
		OpcuaNodeIdServicesObject_ViewsFolder,
		OpcuaNodeIdServicesObject_ObjectTypesFolder,
		OpcuaNodeIdServicesObject_VariableTypesFolder,
		OpcuaNodeIdServicesObject_DataTypesFolder,
		OpcuaNodeIdServicesObject_ReferenceTypesFolder,
		OpcuaNodeIdServicesObject_XmlSchema_TypeSystem,
		OpcuaNodeIdServicesObject_OPCBinarySchema_TypeSystem,
		OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_Node_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Node_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_Argument_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Argument_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_Range_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Range_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ServerType_ServerCapabilities,
		OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics,
		OpcuaNodeIdServicesObject_ServerType_VendorServerInfo,
		OpcuaNodeIdServicesObject_ServerType_ServerRedundancy,
		OpcuaNodeIdServicesObject_ServerCapabilitiesType_ModellingRules,
		OpcuaNodeIdServicesObject_Server,
		OpcuaNodeIdServicesObject_Server_ServerCapabilities,
		OpcuaNodeIdServicesObject_Server_ServerDiagnostics,
		OpcuaNodeIdServicesObject_Server_VendorServerInfo,
		OpcuaNodeIdServicesObject_Server_ServerRedundancy,
		OpcuaNodeIdServicesObject_AggregateFunction_Interpolative,
		OpcuaNodeIdServicesObject_AggregateFunction_Average,
		OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage,
		OpcuaNodeIdServicesObject_AggregateFunction_Total,
		OpcuaNodeIdServicesObject_AggregateFunction_Minimum,
		OpcuaNodeIdServicesObject_AggregateFunction_Maximum,
		OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime,
		OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime,
		OpcuaNodeIdServicesObject_AggregateFunction_Range,
		OpcuaNodeIdServicesObject_AggregateFunction_AnnotationCount,
		OpcuaNodeIdServicesObject_AggregateFunction_Count,
		OpcuaNodeIdServicesObject_AggregateFunction_NumberOfTransitions,
		OpcuaNodeIdServicesObject_AggregateFunction_Start,
		OpcuaNodeIdServicesObject_AggregateFunction_End,
		OpcuaNodeIdServicesObject_AggregateFunction_Delta,
		OpcuaNodeIdServicesObject_AggregateFunction_DurationGood,
		OpcuaNodeIdServicesObject_AggregateFunction_DurationBad,
		OpcuaNodeIdServicesObject_AggregateFunction_PercentGood,
		OpcuaNodeIdServicesObject_AggregateFunction_PercentBad,
		OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_Ready,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_Running,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_Suspended,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_Halted,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_HaltedToReady,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToRunning,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToHalted,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToReady,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToSuspended,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToRunning,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToHalted,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToReady,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToHalted,
		OpcuaNodeIdServicesObject_ServerDiagnosticsType_SessionsDiagnosticsSummary,
		OpcuaNodeIdServicesObject_ServerCapabilitiesType_AggregateFunctions,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_Unshelved,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelved,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelved,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToTimedShelved,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToOneShotShelved,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToUnshelved,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToOneShotShelved,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToUnshelved,
		OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToTimedShelved,
		OpcuaNodeIdServicesObject_Server_ServerCapabilities_ModellingRules,
		OpcuaNodeIdServicesObject_Server_ServerCapabilities_AggregateFunctions,
		OpcuaNodeIdServicesObject_EventTypesFolder,
		OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateConfiguration,
		OpcuaNodeIdServicesObject_DefaultBinary,
		OpcuaNodeIdServicesObject_DefaultXml,
		OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_ModellingRules,
		OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_AggregateFunctions,
		OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary,
		OpcuaNodeIdServicesObject_Server_ServerDiagnostics_SessionsDiagnosticsSummary,
		OpcuaNodeIdServicesObject_ProgramStateMachineType_FinalResultData,
		OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AlarmConditionType_ShelvingState,
		OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighHigh,
		OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_High,
		OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_Low,
		OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowLow,
		OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowLowToLow,
		OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowToLowLow,
		OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighHighToHigh,
		OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighToHighHigh,
		OpcuaNodeIdServicesObject_ExclusiveLimitAlarmType_LimitState,
		OpcuaNodeIdServicesObject_HistoryServerCapabilitiesType_AggregateFunctions,
		OpcuaNodeIdServicesObject_HistoryServerCapabilities,
		OpcuaNodeIdServicesObject_HistoryServerCapabilities_AggregateFunctions,
		OpcuaNodeIdServicesObject_HAConfiguration,
		OpcuaNodeIdServicesObject_HAConfiguration_AggregateConfiguration,
		OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage2,
		OpcuaNodeIdServicesObject_AggregateFunction_Minimum2,
		OpcuaNodeIdServicesObject_AggregateFunction_Maximum2,
		OpcuaNodeIdServicesObject_AggregateFunction_Range2,
		OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality2,
		OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AggregateFunction_Total2,
		OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime2,
		OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime2,
		OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateZero,
		OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateNonZero,
		OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationSample,
		OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationPopulation,
		OpcuaNodeIdServicesObject_AggregateFunction_VarianceSample,
		OpcuaNodeIdServicesObject_AggregateFunction_VariancePopulation,
		OpcuaNodeIdServicesObject_AggregateFunction_StartBound,
		OpcuaNodeIdServicesObject_AggregateFunction_EndBound,
		OpcuaNodeIdServicesObject_AggregateFunction_DeltaBounds,
		OpcuaNodeIdServicesObject_ModellingRule_OptionalPlaceholder,
		OpcuaNodeIdServicesObject_ModellingRule_MandatoryPlaceholder,
		OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_OperationLimits,
		OpcuaNodeIdServicesObject_ServerType_Namespaces,
		OpcuaNodeIdServicesObject_ServerCapabilitiesType_OperationLimits,
		OpcuaNodeIdServicesObject_NamespaceMetadataType_NamespaceFile,
		OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder,
		OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile,
		OpcuaNodeIdServicesObject_Server_ServerCapabilities_OperationLimits,
		OpcuaNodeIdServicesObject_Server_Namespaces,
		OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateFunctions,
		OpcuaNodeIdServicesObject_HAConfiguration_AggregateFunctions,
		OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_XVType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_XVType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SessionsDiagnosticsSummaryType_ClientName_Placeholder,
		OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ServerConfiguration,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList,
		OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Union_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_Union_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_FileDirectoryType_FileDirectoryName_Placeholder,
		OpcuaNodeIdServicesObject_FileDirectoryType_FileName_Placeholder,
		OpcuaNodeIdServicesObject_CertificateGroupType_TrustList,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustList,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustList,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup,
		OpcuaNodeIdServicesObject_PubSubConnectionType_Address,
		OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder,
		OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Status,
		OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Address,
		OpcuaNodeIdServicesObject_PublishSubscribeType_PublishedDataSets,
		OpcuaNodeIdServicesObject_PublishSubscribe,
		OpcuaNodeIdServicesObject_DataSetFolderType_DataSetFolderName_Placeholder,
		OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder,
		OpcuaNodeIdServicesObject_PubSubConnectionType_Status,
		OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Node_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DatagramConnectionTransportType_DiscoveryAddress,
		OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Argument_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Union_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder,
		OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Status,
		OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings,
		OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubGroupType_Status,
		OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetWriterType_Status,
		OpcuaNodeIdServicesObject_DataSetWriterType_TransportSettings,
		OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetReaderType_Status,
		OpcuaNodeIdServicesObject_DataSetReaderType_TransportSettings,
		OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetReaderType_SubscribedDataSet,
		OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Range_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_XVType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishSubscribe_SecurityGroups,
		OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder,
		OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupName_Placeholder,
		OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields,
		OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishedDataSetType_ExtensionFields,
		OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ServerConfigurationType_ConfigurationFile,
		OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Server_ServerCapabilities_RoleSet,
		OpcuaNodeIdServicesObject_RoleSetType_RoleName_Placeholder,
		OpcuaNodeIdServicesObject_WellKnownRole_Anonymous,
		OpcuaNodeIdServicesObject_WellKnownRole_AuthenticatedUser,
		OpcuaNodeIdServicesObject_WellKnownRole_Observer,
		OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WellKnownRole_Operator,
		OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WellKnownRole_Supervisor,
		OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WellKnownRole_SecurityAdmin,
		OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WellKnownRole_ConfigureAdmin,
		OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TemporaryFileTransferType_TransferState_Placeholder,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_Idle,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepare,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransfer,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWrite,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_Error,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToReadPrepare,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToReadTransfer,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToIdle,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToApplyWrite,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToIdle,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToError,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToError,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToError,
		OpcuaNodeIdServicesObject_FileTransferStateMachineType_ErrorToIdle,
		OpcuaNodeIdServicesObject_PublishSubscribeType_Status,
		OpcuaNodeIdServicesObject_ServerConfiguration_ConfigurationFile,
		OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_TransportSettings,
		OpcuaNodeIdServicesObject_PubSubKeyServiceType_SecurityGroups,
		OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_OPCUANamespaceMetadata,
		OpcuaNodeIdServicesObject_OPCUANamespaceMetadata_NamespaceFile,
		OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_WellKnownRole_Engineer,
		OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_RoleSet,
		OpcuaNodeIdServicesObject_ServerCapabilitiesType_RoleSet,
		OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_FileSystem,
		OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile,
		OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AlarmConditionType_FirstInGroup,
		OpcuaNodeIdServicesObject_AlarmConditionType_AlarmGroup_Placeholder,
		OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder,
		OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState,
		OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup,
		OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder,
		OpcuaNodeIdServicesObject_ManagedApplications,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_PubSubConnectionType_TransportSettings,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_TransportSettings,
		OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_MessageSettings,
		OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_TransportSettings,
		OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_MessageSettings,
		OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder,
		OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Status,
		OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder,
		OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Status,
		OpcuaNodeIdServicesObject_PublishSubscribe_PublishedDataSets,
		OpcuaNodeIdServicesObject_PublishSubscribe_Status,
		OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics,
		OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_KeyCredentialConfigurationFolderType_ServiceName_Placeholder,
		OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DictionaryEntryType_DictionaryEntryName_Placeholder,
		OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryFolderName_Placeholder,
		OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryEntryName_Placeholder,
		OpcuaNodeIdServicesObject_Dictionaries,
		OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_InterfaceTypes,
		OpcuaNodeIdServicesObject_AuthorizationServices,
		OpcuaNodeIdServicesObject_WriterGroupType_TransportSettings,
		OpcuaNodeIdServicesObject_WriterGroupType_MessageSettings,
		OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder,
		OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_TransportSettings,
		OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_MessageSettings,
		OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Status,
		OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics,
		OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics,
		OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder,
		OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_TransportSettings,
		OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_MessageSettings,
		OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Status,
		OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics,
		OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_KeyCredentialConfiguration,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_TransactionDiagnostics,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile,
		OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_WellKnownRole_TrustedApplication,
		OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics,
		OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics,
		OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_Vector_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_Frame_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Vector_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_Frame_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics,
		OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_LLDP,
		OpcuaNodeIdServicesObject_LLDP_RemoteStatistics,
		OpcuaNodeIdServicesObject_LLDP_LocalSystemData,
		OpcuaNodeIdServicesObject_LLDP_Ports,
		OpcuaNodeIdServicesObject_LldpInformationType_RemoteStatistics,
		OpcuaNodeIdServicesObject_LldpInformationType_LocalSystemData,
		OpcuaNodeIdServicesObject_LldpInformationType_Ports,
		OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder,
		OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder_RemoteSystemsData,
		OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData,
		OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder,
		OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Vector_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Frame_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics,
		OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics,
		OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics,
		OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServerLog,
		OpcuaNodeIdServicesObject_Logs,
		OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials,
		OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_AuthorizationServices,
		OpcuaNodeIdServicesObject_ApplicationConfigurationType_KeyCredentials,
		OpcuaNodeIdServicesObject_ApplicationConfigurationType_AuthorizationServices,
		OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired,
		OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics,
		OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics,
		OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsType_Counters,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsType_LiveValues,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_AuthorizationServices,
		OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsRootType_LiveValues,
		OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsConnectionType_LiveValues,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_Counters,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_LiveValues,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_Counters,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_LiveValues,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_Counters,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_LiveValues,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_Counters,
		OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_LiveValues,
		OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet,
		OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics,
		OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_Counters,
		OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_LiveValues,
		OpcuaNodeIdServicesObject_ReaderGroupType_TransportSettings,
		OpcuaNodeIdServicesObject_ReaderGroupType_MessageSettings,
		OpcuaNodeIdServicesObject_DataSetWriterType_MessageSettings,
		OpcuaNodeIdServicesObject_DataSetReaderType_MessageSettings,
		OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_AliasNameCategoryType_Alias_Placeholder,
		OpcuaNodeIdServicesObject_AliasNameCategoryType_SubAliasNameCategories_Placeholder,
		OpcuaNodeIdServicesObject_Aliases,
		OpcuaNodeIdServicesObject_TagVariables,
		OpcuaNodeIdServicesObject_Topics,
		OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_OrderedListType_OrderedObject_Placeholder,
		OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder,
		OpcuaNodeIdServicesObject_PublishSubscribeType_SubscribedDataSets,
		OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubCapablities,
		OpcuaNodeIdServicesObject_PublishSubscribeType_DataSetClasses,
		OpcuaNodeIdServicesObject_PublishSubscribe_SubscribedDataSets,
		OpcuaNodeIdServicesObject_PublishSubscribe_PubSubCapablities,
		OpcuaNodeIdServicesObject_PublishSubscribe_DataSetClasses,
		OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder,
		OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder,
		OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet,
		OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetType_SubscribedDataSet,
		OpcuaNodeIdServicesObject_DatagramWriterGroupTransportType_Address,
		OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportType_Address,
		OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_Resources,
		OpcuaNodeIdServicesObject_Communication,
		OpcuaNodeIdServicesObject_MappingTables,
		OpcuaNodeIdServicesObject_NetworkInterfaces,
		OpcuaNodeIdServicesObject_Streams,
		OpcuaNodeIdServicesObject_TalkerStreams,
		OpcuaNodeIdServicesObject_ListenerStreams,
		OpcuaNodeIdServicesObject_UserManagement,
		OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_IetfBaseNetworkInterfaceType_InterfaceName_Placeholder,
		OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubKeyServiceType_KeyPushTargets,
		OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder,
		OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder,
		OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubConfiguration,
		OpcuaNodeIdServicesObject_PublishSubscribe_KeyPushTargets,
		OpcuaNodeIdServicesObject_PublishSubscribe_PubSubConfiguration,
		OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAdmin,
		OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerPush,
		OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAccess,
		OpcuaNodeIdServicesObject_PubSubKeyPushTargetType_SecurityGroupName_Placeholder,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup,
		OpcuaNodeIdServicesObject_ProvisionableDevice,
		OpcuaNodeIdServicesObject_Locations,
		OpcuaNodeIdServicesObject_ServerConfigurationType_TransactionDiagnostics,
		OpcuaNodeIdServicesObject_ServerConfiguration_TransactionDiagnostics,
		OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics,
		OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits,
		OpcuaNodeIdServicesObject_ServerUnitType_CoherentUnit,
		OpcuaNodeIdServicesObject_QuantityType_ServerUnits,
		OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder,
		OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_AlternativeUnits,
		OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit,
		OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder,
		OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder_ServerUnits,
		OpcuaNodeIdServicesObject_Quantities,
		OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits_AlternativeUnit_Placeholder,
		OpcuaNodeIdServicesObject_HistoricalEventConfigurationType_EventTypes,
		OpcuaNodeIdServicesObject_DefaultHAConfiguration,
		OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateConfiguration,
		OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateFunctions,
		OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_DefaultHEConfiguration,
		OpcuaNodeIdServicesObject_DefaultHEConfiguration_EventTypes,
		OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultJson,
		OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultBinary,
		OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultXml,
		OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultJson,
	}
}

func OpcuaNodeIdServicesObjectByValue(value int32) (enum OpcuaNodeIdServicesObject, ok bool) {
	switch value {
	case 11172:
		return OpcuaNodeIdServicesObject_HistoryServerCapabilitiesType_AggregateFunctions, true
	case 11192:
		return OpcuaNodeIdServicesObject_HistoryServerCapabilities, true
	case 11201:
		return OpcuaNodeIdServicesObject_HistoryServerCapabilities_AggregateFunctions, true
	case 11202:
		return OpcuaNodeIdServicesObject_HAConfiguration, true
	case 11203:
		return OpcuaNodeIdServicesObject_HAConfiguration_AggregateConfiguration, true
	case 11218:
		return OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultXml, true
	case 11219:
		return OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultXml, true
	case 11226:
		return OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultBinary, true
	case 11227:
		return OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultBinary, true
	case 11285:
		return OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage2, true
	case 11286:
		return OpcuaNodeIdServicesObject_AggregateFunction_Minimum2, true
	case 11287:
		return OpcuaNodeIdServicesObject_AggregateFunction_Maximum2, true
	case 11288:
		return OpcuaNodeIdServicesObject_AggregateFunction_Range2, true
	case 11292:
		return OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality2, true
	case 11296:
		return OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultXml, true
	case 11300:
		return OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultBinary, true
	case 11304:
		return OpcuaNodeIdServicesObject_AggregateFunction_Total2, true
	case 11305:
		return OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime2, true
	case 11306:
		return OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime2, true
	case 11307:
		return OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateZero, true
	case 11308:
		return OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateNonZero, true
	case 11426:
		return OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationSample, true
	case 11427:
		return OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationPopulation, true
	case 11428:
		return OpcuaNodeIdServicesObject_AggregateFunction_VarianceSample, true
	case 11429:
		return OpcuaNodeIdServicesObject_AggregateFunction_VariancePopulation, true
	case 11505:
		return OpcuaNodeIdServicesObject_AggregateFunction_StartBound, true
	case 11506:
		return OpcuaNodeIdServicesObject_AggregateFunction_EndBound, true
	case 11507:
		return OpcuaNodeIdServicesObject_AggregateFunction_DeltaBounds, true
	case 11508:
		return OpcuaNodeIdServicesObject_ModellingRule_OptionalPlaceholder, true
	case 11510:
		return OpcuaNodeIdServicesObject_ModellingRule_MandatoryPlaceholder, true
	case 11516:
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_OperationLimits, true
	case 11527:
		return OpcuaNodeIdServicesObject_ServerType_Namespaces, true
	case 11551:
		return OpcuaNodeIdServicesObject_ServerCapabilitiesType_OperationLimits, true
	case 11624:
		return OpcuaNodeIdServicesObject_NamespaceMetadataType_NamespaceFile, true
	case 11646:
		return OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder, true
	case 11654:
		return OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile, true
	case 11704:
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities_OperationLimits, true
	case 11715:
		return OpcuaNodeIdServicesObject_Server_Namespaces, true
	case 11876:
		return OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateFunctions, true
	case 11877:
		return OpcuaNodeIdServicesObject_HAConfiguration_AggregateFunctions, true
	case 11887:
		return OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultXml, true
	case 11888:
		return OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultXml, true
	case 11889:
		return OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultBinary, true
	case 11890:
		return OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultBinary, true
	case 11949:
		return OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultXml, true
	case 11950:
		return OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultXml, true
	case 11957:
		return OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultBinary, true
	case 11958:
		return OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultBinary, true
	case 12081:
		return OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultXml, true
	case 12082:
		return OpcuaNodeIdServicesObject_XVType_Encoding_DefaultXml, true
	case 12089:
		return OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultBinary, true
	case 12090:
		return OpcuaNodeIdServicesObject_XVType_Encoding_DefaultBinary, true
	case 12097:
		return OpcuaNodeIdServicesObject_SessionsDiagnosticsSummaryType_ClientName_Placeholder, true
	case 121:
		return OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultBinary, true
	case 12173:
		return OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultXml, true
	case 12174:
		return OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultXml, true
	case 12181:
		return OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultBinary, true
	case 12182:
		return OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultBinary, true
	case 12195:
		return OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultXml, true
	case 12196:
		return OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultXml, true
	case 12197:
		return OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultXml, true
	case 12199:
		return OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultXml, true
	case 122:
		return OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultBinary, true
	case 12200:
		return OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultXml, true
	case 12207:
		return OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultBinary, true
	case 12208:
		return OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultBinary, true
	case 12209:
		return OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultBinary, true
	case 12211:
		return OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultBinary, true
	case 12212:
		return OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultBinary, true
	case 123:
		return OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultBinary, true
	case 124:
		return OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultBinary, true
	case 125:
		return OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultBinary, true
	case 126:
		return OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultBinary, true
	case 12637:
		return OpcuaNodeIdServicesObject_ServerConfiguration, true
	case 12642:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList, true
	case 12676:
		return OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultXml, true
	case 12680:
		return OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultBinary, true
	case 127:
		return OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultBinary, true
	case 12757:
		return OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultXml, true
	case 12758:
		return OpcuaNodeIdServicesObject_Union_Encoding_DefaultXml, true
	case 12765:
		return OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultBinary, true
	case 12766:
		return OpcuaNodeIdServicesObject_Union_Encoding_DefaultBinary, true
	case 128:
		return OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultBinary, true
	case 12892:
		return OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultXml, true
	case 12893:
		return OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultXml, true
	case 12900:
		return OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultBinary, true
	case 12901:
		return OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultBinary, true
	case 13354:
		return OpcuaNodeIdServicesObject_FileDirectoryType_FileDirectoryName_Placeholder, true
	case 13366:
		return OpcuaNodeIdServicesObject_FileDirectoryType_FileName_Placeholder, true
	case 13599:
		return OpcuaNodeIdServicesObject_CertificateGroupType_TrustList, true
	case 13814:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup, true
	case 13815:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustList, true
	case 13848:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup, true
	case 13849:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustList, true
	case 13882:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup, true
	case 13883:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList, true
	case 13916:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder, true
	case 13917:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList, true
	case 13950:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups, true
	case 13951:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup, true
	case 13952:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList, true
	case 13985:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup, true
	case 13986:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList, true
	case 14019:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup, true
	case 14020:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList, true
	case 14053:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups, true
	case 14088:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup, true
	case 14089:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList, true
	case 14122:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup, true
	case 14123:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList, true
	case 14156:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup, true
	case 14221:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Address, true
	case 14319:
		return OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultXml, true
	case 14323:
		return OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultBinary, true
	case 14417:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder, true
	case 14419:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Status, true
	case 14423:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Address, true
	case 14434:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_PublishedDataSets, true
	case 14443:
		return OpcuaNodeIdServicesObject_PublishSubscribe, true
	case 14478:
		return OpcuaNodeIdServicesObject_DataSetFolderType_DataSetFolderName_Placeholder, true
	case 14487:
		return OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder, true
	case 14600:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Status, true
	case 14794:
		return OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultXml, true
	case 14795:
		return OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultXml, true
	case 14796:
		return OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultXml, true
	case 14797:
		return OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultXml, true
	case 14798:
		return OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultXml, true
	case 14799:
		return OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultXml, true
	case 14800:
		return OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultXml, true
	case 14801:
		return OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultXml, true
	case 14802:
		return OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultXml, true
	case 14803:
		return OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultXml, true
	case 14804:
		return OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultXml, true
	case 14839:
		return OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultBinary, true
	case 14844:
		return OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultBinary, true
	case 14845:
		return OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultBinary, true
	case 14846:
		return OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultBinary, true
	case 14847:
		return OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultBinary, true
	case 14848:
		return OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultBinary, true
	case 15024:
		return OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultBinary, true
	case 15025:
		return OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultBinary, true
	case 15026:
		return OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultBinary, true
	case 15041:
		return OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultJson, true
	case 15042:
		return OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultJson, true
	case 15044:
		return OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultJson, true
	case 15045:
		return OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultJson, true
	case 15049:
		return OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultJson, true
	case 15050:
		return OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultJson, true
	case 15051:
		return OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultJson, true
	case 15057:
		return OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultJson, true
	case 15058:
		return OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultJson, true
	case 15059:
		return OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultJson, true
	case 15060:
		return OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultJson, true
	case 15061:
		return OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultJson, true
	case 15062:
		return OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultJson, true
	case 15063:
		return OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultJson, true
	case 15065:
		return OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultJson, true
	case 15066:
		return OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultJson, true
	case 15067:
		return OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultJson, true
	case 15068:
		return OpcuaNodeIdServicesObject_Node_Encoding_DefaultJson, true
	case 15069:
		return OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultJson, true
	case 15070:
		return OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultJson, true
	case 15071:
		return OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultJson, true
	case 15072:
		return OpcuaNodeIdServicesObject_DatagramConnectionTransportType_DiscoveryAddress, true
	case 15073:
		return OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultJson, true
	case 15074:
		return OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultJson, true
	case 15075:
		return OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultJson, true
	case 15076:
		return OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultJson, true
	case 15077:
		return OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultJson, true
	case 15078:
		return OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultJson, true
	case 15079:
		return OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultJson, true
	case 15080:
		return OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultJson, true
	case 15081:
		return OpcuaNodeIdServicesObject_Argument_Encoding_DefaultJson, true
	case 15082:
		return OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultJson, true
	case 15083:
		return OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultJson, true
	case 15084:
		return OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultJson, true
	case 15085:
		return OpcuaNodeIdServicesObject_Union_Encoding_DefaultJson, true
	case 15086:
		return OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultJson, true
	case 15087:
		return OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultJson, true
	case 15088:
		return OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultJson, true
	case 15089:
		return OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultJson, true
	case 15090:
		return OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultJson, true
	case 15091:
		return OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultJson, true
	case 15092:
		return OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultJson, true
	case 15093:
		return OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultJson, true
	case 15094:
		return OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultJson, true
	case 15095:
		return OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultJson, true
	case 15096:
		return OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultJson, true
	case 15097:
		return OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultJson, true
	case 15098:
		return OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultJson, true
	case 15099:
		return OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultJson, true
	case 15100:
		return OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultJson, true
	case 15101:
		return OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultJson, true
	case 15102:
		return OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultJson, true
	case 15103:
		return OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultJson, true
	case 15104:
		return OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultJson, true
	case 15105:
		return OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultJson, true
	case 15106:
		return OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultJson, true
	case 15107:
		return OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultJson, true
	case 15130:
		return OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultJson, true
	case 15131:
		return OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultJson, true
	case 15132:
		return OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultJson, true
	case 15133:
		return OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultJson, true
	case 15134:
		return OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultJson, true
	case 15135:
		return OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultJson, true
	case 15136:
		return OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultJson, true
	case 15137:
		return OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultJson, true
	case 15138:
		return OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultJson, true
	case 15139:
		return OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultJson, true
	case 15140:
		return OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultJson, true
	case 15141:
		return OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultJson, true
	case 15142:
		return OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultJson, true
	case 15143:
		return OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultJson, true
	case 15144:
		return OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultJson, true
	case 15145:
		return OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultJson, true
	case 15146:
		return OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultJson, true
	case 15147:
		return OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultJson, true
	case 15148:
		return OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultJson, true
	case 15149:
		return OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultJson, true
	case 15150:
		return OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultJson, true
	case 15151:
		return OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultJson, true
	case 15152:
		return OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultJson, true
	case 15153:
		return OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultJson, true
	case 15157:
		return OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultJson, true
	case 15158:
		return OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultJson, true
	case 15159:
		return OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultJson, true
	case 15160:
		return OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultJson, true
	case 15161:
		return OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultJson, true
	case 15162:
		return OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultJson, true
	case 15163:
		return OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultJson, true
	case 15164:
		return OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultJson, true
	case 15165:
		return OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultJson, true
	case 15166:
		return OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultJson, true
	case 15167:
		return OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultJson, true
	case 15168:
		return OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultJson, true
	case 15169:
		return OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultJson, true
	case 15170:
		return OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultJson, true
	case 15171:
		return OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultJson, true
	case 15172:
		return OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultJson, true
	case 15173:
		return OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultJson, true
	case 15174:
		return OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultJson, true
	case 15175:
		return OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultJson, true
	case 15176:
		return OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultJson, true
	case 15177:
		return OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultJson, true
	case 15179:
		return OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultJson, true
	case 15180:
		return OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultJson, true
	case 15182:
		return OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultJson, true
	case 15183:
		return OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultJson, true
	case 15184:
		return OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultJson, true
	case 15185:
		return OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultJson, true
	case 15186:
		return OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultJson, true
	case 15187:
		return OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultJson, true
	case 15188:
		return OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultJson, true
	case 15189:
		return OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultJson, true
	case 15190:
		return OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultJson, true
	case 15191:
		return OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultJson, true
	case 15192:
		return OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultJson, true
	case 15193:
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson, true
	case 15194:
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson, true
	case 15195:
		return OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultJson, true
	case 15196:
		return OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultJson, true
	case 15197:
		return OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultJson, true
	case 15198:
		return OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultJson, true
	case 15199:
		return OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultJson, true
	case 15200:
		return OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultJson, true
	case 15201:
		return OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultJson, true
	case 15202:
		return OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultJson, true
	case 15203:
		return OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultJson, true
	case 15204:
		return OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultJson, true
	case 15205:
		return OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultJson, true
	case 15206:
		return OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultJson, true
	case 15207:
		return OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultJson, true
	case 15208:
		return OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultJson, true
	case 15209:
		return OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultJson, true
	case 15210:
		return OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultJson, true
	case 15211:
		return OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultJson, true
	case 15222:
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder, true
	case 15223:
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Status, true
	case 15227:
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings, true
	case 15228:
		return OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultJson, true
	case 15232:
		return OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultXml, true
	case 15233:
		return OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultXml, true
	case 15234:
		return OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultXml, true
	case 15236:
		return OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultJson, true
	case 15244:
		return OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultJson, true
	case 15252:
		return OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultJson, true
	case 15254:
		return OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultJson, true
	case 15255:
		return OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultJson, true
	case 15256:
		return OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultJson, true
	case 15257:
		return OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultJson, true
	case 15258:
		return OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultJson, true
	case 15259:
		return OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultJson, true
	case 15260:
		return OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultJson, true
	case 15261:
		return OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultJson, true
	case 15262:
		return OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultJson, true
	case 15263:
		return OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultJson, true
	case 15264:
		return OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultJson, true
	case 15265:
		return OpcuaNodeIdServicesObject_PubSubGroupType_Status, true
	case 15269:
		return OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultJson, true
	case 15270:
		return OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultJson, true
	case 15271:
		return OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultJson, true
	case 15272:
		return OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultJson, true
	case 15273:
		return OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultJson, true
	case 15274:
		return OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultJson, true
	case 15275:
		return OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultJson, true
	case 15276:
		return OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultJson, true
	case 15277:
		return OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultJson, true
	case 15278:
		return OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultJson, true
	case 15279:
		return OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultJson, true
	case 15280:
		return OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultJson, true
	case 15281:
		return OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultJson, true
	case 15282:
		return OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultJson, true
	case 15283:
		return OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultJson, true
	case 15284:
		return OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultJson, true
	case 15285:
		return OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultJson, true
	case 15286:
		return OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultJson, true
	case 15287:
		return OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultJson, true
	case 15288:
		return OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultJson, true
	case 15289:
		return OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultJson, true
	case 15290:
		return OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultJson, true
	case 15291:
		return OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultJson, true
	case 15292:
		return OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultJson, true
	case 15293:
		return OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultJson, true
	case 15294:
		return OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultJson, true
	case 15295:
		return OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultJson, true
	case 15299:
		return OpcuaNodeIdServicesObject_DataSetWriterType_Status, true
	case 15303:
		return OpcuaNodeIdServicesObject_DataSetWriterType_TransportSettings, true
	case 15304:
		return OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultJson, true
	case 15307:
		return OpcuaNodeIdServicesObject_DataSetReaderType_Status, true
	case 15311:
		return OpcuaNodeIdServicesObject_DataSetReaderType_TransportSettings, true
	case 15312:
		return OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultJson, true
	case 15313:
		return OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultJson, true
	case 15314:
		return OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultJson, true
	case 15315:
		return OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultJson, true
	case 15316:
		return OpcuaNodeIdServicesObject_DataSetReaderType_SubscribedDataSet, true
	case 15320:
		return OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultJson, true
	case 15321:
		return OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultJson, true
	case 15322:
		return OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultJson, true
	case 15323:
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultJson, true
	case 15324:
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultJson, true
	case 15325:
		return OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultJson, true
	case 15326:
		return OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultJson, true
	case 15327:
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultJson, true
	case 15328:
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultJson, true
	case 15329:
		return OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultJson, true
	case 15331:
		return OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultJson, true
	case 15332:
		return OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultJson, true
	case 15333:
		return OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultJson, true
	case 15335:
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultJson, true
	case 15336:
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultJson, true
	case 15337:
		return OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultJson, true
	case 15338:
		return OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultJson, true
	case 15339:
		return OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultJson, true
	case 15340:
		return OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultJson, true
	case 15341:
		return OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultJson, true
	case 15342:
		return OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultJson, true
	case 15343:
		return OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultJson, true
	case 15344:
		return OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultJson, true
	case 15345:
		return OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultJson, true
	case 15346:
		return OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultJson, true
	case 15347:
		return OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultJson, true
	case 15348:
		return OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultJson, true
	case 15349:
		return OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultJson, true
	case 15350:
		return OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultJson, true
	case 15351:
		return OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultJson, true
	case 15352:
		return OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultJson, true
	case 15353:
		return OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultJson, true
	case 15354:
		return OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultJson, true
	case 15355:
		return OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultJson, true
	case 15356:
		return OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultJson, true
	case 15357:
		return OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultJson, true
	case 15358:
		return OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultJson, true
	case 15359:
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultJson, true
	case 15360:
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultJson, true
	case 15361:
		return OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultJson, true
	case 15362:
		return OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultJson, true
	case 15363:
		return OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultJson, true
	case 15364:
		return OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultJson, true
	case 15365:
		return OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson, true
	case 15366:
		return OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultJson, true
	case 15367:
		return OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultJson, true
	case 15368:
		return OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultJson, true
	case 15369:
		return OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultJson, true
	case 15370:
		return OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultJson, true
	case 15371:
		return OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultJson, true
	case 15372:
		return OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultJson, true
	case 15373:
		return OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultJson, true
	case 15374:
		return OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultJson, true
	case 15375:
		return OpcuaNodeIdServicesObject_Range_Encoding_DefaultJson, true
	case 15376:
		return OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultJson, true
	case 15377:
		return OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultJson, true
	case 15378:
		return OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultJson, true
	case 15379:
		return OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultJson, true
	case 15380:
		return OpcuaNodeIdServicesObject_XVType_Encoding_DefaultJson, true
	case 15381:
		return OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultJson, true
	case 15382:
		return OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultJson, true
	case 15396:
		return OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultJson, true
	case 15397:
		return OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultJson, true
	case 15398:
		return OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultJson, true
	case 15401:
		return OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultBinary, true
	case 15402:
		return OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultBinary, true
	case 15403:
		return OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultXml, true
	case 15404:
		return OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultXml, true
	case 15405:
		return OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultJson, true
	case 15421:
		return OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultBinary, true
	case 15422:
		return OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultBinary, true
	case 15431:
		return OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultJson, true
	case 15443:
		return OpcuaNodeIdServicesObject_PublishSubscribe_SecurityGroups, true
	case 15453:
		return OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder, true
	case 15459:
		return OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupName_Placeholder, true
	case 15473:
		return OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields, true
	case 15479:
		return OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultBinary, true
	case 15481:
		return OpcuaNodeIdServicesObject_PublishedDataSetType_ExtensionFields, true
	case 15529:
		return OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultXml, true
	case 15531:
		return OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultXml, true
	case 15564:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_ConfigurationFile, true
	case 15579:
		return OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultXml, true
	case 15589:
		return OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultXml, true
	case 15590:
		return OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultXml, true
	case 15606:
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities_RoleSet, true
	case 15608:
		return OpcuaNodeIdServicesObject_RoleSetType_RoleName_Placeholder, true
	case 15644:
		return OpcuaNodeIdServicesObject_WellKnownRole_Anonymous, true
	case 15656:
		return OpcuaNodeIdServicesObject_WellKnownRole_AuthenticatedUser, true
	case 15668:
		return OpcuaNodeIdServicesObject_WellKnownRole_Observer, true
	case 15671:
		return OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultBinary, true
	case 15676:
		return OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultBinary, true
	case 15677:
		return OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultBinary, true
	case 15678:
		return OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultBinary, true
	case 15679:
		return OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultBinary, true
	case 15680:
		return OpcuaNodeIdServicesObject_WellKnownRole_Operator, true
	case 15681:
		return OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultBinary, true
	case 15682:
		return OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultBinary, true
	case 15683:
		return OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultBinary, true
	case 15688:
		return OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultBinary, true
	case 15689:
		return OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultBinary, true
	case 15691:
		return OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultBinary, true
	case 15692:
		return OpcuaNodeIdServicesObject_WellKnownRole_Supervisor, true
	case 15693:
		return OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultBinary, true
	case 15694:
		return OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultBinary, true
	case 15695:
		return OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultBinary, true
	case 15700:
		return OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultJson, true
	case 15701:
		return OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultBinary, true
	case 15702:
		return OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultBinary, true
	case 15703:
		return OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultBinary, true
	case 15704:
		return OpcuaNodeIdServicesObject_WellKnownRole_SecurityAdmin, true
	case 15705:
		return OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultBinary, true
	case 15706:
		return OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultBinary, true
	case 15707:
		return OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultBinary, true
	case 15712:
		return OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultBinary, true
	case 15713:
		return OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultBinary, true
	case 15714:
		return OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultJson, true
	case 15715:
		return OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultBinary, true
	case 15716:
		return OpcuaNodeIdServicesObject_WellKnownRole_ConfigureAdmin, true
	case 15717:
		return OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultBinary, true
	case 15718:
		return OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultBinary, true
	case 15719:
		return OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultBinary, true
	case 15724:
		return OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultBinary, true
	case 15725:
		return OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultBinary, true
	case 15726:
		return OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultJson, true
	case 15727:
		return OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultBinary, true
	case 15728:
		return OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultXml, true
	case 15729:
		return OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary, true
	case 15733:
		return OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary, true
	case 15736:
		return OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultBinary, true
	case 15754:
		return OpcuaNodeIdServicesObject_TemporaryFileTransferType_TransferState_Placeholder, true
	case 15815:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_Idle, true
	case 15817:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepare, true
	case 15819:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransfer, true
	case 15821:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWrite, true
	case 15823:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_Error, true
	case 15825:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToReadPrepare, true
	case 15827:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToReadTransfer, true
	case 15829:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToIdle, true
	case 15831:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToApplyWrite, true
	case 15833:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToIdle, true
	case 15835:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToError, true
	case 15837:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToError, true
	case 15839:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToError, true
	case 15841:
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ErrorToIdle, true
	case 15844:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_Status, true
	case 15892:
		return OpcuaNodeIdServicesObject_ServerConfiguration_ConfigurationFile, true
	case 15902:
		return OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultXml, true
	case 15903:
		return OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultBinary, true
	case 15905:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_TransportSettings, true
	case 15913:
		return OpcuaNodeIdServicesObject_PubSubKeyServiceType_SecurityGroups, true
	case 15949:
		return OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultXml, true
	case 15950:
		return OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultXml, true
	case 15951:
		return OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultXml, true
	case 15952:
		return OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultXml, true
	case 15953:
		return OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultXml, true
	case 15954:
		return OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultXml, true
	case 15955:
		return OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultXml, true
	case 15956:
		return OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultXml, true
	case 15957:
		return OpcuaNodeIdServicesObject_OPCUANamespaceMetadata, true
	case 15965:
		return OpcuaNodeIdServicesObject_OPCUANamespaceMetadata_NamespaceFile, true
	case 15987:
		return OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultXml, true
	case 15988:
		return OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultXml, true
	case 15990:
		return OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultXml, true
	case 15991:
		return OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultXml, true
	case 15992:
		return OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultXml, true
	case 15993:
		return OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultXml, true
	case 15995:
		return OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultXml, true
	case 15996:
		return OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultXml, true
	case 16007:
		return OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultXml, true
	case 16008:
		return OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultXml, true
	case 16009:
		return OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultXml, true
	case 16010:
		return OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultXml, true
	case 16011:
		return OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultXml, true
	case 16012:
		return OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultXml, true
	case 16014:
		return OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultXml, true
	case 16015:
		return OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultXml, true
	case 16016:
		return OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultXml, true
	case 16017:
		return OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultXml, true
	case 16018:
		return OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultXml, true
	case 16019:
		return OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultXml, true
	case 16021:
		return OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultXml, true
	case 16022:
		return OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultXml, true
	case 16023:
		return OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultXml, true
	case 16036:
		return OpcuaNodeIdServicesObject_WellKnownRole_Engineer, true
	case 16126:
		return OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultXml, true
	case 16150:
		return OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultJson, true
	case 16151:
		return OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultJson, true
	case 16152:
		return OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultJson, true
	case 16153:
		return OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultJson, true
	case 16154:
		return OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultJson, true
	case 16155:
		return OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultJson, true
	case 16156:
		return OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultJson, true
	case 16157:
		return OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultJson, true
	case 16158:
		return OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultJson, true
	case 16159:
		return OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultJson, true
	case 16161:
		return OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultJson, true
	case 16280:
		return OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultJson, true
	case 16281:
		return OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultJson, true
	case 16282:
		return OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultJson, true
	case 16284:
		return OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultJson, true
	case 16285:
		return OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultJson, true
	case 16286:
		return OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultJson, true
	case 16287:
		return OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultJson, true
	case 16288:
		return OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultJson, true
	case 16289:
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_RoleSet, true
	case 16295:
		return OpcuaNodeIdServicesObject_ServerCapabilitiesType_RoleSet, true
	case 16308:
		return OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultJson, true
	case 16310:
		return OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultJson, true
	case 16311:
		return OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultJson, true
	case 16314:
		return OpcuaNodeIdServicesObject_FileSystem, true
	case 16323:
		return OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultJson, true
	case 16324:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile, true
	case 16391:
		return OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultJson, true
	case 16392:
		return OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultJson, true
	case 16393:
		return OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultJson, true
	case 16394:
		return OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultJson, true
	case 16398:
		return OpcuaNodeIdServicesObject_AlarmConditionType_FirstInGroup, true
	case 16399:
		return OpcuaNodeIdServicesObject_AlarmConditionType_AlarmGroup_Placeholder, true
	case 16404:
		return OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultJson, true
	case 16406:
		return OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder, true
	case 16502:
		return OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState, true
	case 16524:
		return OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultJson, true
	case 16525:
		return OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultJson, true
	case 16526:
		return OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultJson, true
	case 16530:
		return OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup, true
	case 16538:
		return OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultBinary, true
	case 16539:
		return OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultBinary, true
	case 16540:
		return OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultBinary, true
	case 16541:
		return OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultBinary, true
	case 16542:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultBinary, true
	case 16543:
		return OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultBinary, true
	case 16544:
		return OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultBinary, true
	case 16545:
		return OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultBinary, true
	case 16546:
		return OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultBinary, true
	case 16547:
		return OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultBinary, true
	case 16587:
		return OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultXml, true
	case 16588:
		return OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultXml, true
	case 16589:
		return OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultXml, true
	case 16590:
		return OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultXml, true
	case 16591:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultXml, true
	case 16592:
		return OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultXml, true
	case 16593:
		return OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultXml, true
	case 16594:
		return OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultXml, true
	case 16595:
		return OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultXml, true
	case 16596:
		return OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultXml, true
	case 16632:
		return OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultJson, true
	case 16633:
		return OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultJson, true
	case 16634:
		return OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultJson, true
	case 16635:
		return OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultJson, true
	case 16636:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultJson, true
	case 16637:
		return OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultJson, true
	case 16642:
		return OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultJson, true
	case 16643:
		return OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultJson, true
	case 16644:
		return OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultJson, true
	case 16645:
		return OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultJson, true
	case 16663:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder, true
	case 16706:
		return OpcuaNodeIdServicesObject_ManagedApplications, true
	case 16707:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups, true
	case 16708:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup, true
	case 16709:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList, true
	case 16754:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired, true
	case 16758:
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings, true
	case 16847:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case 16898:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case 16939:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate, true
	case 17040:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case 17091:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case 17125:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup, true
	case 17126:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList, true
	case 17166:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired, true
	case 17203:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_TransportSettings, true
	case 17271:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case 17290:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_TransportSettings, true
	case 17291:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_MessageSettings, true
	case 17307:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_TransportSettings, true
	case 17308:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_MessageSettings, true
	case 17310:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder, true
	case 17314:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Status, true
	case 17325:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder, true
	case 17329:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Status, true
	case 17371:
		return OpcuaNodeIdServicesObject_PublishSubscribe_PublishedDataSets, true
	case 17405:
		return OpcuaNodeIdServicesObject_PublishSubscribe_Status, true
	case 17409:
		return OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics, true
	case 17423:
		return OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_Counters, true
	case 17457:
		return OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_LiveValues, true
	case 17468:
		return OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultBinary, true
	case 17472:
		return OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultXml, true
	case 17476:
		return OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultJson, true
	case 17499:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case 17511:
		return OpcuaNodeIdServicesObject_KeyCredentialConfigurationFolderType_ServiceName_Placeholder, true
	case 17537:
		return OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultBinary, true
	case 17541:
		return OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultXml, true
	case 17547:
		return OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultJson, true
	case 17549:
		return OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultBinary, true
	case 17553:
		return OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultXml, true
	case 17557:
		return OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultJson, true
	case 17590:
		return OpcuaNodeIdServicesObject_DictionaryEntryType_DictionaryEntryName_Placeholder, true
	case 17592:
		return OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryFolderName_Placeholder, true
	case 17593:
		return OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryEntryName_Placeholder, true
	case 17594:
		return OpcuaNodeIdServicesObject_Dictionaries, true
	case 17608:
		return OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultXml, true
	case 17609:
		return OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultXml, true
	case 17610:
		return OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultBinary, true
	case 17611:
		return OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultBinary, true
	case 17629:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate, true
	case 17708:
		return OpcuaNodeIdServicesObject_InterfaceTypes, true
	case 17732:
		return OpcuaNodeIdServicesObject_AuthorizationServices, true
	case 17741:
		return OpcuaNodeIdServicesObject_WriterGroupType_TransportSettings, true
	case 17742:
		return OpcuaNodeIdServicesObject_WriterGroupType_MessageSettings, true
	case 17743:
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder, true
	case 17747:
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_TransportSettings, true
	case 17748:
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_MessageSettings, true
	case 17749:
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Status, true
	case 17753:
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics, true
	case 17767:
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters, true
	case 17798:
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues, true
	case 17812:
		return OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics, true
	case 17826:
		return OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_Counters, true
	case 17858:
		return OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_LiveValues, true
	case 17862:
		return OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultXml, true
	case 17863:
		return OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultBinary, true
	case 17895:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case 17951:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case 18015:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup, true
	case 18016:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList, true
	case 18059:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired, true
	case 18076:
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder, true
	case 18086:
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_TransportSettings, true
	case 18087:
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_MessageSettings, true
	case 18088:
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Status, true
	case 18092:
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics, true
	case 18106:
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters, true
	case 18137:
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues, true
	case 18155:
		return OpcuaNodeIdServicesObject_KeyCredentialConfiguration, true
	case 18279:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case 18323:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case 18359:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate, true
	case 18446:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case 18490:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case 18547:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_TransactionDiagnostics, true
	case 18554:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile, true
	case 18598:
		return OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultBinary, true
	case 18599:
		return OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultBinary, true
	case 18600:
		return OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultBinary, true
	case 18610:
		return OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultXml, true
	case 18611:
		return OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultXml, true
	case 18612:
		return OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultXml, true
	case 18622:
		return OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultJson, true
	case 18623:
		return OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultJson, true
	case 18624:
		return OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultJson, true
	case 18625:
		return OpcuaNodeIdServicesObject_WellKnownRole_TrustedApplication, true
	case 18650:
		return OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultBinary, true
	case 18651:
		return OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultBinary, true
	case 18652:
		return OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultXml, true
	case 18653:
		return OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultXml, true
	case 18654:
		return OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultJson, true
	case 18655:
		return OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultJson, true
	case 18667:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics, true
	case 18681:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters, true
	case 18712:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues, true
	case 18715:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics, true
	case 18729:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_Counters, true
	case 18760:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_LiveValues, true
	case 18795:
		return OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultBinary, true
	case 18815:
		return OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultBinary, true
	case 18816:
		return OpcuaNodeIdServicesObject_Vector_Encoding_DefaultBinary, true
	case 18817:
		return OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultBinary, true
	case 18818:
		return OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultBinary, true
	case 18819:
		return OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultBinary, true
	case 18820:
		return OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultBinary, true
	case 18821:
		return OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultBinary, true
	case 18822:
		return OpcuaNodeIdServicesObject_Frame_Encoding_DefaultBinary, true
	case 18823:
		return OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultBinary, true
	case 18851:
		return OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultXml, true
	case 18852:
		return OpcuaNodeIdServicesObject_Vector_Encoding_DefaultXml, true
	case 18853:
		return OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultXml, true
	case 18854:
		return OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultXml, true
	case 18855:
		return OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultXml, true
	case 18856:
		return OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultXml, true
	case 18857:
		return OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultXml, true
	case 18858:
		return OpcuaNodeIdServicesObject_Frame_Encoding_DefaultXml, true
	case 18859:
		return OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultXml, true
	case 18871:
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics, true
	case 18885:
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters, true
	case 18916:
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues, true
	case 18930:
		return OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultBinary, true
	case 18937:
		return OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultXml, true
	case 18938:
		return OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultXml, true
	case 18945:
		return OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultJson, true
	case 18946:
		return OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultJson, true
	case 18958:
		return OpcuaNodeIdServicesObject_LLDP, true
	case 18959:
		return OpcuaNodeIdServicesObject_LLDP_RemoteStatistics, true
	case 18965:
		return OpcuaNodeIdServicesObject_LLDP_LocalSystemData, true
	case 18972:
		return OpcuaNodeIdServicesObject_LLDP_Ports, true
	case 18974:
		return OpcuaNodeIdServicesObject_LldpInformationType_RemoteStatistics, true
	case 18980:
		return OpcuaNodeIdServicesObject_LldpInformationType_LocalSystemData, true
	case 18987:
		return OpcuaNodeIdServicesObject_LldpInformationType_Ports, true
	case 18988:
		return OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder, true
	case 18995:
		return OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder_RemoteSystemsData, true
	case 19016:
		return OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData, true
	case 19017:
		return OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder, true
	case 19064:
		return OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultJson, true
	case 19065:
		return OpcuaNodeIdServicesObject_Vector_Encoding_DefaultJson, true
	case 19066:
		return OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultJson, true
	case 19067:
		return OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultJson, true
	case 19068:
		return OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultJson, true
	case 19069:
		return OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultJson, true
	case 19070:
		return OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultJson, true
	case 19071:
		return OpcuaNodeIdServicesObject_Frame_Encoding_DefaultJson, true
	case 19072:
		return OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultJson, true
	case 19079:
		return OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultBinary, true
	case 19080:
		return OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultBinary, true
	case 19081:
		return OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultBinary, true
	case 19100:
		return OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultXml, true
	case 19101:
		return OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultXml, true
	case 19102:
		return OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultXml, true
	case 19107:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics, true
	case 19121:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters, true
	case 19152:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues, true
	case 19176:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics, true
	case 19190:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters, true
	case 19221:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues, true
	case 19241:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics, true
	case 19255:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_Counters, true
	case 19286:
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_LiveValues, true
	case 19299:
		return OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultJson, true
	case 19300:
		return OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultJson, true
	case 19301:
		return OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultJson, true
	case 19372:
		return OpcuaNodeIdServicesObject_ServerLog, true
	case 19378:
		return OpcuaNodeIdServicesObject_Logs, true
	case 19379:
		return OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultBinary, true
	case 19383:
		return OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultXml, true
	case 19387:
		return OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultJson, true
	case 19409:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials, true
	case 19413:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_AuthorizationServices, true
	case 19423:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationType_KeyCredentials, true
	case 19427:
		return OpcuaNodeIdServicesObject_ApplicationConfigurationType_AuthorizationServices, true
	case 19435:
		return OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultBinary, true
	case 19436:
		return OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultBinary, true
	case 19437:
		return OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultXml, true
	case 19438:
		return OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultXml, true
	case 19439:
		return OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultJson, true
	case 19440:
		return OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultJson, true
	case 19450:
		return OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired, true
	case 19537:
		return OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_ShelvingState, true
	case 19550:
		return OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics, true
	case 19564:
		return OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_Counters, true
	case 19595:
		return OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_LiveValues, true
	case 19609:
		return OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics, true
	case 19623:
		return OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_Counters, true
	case 19654:
		return OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_LiveValues, true
	case 19691:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsType_Counters, true
	case 19722:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsType_LiveValues, true
	case 19739:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials, true
	case 19743:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_AuthorizationServices, true
	case 19752:
		return OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultBinary, true
	case 19753:
		return OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultBinary, true
	case 19754:
		return OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultBinary, true
	case 19755:
		return OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultBinary, true
	case 19756:
		return OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultBinary, true
	case 19772:
		return OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultXml, true
	case 19773:
		return OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultXml, true
	case 19774:
		return OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultXml, true
	case 19775:
		return OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultXml, true
	case 19776:
		return OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultXml, true
	case 19777:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsRootType_LiveValues, true
	case 19802:
		return OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultJson, true
	case 19803:
		return OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultJson, true
	case 19804:
		return OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultJson, true
	case 19805:
		return OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultJson, true
	case 19806:
		return OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultJson, true
	case 19831:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsConnectionType_LiveValues, true
	case 19848:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_Counters, true
	case 19879:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_LiveValues, true
	case 19917:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_Counters, true
	case 19948:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_LiveValues, true
	case 19982:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_Counters, true
	case 20013:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_LiveValues, true
	case 20041:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_Counters, true
	case 20072:
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_LiveValues, true
	case 2009:
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities, true
	case 2010:
		return OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics, true
	case 2011:
		return OpcuaNodeIdServicesObject_ServerType_VendorServerInfo, true
	case 2012:
		return OpcuaNodeIdServicesObject_ServerType_ServerRedundancy, true
	case 20120:
		return OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_FirstInGroup, true
	case 20143:
		return OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate, true
	case 2019:
		return OpcuaNodeIdServicesObject_ServerCapabilitiesType_ModellingRules, true
	case 20230:
		return OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_ShelvingState, true
	case 20268:
		return OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_FirstInGroup, true
	case 20291:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired, true
	case 20378:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case 20418:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case 20441:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate, true
	case 20528:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case 20566:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case 20589:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired, true
	case 20676:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case 20714:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case 20737:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate, true
	case 20824:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case 20862:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case 20885:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired, true
	case 20972:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case 21000:
		return OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultXml, true
	case 21001:
		return OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultBinary, true
	case 21006:
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet, true
	case 21015:
		return OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics, true
	case 21029:
		return OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_Counters, true
	case 21060:
		return OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_LiveValues, true
	case 21080:
		return OpcuaNodeIdServicesObject_ReaderGroupType_TransportSettings, true
	case 21081:
		return OpcuaNodeIdServicesObject_ReaderGroupType_MessageSettings, true
	case 21095:
		return OpcuaNodeIdServicesObject_DataSetWriterType_MessageSettings, true
	case 21103:
		return OpcuaNodeIdServicesObject_DataSetReaderType_MessageSettings, true
	case 21150:
		return OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultBinary, true
	case 21151:
		return OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultBinary, true
	case 21152:
		return OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultBinary, true
	case 21153:
		return OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultBinary, true
	case 21154:
		return OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultBinary, true
	case 21155:
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultBinary, true
	case 21174:
		return OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultXml, true
	case 21175:
		return OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultXml, true
	case 21176:
		return OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultXml, true
	case 21177:
		return OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultXml, true
	case 21178:
		return OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultXml, true
	case 21179:
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultXml, true
	case 21198:
		return OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultJson, true
	case 21199:
		return OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultJson, true
	case 21200:
		return OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultJson, true
	case 21201:
		return OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultJson, true
	case 21202:
		return OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultJson, true
	case 21203:
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultJson, true
	case 21213:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case 21236:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate, true
	case 21323:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case 21361:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case 21384:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired, true
	case 21471:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState, true
	case 21509:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroup, true
	case 21532:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate, true
	case 21619:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState, true
	case 21657:
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroup, true
	case 21680:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired, true
	case 21767:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case 21805:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case 21828:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate, true
	case 21915:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case 21953:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case 21976:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired, true
	case 22063:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case 22101:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case 22124:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate, true
	case 22211:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case 22249:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case 22272:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired, true
	case 22359:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case 22397:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case 22420:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate, true
	case 22507:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case 2253:
		return OpcuaNodeIdServicesObject_Server, true
	case 22545:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case 22568:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired, true
	case 22655:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case 2268:
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities, true
	case 22693:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case 22716:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate, true
	case 2274:
		return OpcuaNodeIdServicesObject_Server_ServerDiagnostics, true
	case 22803:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case 22841:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case 22864:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired, true
	case 2295:
		return OpcuaNodeIdServicesObject_Server_VendorServerInfo, true
	case 22951:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case 2296:
		return OpcuaNodeIdServicesObject_Server_ServerRedundancy, true
	case 22989:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case 23012:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate, true
	case 23099:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case 23137:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case 23160:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired, true
	case 23247:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case 23285:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case 23308:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate, true
	case 23395:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case 2341:
		return OpcuaNodeIdServicesObject_AggregateFunction_Interpolative, true
	case 2342:
		return OpcuaNodeIdServicesObject_AggregateFunction_Average, true
	case 2343:
		return OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage, true
	case 23433:
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case 2344:
		return OpcuaNodeIdServicesObject_AggregateFunction_Total, true
	case 23457:
		return OpcuaNodeIdServicesObject_AliasNameCategoryType_Alias_Placeholder, true
	case 23458:
		return OpcuaNodeIdServicesObject_AliasNameCategoryType_SubAliasNameCategories_Placeholder, true
	case 2346:
		return OpcuaNodeIdServicesObject_AggregateFunction_Minimum, true
	case 2347:
		return OpcuaNodeIdServicesObject_AggregateFunction_Maximum, true
	case 23470:
		return OpcuaNodeIdServicesObject_Aliases, true
	case 23479:
		return OpcuaNodeIdServicesObject_TagVariables, true
	case 2348:
		return OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime, true
	case 23488:
		return OpcuaNodeIdServicesObject_Topics, true
	case 2349:
		return OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime, true
	case 23499:
		return OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultBinary, true
	case 2350:
		return OpcuaNodeIdServicesObject_AggregateFunction_Range, true
	case 23500:
		return OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultBinary, true
	case 23505:
		return OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultXml, true
	case 23506:
		return OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultXml, true
	case 23507:
		return OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultBinary, true
	case 2351:
		return OpcuaNodeIdServicesObject_AggregateFunction_AnnotationCount, true
	case 23511:
		return OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultJson, true
	case 23512:
		return OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultJson, true
	case 23519:
		return OpcuaNodeIdServicesObject_OrderedListType_OrderedObject_Placeholder, true
	case 2352:
		return OpcuaNodeIdServicesObject_AggregateFunction_Count, true
	case 23520:
		return OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultXml, true
	case 23528:
		return OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultJson, true
	case 2355:
		return OpcuaNodeIdServicesObject_AggregateFunction_NumberOfTransitions, true
	case 23557:
		return OpcuaNodeIdServicesObject_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder, true
	case 2357:
		return OpcuaNodeIdServicesObject_AggregateFunction_Start, true
	case 2358:
		return OpcuaNodeIdServicesObject_AggregateFunction_End, true
	case 2359:
		return OpcuaNodeIdServicesObject_AggregateFunction_Delta, true
	case 2360:
		return OpcuaNodeIdServicesObject_AggregateFunction_DurationGood, true
	case 2361:
		return OpcuaNodeIdServicesObject_AggregateFunction_DurationBad, true
	case 2362:
		return OpcuaNodeIdServicesObject_AggregateFunction_PercentGood, true
	case 23622:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_SubscribedDataSets, true
	case 2363:
		return OpcuaNodeIdServicesObject_AggregateFunction_PercentBad, true
	case 2364:
		return OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality, true
	case 23642:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubCapablities, true
	case 23649:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_DataSetClasses, true
	case 23658:
		return OpcuaNodeIdServicesObject_PublishSubscribe_SubscribedDataSets, true
	case 23678:
		return OpcuaNodeIdServicesObject_PublishSubscribe_PubSubCapablities, true
	case 23685:
		return OpcuaNodeIdServicesObject_PublishSubscribe_DataSetClasses, true
	case 23796:
		return OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder, true
	case 23807:
		return OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder, true
	case 23808:
		return OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet, true
	case 23829:
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetType_SubscribedDataSet, true
	case 23842:
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransportType_Address, true
	case 23851:
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary, true
	case 23852:
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary, true
	case 23853:
		return OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultBinary, true
	case 23854:
		return OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultBinary, true
	case 23855:
		return OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultBinary, true
	case 23856:
		return OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultBinary, true
	case 23857:
		return OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultBinary, true
	case 23860:
		return OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultBinary, true
	case 23861:
		return OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultBinary, true
	case 23864:
		return OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultBinary, true
	case 23865:
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary, true
	case 23866:
		return OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary, true
	case 23919:
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml, true
	case 23920:
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultXml, true
	case 23921:
		return OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultXml, true
	case 23922:
		return OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultXml, true
	case 23923:
		return OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultXml, true
	case 23924:
		return OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultXml, true
	case 23925:
		return OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultXml, true
	case 23928:
		return OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultXml, true
	case 23929:
		return OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultXml, true
	case 23932:
		return OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultXml, true
	case 23933:
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultXml, true
	case 23934:
		return OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultXml, true
	case 23987:
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson, true
	case 23988:
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultJson, true
	case 23989:
		return OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultJson, true
	case 23990:
		return OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultJson, true
	case 23991:
		return OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultJson, true
	case 23992:
		return OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultJson, true
	case 23993:
		return OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultJson, true
	case 23996:
		return OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultJson, true
	case 23997:
		return OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultJson, true
	case 2400:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_Ready, true
	case 24000:
		return OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultJson, true
	case 24001:
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultJson, true
	case 24002:
		return OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultJson, true
	case 24017:
		return OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportType_Address, true
	case 2402:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_Running, true
	case 24034:
		return OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultBinary, true
	case 24038:
		return OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultXml, true
	case 2404:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_Suspended, true
	case 24042:
		return OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultJson, true
	case 2406:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_Halted, true
	case 2408:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_HaltedToReady, true
	case 2410:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToRunning, true
	case 24108:
		return OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultBinary, true
	case 24109:
		return OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultBinary, true
	case 24110:
		return OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultBinary, true
	case 2412:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToHalted, true
	case 24120:
		return OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultXml, true
	case 24121:
		return OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultXml, true
	case 24122:
		return OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultXml, true
	case 24132:
		return OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultJson, true
	case 24133:
		return OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultJson, true
	case 24134:
		return OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultJson, true
	case 2414:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToReady, true
	case 2416:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToSuspended, true
	case 2418:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToRunning, true
	case 2420:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToHalted, true
	case 2422:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToReady, true
	case 24226:
		return OpcuaNodeIdServicesObject_Resources, true
	case 24227:
		return OpcuaNodeIdServicesObject_Communication, true
	case 24228:
		return OpcuaNodeIdServicesObject_MappingTables, true
	case 24229:
		return OpcuaNodeIdServicesObject_NetworkInterfaces, true
	case 24230:
		return OpcuaNodeIdServicesObject_Streams, true
	case 24231:
		return OpcuaNodeIdServicesObject_TalkerStreams, true
	case 24232:
		return OpcuaNodeIdServicesObject_ListenerStreams, true
	case 2424:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToHalted, true
	case 24290:
		return OpcuaNodeIdServicesObject_UserManagement, true
	case 24292:
		return OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultBinary, true
	case 24296:
		return OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultXml, true
	case 24300:
		return OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultJson, true
	case 25226:
		return OpcuaNodeIdServicesObject_IetfBaseNetworkInterfaceType_InterfaceName_Placeholder, true
	case 25239:
		return OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultBinary, true
	case 25243:
		return OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultXml, true
	case 25247:
		return OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultJson, true
	case 25277:
		return OpcuaNodeIdServicesObject_PubSubKeyServiceType_KeyPushTargets, true
	case 25347:
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder, true
	case 25358:
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder, true
	case 25403:
		return OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubConfiguration, true
	case 25440:
		return OpcuaNodeIdServicesObject_PublishSubscribe_KeyPushTargets, true
	case 25451:
		return OpcuaNodeIdServicesObject_PublishSubscribe_PubSubConfiguration, true
	case 25529:
		return OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary, true
	case 25530:
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultBinary, true
	case 25531:
		return OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultBinary, true
	case 25532:
		return OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultBinary, true
	case 25545:
		return OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultXml, true
	case 25546:
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultXml, true
	case 25547:
		return OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultXml, true
	case 25548:
		return OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultXml, true
	case 25561:
		return OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultJson, true
	case 25562:
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultJson, true
	case 25563:
		return OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultJson, true
	case 25564:
		return OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultJson, true
	case 25565:
		return OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAdmin, true
	case 25584:
		return OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerPush, true
	case 25603:
		return OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAccess, true
	case 25626:
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetType_SecurityGroupName_Placeholder, true
	case 259:
		return OpcuaNodeIdServicesObject_Node_Encoding_DefaultXml, true
	case 260:
		return OpcuaNodeIdServicesObject_Node_Encoding_DefaultBinary, true
	case 262:
		return OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultXml, true
	case 263:
		return OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultBinary, true
	case 265:
		return OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultXml, true
	case 266:
		return OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultBinary, true
	case 268:
		return OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultXml, true
	case 26878:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder, true
	case 26879:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups, true
	case 26880:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup, true
	case 26881:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList, true
	case 269:
		return OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultBinary, true
	case 26921:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired, true
	case 27008:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case 27052:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case 27087:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate, true
	case 271:
		return OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultXml, true
	case 27174:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case 272:
		return OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultBinary, true
	case 27218:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case 27252:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup, true
	case 27253:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList, true
	case 27293:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired, true
	case 27380:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case 274:
		return OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultXml, true
	case 27424:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case 2744:
		return OpcuaNodeIdServicesObject_ServerDiagnosticsType_SessionsDiagnosticsSummary, true
	case 27459:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate, true
	case 275:
		return OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultBinary, true
	case 2754:
		return OpcuaNodeIdServicesObject_ServerCapabilitiesType_AggregateFunctions, true
	case 27546:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case 27590:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case 27624:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup, true
	case 27625:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList, true
	case 27665:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired, true
	case 277:
		return OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultXml, true
	case 27752:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case 27796:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case 278:
		return OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultBinary, true
	case 27831:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate, true
	case 27918:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case 27962:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case 280:
		return OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultXml, true
	case 281:
		return OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultBinary, true
	case 283:
		return OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultXml, true
	case 284:
		return OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultBinary, true
	case 286:
		return OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultXml, true
	case 287:
		return OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultBinary, true
	case 2930:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_Unshelved, true
	case 2932:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelved, true
	case 2933:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelved, true
	case 2935:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToTimedShelved, true
	case 2936:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToOneShotShelved, true
	case 2940:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToUnshelved, true
	case 2942:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToOneShotShelved, true
	case 2943:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToUnshelved, true
	case 2945:
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToTimedShelved, true
	case 297:
		return OpcuaNodeIdServicesObject_Argument_Encoding_DefaultXml, true
	case 298:
		return OpcuaNodeIdServicesObject_Argument_Encoding_DefaultBinary, true
	case 29878:
		return OpcuaNodeIdServicesObject_ProvisionableDevice, true
	case 2996:
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities_ModellingRules, true
	case 2997:
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities_AggregateFunctions, true
	case 300:
		return OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultXml, true
	case 301:
		return OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultBinary, true
	case 3048:
		return OpcuaNodeIdServicesObject_EventTypesFolder, true
	case 305:
		return OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultXml, true
	case 3059:
		return OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateConfiguration, true
	case 306:
		return OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultBinary, true
	case 3062:
		return OpcuaNodeIdServicesObject_DefaultBinary, true
	case 3063:
		return OpcuaNodeIdServicesObject_DefaultXml, true
	case 309:
		return OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultXml, true
	case 3093:
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_ModellingRules, true
	case 3094:
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_AggregateFunctions, true
	case 310:
		return OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultBinary, true
	case 3111:
		return OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary, true
	case 313:
		return OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultXml, true
	case 314:
		return OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultBinary, true
	case 317:
		return OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultXml, true
	case 318:
		return OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultBinary, true
	case 31915:
		return OpcuaNodeIdServicesObject_Locations, true
	case 320:
		return OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultXml, true
	case 321:
		return OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultBinary, true
	case 32299:
		return OpcuaNodeIdServicesObject_ServerConfigurationType_TransactionDiagnostics, true
	case 323:
		return OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultXml, true
	case 32336:
		return OpcuaNodeIdServicesObject_ServerConfiguration_TransactionDiagnostics, true
	case 32362:
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics, true
	case 32382:
		return OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultBinary, true
	case 32386:
		return OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultXml, true
	case 32390:
		return OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultJson, true
	case 324:
		return OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultBinary, true
	case 32422:
		return OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultBinary, true
	case 32426:
		return OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultXml, true
	case 32430:
		return OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultJson, true
	case 32452:
		return OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits, true
	case 32462:
		return OpcuaNodeIdServicesObject_ServerUnitType_CoherentUnit, true
	case 32481:
		return OpcuaNodeIdServicesObject_QuantityType_ServerUnits, true
	case 32482:
		return OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder, true
	case 32487:
		return OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_AlternativeUnits, true
	case 32497:
		return OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit, true
	case 32503:
		return OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder, true
	case 32509:
		return OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder_ServerUnits, true
	case 32530:
		return OpcuaNodeIdServicesObject_Quantities, true
	case 32560:
		return OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultBinary, true
	case 32561:
		return OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultBinary, true
	case 32562:
		return OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultBinary, true
	case 32572:
		return OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultXml, true
	case 32573:
		return OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultXml, true
	case 32574:
		return OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultXml, true
	case 32584:
		return OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultJson, true
	case 32585:
		return OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultJson, true
	case 32586:
		return OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultJson, true
	case 32587:
		return OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits_AlternativeUnit_Placeholder, true
	case 326:
		return OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultXml, true
	case 32622:
		return OpcuaNodeIdServicesObject_HistoricalEventConfigurationType_EventTypes, true
	case 32637:
		return OpcuaNodeIdServicesObject_DefaultHAConfiguration, true
	case 32638:
		return OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateConfiguration, true
	case 32643:
		return OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateFunctions, true
	case 32661:
		return OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultBinary, true
	case 32662:
		return OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultBinary, true
	case 32669:
		return OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultXml, true
	case 32670:
		return OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultXml, true
	case 32677:
		return OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultJson, true
	case 32678:
		return OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultJson, true
	case 327:
		return OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultBinary, true
	case 32754:
		return OpcuaNodeIdServicesObject_DefaultHEConfiguration, true
	case 32755:
		return OpcuaNodeIdServicesObject_DefaultHEConfiguration_EventTypes, true
	case 32800:
		return OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultBinary, true
	case 32801:
		return OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultXml, true
	case 32802:
		return OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultJson, true
	case 32825:
		return OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultBinary, true
	case 32829:
		return OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultXml, true
	case 32833:
		return OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultJson, true
	case 332:
		return OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultXml, true
	case 333:
		return OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultBinary, true
	case 339:
		return OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultXml, true
	case 340:
		return OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultBinary, true
	case 345:
		return OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultXml, true
	case 346:
		return OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultBinary, true
	case 350:
		return OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultXml, true
	case 351:
		return OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultBinary, true
	case 353:
		return OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultXml, true
	case 354:
		return OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultBinary, true
	case 356:
		return OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultXml, true
	case 357:
		return OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultBinary, true
	case 359:
		return OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultXml, true
	case 360:
		return OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultBinary, true
	case 362:
		return OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultXml, true
	case 363:
		return OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultBinary, true
	case 365:
		return OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultXml, true
	case 366:
		return OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultBinary, true
	case 368:
		return OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultXml, true
	case 369:
		return OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultBinary, true
	case 3706:
		return OpcuaNodeIdServicesObject_Server_ServerDiagnostics_SessionsDiagnosticsSummary, true
	case 371:
		return OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultXml, true
	case 372:
		return OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultBinary, true
	case 374:
		return OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultXml, true
	case 375:
		return OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultBinary, true
	case 377:
		return OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultXml, true
	case 378:
		return OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultBinary, true
	case 380:
		return OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultXml, true
	case 381:
		return OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultBinary, true
	case 383:
		return OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultXml, true
	case 384:
		return OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultBinary, true
	case 3850:
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_FinalResultData, true
	case 386:
		return OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultXml, true
	case 387:
		return OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultBinary, true
	case 390:
		return OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultXml, true
	case 391:
		return OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultBinary, true
	case 393:
		return OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultXml, true
	case 394:
		return OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultBinary, true
	case 396:
		return OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultXml, true
	case 397:
		return OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultBinary, true
	case 421:
		return OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultXml, true
	case 422:
		return OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultBinary, true
	case 424:
		return OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultXml, true
	case 425:
		return OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultBinary, true
	case 427:
		return OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultXml, true
	case 428:
		return OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultBinary, true
	case 430:
		return OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultXml, true
	case 431:
		return OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultBinary, true
	case 433:
		return OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultXml, true
	case 434:
		return OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultBinary, true
	case 436:
		return OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultXml, true
	case 437:
		return OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultBinary, true
	case 439:
		return OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultXml, true
	case 440:
		return OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultBinary, true
	case 442:
		return OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultXml, true
	case 443:
		return OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultBinary, true
	case 445:
		return OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultXml, true
	case 446:
		return OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultBinary, true
	case 448:
		return OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultXml, true
	case 449:
		return OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultBinary, true
	case 451:
		return OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultXml, true
	case 452:
		return OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultBinary, true
	case 454:
		return OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultXml, true
	case 455:
		return OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultBinary, true
	case 457:
		return OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultXml, true
	case 458:
		return OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultBinary, true
	case 460:
		return OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultXml, true
	case 461:
		return OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultBinary, true
	case 463:
		return OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultXml, true
	case 464:
		return OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultBinary, true
	case 466:
		return OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultXml, true
	case 467:
		return OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultBinary, true
	case 469:
		return OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultXml, true
	case 470:
		return OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultBinary, true
	case 472:
		return OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultXml, true
	case 473:
		return OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultBinary, true
	case 475:
		return OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultXml, true
	case 476:
		return OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultBinary, true
	case 478:
		return OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultXml, true
	case 479:
		return OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultBinary, true
	case 481:
		return OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultXml, true
	case 482:
		return OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultBinary, true
	case 484:
		return OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultXml, true
	case 485:
		return OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultBinary, true
	case 487:
		return OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultXml, true
	case 488:
		return OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultBinary, true
	case 490:
		return OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultXml, true
	case 491:
		return OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultBinary, true
	case 493:
		return OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultXml, true
	case 494:
		return OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultBinary, true
	case 496:
		return OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultXml, true
	case 497:
		return OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultBinary, true
	case 499:
		return OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultXml, true
	case 500:
		return OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultBinary, true
	case 502:
		return OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultXml, true
	case 503:
		return OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultBinary, true
	case 505:
		return OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultXml, true
	case 506:
		return OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultBinary, true
	case 508:
		return OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultXml, true
	case 509:
		return OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultBinary, true
	case 512:
		return OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultXml, true
	case 513:
		return OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultBinary, true
	case 515:
		return OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultXml, true
	case 516:
		return OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultBinary, true
	case 519:
		return OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultXml, true
	case 520:
		return OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultBinary, true
	case 523:
		return OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultXml, true
	case 524:
		return OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultBinary, true
	case 526:
		return OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultXml, true
	case 527:
		return OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultBinary, true
	case 529:
		return OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultXml, true
	case 530:
		return OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultBinary, true
	case 532:
		return OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultXml, true
	case 533:
		return OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultBinary, true
	case 535:
		return OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultXml, true
	case 536:
		return OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultBinary, true
	case 538:
		return OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultXml, true
	case 539:
		return OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultBinary, true
	case 541:
		return OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultXml, true
	case 542:
		return OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultBinary, true
	case 544:
		return OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultXml, true
	case 545:
		return OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultBinary, true
	case 547:
		return OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultXml, true
	case 548:
		return OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultBinary, true
	case 550:
		return OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultXml, true
	case 551:
		return OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultBinary, true
	case 553:
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml, true
	case 554:
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary, true
	case 556:
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml, true
	case 557:
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary, true
	case 559:
		return OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultXml, true
	case 560:
		return OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultBinary, true
	case 562:
		return OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultXml, true
	case 563:
		return OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultBinary, true
	case 565:
		return OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultXml, true
	case 566:
		return OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultBinary, true
	case 568:
		return OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultXml, true
	case 569:
		return OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultBinary, true
	case 571:
		return OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultXml, true
	case 572:
		return OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultBinary, true
	case 574:
		return OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultXml, true
	case 575:
		return OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultBinary, true
	case 578:
		return OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultXml, true
	case 579:
		return OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultBinary, true
	case 581:
		return OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultXml, true
	case 582:
		return OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultBinary, true
	case 584:
		return OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultXml, true
	case 585:
		return OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultBinary, true
	case 587:
		return OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultXml, true
	case 588:
		return OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultBinary, true
	case 590:
		return OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultXml, true
	case 591:
		return OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultBinary, true
	case 593:
		return OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultXml, true
	case 594:
		return OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultBinary, true
	case 596:
		return OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultXml, true
	case 597:
		return OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultBinary, true
	case 599:
		return OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultXml, true
	case 600:
		return OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultBinary, true
	case 602:
		return OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultXml, true
	case 603:
		return OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultBinary, true
	case 605:
		return OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultXml, true
	case 606:
		return OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultBinary, true
	case 608:
		return OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultXml, true
	case 609:
		return OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultBinary, true
	case 611:
		return OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultXml, true
	case 612:
		return OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultBinary, true
	case 614:
		return OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultXml, true
	case 615:
		return OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultBinary, true
	case 617:
		return OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultXml, true
	case 618:
		return OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultBinary, true
	case 620:
		return OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultXml, true
	case 621:
		return OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultBinary, true
	case 623:
		return OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultXml, true
	case 624:
		return OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultBinary, true
	case 627:
		return OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultXml, true
	case 628:
		return OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultBinary, true
	case 630:
		return OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultXml, true
	case 631:
		return OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultBinary, true
	case 633:
		return OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultXml, true
	case 634:
		return OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultBinary, true
	case 636:
		return OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultXml, true
	case 637:
		return OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultBinary, true
	case 639:
		return OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultXml, true
	case 640:
		return OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultBinary, true
	case 642:
		return OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultXml, true
	case 643:
		return OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultBinary, true
	case 645:
		return OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultXml, true
	case 646:
		return OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultBinary, true
	case 648:
		return OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultXml, true
	case 649:
		return OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultBinary, true
	case 651:
		return OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultXml, true
	case 652:
		return OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultBinary, true
	case 654:
		return OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultXml, true
	case 655:
		return OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultBinary, true
	case 657:
		return OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultXml, true
	case 658:
		return OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultBinary, true
	case 660:
		return OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultXml, true
	case 661:
		return OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultBinary, true
	case 663:
		return OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultXml, true
	case 664:
		return OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultBinary, true
	case 666:
		return OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultXml, true
	case 667:
		return OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultBinary, true
	case 669:
		return OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultXml, true
	case 670:
		return OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultBinary, true
	case 672:
		return OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultXml, true
	case 673:
		return OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultBinary, true
	case 675:
		return OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultXml, true
	case 676:
		return OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultBinary, true
	case 678:
		return OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultXml, true
	case 679:
		return OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultBinary, true
	case 681:
		return OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultXml, true
	case 682:
		return OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultBinary, true
	case 684:
		return OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultXml, true
	case 685:
		return OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultBinary, true
	case 687:
		return OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultXml, true
	case 688:
		return OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultBinary, true
	case 690:
		return OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultXml, true
	case 691:
		return OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultBinary, true
	case 693:
		return OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultXml, true
	case 694:
		return OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultBinary, true
	case 696:
		return OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultXml, true
	case 697:
		return OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultBinary, true
	case 699:
		return OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultXml, true
	case 700:
		return OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultBinary, true
	case 702:
		return OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultXml, true
	case 703:
		return OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultBinary, true
	case 705:
		return OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultXml, true
	case 706:
		return OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultBinary, true
	case 708:
		return OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultXml, true
	case 709:
		return OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultBinary, true
	case 711:
		return OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultXml, true
	case 712:
		return OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultBinary, true
	case 714:
		return OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultXml, true
	case 715:
		return OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultBinary, true
	case 720:
		return OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultXml, true
	case 721:
		return OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultBinary, true
	case 723:
		return OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultXml, true
	case 724:
		return OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultBinary, true
	case 726:
		return OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultXml, true
	case 727:
		return OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultBinary, true
	case 729:
		return OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultXml, true
	case 730:
		return OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultBinary, true
	case 732:
		return OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultXml, true
	case 733:
		return OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultBinary, true
	case 735:
		return OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultXml, true
	case 736:
		return OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultBinary, true
	case 738:
		return OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultXml, true
	case 739:
		return OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultBinary, true
	case 741:
		return OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultXml, true
	case 742:
		return OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultBinary, true
	case 744:
		return OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultXml, true
	case 745:
		return OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultBinary, true
	case 747:
		return OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultXml, true
	case 748:
		return OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultBinary, true
	case 750:
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultXml, true
	case 751:
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultBinary, true
	case 753:
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultXml, true
	case 754:
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultBinary, true
	case 756:
		return OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultXml, true
	case 757:
		return OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultBinary, true
	case 759:
		return OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultXml, true
	case 760:
		return OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultBinary, true
	case 7616:
		return OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultXml, true
	case 762:
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultXml, true
	case 763:
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultBinary, true
	case 765:
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultXml, true
	case 766:
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultBinary, true
	case 768:
		return OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultXml, true
	case 769:
		return OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultBinary, true
	case 771:
		return OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultXml, true
	case 772:
		return OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultBinary, true
	case 774:
		return OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultXml, true
	case 775:
		return OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultBinary, true
	case 777:
		return OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultXml, true
	case 778:
		return OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultBinary, true
	case 78:
		return OpcuaNodeIdServicesObject_ModellingRule_Mandatory, true
	case 780:
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultXml, true
	case 781:
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultBinary, true
	case 783:
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultXml, true
	case 784:
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultBinary, true
	case 786:
		return OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultXml, true
	case 787:
		return OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultBinary, true
	case 789:
		return OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultXml, true
	case 790:
		return OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultBinary, true
	case 792:
		return OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultXml, true
	case 793:
		return OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultBinary, true
	case 795:
		return OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultXml, true
	case 796:
		return OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultBinary, true
	case 798:
		return OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultXml, true
	case 799:
		return OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultBinary, true
	case 80:
		return OpcuaNodeIdServicesObject_ModellingRule_Optional, true
	case 801:
		return OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultXml, true
	case 802:
		return OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultBinary, true
	case 804:
		return OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultXml, true
	case 805:
		return OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultBinary, true
	case 807:
		return OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultXml, true
	case 808:
		return OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultBinary, true
	case 810:
		return OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultXml, true
	case 811:
		return OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultBinary, true
	case 819:
		return OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultXml, true
	case 820:
		return OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultBinary, true
	case 822:
		return OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultXml, true
	case 823:
		return OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultBinary, true
	case 825:
		return OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultXml, true
	case 8251:
		return OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultBinary, true
	case 826:
		return OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultBinary, true
	case 828:
		return OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultXml, true
	case 829:
		return OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultBinary, true
	case 83:
		return OpcuaNodeIdServicesObject_ModellingRule_ExposesItsArray, true
	case 831:
		return OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultXml, true
	case 832:
		return OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultBinary, true
	case 834:
		return OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultXml, true
	case 835:
		return OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultBinary, true
	case 837:
		return OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultXml, true
	case 838:
		return OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultBinary, true
	case 84:
		return OpcuaNodeIdServicesObject_RootFolder, true
	case 840:
		return OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultXml, true
	case 841:
		return OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultBinary, true
	case 843:
		return OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultXml, true
	case 844:
		return OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultBinary, true
	case 846:
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultXml, true
	case 847:
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultBinary, true
	case 849:
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultXml, true
	case 85:
		return OpcuaNodeIdServicesObject_ObjectsFolder, true
	case 850:
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultBinary, true
	case 854:
		return OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultXml, true
	case 855:
		return OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultBinary, true
	case 857:
		return OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml, true
	case 858:
		return OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary, true
	case 86:
		return OpcuaNodeIdServicesObject_TypesFolder, true
	case 860:
		return OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultXml, true
	case 861:
		return OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary, true
	case 863:
		return OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultXml, true
	case 864:
		return OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultBinary, true
	case 866:
		return OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultXml, true
	case 867:
		return OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultBinary, true
	case 869:
		return OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultXml, true
	case 87:
		return OpcuaNodeIdServicesObject_ViewsFolder, true
	case 870:
		return OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary, true
	case 872:
		return OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultXml, true
	case 873:
		return OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultBinary, true
	case 875:
		return OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultXml, true
	case 876:
		return OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultBinary, true
	case 878:
		return OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultXml, true
	case 879:
		return OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultBinary, true
	case 88:
		return OpcuaNodeIdServicesObject_ObjectTypesFolder, true
	case 885:
		return OpcuaNodeIdServicesObject_Range_Encoding_DefaultXml, true
	case 886:
		return OpcuaNodeIdServicesObject_Range_Encoding_DefaultBinary, true
	case 888:
		return OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultXml, true
	case 889:
		return OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultBinary, true
	case 89:
		return OpcuaNodeIdServicesObject_VariableTypesFolder, true
	case 8913:
		return OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultXml, true
	case 8917:
		return OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultBinary, true
	case 892:
		return OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultXml, true
	case 893:
		return OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultBinary, true
	case 895:
		return OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultXml, true
	case 896:
		return OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultBinary, true
	case 898:
		return OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultXml, true
	case 899:
		return OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultBinary, true
	case 90:
		return OpcuaNodeIdServicesObject_DataTypesFolder, true
	case 91:
		return OpcuaNodeIdServicesObject_ReferenceTypesFolder, true
	case 915:
		return OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultXml, true
	case 916:
		return OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultBinary, true
	case 9178:
		return OpcuaNodeIdServicesObject_AlarmConditionType_ShelvingState, true
	case 918:
		return OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultXml, true
	case 919:
		return OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultBinary, true
	case 92:
		return OpcuaNodeIdServicesObject_XmlSchema_TypeSystem, true
	case 921:
		return OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultXml, true
	case 922:
		return OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultBinary, true
	case 93:
		return OpcuaNodeIdServicesObject_OPCBinarySchema_TypeSystem, true
	case 9329:
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighHigh, true
	case 9331:
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_High, true
	case 9333:
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_Low, true
	case 9335:
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowLow, true
	case 9337:
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowLowToLow, true
	case 9338:
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowToLowLow, true
	case 9339:
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighHighToHigh, true
	case 9340:
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighToHighHigh, true
	case 939:
		return OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultXml, true
	case 940:
		return OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultBinary, true
	case 9455:
		return OpcuaNodeIdServicesObject_ExclusiveLimitAlarmType_LimitState, true
	case 946:
		return OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultXml, true
	case 947:
		return OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultBinary, true
	case 949:
		return OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultXml, true
	case 950:
		return OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultBinary, true
	}
	return 0, false
}

func OpcuaNodeIdServicesObjectByName(value string) (enum OpcuaNodeIdServicesObject, ok bool) {
	switch value {
	case "HistoryServerCapabilitiesType_AggregateFunctions":
		return OpcuaNodeIdServicesObject_HistoryServerCapabilitiesType_AggregateFunctions, true
	case "HistoryServerCapabilities":
		return OpcuaNodeIdServicesObject_HistoryServerCapabilities, true
	case "HistoryServerCapabilities_AggregateFunctions":
		return OpcuaNodeIdServicesObject_HistoryServerCapabilities_AggregateFunctions, true
	case "HAConfiguration":
		return OpcuaNodeIdServicesObject_HAConfiguration, true
	case "HAConfiguration_AggregateConfiguration":
		return OpcuaNodeIdServicesObject_HAConfiguration_AggregateConfiguration, true
	case "ModificationInfo_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultXml, true
	case "HistoryModifiedData_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultXml, true
	case "ModificationInfo_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultBinary, true
	case "HistoryModifiedData_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultBinary, true
	case "AggregateFunction_TimeAverage2":
		return OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage2, true
	case "AggregateFunction_Minimum2":
		return OpcuaNodeIdServicesObject_AggregateFunction_Minimum2, true
	case "AggregateFunction_Maximum2":
		return OpcuaNodeIdServicesObject_AggregateFunction_Maximum2, true
	case "AggregateFunction_Range2":
		return OpcuaNodeIdServicesObject_AggregateFunction_Range2, true
	case "AggregateFunction_WorstQuality2":
		return OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality2, true
	case "UpdateStructureDataDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultXml, true
	case "UpdateStructureDataDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultBinary, true
	case "AggregateFunction_Total2":
		return OpcuaNodeIdServicesObject_AggregateFunction_Total2, true
	case "AggregateFunction_MinimumActualTime2":
		return OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime2, true
	case "AggregateFunction_MaximumActualTime2":
		return OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime2, true
	case "AggregateFunction_DurationInStateZero":
		return OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateZero, true
	case "AggregateFunction_DurationInStateNonZero":
		return OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateNonZero, true
	case "AggregateFunction_StandardDeviationSample":
		return OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationSample, true
	case "AggregateFunction_StandardDeviationPopulation":
		return OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationPopulation, true
	case "AggregateFunction_VarianceSample":
		return OpcuaNodeIdServicesObject_AggregateFunction_VarianceSample, true
	case "AggregateFunction_VariancePopulation":
		return OpcuaNodeIdServicesObject_AggregateFunction_VariancePopulation, true
	case "AggregateFunction_StartBound":
		return OpcuaNodeIdServicesObject_AggregateFunction_StartBound, true
	case "AggregateFunction_EndBound":
		return OpcuaNodeIdServicesObject_AggregateFunction_EndBound, true
	case "AggregateFunction_DeltaBounds":
		return OpcuaNodeIdServicesObject_AggregateFunction_DeltaBounds, true
	case "ModellingRule_OptionalPlaceholder":
		return OpcuaNodeIdServicesObject_ModellingRule_OptionalPlaceholder, true
	case "ModellingRule_MandatoryPlaceholder":
		return OpcuaNodeIdServicesObject_ModellingRule_MandatoryPlaceholder, true
	case "ServerType_ServerCapabilities_OperationLimits":
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_OperationLimits, true
	case "ServerType_Namespaces":
		return OpcuaNodeIdServicesObject_ServerType_Namespaces, true
	case "ServerCapabilitiesType_OperationLimits":
		return OpcuaNodeIdServicesObject_ServerCapabilitiesType_OperationLimits, true
	case "NamespaceMetadataType_NamespaceFile":
		return OpcuaNodeIdServicesObject_NamespaceMetadataType_NamespaceFile, true
	case "NamespacesType_NamespaceIdentifier_Placeholder":
		return OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder, true
	case "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile":
		return OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile, true
	case "Server_ServerCapabilities_OperationLimits":
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities_OperationLimits, true
	case "Server_Namespaces":
		return OpcuaNodeIdServicesObject_Server_Namespaces, true
	case "HistoricalDataConfigurationType_AggregateFunctions":
		return OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateFunctions, true
	case "HAConfiguration_AggregateFunctions":
		return OpcuaNodeIdServicesObject_HAConfiguration_AggregateFunctions, true
	case "InstanceNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultXml, true
	case "TypeNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultXml, true
	case "InstanceNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultBinary, true
	case "TypeNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultBinary, true
	case "EndpointUrlListDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultXml, true
	case "NetworkGroupDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultXml, true
	case "EndpointUrlListDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultBinary, true
	case "NetworkGroupDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultBinary, true
	case "AxisInformation_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultXml, true
	case "XVType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_XVType_Encoding_DefaultXml, true
	case "AxisInformation_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultBinary, true
	case "XVType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_XVType_Encoding_DefaultBinary, true
	case "SessionsDiagnosticsSummaryType_ClientName_Placeholder":
		return OpcuaNodeIdServicesObject_SessionsDiagnosticsSummaryType_ClientName_Placeholder, true
	case "DataTypeDefinition_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultBinary, true
	case "ComplexNumberType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultXml, true
	case "DoubleComplexNumberType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultXml, true
	case "ComplexNumberType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultBinary, true
	case "DoubleComplexNumberType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultBinary, true
	case "ServerOnNetwork_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultXml, true
	case "FindServersOnNetworkRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultXml, true
	case "FindServersOnNetworkResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultXml, true
	case "RegisterServer2Request_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultXml, true
	case "StructureDefinition_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultBinary, true
	case "RegisterServer2Response_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultXml, true
	case "ServerOnNetwork_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultBinary, true
	case "FindServersOnNetworkRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultBinary, true
	case "FindServersOnNetworkResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultBinary, true
	case "RegisterServer2Request_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultBinary, true
	case "RegisterServer2Response_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultBinary, true
	case "EnumDefinition_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultBinary, true
	case "DataSetMetaDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultBinary, true
	case "DataTypeDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultBinary, true
	case "StructureDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultBinary, true
	case "ServerConfiguration":
		return OpcuaNodeIdServicesObject_ServerConfiguration, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList, true
	case "TrustListDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultXml, true
	case "TrustListDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultBinary, true
	case "EnumDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultBinary, true
	case "OptionSet_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultXml, true
	case "Union_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_Union_Encoding_DefaultXml, true
	case "OptionSet_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultBinary, true
	case "Union_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_Union_Encoding_DefaultBinary, true
	case "RolePermissionType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultBinary, true
	case "DiscoveryConfiguration_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultXml, true
	case "MdnsDiscoveryConfiguration_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultXml, true
	case "DiscoveryConfiguration_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultBinary, true
	case "MdnsDiscoveryConfiguration_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultBinary, true
	case "FileDirectoryType_FileDirectoryName_Placeholder":
		return OpcuaNodeIdServicesObject_FileDirectoryType_FileDirectoryName_Placeholder, true
	case "FileDirectoryType_FileName_Placeholder":
		return OpcuaNodeIdServicesObject_FileDirectoryType_FileName_Placeholder, true
	case "CertificateGroupType_TrustList":
		return OpcuaNodeIdServicesObject_CertificateGroupType_TrustList, true
	case "CertificateGroupFolderType_DefaultApplicationGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustList":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustList, true
	case "CertificateGroupFolderType_DefaultHttpsGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustList":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustList, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList, true
	case "ServerConfigurationType_CertificateGroups":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList, true
	case "ServerConfiguration_CertificateGroups":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup, true
	case "PubSubConnectionType_Address":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Address, true
	case "PublishedVariableDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultXml, true
	case "PublishedVariableDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultBinary, true
	case "PublishSubscribeType_ConnectionName_Placeholder":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Status":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Status, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Address":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Address, true
	case "PublishSubscribeType_PublishedDataSets":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_PublishedDataSets, true
	case "PublishSubscribe":
		return OpcuaNodeIdServicesObject_PublishSubscribe, true
	case "DataSetFolderType_DataSetFolderName_Placeholder":
		return OpcuaNodeIdServicesObject_DataSetFolderType_DataSetFolderName_Placeholder, true
	case "DataSetFolderType_PublishedDataSetName_Placeholder":
		return OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder, true
	case "PubSubConnectionType_Status":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Status, true
	case "DataSetMetaDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultXml, true
	case "FieldMetaData_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultXml, true
	case "DataTypeDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultXml, true
	case "DataTypeDefinition_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultXml, true
	case "StructureDefinition_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultXml, true
	case "EnumDefinition_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultXml, true
	case "StructureField_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultXml, true
	case "EnumField_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultXml, true
	case "KeyValuePair_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultXml, true
	case "ConfigurationVersionDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultXml, true
	case "FieldTargetDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultXml, true
	case "FieldMetaData_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultBinary, true
	case "StructureField_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultBinary, true
	case "EnumField_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultBinary, true
	case "KeyValuePair_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultBinary, true
	case "ConfigurationVersionDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultBinary, true
	case "FieldTargetDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultBinary, true
	case "TestScalarStructure_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultBinary, true
	case "TestArrayStructure_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultBinary, true
	case "TestStructure_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultBinary, true
	case "KeyValuePair_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultJson, true
	case "IdentityMappingRuleType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultJson, true
	case "TrustListDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultJson, true
	case "DecimalDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultJson, true
	case "ConfigurationVersionDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultJson, true
	case "DataSetMetaDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultJson, true
	case "FieldMetaData_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultJson, true
	case "DataTypeDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultJson, true
	case "StructureDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultJson, true
	case "EnumDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultJson, true
	case "PublishedVariableDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultJson, true
	case "FieldTargetDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultJson, true
	case "RolePermissionType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultJson, true
	case "DataTypeDefinition_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultJson, true
	case "StructureField_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultJson, true
	case "StructureDefinition_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultJson, true
	case "EnumDefinition_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultJson, true
	case "Node_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_Node_Encoding_DefaultJson, true
	case "InstanceNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultJson, true
	case "TypeNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultJson, true
	case "ObjectNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultJson, true
	case "DatagramConnectionTransportType_DiscoveryAddress":
		return OpcuaNodeIdServicesObject_DatagramConnectionTransportType_DiscoveryAddress, true
	case "ObjectTypeNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultJson, true
	case "VariableNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultJson, true
	case "VariableTypeNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultJson, true
	case "ReferenceTypeNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultJson, true
	case "MethodNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultJson, true
	case "ViewNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultJson, true
	case "DataTypeNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultJson, true
	case "ReferenceNode_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultJson, true
	case "Argument_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_Argument_Encoding_DefaultJson, true
	case "EnumValueType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultJson, true
	case "EnumField_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultJson, true
	case "OptionSet_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultJson, true
	case "Union_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_Union_Encoding_DefaultJson, true
	case "TimeZoneDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultJson, true
	case "ApplicationDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultJson, true
	case "RequestHeader_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultJson, true
	case "ResponseHeader_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultJson, true
	case "ServiceFault_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultJson, true
	case "SessionlessInvokeRequestType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultJson, true
	case "SessionlessInvokeResponseType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultJson, true
	case "FindServersRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultJson, true
	case "FindServersResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultJson, true
	case "ServerOnNetwork_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultJson, true
	case "FindServersOnNetworkRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultJson, true
	case "FindServersOnNetworkResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultJson, true
	case "UserTokenPolicy_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultJson, true
	case "EndpointDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultJson, true
	case "GetEndpointsRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultJson, true
	case "GetEndpointsResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultJson, true
	case "RegisteredServer_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultJson, true
	case "RegisterServerRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultJson, true
	case "RegisterServerResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultJson, true
	case "DiscoveryConfiguration_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultJson, true
	case "MdnsDiscoveryConfiguration_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultJson, true
	case "RegisterServer2Request_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultJson, true
	case "RegisterServer2Response_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultJson, true
	case "ChannelSecurityToken_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultJson, true
	case "OpenSecureChannelRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultJson, true
	case "OpenSecureChannelResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultJson, true
	case "CloseSecureChannelRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultJson, true
	case "CloseSecureChannelResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultJson, true
	case "SignedSoftwareCertificate_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultJson, true
	case "SignatureData_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultJson, true
	case "CreateSessionRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultJson, true
	case "CreateSessionResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultJson, true
	case "UserIdentityToken_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultJson, true
	case "AnonymousIdentityToken_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultJson, true
	case "UserNameIdentityToken_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultJson, true
	case "X509IdentityToken_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultJson, true
	case "IssuedIdentityToken_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultJson, true
	case "ActivateSessionRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultJson, true
	case "ActivateSessionResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultJson, true
	case "CloseSessionRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultJson, true
	case "CloseSessionResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultJson, true
	case "CancelRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultJson, true
	case "CancelResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultJson, true
	case "NodeAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultJson, true
	case "ObjectAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultJson, true
	case "VariableAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultJson, true
	case "MethodAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultJson, true
	case "ObjectTypeAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultJson, true
	case "VariableTypeAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultJson, true
	case "ReferenceTypeAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultJson, true
	case "DataTypeAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultJson, true
	case "ViewAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultJson, true
	case "GenericAttributeValue_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultJson, true
	case "GenericAttributes_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultJson, true
	case "AddNodesItem_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultJson, true
	case "AddNodesResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultJson, true
	case "AddNodesRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultJson, true
	case "AddNodesResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultJson, true
	case "AddReferencesItem_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultJson, true
	case "AddReferencesRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultJson, true
	case "AddReferencesResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultJson, true
	case "DeleteNodesItem_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultJson, true
	case "DeleteNodesRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultJson, true
	case "DeleteNodesResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultJson, true
	case "DeleteReferencesItem_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultJson, true
	case "DeleteReferencesRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultJson, true
	case "DeleteReferencesResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultJson, true
	case "ViewDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultJson, true
	case "BrowseDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultJson, true
	case "ReferenceDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultJson, true
	case "BrowseResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultJson, true
	case "BrowseRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultJson, true
	case "BrowseResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultJson, true
	case "BrowseNextRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultJson, true
	case "BrowseNextResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultJson, true
	case "RelativePathElement_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultJson, true
	case "RelativePath_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultJson, true
	case "BrowsePath_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultJson, true
	case "BrowsePathTarget_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultJson, true
	case "BrowsePathResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultJson, true
	case "TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson, true
	case "TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson, true
	case "RegisterNodesRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultJson, true
	case "RegisterNodesResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultJson, true
	case "UnregisterNodesRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultJson, true
	case "UnregisterNodesResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultJson, true
	case "EndpointConfiguration_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultJson, true
	case "QueryDataDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultJson, true
	case "NodeTypeDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultJson, true
	case "QueryDataSet_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultJson, true
	case "NodeReference_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultJson, true
	case "ContentFilterElement_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultJson, true
	case "ContentFilter_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultJson, true
	case "FilterOperand_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultJson, true
	case "ElementOperand_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultJson, true
	case "LiteralOperand_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultJson, true
	case "AttributeOperand_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultJson, true
	case "SimpleAttributeOperand_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultJson, true
	case "ContentFilterElementResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultJson, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder":
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Status":
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Status, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings":
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings, true
	case "ContentFilterResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultJson, true
	case "TestScalarStructure_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultXml, true
	case "TestArrayStructure_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultXml, true
	case "TestStructure_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultXml, true
	case "ParsingResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultJson, true
	case "QueryFirstRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultJson, true
	case "QueryFirstResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultJson, true
	case "QueryNextRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultJson, true
	case "QueryNextResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultJson, true
	case "ReadValueId_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultJson, true
	case "ReadRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultJson, true
	case "ReadResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultJson, true
	case "HistoryReadValueId_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultJson, true
	case "HistoryReadResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultJson, true
	case "HistoryReadDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultJson, true
	case "ReadEventDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultJson, true
	case "ReadRawModifiedDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultJson, true
	case "ReadProcessedDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultJson, true
	case "PubSubGroupType_Status":
		return OpcuaNodeIdServicesObject_PubSubGroupType_Status, true
	case "ReadAtTimeDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultJson, true
	case "HistoryData_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultJson, true
	case "ModificationInfo_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultJson, true
	case "HistoryModifiedData_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultJson, true
	case "HistoryEvent_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultJson, true
	case "HistoryReadRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultJson, true
	case "HistoryReadResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultJson, true
	case "WriteValue_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultJson, true
	case "WriteRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultJson, true
	case "WriteResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultJson, true
	case "HistoryUpdateDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultJson, true
	case "UpdateDataDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultJson, true
	case "UpdateStructureDataDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultJson, true
	case "UpdateEventDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultJson, true
	case "DeleteRawModifiedDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultJson, true
	case "DeleteAtTimeDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultJson, true
	case "DeleteEventDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultJson, true
	case "HistoryUpdateResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultJson, true
	case "HistoryUpdateRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultJson, true
	case "HistoryUpdateResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultJson, true
	case "CallMethodRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultJson, true
	case "CallMethodResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultJson, true
	case "CallRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultJson, true
	case "CallResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultJson, true
	case "MonitoringFilter_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultJson, true
	case "DataChangeFilter_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultJson, true
	case "EventFilter_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultJson, true
	case "DataSetWriterType_Status":
		return OpcuaNodeIdServicesObject_DataSetWriterType_Status, true
	case "DataSetWriterType_TransportSettings":
		return OpcuaNodeIdServicesObject_DataSetWriterType_TransportSettings, true
	case "AggregateConfiguration_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultJson, true
	case "DataSetReaderType_Status":
		return OpcuaNodeIdServicesObject_DataSetReaderType_Status, true
	case "DataSetReaderType_TransportSettings":
		return OpcuaNodeIdServicesObject_DataSetReaderType_TransportSettings, true
	case "AggregateFilter_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultJson, true
	case "MonitoringFilterResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultJson, true
	case "EventFilterResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultJson, true
	case "AggregateFilterResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultJson, true
	case "DataSetReaderType_SubscribedDataSet":
		return OpcuaNodeIdServicesObject_DataSetReaderType_SubscribedDataSet, true
	case "MonitoringParameters_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultJson, true
	case "MonitoredItemCreateRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultJson, true
	case "MonitoredItemCreateResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultJson, true
	case "CreateMonitoredItemsRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultJson, true
	case "CreateMonitoredItemsResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultJson, true
	case "MonitoredItemModifyRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultJson, true
	case "MonitoredItemModifyResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultJson, true
	case "ModifyMonitoredItemsRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultJson, true
	case "ModifyMonitoredItemsResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultJson, true
	case "SetMonitoringModeRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultJson, true
	case "SetMonitoringModeResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultJson, true
	case "SetTriggeringRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultJson, true
	case "SetTriggeringResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultJson, true
	case "DeleteMonitoredItemsRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultJson, true
	case "DeleteMonitoredItemsResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultJson, true
	case "CreateSubscriptionRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultJson, true
	case "CreateSubscriptionResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultJson, true
	case "ModifySubscriptionRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultJson, true
	case "ModifySubscriptionResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultJson, true
	case "SetPublishingModeRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultJson, true
	case "SetPublishingModeResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultJson, true
	case "NotificationMessage_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultJson, true
	case "NotificationData_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultJson, true
	case "DataChangeNotification_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultJson, true
	case "MonitoredItemNotification_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultJson, true
	case "EventNotificationList_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultJson, true
	case "EventFieldList_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultJson, true
	case "HistoryEventFieldList_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultJson, true
	case "StatusChangeNotification_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultJson, true
	case "SubscriptionAcknowledgement_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultJson, true
	case "PublishRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultJson, true
	case "PublishResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultJson, true
	case "RepublishRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultJson, true
	case "RepublishResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultJson, true
	case "TransferResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultJson, true
	case "TransferSubscriptionsRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultJson, true
	case "TransferSubscriptionsResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultJson, true
	case "DeleteSubscriptionsRequest_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultJson, true
	case "DeleteSubscriptionsResponse_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultJson, true
	case "BuildInfo_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultJson, true
	case "RedundantServerDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultJson, true
	case "EndpointUrlListDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultJson, true
	case "NetworkGroupDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultJson, true
	case "SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson, true
	case "ServerDiagnosticsSummaryDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultJson, true
	case "ServerStatusDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultJson, true
	case "SessionDiagnosticsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultJson, true
	case "SessionSecurityDiagnosticsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultJson, true
	case "ServiceCounterDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultJson, true
	case "StatusResult_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultJson, true
	case "SubscriptionDiagnosticsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultJson, true
	case "ModelChangeStructureDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultJson, true
	case "SemanticChangeStructureDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultJson, true
	case "Range_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_Range_Encoding_DefaultJson, true
	case "EUInformation_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultJson, true
	case "ComplexNumberType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultJson, true
	case "DoubleComplexNumberType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultJson, true
	case "AxisInformation_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultJson, true
	case "XVType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_XVType_Encoding_DefaultJson, true
	case "ProgramDiagnosticDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultJson, true
	case "Annotation_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultJson, true
	case "TestScalarStructure_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultJson, true
	case "TestArrayStructure_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultJson, true
	case "TestStructure_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultJson, true
	case "TestAbstractStructure_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultBinary, true
	case "TestConcreteStructure_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultBinary, true
	case "TestAbstractStructure_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultXml, true
	case "TestConcreteStructure_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultXml, true
	case "TestAbstractStructure_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultJson, true
	case "SimpleTypeDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultBinary, true
	case "UABinaryFileDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultBinary, true
	case "TestConcreteStructure_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultJson, true
	case "PublishSubscribe_SecurityGroups":
		return OpcuaNodeIdServicesObject_PublishSubscribe_SecurityGroups, true
	case "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder":
		return OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder, true
	case "SecurityGroupFolderType_SecurityGroupName_Placeholder":
		return OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupName_Placeholder, true
	case "DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields":
		return OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields, true
	case "BrokerConnectionTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultBinary, true
	case "PublishedDataSetType_ExtensionFields":
		return OpcuaNodeIdServicesObject_PublishedDataSetType_ExtensionFields, true
	case "SimpleTypeDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultXml, true
	case "UABinaryFileDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultXml, true
	case "ServerConfigurationType_ConfigurationFile":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_ConfigurationFile, true
	case "BrokerConnectionTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultXml, true
	case "StructureDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultXml, true
	case "EnumDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultXml, true
	case "Server_ServerCapabilities_RoleSet":
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities_RoleSet, true
	case "RoleSetType_RoleName_Placeholder":
		return OpcuaNodeIdServicesObject_RoleSetType_RoleName_Placeholder, true
	case "WellKnownRole_Anonymous":
		return OpcuaNodeIdServicesObject_WellKnownRole_Anonymous, true
	case "WellKnownRole_AuthenticatedUser":
		return OpcuaNodeIdServicesObject_WellKnownRole_AuthenticatedUser, true
	case "WellKnownRole_Observer":
		return OpcuaNodeIdServicesObject_WellKnownRole_Observer, true
	case "EndpointType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultBinary, true
	case "DataTypeSchemaHeader_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultBinary, true
	case "PublishedDataSetDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultBinary, true
	case "PublishedDataSetSourceDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultBinary, true
	case "PublishedDataItemsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultBinary, true
	case "WellKnownRole_Operator":
		return OpcuaNodeIdServicesObject_WellKnownRole_Operator, true
	case "PublishedEventsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultBinary, true
	case "DataSetWriterDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultBinary, true
	case "DataSetWriterTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultBinary, true
	case "DataSetWriterMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultBinary, true
	case "PubSubGroupDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultBinary, true
	case "WriterGroupTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultBinary, true
	case "WellKnownRole_Supervisor":
		return OpcuaNodeIdServicesObject_WellKnownRole_Supervisor, true
	case "WriterGroupMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultBinary, true
	case "PubSubConnectionDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultBinary, true
	case "ConnectionTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultBinary, true
	case "SimpleTypeDescription_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultJson, true
	case "ReaderGroupTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultBinary, true
	case "ReaderGroupMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultBinary, true
	case "DataSetReaderDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultBinary, true
	case "WellKnownRole_SecurityAdmin":
		return OpcuaNodeIdServicesObject_WellKnownRole_SecurityAdmin, true
	case "DataSetReaderTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultBinary, true
	case "DataSetReaderMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultBinary, true
	case "SubscribedDataSetDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultBinary, true
	case "TargetVariablesDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultBinary, true
	case "SubscribedDataSetMirrorDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultBinary, true
	case "UABinaryFileDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultJson, true
	case "UadpWriterGroupMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultBinary, true
	case "WellKnownRole_ConfigureAdmin":
		return OpcuaNodeIdServicesObject_WellKnownRole_ConfigureAdmin, true
	case "UadpDataSetWriterMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultBinary, true
	case "UadpDataSetReaderMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultBinary, true
	case "JsonWriterGroupMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultBinary, true
	case "JsonDataSetWriterMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultBinary, true
	case "JsonDataSetReaderMessageDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultBinary, true
	case "BrokerConnectionTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultJson, true
	case "BrokerWriterGroupTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultBinary, true
	case "IdentityMappingRuleType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultXml, true
	case "BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary, true
	case "BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary, true
	case "IdentityMappingRuleType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultBinary, true
	case "TemporaryFileTransferType_TransferState_Placeholder":
		return OpcuaNodeIdServicesObject_TemporaryFileTransferType_TransferState_Placeholder, true
	case "FileTransferStateMachineType_Idle":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_Idle, true
	case "FileTransferStateMachineType_ReadPrepare":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepare, true
	case "FileTransferStateMachineType_ReadTransfer":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransfer, true
	case "FileTransferStateMachineType_ApplyWrite":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWrite, true
	case "FileTransferStateMachineType_Error":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_Error, true
	case "FileTransferStateMachineType_IdleToReadPrepare":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToReadPrepare, true
	case "FileTransferStateMachineType_ReadPrepareToReadTransfer":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToReadTransfer, true
	case "FileTransferStateMachineType_ReadTransferToIdle":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToIdle, true
	case "FileTransferStateMachineType_IdleToApplyWrite":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToApplyWrite, true
	case "FileTransferStateMachineType_ApplyWriteToIdle":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToIdle, true
	case "FileTransferStateMachineType_ReadPrepareToError":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToError, true
	case "FileTransferStateMachineType_ReadTransferToError":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToError, true
	case "FileTransferStateMachineType_ApplyWriteToError":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToError, true
	case "FileTransferStateMachineType_ErrorToIdle":
		return OpcuaNodeIdServicesObject_FileTransferStateMachineType_ErrorToIdle, true
	case "PublishSubscribeType_Status":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_Status, true
	case "ServerConfiguration_ConfigurationFile":
		return OpcuaNodeIdServicesObject_ServerConfiguration_ConfigurationFile, true
	case "SessionlessInvokeRequestType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultXml, true
	case "SessionlessInvokeRequestType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultBinary, true
	case "PublishSubscribeType_ConnectionName_Placeholder_TransportSettings":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_TransportSettings, true
	case "PubSubKeyServiceType_SecurityGroups":
		return OpcuaNodeIdServicesObject_PubSubKeyServiceType_SecurityGroups, true
	case "EndpointType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultXml, true
	case "DataTypeSchemaHeader_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultXml, true
	case "PublishedDataSetDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultXml, true
	case "PublishedDataSetSourceDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultXml, true
	case "PublishedDataItemsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultXml, true
	case "PublishedEventsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultXml, true
	case "DataSetWriterDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultXml, true
	case "DataSetWriterTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultXml, true
	case "OPCUANamespaceMetadata":
		return OpcuaNodeIdServicesObject_OPCUANamespaceMetadata, true
	case "OPCUANamespaceMetadata_NamespaceFile":
		return OpcuaNodeIdServicesObject_OPCUANamespaceMetadata_NamespaceFile, true
	case "DataSetWriterMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultXml, true
	case "PubSubGroupDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultXml, true
	case "WriterGroupTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultXml, true
	case "WriterGroupMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultXml, true
	case "PubSubConnectionDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultXml, true
	case "ConnectionTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultXml, true
	case "ReaderGroupTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultXml, true
	case "ReaderGroupMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultXml, true
	case "DataSetReaderDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultXml, true
	case "DataSetReaderTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultXml, true
	case "DataSetReaderMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultXml, true
	case "SubscribedDataSetDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultXml, true
	case "TargetVariablesDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultXml, true
	case "SubscribedDataSetMirrorDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultXml, true
	case "UadpWriterGroupMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultXml, true
	case "UadpDataSetWriterMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultXml, true
	case "UadpDataSetReaderMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultXml, true
	case "JsonWriterGroupMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultXml, true
	case "JsonDataSetWriterMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultXml, true
	case "JsonDataSetReaderMessageDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultXml, true
	case "BrokerWriterGroupTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultXml, true
	case "BrokerDataSetWriterTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultXml, true
	case "BrokerDataSetReaderTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultXml, true
	case "WellKnownRole_Engineer":
		return OpcuaNodeIdServicesObject_WellKnownRole_Engineer, true
	case "RolePermissionType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultXml, true
	case "EndpointType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultJson, true
	case "DataTypeSchemaHeader_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultJson, true
	case "PublishedDataSetDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultJson, true
	case "PublishedDataSetSourceDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultJson, true
	case "PublishedDataItemsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultJson, true
	case "PublishedEventsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultJson, true
	case "DataSetWriterDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultJson, true
	case "DataSetWriterTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultJson, true
	case "DataSetWriterMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultJson, true
	case "PubSubGroupDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultJson, true
	case "WriterGroupTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultJson, true
	case "WriterGroupMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultJson, true
	case "PubSubConnectionDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultJson, true
	case "ConnectionTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultJson, true
	case "ReaderGroupTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultJson, true
	case "ReaderGroupMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultJson, true
	case "DataSetReaderDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultJson, true
	case "DataSetReaderTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultJson, true
	case "DataSetReaderMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultJson, true
	case "ServerType_ServerCapabilities_RoleSet":
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_RoleSet, true
	case "ServerCapabilitiesType_RoleSet":
		return OpcuaNodeIdServicesObject_ServerCapabilitiesType_RoleSet, true
	case "SubscribedDataSetDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultJson, true
	case "TargetVariablesDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultJson, true
	case "SubscribedDataSetMirrorDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultJson, true
	case "FileSystem":
		return OpcuaNodeIdServicesObject_FileSystem, true
	case "UadpWriterGroupMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultJson, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile, true
	case "UadpDataSetWriterMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultJson, true
	case "UadpDataSetReaderMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultJson, true
	case "JsonWriterGroupMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultJson, true
	case "JsonDataSetWriterMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultJson, true
	case "AlarmConditionType_FirstInGroup":
		return OpcuaNodeIdServicesObject_AlarmConditionType_FirstInGroup, true
	case "AlarmConditionType_AlarmGroup_Placeholder":
		return OpcuaNodeIdServicesObject_AlarmConditionType_AlarmGroup_Placeholder, true
	case "JsonDataSetReaderMessageDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultJson, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder":
		return OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState":
		return OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState, true
	case "BrokerWriterGroupTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultJson, true
	case "BrokerDataSetWriterTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultJson, true
	case "BrokerDataSetReaderTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultJson, true
	case "AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup":
		return OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup, true
	case "BaseConfigurationDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultBinary, true
	case "BaseConfigurationRecordDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultBinary, true
	case "CertificateGroupDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultBinary, true
	case "ConfigurationUpdateTargetType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultBinary, true
	case "ApplicationConfigurationDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultBinary, true
	case "ApplicationIdentityDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultBinary, true
	case "EndpointDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultBinary, true
	case "ServerEndpointDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultBinary, true
	case "SecuritySettingsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultBinary, true
	case "UserTokenSettingsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultBinary, true
	case "BaseConfigurationDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultXml, true
	case "BaseConfigurationRecordDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultXml, true
	case "CertificateGroupDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultXml, true
	case "ConfigurationUpdateTargetType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultXml, true
	case "ApplicationConfigurationDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultXml, true
	case "ApplicationIdentityDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultXml, true
	case "EndpointDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultXml, true
	case "ServerEndpointDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultXml, true
	case "SecuritySettingsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultXml, true
	case "UserTokenSettingsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultXml, true
	case "BaseConfigurationDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultJson, true
	case "BaseConfigurationRecordDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultJson, true
	case "CertificateGroupDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultJson, true
	case "ConfigurationUpdateTargetType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultJson, true
	case "ApplicationConfigurationDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultJson, true
	case "ApplicationIdentityDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultJson, true
	case "EndpointDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultJson, true
	case "ServerEndpointDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultJson, true
	case "SecuritySettingsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultJson, true
	case "UserTokenSettingsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultJson, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder, true
	case "ManagedApplications":
		return OpcuaNodeIdServicesObject_ManagedApplications, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings":
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired, true
	case "PubSubConnectionType_TransportSettings":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_TransportSettings, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_TransportSettings":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_TransportSettings, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_MessageSettings":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_MessageSettings, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_TransportSettings":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_TransportSettings, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_MessageSettings":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_MessageSettings, true
	case "PubSubConnectionType_WriterGroupName_Placeholder":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Status":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Status, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Status":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Status, true
	case "PublishSubscribe_PublishedDataSets":
		return OpcuaNodeIdServicesObject_PublishSubscribe_PublishedDataSets, true
	case "PublishSubscribe_Status":
		return OpcuaNodeIdServicesObject_PublishSubscribe_Status, true
	case "PublishSubscribe_Diagnostics":
		return OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics, true
	case "PublishSubscribe_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_Counters, true
	case "PublishSubscribe_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_LiveValues, true
	case "DatagramConnectionTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultBinary, true
	case "DatagramConnectionTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultXml, true
	case "DatagramConnectionTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultJson, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case "KeyCredentialConfigurationFolderType_ServiceName_Placeholder":
		return OpcuaNodeIdServicesObject_KeyCredentialConfigurationFolderType_ServiceName_Placeholder, true
	case "AdditionalParametersType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultBinary, true
	case "AdditionalParametersType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultXml, true
	case "AdditionalParametersType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultJson, true
	case "EphemeralKeyType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultBinary, true
	case "EphemeralKeyType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultXml, true
	case "EphemeralKeyType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultJson, true
	case "DictionaryEntryType_DictionaryEntryName_Placeholder":
		return OpcuaNodeIdServicesObject_DictionaryEntryType_DictionaryEntryName_Placeholder, true
	case "DictionaryFolderType_DictionaryFolderName_Placeholder":
		return OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryFolderName_Placeholder, true
	case "DictionaryFolderType_DictionaryEntryName_Placeholder":
		return OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryEntryName_Placeholder, true
	case "Dictionaries":
		return OpcuaNodeIdServicesObject_Dictionaries, true
	case "GenericAttributeValue_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultXml, true
	case "GenericAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultXml, true
	case "GenericAttributeValue_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultBinary, true
	case "GenericAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultBinary, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate, true
	case "InterfaceTypes":
		return OpcuaNodeIdServicesObject_InterfaceTypes, true
	case "AuthorizationServices":
		return OpcuaNodeIdServicesObject_AuthorizationServices, true
	case "WriterGroupType_TransportSettings":
		return OpcuaNodeIdServicesObject_WriterGroupType_TransportSettings, true
	case "WriterGroupType_MessageSettings":
		return OpcuaNodeIdServicesObject_WriterGroupType_MessageSettings, true
	case "WriterGroupType_DataSetWriterName_Placeholder":
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder, true
	case "WriterGroupType_DataSetWriterName_Placeholder_TransportSettings":
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_TransportSettings, true
	case "WriterGroupType_DataSetWriterName_Placeholder_MessageSettings":
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_MessageSettings, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Status":
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Status, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics":
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters, true
	case "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues, true
	case "WriterGroupType_Diagnostics":
		return OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics, true
	case "WriterGroupType_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_Counters, true
	case "WriterGroupType_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_LiveValues, true
	case "DecimalDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultXml, true
	case "DecimalDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultBinary, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired, true
	case "ReaderGroupType_DataSetReaderName_Placeholder":
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_TransportSettings":
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_TransportSettings, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_MessageSettings":
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_MessageSettings, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Status":
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Status, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics":
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues, true
	case "KeyCredentialConfiguration":
		return OpcuaNodeIdServicesObject_KeyCredentialConfiguration, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_TransactionDiagnostics":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_TransactionDiagnostics, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile, true
	case "ActionTargetDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultBinary, true
	case "PublishedActionDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultBinary, true
	case "ActionMethodDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultBinary, true
	case "ActionTargetDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultXml, true
	case "PublishedActionDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultXml, true
	case "ActionMethodDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultXml, true
	case "ActionTargetDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultJson, true
	case "PublishedActionDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultJson, true
	case "ActionMethodDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultJson, true
	case "WellKnownRole_TrustedApplication":
		return OpcuaNodeIdServicesObject_WellKnownRole_TrustedApplication, true
	case "SortRuleElement_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultBinary, true
	case "ReadEventDetailsSorted_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultBinary, true
	case "SortRuleElement_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultXml, true
	case "ReadEventDetailsSorted_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultXml, true
	case "SortRuleElement_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultJson, true
	case "ReadEventDetailsSorted_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultJson, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters, true
	case "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues, true
	case "PublishSubscribeType_Diagnostics":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics, true
	case "PublishSubscribeType_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_Counters, true
	case "PublishSubscribeType_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_LiveValues, true
	case "PublishedActionMethodDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultBinary, true
	case "RationalNumber_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultBinary, true
	case "Vector_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_Vector_Encoding_DefaultBinary, true
	case "ThreeDVector_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultBinary, true
	case "CartesianCoordinates_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultBinary, true
	case "ThreeDCartesianCoordinates_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultBinary, true
	case "Orientation_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultBinary, true
	case "ThreeDOrientation_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultBinary, true
	case "Frame_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_Frame_Encoding_DefaultBinary, true
	case "ThreeDFrame_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultBinary, true
	case "RationalNumber_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultXml, true
	case "Vector_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_Vector_Encoding_DefaultXml, true
	case "ThreeDVector_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultXml, true
	case "CartesianCoordinates_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultXml, true
	case "ThreeDCartesianCoordinates_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultXml, true
	case "Orientation_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultXml, true
	case "ThreeDOrientation_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultXml, true
	case "Frame_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_Frame_Encoding_DefaultXml, true
	case "ThreeDFrame_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultXml, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics":
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters, true
	case "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues, true
	case "DtlsPubSubConnectionDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultBinary, true
	case "PublishedActionMethodDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultXml, true
	case "DtlsPubSubConnectionDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultXml, true
	case "PublishedActionMethodDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultJson, true
	case "DtlsPubSubConnectionDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultJson, true
	case "LLDP":
		return OpcuaNodeIdServicesObject_LLDP, true
	case "LLDP_RemoteStatistics":
		return OpcuaNodeIdServicesObject_LLDP_RemoteStatistics, true
	case "LLDP_LocalSystemData":
		return OpcuaNodeIdServicesObject_LLDP_LocalSystemData, true
	case "LLDP_Ports":
		return OpcuaNodeIdServicesObject_LLDP_Ports, true
	case "LldpInformationType_RemoteStatistics":
		return OpcuaNodeIdServicesObject_LldpInformationType_RemoteStatistics, true
	case "LldpInformationType_LocalSystemData":
		return OpcuaNodeIdServicesObject_LldpInformationType_LocalSystemData, true
	case "LldpInformationType_Ports":
		return OpcuaNodeIdServicesObject_LldpInformationType_Ports, true
	case "LldpInformationType_Ports_LldpPortInformation_Placeholder":
		return OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder, true
	case "LldpInformationType_Ports_LldpPortInformation_Placeholder_RemoteSystemsData":
		return OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder_RemoteSystemsData, true
	case "LldpPortInformationType_RemoteSystemsData":
		return OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder":
		return OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder, true
	case "RationalNumber_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultJson, true
	case "Vector_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_Vector_Encoding_DefaultJson, true
	case "ThreeDVector_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultJson, true
	case "CartesianCoordinates_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultJson, true
	case "ThreeDCartesianCoordinates_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultJson, true
	case "Orientation_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultJson, true
	case "ThreeDOrientation_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultJson, true
	case "Frame_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_Frame_Encoding_DefaultJson, true
	case "ThreeDFrame_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultJson, true
	case "LldpManagementAddressTxPortType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultBinary, true
	case "LldpManagementAddressType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultBinary, true
	case "LldpTlvType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultBinary, true
	case "LldpManagementAddressTxPortType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultXml, true
	case "LldpManagementAddressType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultXml, true
	case "LldpTlvType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultXml, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters, true
	case "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters, true
	case "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues, true
	case "PubSubConnectionType_Diagnostics":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics, true
	case "PubSubConnectionType_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_Counters, true
	case "PubSubConnectionType_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_LiveValues, true
	case "LldpManagementAddressTxPortType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultJson, true
	case "LldpManagementAddressType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultJson, true
	case "LldpTlvType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultJson, true
	case "ServerLog":
		return OpcuaNodeIdServicesObject_ServerLog, true
	case "Logs":
		return OpcuaNodeIdServicesObject_Logs, true
	case "LogRecord_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultBinary, true
	case "LogRecord_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultXml, true
	case "LogRecord_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultJson, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials, true
	case "ApplicationConfigurationFolderType_ApplicationName_Placeholder_AuthorizationServices":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_AuthorizationServices, true
	case "ApplicationConfigurationType_KeyCredentials":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationType_KeyCredentials, true
	case "ApplicationConfigurationType_AuthorizationServices":
		return OpcuaNodeIdServicesObject_ApplicationConfigurationType_AuthorizationServices, true
	case "TestUnion_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultBinary, true
	case "TestOptionalFields_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultBinary, true
	case "TestUnion_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultXml, true
	case "TestOptionalFields_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultXml, true
	case "TestUnion_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultJson, true
	case "TestOptionalFields_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultJson, true
	case "CertificateGroupType_CertificateExpired":
		return OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired, true
	case "CertificateGroupType_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_ShelvingState, true
	case "DataSetWriterType_Diagnostics":
		return OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics, true
	case "DataSetWriterType_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_Counters, true
	case "DataSetWriterType_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_LiveValues, true
	case "DataSetReaderType_Diagnostics":
		return OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics, true
	case "DataSetReaderType_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_Counters, true
	case "DataSetReaderType_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_LiveValues, true
	case "PubSubDiagnosticsType_Counters":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsType_Counters, true
	case "PubSubDiagnosticsType_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsType_LiveValues, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_AuthorizationServices":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_AuthorizationServices, true
	case "AuthorizationServiceConfigurationDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultBinary, true
	case "LogRecordsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultBinary, true
	case "SpanContextDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultBinary, true
	case "TraceContextDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultBinary, true
	case "NameValuePair_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultBinary, true
	case "AuthorizationServiceConfigurationDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultXml, true
	case "LogRecordsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultXml, true
	case "SpanContextDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultXml, true
	case "TraceContextDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultXml, true
	case "NameValuePair_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultXml, true
	case "PubSubDiagnosticsRootType_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsRootType_LiveValues, true
	case "AuthorizationServiceConfigurationDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultJson, true
	case "LogRecordsDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultJson, true
	case "SpanContextDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultJson, true
	case "TraceContextDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultJson, true
	case "NameValuePair_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultJson, true
	case "PubSubDiagnosticsConnectionType_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsConnectionType_LiveValues, true
	case "PubSubDiagnosticsWriterGroupType_Counters":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_Counters, true
	case "PubSubDiagnosticsWriterGroupType_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_LiveValues, true
	case "PubSubDiagnosticsReaderGroupType_Counters":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_Counters, true
	case "PubSubDiagnosticsReaderGroupType_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_LiveValues, true
	case "PubSubDiagnosticsDataSetWriterType_Counters":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_Counters, true
	case "PubSubDiagnosticsDataSetWriterType_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_LiveValues, true
	case "PubSubDiagnosticsDataSetReaderType_Counters":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_Counters, true
	case "PubSubDiagnosticsDataSetReaderType_LiveValues":
		return OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_LiveValues, true
	case "ServerType_ServerCapabilities":
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities, true
	case "ServerType_ServerDiagnostics":
		return OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics, true
	case "ServerType_VendorServerInfo":
		return OpcuaNodeIdServicesObject_ServerType_VendorServerInfo, true
	case "ServerType_ServerRedundancy":
		return OpcuaNodeIdServicesObject_ServerType_ServerRedundancy, true
	case "CertificateGroupType_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_FirstInGroup, true
	case "CertificateGroupType_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate, true
	case "ServerCapabilitiesType_ModellingRules":
		return OpcuaNodeIdServicesObject_ServerCapabilitiesType_ModellingRules, true
	case "CertificateGroupType_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_ShelvingState, true
	case "CertificateGroupType_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_FirstInGroup, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case "SessionlessInvokeResponseType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultXml, true
	case "SessionlessInvokeResponseType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultBinary, true
	case "ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet":
		return OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet, true
	case "ReaderGroupType_Diagnostics":
		return OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics, true
	case "ReaderGroupType_Diagnostics_Counters":
		return OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_Counters, true
	case "ReaderGroupType_Diagnostics_LiveValues":
		return OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_LiveValues, true
	case "ReaderGroupType_TransportSettings":
		return OpcuaNodeIdServicesObject_ReaderGroupType_TransportSettings, true
	case "ReaderGroupType_MessageSettings":
		return OpcuaNodeIdServicesObject_ReaderGroupType_MessageSettings, true
	case "DataSetWriterType_MessageSettings":
		return OpcuaNodeIdServicesObject_DataSetWriterType_MessageSettings, true
	case "DataSetReaderType_MessageSettings":
		return OpcuaNodeIdServicesObject_DataSetReaderType_MessageSettings, true
	case "WriterGroupDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultBinary, true
	case "NetworkAddressDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultBinary, true
	case "NetworkAddressUrlDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultBinary, true
	case "ReaderGroupDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultBinary, true
	case "PubSubConfigurationDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultBinary, true
	case "DatagramWriterGroupTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultBinary, true
	case "WriterGroupDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultXml, true
	case "NetworkAddressDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultXml, true
	case "NetworkAddressUrlDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultXml, true
	case "ReaderGroupDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultXml, true
	case "PubSubConfigurationDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultXml, true
	case "DatagramWriterGroupTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultXml, true
	case "WriterGroupDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultJson, true
	case "NetworkAddressDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultJson, true
	case "NetworkAddressUrlDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultJson, true
	case "ReaderGroupDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultJson, true
	case "PubSubConfigurationDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultJson, true
	case "DatagramWriterGroupTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultJson, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroup, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState, true
	case "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case "Server":
		return OpcuaNodeIdServicesObject_Server, true
	case "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case "Server_ServerCapabilities":
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate, true
	case "Server_ServerDiagnostics":
		return OpcuaNodeIdServicesObject_Server_ServerDiagnostics, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired, true
	case "Server_VendorServerInfo":
		return OpcuaNodeIdServicesObject_Server_VendorServerInfo, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case "Server_ServerRedundancy":
		return OpcuaNodeIdServicesObject_Server_ServerRedundancy, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case "AggregateFunction_Interpolative":
		return OpcuaNodeIdServicesObject_AggregateFunction_Interpolative, true
	case "AggregateFunction_Average":
		return OpcuaNodeIdServicesObject_AggregateFunction_Average, true
	case "AggregateFunction_TimeAverage":
		return OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage, true
	case "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case "AggregateFunction_Total":
		return OpcuaNodeIdServicesObject_AggregateFunction_Total, true
	case "AliasNameCategoryType_Alias_Placeholder":
		return OpcuaNodeIdServicesObject_AliasNameCategoryType_Alias_Placeholder, true
	case "AliasNameCategoryType_SubAliasNameCategories_Placeholder":
		return OpcuaNodeIdServicesObject_AliasNameCategoryType_SubAliasNameCategories_Placeholder, true
	case "AggregateFunction_Minimum":
		return OpcuaNodeIdServicesObject_AggregateFunction_Minimum, true
	case "AggregateFunction_Maximum":
		return OpcuaNodeIdServicesObject_AggregateFunction_Maximum, true
	case "Aliases":
		return OpcuaNodeIdServicesObject_Aliases, true
	case "TagVariables":
		return OpcuaNodeIdServicesObject_TagVariables, true
	case "AggregateFunction_MinimumActualTime":
		return OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime, true
	case "Topics":
		return OpcuaNodeIdServicesObject_Topics, true
	case "AggregateFunction_MaximumActualTime":
		return OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime, true
	case "AliasNameDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultBinary, true
	case "AggregateFunction_Range":
		return OpcuaNodeIdServicesObject_AggregateFunction_Range, true
	case "ReadAnnotationDataDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultBinary, true
	case "AliasNameDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultXml, true
	case "ReadAnnotationDataDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultXml, true
	case "CurrencyUnitType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultBinary, true
	case "AggregateFunction_AnnotationCount":
		return OpcuaNodeIdServicesObject_AggregateFunction_AnnotationCount, true
	case "AliasNameDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultJson, true
	case "ReadAnnotationDataDetails_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultJson, true
	case "OrderedListType_OrderedObject_Placeholder":
		return OpcuaNodeIdServicesObject_OrderedListType_OrderedObject_Placeholder, true
	case "AggregateFunction_Count":
		return OpcuaNodeIdServicesObject_AggregateFunction_Count, true
	case "CurrencyUnitType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultXml, true
	case "CurrencyUnitType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultJson, true
	case "AggregateFunction_NumberOfTransitions":
		return OpcuaNodeIdServicesObject_AggregateFunction_NumberOfTransitions, true
	case "AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder":
		return OpcuaNodeIdServicesObject_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder, true
	case "AggregateFunction_Start":
		return OpcuaNodeIdServicesObject_AggregateFunction_Start, true
	case "AggregateFunction_End":
		return OpcuaNodeIdServicesObject_AggregateFunction_End, true
	case "AggregateFunction_Delta":
		return OpcuaNodeIdServicesObject_AggregateFunction_Delta, true
	case "AggregateFunction_DurationGood":
		return OpcuaNodeIdServicesObject_AggregateFunction_DurationGood, true
	case "AggregateFunction_DurationBad":
		return OpcuaNodeIdServicesObject_AggregateFunction_DurationBad, true
	case "AggregateFunction_PercentGood":
		return OpcuaNodeIdServicesObject_AggregateFunction_PercentGood, true
	case "PublishSubscribeType_SubscribedDataSets":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_SubscribedDataSets, true
	case "AggregateFunction_PercentBad":
		return OpcuaNodeIdServicesObject_AggregateFunction_PercentBad, true
	case "AggregateFunction_WorstQuality":
		return OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality, true
	case "PublishSubscribeType_PubSubCapablities":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubCapablities, true
	case "PublishSubscribeType_DataSetClasses":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_DataSetClasses, true
	case "PublishSubscribe_SubscribedDataSets":
		return OpcuaNodeIdServicesObject_PublishSubscribe_SubscribedDataSets, true
	case "PublishSubscribe_PubSubCapablities":
		return OpcuaNodeIdServicesObject_PublishSubscribe_PubSubCapablities, true
	case "PublishSubscribe_DataSetClasses":
		return OpcuaNodeIdServicesObject_PublishSubscribe_DataSetClasses, true
	case "SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder":
		return OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder, true
	case "SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder":
		return OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder, true
	case "SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet":
		return OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet, true
	case "StandaloneSubscribedDataSetType_SubscribedDataSet":
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetType_SubscribedDataSet, true
	case "DatagramWriterGroupTransportType_Address":
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransportType_Address, true
	case "StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary, true
	case "StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary, true
	case "SecurityGroupDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultBinary, true
	case "PubSubConfiguration2DataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultBinary, true
	case "QosDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultBinary, true
	case "TransmitQosDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultBinary, true
	case "TransmitQosPriorityDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultBinary, true
	case "ReceiveQosDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultBinary, true
	case "ReceiveQosPriorityDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultBinary, true
	case "DatagramConnectionTransport2DataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultBinary, true
	case "DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary, true
	case "DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary, true
	case "StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml, true
	case "StandaloneSubscribedDataSetDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultXml, true
	case "SecurityGroupDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultXml, true
	case "PubSubConfiguration2DataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultXml, true
	case "QosDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultXml, true
	case "TransmitQosDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultXml, true
	case "TransmitQosPriorityDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultXml, true
	case "ReceiveQosDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultXml, true
	case "ReceiveQosPriorityDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultXml, true
	case "DatagramConnectionTransport2DataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultXml, true
	case "DatagramWriterGroupTransport2DataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultXml, true
	case "DatagramDataSetReaderTransportDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultXml, true
	case "StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson, true
	case "StandaloneSubscribedDataSetDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultJson, true
	case "SecurityGroupDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultJson, true
	case "PubSubConfiguration2DataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultJson, true
	case "QosDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultJson, true
	case "TransmitQosDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultJson, true
	case "TransmitQosPriorityDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultJson, true
	case "ReceiveQosDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultJson, true
	case "ReceiveQosPriorityDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultJson, true
	case "ProgramStateMachineType_Ready":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_Ready, true
	case "DatagramConnectionTransport2DataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultJson, true
	case "DatagramWriterGroupTransport2DataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultJson, true
	case "DatagramDataSetReaderTransportDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultJson, true
	case "DatagramDataSetReaderTransportType_Address":
		return OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportType_Address, true
	case "ProgramStateMachineType_Running":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_Running, true
	case "ProgramDiagnostic2DataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultBinary, true
	case "ProgramDiagnostic2DataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultXml, true
	case "ProgramStateMachineType_Suspended":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_Suspended, true
	case "ProgramDiagnostic2DataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultJson, true
	case "ProgramStateMachineType_Halted":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_Halted, true
	case "ProgramStateMachineType_HaltedToReady":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_HaltedToReady, true
	case "ProgramStateMachineType_ReadyToRunning":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToRunning, true
	case "PortableQualifiedName_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultBinary, true
	case "PortableNodeId_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultBinary, true
	case "UnsignedRationalNumber_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultBinary, true
	case "ProgramStateMachineType_RunningToHalted":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToHalted, true
	case "PortableQualifiedName_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultXml, true
	case "PortableNodeId_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultXml, true
	case "UnsignedRationalNumber_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultXml, true
	case "PortableQualifiedName_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultJson, true
	case "PortableNodeId_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultJson, true
	case "UnsignedRationalNumber_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultJson, true
	case "ProgramStateMachineType_RunningToReady":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToReady, true
	case "ProgramStateMachineType_RunningToSuspended":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToSuspended, true
	case "ProgramStateMachineType_SuspendedToRunning":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToRunning, true
	case "ProgramStateMachineType_SuspendedToHalted":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToHalted, true
	case "ProgramStateMachineType_SuspendedToReady":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToReady, true
	case "Resources":
		return OpcuaNodeIdServicesObject_Resources, true
	case "Communication":
		return OpcuaNodeIdServicesObject_Communication, true
	case "MappingTables":
		return OpcuaNodeIdServicesObject_MappingTables, true
	case "NetworkInterfaces":
		return OpcuaNodeIdServicesObject_NetworkInterfaces, true
	case "Streams":
		return OpcuaNodeIdServicesObject_Streams, true
	case "TalkerStreams":
		return OpcuaNodeIdServicesObject_TalkerStreams, true
	case "ListenerStreams":
		return OpcuaNodeIdServicesObject_ListenerStreams, true
	case "ProgramStateMachineType_ReadyToHalted":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToHalted, true
	case "UserManagement":
		return OpcuaNodeIdServicesObject_UserManagement, true
	case "UserManagementDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultBinary, true
	case "UserManagementDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultXml, true
	case "UserManagementDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultJson, true
	case "IetfBaseNetworkInterfaceType_InterfaceName_Placeholder":
		return OpcuaNodeIdServicesObject_IetfBaseNetworkInterfaceType_InterfaceName_Placeholder, true
	case "PriorityMappingEntryType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultBinary, true
	case "PriorityMappingEntryType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultXml, true
	case "PriorityMappingEntryType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultJson, true
	case "PubSubKeyServiceType_KeyPushTargets":
		return OpcuaNodeIdServicesObject_PubSubKeyServiceType_KeyPushTargets, true
	case "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder":
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder, true
	case "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder":
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder, true
	case "PublishSubscribeType_PubSubConfiguration":
		return OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubConfiguration, true
	case "PublishSubscribe_KeyPushTargets":
		return OpcuaNodeIdServicesObject_PublishSubscribe_KeyPushTargets, true
	case "PublishSubscribe_PubSubConfiguration":
		return OpcuaNodeIdServicesObject_PublishSubscribe_PubSubConfiguration, true
	case "PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary, true
	case "PubSubKeyPushTargetDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultBinary, true
	case "PubSubConfigurationRefDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultBinary, true
	case "PubSubConfigurationValueDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultBinary, true
	case "PublishedDataSetCustomSourceDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultXml, true
	case "PubSubKeyPushTargetDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultXml, true
	case "PubSubConfigurationRefDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultXml, true
	case "PubSubConfigurationValueDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultXml, true
	case "PublishedDataSetCustomSourceDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultJson, true
	case "PubSubKeyPushTargetDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultJson, true
	case "PubSubConfigurationRefDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultJson, true
	case "PubSubConfigurationValueDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultJson, true
	case "WellKnownRole_SecurityKeyServerAdmin":
		return OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAdmin, true
	case "WellKnownRole_SecurityKeyServerPush":
		return OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerPush, true
	case "WellKnownRole_SecurityKeyServerAccess":
		return OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAccess, true
	case "PubSubKeyPushTargetType_SecurityGroupName_Placeholder":
		return OpcuaNodeIdServicesObject_PubSubKeyPushTargetType_SecurityGroupName_Placeholder, true
	case "Node_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_Node_Encoding_DefaultXml, true
	case "Node_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_Node_Encoding_DefaultBinary, true
	case "ObjectNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultXml, true
	case "ObjectNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultBinary, true
	case "ObjectTypeNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultXml, true
	case "ObjectTypeNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultBinary, true
	case "VariableNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultXml, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList, true
	case "VariableNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultBinary, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate, true
	case "VariableTypeNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultXml, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState, true
	case "VariableTypeNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultBinary, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState, true
	case "ReferenceTypeNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultXml, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup, true
	case "ServerDiagnosticsType_SessionsDiagnosticsSummary":
		return OpcuaNodeIdServicesObject_ServerDiagnosticsType_SessionsDiagnosticsSummary, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate, true
	case "ReferenceTypeNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultBinary, true
	case "ServerCapabilitiesType_AggregateFunctions":
		return OpcuaNodeIdServicesObject_ServerCapabilitiesType_AggregateFunctions, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired, true
	case "MethodNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultXml, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup, true
	case "MethodNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultBinary, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup, true
	case "ViewNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultXml, true
	case "ViewNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultBinary, true
	case "DataTypeNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultXml, true
	case "DataTypeNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultBinary, true
	case "ReferenceNode_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultXml, true
	case "ReferenceNode_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultBinary, true
	case "ShelvedStateMachineType_Unshelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_Unshelved, true
	case "ShelvedStateMachineType_TimedShelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelved, true
	case "ShelvedStateMachineType_OneShotShelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelved, true
	case "ShelvedStateMachineType_UnshelvedToTimedShelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToTimedShelved, true
	case "ShelvedStateMachineType_UnshelvedToOneShotShelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToOneShotShelved, true
	case "ShelvedStateMachineType_TimedShelvedToUnshelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToUnshelved, true
	case "ShelvedStateMachineType_TimedShelvedToOneShotShelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToOneShotShelved, true
	case "ShelvedStateMachineType_OneShotShelvedToUnshelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToUnshelved, true
	case "ShelvedStateMachineType_OneShotShelvedToTimedShelved":
		return OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToTimedShelved, true
	case "Argument_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_Argument_Encoding_DefaultXml, true
	case "Argument_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_Argument_Encoding_DefaultBinary, true
	case "ProvisionableDevice":
		return OpcuaNodeIdServicesObject_ProvisionableDevice, true
	case "Server_ServerCapabilities_ModellingRules":
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities_ModellingRules, true
	case "Server_ServerCapabilities_AggregateFunctions":
		return OpcuaNodeIdServicesObject_Server_ServerCapabilities_AggregateFunctions, true
	case "StatusResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultXml, true
	case "StatusResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultBinary, true
	case "EventTypesFolder":
		return OpcuaNodeIdServicesObject_EventTypesFolder, true
	case "UserTokenPolicy_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultXml, true
	case "HistoricalDataConfigurationType_AggregateConfiguration":
		return OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateConfiguration, true
	case "UserTokenPolicy_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultBinary, true
	case "DefaultBinary":
		return OpcuaNodeIdServicesObject_DefaultBinary, true
	case "DefaultXml":
		return OpcuaNodeIdServicesObject_DefaultXml, true
	case "ApplicationDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultXml, true
	case "ServerType_ServerCapabilities_ModellingRules":
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_ModellingRules, true
	case "ServerType_ServerCapabilities_AggregateFunctions":
		return OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_AggregateFunctions, true
	case "ApplicationDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultBinary, true
	case "ServerType_ServerDiagnostics_SessionsDiagnosticsSummary":
		return OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary, true
	case "EndpointDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultXml, true
	case "EndpointDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultBinary, true
	case "UserIdentityToken_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultXml, true
	case "UserIdentityToken_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultBinary, true
	case "Locations":
		return OpcuaNodeIdServicesObject_Locations, true
	case "AnonymousIdentityToken_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultXml, true
	case "AnonymousIdentityToken_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultBinary, true
	case "ServerConfigurationType_TransactionDiagnostics":
		return OpcuaNodeIdServicesObject_ServerConfigurationType_TransactionDiagnostics, true
	case "UserNameIdentityToken_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultXml, true
	case "ServerConfiguration_TransactionDiagnostics":
		return OpcuaNodeIdServicesObject_ServerConfiguration_TransactionDiagnostics, true
	case "ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics":
		return OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics, true
	case "TransactionErrorType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultBinary, true
	case "TransactionErrorType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultXml, true
	case "TransactionErrorType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultJson, true
	case "UserNameIdentityToken_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultBinary, true
	case "BitFieldDefinition_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultBinary, true
	case "BitFieldDefinition_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultXml, true
	case "BitFieldDefinition_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultJson, true
	case "ServerUnitType_AlternativeUnits":
		return OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits, true
	case "ServerUnitType_CoherentUnit":
		return OpcuaNodeIdServicesObject_ServerUnitType_CoherentUnit, true
	case "QuantityType_ServerUnits":
		return OpcuaNodeIdServicesObject_QuantityType_ServerUnits, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder":
		return OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_AlternativeUnits":
		return OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_AlternativeUnits, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit":
		return OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit, true
	case "QuantitiesFolderType_Quantity_Placeholder":
		return OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder, true
	case "QuantitiesFolderType_Quantity_Placeholder_ServerUnits":
		return OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder_ServerUnits, true
	case "Quantities":
		return OpcuaNodeIdServicesObject_Quantities, true
	case "AnnotationDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultBinary, true
	case "LinearConversionDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultBinary, true
	case "QuantityDimension_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultBinary, true
	case "AnnotationDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultXml, true
	case "LinearConversionDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultXml, true
	case "QuantityDimension_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultXml, true
	case "AnnotationDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultJson, true
	case "LinearConversionDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultJson, true
	case "QuantityDimension_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultJson, true
	case "ServerUnitType_AlternativeUnits_AlternativeUnit_Placeholder":
		return OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits_AlternativeUnit_Placeholder, true
	case "X509IdentityToken_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultXml, true
	case "HistoricalEventConfigurationType_EventTypes":
		return OpcuaNodeIdServicesObject_HistoricalEventConfigurationType_EventTypes, true
	case "DefaultHAConfiguration":
		return OpcuaNodeIdServicesObject_DefaultHAConfiguration, true
	case "DefaultHAConfiguration_AggregateConfiguration":
		return OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateConfiguration, true
	case "DefaultHAConfiguration_AggregateFunctions":
		return OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateFunctions, true
	case "ReferenceDescriptionDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultBinary, true
	case "ReferenceListEntryDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultBinary, true
	case "ReferenceDescriptionDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultXml, true
	case "ReferenceListEntryDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultXml, true
	case "ReferenceDescriptionDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultJson, true
	case "ReferenceListEntryDataType_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultJson, true
	case "X509IdentityToken_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultBinary, true
	case "DefaultHEConfiguration":
		return OpcuaNodeIdServicesObject_DefaultHEConfiguration, true
	case "DefaultHEConfiguration_EventTypes":
		return OpcuaNodeIdServicesObject_DefaultHEConfiguration_EventTypes, true
	case "ReadEventDetails2_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultBinary, true
	case "ReadEventDetails2_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultXml, true
	case "ReadEventDetails2_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultJson, true
	case "HistoryModifiedEvent_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultBinary, true
	case "HistoryModifiedEvent_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultXml, true
	case "HistoryModifiedEvent_Encoding_DefaultJson":
		return OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultJson, true
	case "EndpointConfiguration_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultXml, true
	case "EndpointConfiguration_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultBinary, true
	case "BuildInfo_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultXml, true
	case "BuildInfo_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultBinary, true
	case "SignedSoftwareCertificate_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultXml, true
	case "SignedSoftwareCertificate_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultBinary, true
	case "NodeAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultXml, true
	case "NodeAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultBinary, true
	case "ObjectAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultXml, true
	case "ObjectAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultBinary, true
	case "VariableAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultXml, true
	case "VariableAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultBinary, true
	case "MethodAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultXml, true
	case "MethodAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultBinary, true
	case "ObjectTypeAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultXml, true
	case "ObjectTypeAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultBinary, true
	case "VariableTypeAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultXml, true
	case "VariableTypeAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultBinary, true
	case "ReferenceTypeAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultXml, true
	case "ReferenceTypeAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultBinary, true
	case "Server_ServerDiagnostics_SessionsDiagnosticsSummary":
		return OpcuaNodeIdServicesObject_Server_ServerDiagnostics_SessionsDiagnosticsSummary, true
	case "DataTypeAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultXml, true
	case "DataTypeAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultBinary, true
	case "ViewAttributes_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultXml, true
	case "ViewAttributes_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultBinary, true
	case "AddNodesItem_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultXml, true
	case "AddNodesItem_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultBinary, true
	case "AddReferencesItem_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultXml, true
	case "AddReferencesItem_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultBinary, true
	case "DeleteNodesItem_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultXml, true
	case "DeleteNodesItem_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultBinary, true
	case "ProgramStateMachineType_FinalResultData":
		return OpcuaNodeIdServicesObject_ProgramStateMachineType_FinalResultData, true
	case "DeleteReferencesItem_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultXml, true
	case "DeleteReferencesItem_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultBinary, true
	case "RequestHeader_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultXml, true
	case "RequestHeader_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultBinary, true
	case "ResponseHeader_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultXml, true
	case "ResponseHeader_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultBinary, true
	case "ServiceFault_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultXml, true
	case "ServiceFault_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultBinary, true
	case "FindServersRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultXml, true
	case "FindServersRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultBinary, true
	case "FindServersResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultXml, true
	case "FindServersResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultBinary, true
	case "GetEndpointsRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultXml, true
	case "GetEndpointsRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultBinary, true
	case "GetEndpointsResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultXml, true
	case "GetEndpointsResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultBinary, true
	case "RegisteredServer_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultXml, true
	case "RegisteredServer_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultBinary, true
	case "RegisterServerRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultXml, true
	case "RegisterServerRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultBinary, true
	case "RegisterServerResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultXml, true
	case "RegisterServerResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultBinary, true
	case "ChannelSecurityToken_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultXml, true
	case "ChannelSecurityToken_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultBinary, true
	case "OpenSecureChannelRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultXml, true
	case "OpenSecureChannelRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultBinary, true
	case "OpenSecureChannelResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultXml, true
	case "OpenSecureChannelResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultBinary, true
	case "CloseSecureChannelRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultXml, true
	case "CloseSecureChannelRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultBinary, true
	case "CloseSecureChannelResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultXml, true
	case "CloseSecureChannelResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultBinary, true
	case "SignatureData_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultXml, true
	case "SignatureData_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultBinary, true
	case "CreateSessionRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultXml, true
	case "CreateSessionRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultBinary, true
	case "CreateSessionResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultXml, true
	case "CreateSessionResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultBinary, true
	case "ActivateSessionRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultXml, true
	case "ActivateSessionRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultBinary, true
	case "ActivateSessionResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultXml, true
	case "ActivateSessionResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultBinary, true
	case "CloseSessionRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultXml, true
	case "CloseSessionRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultBinary, true
	case "CloseSessionResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultXml, true
	case "CloseSessionResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultBinary, true
	case "CancelRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultXml, true
	case "CancelRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultBinary, true
	case "CancelResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultXml, true
	case "CancelResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultBinary, true
	case "AddNodesResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultXml, true
	case "AddNodesResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultBinary, true
	case "AddNodesRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultXml, true
	case "AddNodesRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultBinary, true
	case "AddNodesResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultXml, true
	case "AddNodesResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultBinary, true
	case "AddReferencesRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultXml, true
	case "AddReferencesRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultBinary, true
	case "AddReferencesResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultXml, true
	case "AddReferencesResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultBinary, true
	case "DeleteNodesRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultXml, true
	case "DeleteNodesRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultBinary, true
	case "DeleteNodesResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultXml, true
	case "DeleteNodesResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultBinary, true
	case "DeleteReferencesRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultXml, true
	case "DeleteReferencesRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultBinary, true
	case "DeleteReferencesResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultXml, true
	case "DeleteReferencesResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultBinary, true
	case "ViewDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultXml, true
	case "ViewDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultBinary, true
	case "BrowseDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultXml, true
	case "BrowseDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultBinary, true
	case "ReferenceDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultXml, true
	case "ReferenceDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultBinary, true
	case "BrowseResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultXml, true
	case "BrowseResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultBinary, true
	case "BrowseRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultXml, true
	case "BrowseRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultBinary, true
	case "BrowseResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultXml, true
	case "BrowseResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultBinary, true
	case "BrowseNextRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultXml, true
	case "BrowseNextRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultBinary, true
	case "BrowseNextResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultXml, true
	case "BrowseNextResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultBinary, true
	case "RelativePathElement_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultXml, true
	case "RelativePathElement_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultBinary, true
	case "RelativePath_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultXml, true
	case "RelativePath_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultBinary, true
	case "BrowsePath_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultXml, true
	case "BrowsePath_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultBinary, true
	case "BrowsePathTarget_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultXml, true
	case "BrowsePathTarget_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultBinary, true
	case "BrowsePathResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultXml, true
	case "BrowsePathResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultBinary, true
	case "TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml, true
	case "TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary, true
	case "TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultXml, true
	case "TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultBinary, true
	case "RegisterNodesRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultXml, true
	case "RegisterNodesRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultBinary, true
	case "RegisterNodesResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultXml, true
	case "RegisterNodesResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultBinary, true
	case "UnregisterNodesRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultXml, true
	case "UnregisterNodesRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultBinary, true
	case "UnregisterNodesResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultXml, true
	case "UnregisterNodesResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultBinary, true
	case "QueryDataDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultXml, true
	case "QueryDataDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultBinary, true
	case "NodeTypeDescription_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultXml, true
	case "NodeTypeDescription_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultBinary, true
	case "QueryDataSet_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultXml, true
	case "QueryDataSet_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultBinary, true
	case "NodeReference_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultXml, true
	case "NodeReference_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultBinary, true
	case "ContentFilterElement_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultXml, true
	case "ContentFilterElement_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultBinary, true
	case "ContentFilter_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultXml, true
	case "ContentFilter_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultBinary, true
	case "FilterOperand_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultXml, true
	case "FilterOperand_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultBinary, true
	case "ElementOperand_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultXml, true
	case "ElementOperand_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultBinary, true
	case "LiteralOperand_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultXml, true
	case "LiteralOperand_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultBinary, true
	case "AttributeOperand_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultXml, true
	case "AttributeOperand_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultBinary, true
	case "SimpleAttributeOperand_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultXml, true
	case "SimpleAttributeOperand_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultBinary, true
	case "ContentFilterElementResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultXml, true
	case "ContentFilterElementResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultBinary, true
	case "ContentFilterResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultXml, true
	case "ContentFilterResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultBinary, true
	case "ParsingResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultXml, true
	case "ParsingResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultBinary, true
	case "QueryFirstRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultXml, true
	case "QueryFirstRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultBinary, true
	case "QueryFirstResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultXml, true
	case "QueryFirstResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultBinary, true
	case "QueryNextRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultXml, true
	case "QueryNextRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultBinary, true
	case "QueryNextResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultXml, true
	case "QueryNextResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultBinary, true
	case "ReadValueId_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultXml, true
	case "ReadValueId_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultBinary, true
	case "ReadRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultXml, true
	case "ReadRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultBinary, true
	case "ReadResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultXml, true
	case "ReadResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultBinary, true
	case "HistoryReadValueId_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultXml, true
	case "HistoryReadValueId_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultBinary, true
	case "HistoryReadResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultXml, true
	case "HistoryReadResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultBinary, true
	case "HistoryReadDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultXml, true
	case "HistoryReadDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultBinary, true
	case "ReadEventDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultXml, true
	case "ReadEventDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultBinary, true
	case "ReadRawModifiedDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultXml, true
	case "ReadRawModifiedDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultBinary, true
	case "ReadProcessedDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultXml, true
	case "ReadProcessedDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultBinary, true
	case "ReadAtTimeDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultXml, true
	case "ReadAtTimeDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultBinary, true
	case "HistoryData_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultXml, true
	case "HistoryData_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultBinary, true
	case "HistoryEvent_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultXml, true
	case "HistoryEvent_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultBinary, true
	case "HistoryReadRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultXml, true
	case "HistoryReadRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultBinary, true
	case "HistoryReadResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultXml, true
	case "HistoryReadResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultBinary, true
	case "WriteValue_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultXml, true
	case "WriteValue_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultBinary, true
	case "WriteRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultXml, true
	case "WriteRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultBinary, true
	case "WriteResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultXml, true
	case "WriteResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultBinary, true
	case "HistoryUpdateDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultXml, true
	case "HistoryUpdateDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultBinary, true
	case "UpdateDataDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultXml, true
	case "UpdateDataDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultBinary, true
	case "UpdateEventDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultXml, true
	case "UpdateEventDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultBinary, true
	case "DeleteRawModifiedDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultXml, true
	case "DeleteRawModifiedDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultBinary, true
	case "DeleteAtTimeDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultXml, true
	case "DeleteAtTimeDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultBinary, true
	case "DeleteEventDetails_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultXml, true
	case "DeleteEventDetails_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultBinary, true
	case "HistoryUpdateResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultXml, true
	case "HistoryUpdateResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultBinary, true
	case "HistoryUpdateRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultXml, true
	case "HistoryUpdateRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultBinary, true
	case "HistoryUpdateResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultXml, true
	case "HistoryUpdateResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultBinary, true
	case "CallMethodRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultXml, true
	case "CallMethodRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultBinary, true
	case "CallMethodResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultXml, true
	case "CallMethodResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultBinary, true
	case "CallRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultXml, true
	case "CallRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultBinary, true
	case "CallResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultXml, true
	case "CallResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultBinary, true
	case "MonitoringFilter_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultXml, true
	case "MonitoringFilter_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultBinary, true
	case "DataChangeFilter_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultXml, true
	case "DataChangeFilter_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultBinary, true
	case "EventFilter_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultXml, true
	case "EventFilter_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultBinary, true
	case "AggregateFilter_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultXml, true
	case "AggregateFilter_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultBinary, true
	case "MonitoringFilterResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultXml, true
	case "MonitoringFilterResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultBinary, true
	case "EventFilterResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultXml, true
	case "EventFilterResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultBinary, true
	case "AggregateFilterResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultXml, true
	case "AggregateFilterResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultBinary, true
	case "MonitoringParameters_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultXml, true
	case "MonitoringParameters_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultBinary, true
	case "MonitoredItemCreateRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultXml, true
	case "MonitoredItemCreateRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultBinary, true
	case "MonitoredItemCreateResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultXml, true
	case "MonitoredItemCreateResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultBinary, true
	case "CreateMonitoredItemsRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultXml, true
	case "CreateMonitoredItemsRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultBinary, true
	case "CreateMonitoredItemsResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultXml, true
	case "CreateMonitoredItemsResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultBinary, true
	case "MonitoredItemModifyRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultXml, true
	case "MonitoredItemModifyRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultBinary, true
	case "MonitoredItemModifyResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultXml, true
	case "MonitoredItemModifyResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultBinary, true
	case "EnumValueType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultXml, true
	case "ModifyMonitoredItemsRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultXml, true
	case "ModifyMonitoredItemsRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultBinary, true
	case "ModifyMonitoredItemsResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultXml, true
	case "ModifyMonitoredItemsResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultBinary, true
	case "SetMonitoringModeRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultXml, true
	case "SetMonitoringModeRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultBinary, true
	case "SetMonitoringModeResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultXml, true
	case "SetMonitoringModeResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultBinary, true
	case "SetTriggeringRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultXml, true
	case "SetTriggeringRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultBinary, true
	case "SetTriggeringResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultXml, true
	case "SetTriggeringResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultBinary, true
	case "ModellingRule_Mandatory":
		return OpcuaNodeIdServicesObject_ModellingRule_Mandatory, true
	case "DeleteMonitoredItemsRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultXml, true
	case "DeleteMonitoredItemsRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultBinary, true
	case "DeleteMonitoredItemsResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultXml, true
	case "DeleteMonitoredItemsResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultBinary, true
	case "CreateSubscriptionRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultXml, true
	case "CreateSubscriptionRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultBinary, true
	case "CreateSubscriptionResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultXml, true
	case "CreateSubscriptionResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultBinary, true
	case "ModifySubscriptionRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultXml, true
	case "ModifySubscriptionRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultBinary, true
	case "ModifySubscriptionResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultXml, true
	case "ModifySubscriptionResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultBinary, true
	case "SetPublishingModeRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultXml, true
	case "SetPublishingModeRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultBinary, true
	case "ModellingRule_Optional":
		return OpcuaNodeIdServicesObject_ModellingRule_Optional, true
	case "SetPublishingModeResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultXml, true
	case "SetPublishingModeResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultBinary, true
	case "NotificationMessage_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultXml, true
	case "NotificationMessage_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultBinary, true
	case "MonitoredItemNotification_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultXml, true
	case "MonitoredItemNotification_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultBinary, true
	case "DataChangeNotification_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultXml, true
	case "DataChangeNotification_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultBinary, true
	case "StatusChangeNotification_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultXml, true
	case "StatusChangeNotification_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultBinary, true
	case "SubscriptionAcknowledgement_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultXml, true
	case "SubscriptionAcknowledgement_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultBinary, true
	case "PublishRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultXml, true
	case "EnumValueType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultBinary, true
	case "PublishRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultBinary, true
	case "PublishResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultXml, true
	case "PublishResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultBinary, true
	case "ModellingRule_ExposesItsArray":
		return OpcuaNodeIdServicesObject_ModellingRule_ExposesItsArray, true
	case "RepublishRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultXml, true
	case "RepublishRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultBinary, true
	case "RepublishResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultXml, true
	case "RepublishResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultBinary, true
	case "TransferResult_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultXml, true
	case "TransferResult_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultBinary, true
	case "RootFolder":
		return OpcuaNodeIdServicesObject_RootFolder, true
	case "TransferSubscriptionsRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultXml, true
	case "TransferSubscriptionsRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultBinary, true
	case "TransferSubscriptionsResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultXml, true
	case "TransferSubscriptionsResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultBinary, true
	case "DeleteSubscriptionsRequest_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultXml, true
	case "DeleteSubscriptionsRequest_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultBinary, true
	case "DeleteSubscriptionsResponse_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultXml, true
	case "ObjectsFolder":
		return OpcuaNodeIdServicesObject_ObjectsFolder, true
	case "DeleteSubscriptionsResponse_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultBinary, true
	case "RedundantServerDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultXml, true
	case "RedundantServerDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultBinary, true
	case "SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultXml, true
	case "SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary, true
	case "TypesFolder":
		return OpcuaNodeIdServicesObject_TypesFolder, true
	case "ServerDiagnosticsSummaryDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultXml, true
	case "ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary, true
	case "ServerStatusDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultXml, true
	case "ServerStatusDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultBinary, true
	case "SessionDiagnosticsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultXml, true
	case "SessionDiagnosticsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultBinary, true
	case "SessionSecurityDiagnosticsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultXml, true
	case "ViewsFolder":
		return OpcuaNodeIdServicesObject_ViewsFolder, true
	case "SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary, true
	case "ServiceCounterDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultXml, true
	case "ServiceCounterDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultBinary, true
	case "SubscriptionDiagnosticsDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultXml, true
	case "SubscriptionDiagnosticsDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultBinary, true
	case "ModelChangeStructureDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultXml, true
	case "ModelChangeStructureDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultBinary, true
	case "ObjectTypesFolder":
		return OpcuaNodeIdServicesObject_ObjectTypesFolder, true
	case "Range_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_Range_Encoding_DefaultXml, true
	case "Range_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_Range_Encoding_DefaultBinary, true
	case "EUInformation_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultXml, true
	case "EUInformation_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultBinary, true
	case "VariableTypesFolder":
		return OpcuaNodeIdServicesObject_VariableTypesFolder, true
	case "TimeZoneDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultXml, true
	case "TimeZoneDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultBinary, true
	case "Annotation_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultXml, true
	case "Annotation_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultBinary, true
	case "ProgramDiagnosticDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultXml, true
	case "ProgramDiagnosticDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultBinary, true
	case "SemanticChangeStructureDataType_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultXml, true
	case "SemanticChangeStructureDataType_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultBinary, true
	case "DataTypesFolder":
		return OpcuaNodeIdServicesObject_DataTypesFolder, true
	case "ReferenceTypesFolder":
		return OpcuaNodeIdServicesObject_ReferenceTypesFolder, true
	case "EventNotificationList_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultXml, true
	case "EventNotificationList_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultBinary, true
	case "AlarmConditionType_ShelvingState":
		return OpcuaNodeIdServicesObject_AlarmConditionType_ShelvingState, true
	case "EventFieldList_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultXml, true
	case "EventFieldList_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultBinary, true
	case "XmlSchema_TypeSystem":
		return OpcuaNodeIdServicesObject_XmlSchema_TypeSystem, true
	case "HistoryEventFieldList_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultXml, true
	case "HistoryEventFieldList_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultBinary, true
	case "OPCBinarySchema_TypeSystem":
		return OpcuaNodeIdServicesObject_OPCBinarySchema_TypeSystem, true
	case "ExclusiveLimitStateMachineType_HighHigh":
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighHigh, true
	case "ExclusiveLimitStateMachineType_High":
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_High, true
	case "ExclusiveLimitStateMachineType_Low":
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_Low, true
	case "ExclusiveLimitStateMachineType_LowLow":
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowLow, true
	case "ExclusiveLimitStateMachineType_LowLowToLow":
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowLowToLow, true
	case "ExclusiveLimitStateMachineType_LowToLowLow":
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_LowToLowLow, true
	case "ExclusiveLimitStateMachineType_HighHighToHigh":
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighHighToHigh, true
	case "ExclusiveLimitStateMachineType_HighToHighHigh":
		return OpcuaNodeIdServicesObject_ExclusiveLimitStateMachineType_HighToHighHigh, true
	case "IssuedIdentityToken_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultXml, true
	case "IssuedIdentityToken_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultBinary, true
	case "ExclusiveLimitAlarmType_LimitState":
		return OpcuaNodeIdServicesObject_ExclusiveLimitAlarmType_LimitState, true
	case "NotificationData_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultXml, true
	case "NotificationData_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultBinary, true
	case "AggregateConfiguration_Encoding_DefaultXml":
		return OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultXml, true
	case "AggregateConfiguration_Encoding_DefaultBinary":
		return OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultBinary, true
	}
	return 0, false
}

func OpcuaNodeIdServicesObjectKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesObjectValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesObject(structType any) OpcuaNodeIdServicesObject {
	castFunc := func(typ any) OpcuaNodeIdServicesObject {
		if sOpcuaNodeIdServicesObject, ok := typ.(OpcuaNodeIdServicesObject); ok {
			return sOpcuaNodeIdServicesObject
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesObject) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesObject) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesObjectParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesObject, error) {
	return OpcuaNodeIdServicesObjectParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesObjectParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesObject, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesObject", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesObject")
	}
	if enum, ok := OpcuaNodeIdServicesObjectByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesObject")
		return OpcuaNodeIdServicesObject(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesObject) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesObject) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesObject", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesObject) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesObject) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesObject_HistoryServerCapabilitiesType_AggregateFunctions:
		return "HistoryServerCapabilitiesType_AggregateFunctions"
	case OpcuaNodeIdServicesObject_HistoryServerCapabilities:
		return "HistoryServerCapabilities"
	case OpcuaNodeIdServicesObject_HistoryServerCapabilities_AggregateFunctions:
		return "HistoryServerCapabilities_AggregateFunctions"
	case OpcuaNodeIdServicesObject_HAConfiguration:
		return "HAConfiguration"
	case OpcuaNodeIdServicesObject_HAConfiguration_AggregateConfiguration:
		return "HAConfiguration_AggregateConfiguration"
	case OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultXml:
		return "ModificationInfo_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultXml:
		return "HistoryModifiedData_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultBinary:
		return "ModificationInfo_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultBinary:
		return "HistoryModifiedData_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage2:
		return "AggregateFunction_TimeAverage2"
	case OpcuaNodeIdServicesObject_AggregateFunction_Minimum2:
		return "AggregateFunction_Minimum2"
	case OpcuaNodeIdServicesObject_AggregateFunction_Maximum2:
		return "AggregateFunction_Maximum2"
	case OpcuaNodeIdServicesObject_AggregateFunction_Range2:
		return "AggregateFunction_Range2"
	case OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality2:
		return "AggregateFunction_WorstQuality2"
	case OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultXml:
		return "UpdateStructureDataDetails_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultBinary:
		return "UpdateStructureDataDetails_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AggregateFunction_Total2:
		return "AggregateFunction_Total2"
	case OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime2:
		return "AggregateFunction_MinimumActualTime2"
	case OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime2:
		return "AggregateFunction_MaximumActualTime2"
	case OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateZero:
		return "AggregateFunction_DurationInStateZero"
	case OpcuaNodeIdServicesObject_AggregateFunction_DurationInStateNonZero:
		return "AggregateFunction_DurationInStateNonZero"
	case OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationSample:
		return "AggregateFunction_StandardDeviationSample"
	case OpcuaNodeIdServicesObject_AggregateFunction_StandardDeviationPopulation:
		return "AggregateFunction_StandardDeviationPopulation"
	case OpcuaNodeIdServicesObject_AggregateFunction_VarianceSample:
		return "AggregateFunction_VarianceSample"
	case OpcuaNodeIdServicesObject_AggregateFunction_VariancePopulation:
		return "AggregateFunction_VariancePopulation"
	case OpcuaNodeIdServicesObject_AggregateFunction_StartBound:
		return "AggregateFunction_StartBound"
	case OpcuaNodeIdServicesObject_AggregateFunction_EndBound:
		return "AggregateFunction_EndBound"
	case OpcuaNodeIdServicesObject_AggregateFunction_DeltaBounds:
		return "AggregateFunction_DeltaBounds"
	case OpcuaNodeIdServicesObject_ModellingRule_OptionalPlaceholder:
		return "ModellingRule_OptionalPlaceholder"
	case OpcuaNodeIdServicesObject_ModellingRule_MandatoryPlaceholder:
		return "ModellingRule_MandatoryPlaceholder"
	case OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_OperationLimits:
		return "ServerType_ServerCapabilities_OperationLimits"
	case OpcuaNodeIdServicesObject_ServerType_Namespaces:
		return "ServerType_Namespaces"
	case OpcuaNodeIdServicesObject_ServerCapabilitiesType_OperationLimits:
		return "ServerCapabilitiesType_OperationLimits"
	case OpcuaNodeIdServicesObject_NamespaceMetadataType_NamespaceFile:
		return "NamespaceMetadataType_NamespaceFile"
	case OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder:
		return "NamespacesType_NamespaceIdentifier_Placeholder"
	case OpcuaNodeIdServicesObject_NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile:
		return "NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile"
	case OpcuaNodeIdServicesObject_Server_ServerCapabilities_OperationLimits:
		return "Server_ServerCapabilities_OperationLimits"
	case OpcuaNodeIdServicesObject_Server_Namespaces:
		return "Server_Namespaces"
	case OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateFunctions:
		return "HistoricalDataConfigurationType_AggregateFunctions"
	case OpcuaNodeIdServicesObject_HAConfiguration_AggregateFunctions:
		return "HAConfiguration_AggregateFunctions"
	case OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultXml:
		return "InstanceNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultXml:
		return "TypeNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultBinary:
		return "InstanceNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultBinary:
		return "TypeNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultXml:
		return "EndpointUrlListDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultXml:
		return "NetworkGroupDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultBinary:
		return "EndpointUrlListDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultBinary:
		return "NetworkGroupDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultXml:
		return "AxisInformation_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_XVType_Encoding_DefaultXml:
		return "XVType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultBinary:
		return "AxisInformation_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_XVType_Encoding_DefaultBinary:
		return "XVType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SessionsDiagnosticsSummaryType_ClientName_Placeholder:
		return "SessionsDiagnosticsSummaryType_ClientName_Placeholder"
	case OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultBinary:
		return "DataTypeDefinition_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultXml:
		return "ComplexNumberType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultXml:
		return "DoubleComplexNumberType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultBinary:
		return "ComplexNumberType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultBinary:
		return "DoubleComplexNumberType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultXml:
		return "ServerOnNetwork_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultXml:
		return "FindServersOnNetworkRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultXml:
		return "FindServersOnNetworkResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultXml:
		return "RegisterServer2Request_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultBinary:
		return "StructureDefinition_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultXml:
		return "RegisterServer2Response_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultBinary:
		return "ServerOnNetwork_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultBinary:
		return "FindServersOnNetworkRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultBinary:
		return "FindServersOnNetworkResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultBinary:
		return "RegisterServer2Request_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultBinary:
		return "RegisterServer2Response_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultBinary:
		return "EnumDefinition_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultBinary:
		return "DataSetMetaDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultBinary:
		return "DataTypeDescription_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultBinary:
		return "StructureDescription_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ServerConfiguration:
		return "ServerConfiguration"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList:
		return "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList"
	case OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultXml:
		return "TrustListDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultBinary:
		return "TrustListDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultBinary:
		return "EnumDescription_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultXml:
		return "OptionSet_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_Union_Encoding_DefaultXml:
		return "Union_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultBinary:
		return "OptionSet_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_Union_Encoding_DefaultBinary:
		return "Union_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultBinary:
		return "RolePermissionType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultXml:
		return "DiscoveryConfiguration_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultXml:
		return "MdnsDiscoveryConfiguration_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultBinary:
		return "DiscoveryConfiguration_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultBinary:
		return "MdnsDiscoveryConfiguration_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_FileDirectoryType_FileDirectoryName_Placeholder:
		return "FileDirectoryType_FileDirectoryName_Placeholder"
	case OpcuaNodeIdServicesObject_FileDirectoryType_FileName_Placeholder:
		return "FileDirectoryType_FileName_Placeholder"
	case OpcuaNodeIdServicesObject_CertificateGroupType_TrustList:
		return "CertificateGroupType_TrustList"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup:
		return "CertificateGroupFolderType_DefaultApplicationGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustList:
		return "CertificateGroupFolderType_DefaultApplicationGroup_TrustList"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup:
		return "CertificateGroupFolderType_DefaultHttpsGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustList:
		return "CertificateGroupFolderType_DefaultHttpsGroup_TrustList"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup:
		return "CertificateGroupFolderType_DefaultUserTokenGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustList:
		return "CertificateGroupFolderType_DefaultUserTokenGroup_TrustList"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder:
		return "CertificateGroupFolderType_AdditionalGroup_Placeholder"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList:
		return "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups:
		return "ServerConfigurationType_CertificateGroups"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList:
		return "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList:
		return "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList:
		return "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups:
		return "ServerConfiguration_CertificateGroups"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup:
		return "ServerConfiguration_CertificateGroups_DefaultHttpsGroup"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList:
		return "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup:
		return "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList:
		return "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup:
		return "ServerConfiguration_CertificateGroups_DefaultApplicationGroup"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_Address:
		return "PubSubConnectionType_Address"
	case OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultXml:
		return "PublishedVariableDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultBinary:
		return "PublishedVariableDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder:
		return "PublishSubscribeType_ConnectionName_Placeholder"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Status:
		return "PublishSubscribeType_ConnectionName_Placeholder_Status"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Address:
		return "PublishSubscribeType_ConnectionName_Placeholder_Address"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_PublishedDataSets:
		return "PublishSubscribeType_PublishedDataSets"
	case OpcuaNodeIdServicesObject_PublishSubscribe:
		return "PublishSubscribe"
	case OpcuaNodeIdServicesObject_DataSetFolderType_DataSetFolderName_Placeholder:
		return "DataSetFolderType_DataSetFolderName_Placeholder"
	case OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder:
		return "DataSetFolderType_PublishedDataSetName_Placeholder"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_Status:
		return "PubSubConnectionType_Status"
	case OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultXml:
		return "DataSetMetaDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultXml:
		return "FieldMetaData_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultXml:
		return "DataTypeDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultXml:
		return "DataTypeDefinition_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultXml:
		return "StructureDefinition_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultXml:
		return "EnumDefinition_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultXml:
		return "StructureField_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultXml:
		return "EnumField_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultXml:
		return "KeyValuePair_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultXml:
		return "ConfigurationVersionDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultXml:
		return "FieldTargetDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultBinary:
		return "FieldMetaData_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultBinary:
		return "StructureField_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultBinary:
		return "EnumField_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultBinary:
		return "KeyValuePair_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultBinary:
		return "ConfigurationVersionDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultBinary:
		return "FieldTargetDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultBinary:
		return "TestScalarStructure_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultBinary:
		return "TestArrayStructure_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultBinary:
		return "TestStructure_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_KeyValuePair_Encoding_DefaultJson:
		return "KeyValuePair_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultJson:
		return "IdentityMappingRuleType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TrustListDataType_Encoding_DefaultJson:
		return "TrustListDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultJson:
		return "DecimalDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ConfigurationVersionDataType_Encoding_DefaultJson:
		return "ConfigurationVersionDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetMetaDataType_Encoding_DefaultJson:
		return "DataSetMetaDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_FieldMetaData_Encoding_DefaultJson:
		return "FieldMetaData_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataTypeDescription_Encoding_DefaultJson:
		return "DataTypeDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultJson:
		return "StructureDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultJson:
		return "EnumDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishedVariableDataType_Encoding_DefaultJson:
		return "PublishedVariableDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_FieldTargetDataType_Encoding_DefaultJson:
		return "FieldTargetDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultJson:
		return "RolePermissionType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataTypeDefinition_Encoding_DefaultJson:
		return "DataTypeDefinition_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_StructureField_Encoding_DefaultJson:
		return "StructureField_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_StructureDefinition_Encoding_DefaultJson:
		return "StructureDefinition_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EnumDefinition_Encoding_DefaultJson:
		return "EnumDefinition_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_Node_Encoding_DefaultJson:
		return "Node_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_InstanceNode_Encoding_DefaultJson:
		return "InstanceNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TypeNode_Encoding_DefaultJson:
		return "TypeNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultJson:
		return "ObjectNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DatagramConnectionTransportType_DiscoveryAddress:
		return "DatagramConnectionTransportType_DiscoveryAddress"
	case OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultJson:
		return "ObjectTypeNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultJson:
		return "VariableNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultJson:
		return "VariableTypeNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultJson:
		return "ReferenceTypeNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultJson:
		return "MethodNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultJson:
		return "ViewNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultJson:
		return "DataTypeNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultJson:
		return "ReferenceNode_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_Argument_Encoding_DefaultJson:
		return "Argument_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EnumValueType_Encoding_DefaultJson:
		return "EnumValueType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EnumField_Encoding_DefaultJson:
		return "EnumField_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_OptionSet_Encoding_DefaultJson:
		return "OptionSet_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_Union_Encoding_DefaultJson:
		return "Union_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TimeZoneDataType_Encoding_DefaultJson:
		return "TimeZoneDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultJson:
		return "ApplicationDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultJson:
		return "RequestHeader_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultJson:
		return "ResponseHeader_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultJson:
		return "ServiceFault_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultJson:
		return "SessionlessInvokeRequestType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultJson:
		return "SessionlessInvokeResponseType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultJson:
		return "FindServersRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultJson:
		return "FindServersResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServerOnNetwork_Encoding_DefaultJson:
		return "ServerOnNetwork_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_FindServersOnNetworkRequest_Encoding_DefaultJson:
		return "FindServersOnNetworkRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_FindServersOnNetworkResponse_Encoding_DefaultJson:
		return "FindServersOnNetworkResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultJson:
		return "UserTokenPolicy_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultJson:
		return "EndpointDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultJson:
		return "GetEndpointsRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultJson:
		return "GetEndpointsResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultJson:
		return "RegisteredServer_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultJson:
		return "RegisterServerRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultJson:
		return "RegisterServerResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DiscoveryConfiguration_Encoding_DefaultJson:
		return "DiscoveryConfiguration_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MdnsDiscoveryConfiguration_Encoding_DefaultJson:
		return "MdnsDiscoveryConfiguration_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RegisterServer2Request_Encoding_DefaultJson:
		return "RegisterServer2Request_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RegisterServer2Response_Encoding_DefaultJson:
		return "RegisterServer2Response_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultJson:
		return "ChannelSecurityToken_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultJson:
		return "OpenSecureChannelRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultJson:
		return "OpenSecureChannelResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultJson:
		return "CloseSecureChannelRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultJson:
		return "CloseSecureChannelResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultJson:
		return "SignedSoftwareCertificate_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultJson:
		return "SignatureData_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultJson:
		return "CreateSessionRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultJson:
		return "CreateSessionResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultJson:
		return "UserIdentityToken_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultJson:
		return "AnonymousIdentityToken_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultJson:
		return "UserNameIdentityToken_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultJson:
		return "X509IdentityToken_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_IssuedIdentityToken_Encoding_DefaultJson:
		return "IssuedIdentityToken_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultJson:
		return "ActivateSessionRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultJson:
		return "ActivateSessionResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultJson:
		return "CloseSessionRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultJson:
		return "CloseSessionResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultJson:
		return "CancelRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultJson:
		return "CancelResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultJson:
		return "NodeAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultJson:
		return "ObjectAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultJson:
		return "VariableAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultJson:
		return "MethodAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultJson:
		return "ObjectTypeAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultJson:
		return "VariableTypeAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultJson:
		return "ReferenceTypeAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultJson:
		return "DataTypeAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultJson:
		return "ViewAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultJson:
		return "GenericAttributeValue_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultJson:
		return "GenericAttributes_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultJson:
		return "AddNodesItem_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultJson:
		return "AddNodesResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultJson:
		return "AddNodesRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultJson:
		return "AddNodesResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultJson:
		return "AddReferencesItem_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultJson:
		return "AddReferencesRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultJson:
		return "AddReferencesResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultJson:
		return "DeleteNodesItem_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultJson:
		return "DeleteNodesRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultJson:
		return "DeleteNodesResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultJson:
		return "DeleteReferencesItem_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultJson:
		return "DeleteReferencesRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultJson:
		return "DeleteReferencesResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultJson:
		return "ViewDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultJson:
		return "BrowseDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultJson:
		return "ReferenceDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowseResult_Encoding_DefaultJson:
		return "BrowseResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowseRequest_Encoding_DefaultJson:
		return "BrowseRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowseResponse_Encoding_DefaultJson:
		return "BrowseResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowseNextRequest_Encoding_DefaultJson:
		return "BrowseNextRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowseNextResponse_Encoding_DefaultJson:
		return "BrowseNextResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RelativePathElement_Encoding_DefaultJson:
		return "RelativePathElement_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RelativePath_Encoding_DefaultJson:
		return "RelativePath_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowsePath_Encoding_DefaultJson:
		return "BrowsePath_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowsePathTarget_Encoding_DefaultJson:
		return "BrowsePathTarget_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrowsePathResult_Encoding_DefaultJson:
		return "BrowsePathResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson:
		return "TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson:
		return "TranslateBrowsePathsToNodeIdsResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RegisterNodesRequest_Encoding_DefaultJson:
		return "RegisterNodesRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RegisterNodesResponse_Encoding_DefaultJson:
		return "RegisterNodesResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UnregisterNodesRequest_Encoding_DefaultJson:
		return "UnregisterNodesRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UnregisterNodesResponse_Encoding_DefaultJson:
		return "UnregisterNodesResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultJson:
		return "EndpointConfiguration_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_QueryDataDescription_Encoding_DefaultJson:
		return "QueryDataDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NodeTypeDescription_Encoding_DefaultJson:
		return "NodeTypeDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_QueryDataSet_Encoding_DefaultJson:
		return "QueryDataSet_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NodeReference_Encoding_DefaultJson:
		return "NodeReference_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ContentFilterElement_Encoding_DefaultJson:
		return "ContentFilterElement_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ContentFilter_Encoding_DefaultJson:
		return "ContentFilter_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_FilterOperand_Encoding_DefaultJson:
		return "FilterOperand_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ElementOperand_Encoding_DefaultJson:
		return "ElementOperand_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_LiteralOperand_Encoding_DefaultJson:
		return "LiteralOperand_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AttributeOperand_Encoding_DefaultJson:
		return "AttributeOperand_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SimpleAttributeOperand_Encoding_DefaultJson:
		return "SimpleAttributeOperand_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ContentFilterElementResult_Encoding_DefaultJson:
		return "ContentFilterElementResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder:
		return "PublishedDataSetType_DataSetWriterName_Placeholder"
	case OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Status:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Status"
	case OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_TransportSettings"
	case OpcuaNodeIdServicesObject_ContentFilterResult_Encoding_DefaultJson:
		return "ContentFilterResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultXml:
		return "TestScalarStructure_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultXml:
		return "TestArrayStructure_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultXml:
		return "TestStructure_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ParsingResult_Encoding_DefaultJson:
		return "ParsingResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_QueryFirstRequest_Encoding_DefaultJson:
		return "QueryFirstRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_QueryFirstResponse_Encoding_DefaultJson:
		return "QueryFirstResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_QueryNextRequest_Encoding_DefaultJson:
		return "QueryNextRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_QueryNextResponse_Encoding_DefaultJson:
		return "QueryNextResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReadValueId_Encoding_DefaultJson:
		return "ReadValueId_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReadRequest_Encoding_DefaultJson:
		return "ReadRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReadResponse_Encoding_DefaultJson:
		return "ReadResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryReadValueId_Encoding_DefaultJson:
		return "HistoryReadValueId_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryReadResult_Encoding_DefaultJson:
		return "HistoryReadResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryReadDetails_Encoding_DefaultJson:
		return "HistoryReadDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReadEventDetails_Encoding_DefaultJson:
		return "ReadEventDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReadRawModifiedDetails_Encoding_DefaultJson:
		return "ReadRawModifiedDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReadProcessedDetails_Encoding_DefaultJson:
		return "ReadProcessedDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubGroupType_Status:
		return "PubSubGroupType_Status"
	case OpcuaNodeIdServicesObject_ReadAtTimeDetails_Encoding_DefaultJson:
		return "ReadAtTimeDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryData_Encoding_DefaultJson:
		return "HistoryData_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ModificationInfo_Encoding_DefaultJson:
		return "ModificationInfo_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryModifiedData_Encoding_DefaultJson:
		return "HistoryModifiedData_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryEvent_Encoding_DefaultJson:
		return "HistoryEvent_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryReadRequest_Encoding_DefaultJson:
		return "HistoryReadRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryReadResponse_Encoding_DefaultJson:
		return "HistoryReadResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_WriteValue_Encoding_DefaultJson:
		return "WriteValue_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_WriteRequest_Encoding_DefaultJson:
		return "WriteRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_WriteResponse_Encoding_DefaultJson:
		return "WriteResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryUpdateDetails_Encoding_DefaultJson:
		return "HistoryUpdateDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UpdateDataDetails_Encoding_DefaultJson:
		return "UpdateDataDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UpdateStructureDataDetails_Encoding_DefaultJson:
		return "UpdateStructureDataDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UpdateEventDetails_Encoding_DefaultJson:
		return "UpdateEventDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteRawModifiedDetails_Encoding_DefaultJson:
		return "DeleteRawModifiedDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteAtTimeDetails_Encoding_DefaultJson:
		return "DeleteAtTimeDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteEventDetails_Encoding_DefaultJson:
		return "DeleteEventDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryUpdateResult_Encoding_DefaultJson:
		return "HistoryUpdateResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryUpdateRequest_Encoding_DefaultJson:
		return "HistoryUpdateRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryUpdateResponse_Encoding_DefaultJson:
		return "HistoryUpdateResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CallMethodRequest_Encoding_DefaultJson:
		return "CallMethodRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CallMethodResult_Encoding_DefaultJson:
		return "CallMethodResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CallRequest_Encoding_DefaultJson:
		return "CallRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CallResponse_Encoding_DefaultJson:
		return "CallResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MonitoringFilter_Encoding_DefaultJson:
		return "MonitoringFilter_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataChangeFilter_Encoding_DefaultJson:
		return "DataChangeFilter_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EventFilter_Encoding_DefaultJson:
		return "EventFilter_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetWriterType_Status:
		return "DataSetWriterType_Status"
	case OpcuaNodeIdServicesObject_DataSetWriterType_TransportSettings:
		return "DataSetWriterType_TransportSettings"
	case OpcuaNodeIdServicesObject_AggregateConfiguration_Encoding_DefaultJson:
		return "AggregateConfiguration_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetReaderType_Status:
		return "DataSetReaderType_Status"
	case OpcuaNodeIdServicesObject_DataSetReaderType_TransportSettings:
		return "DataSetReaderType_TransportSettings"
	case OpcuaNodeIdServicesObject_AggregateFilter_Encoding_DefaultJson:
		return "AggregateFilter_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MonitoringFilterResult_Encoding_DefaultJson:
		return "MonitoringFilterResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EventFilterResult_Encoding_DefaultJson:
		return "EventFilterResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AggregateFilterResult_Encoding_DefaultJson:
		return "AggregateFilterResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetReaderType_SubscribedDataSet:
		return "DataSetReaderType_SubscribedDataSet"
	case OpcuaNodeIdServicesObject_MonitoringParameters_Encoding_DefaultJson:
		return "MonitoringParameters_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MonitoredItemCreateRequest_Encoding_DefaultJson:
		return "MonitoredItemCreateRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MonitoredItemCreateResult_Encoding_DefaultJson:
		return "MonitoredItemCreateResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CreateMonitoredItemsRequest_Encoding_DefaultJson:
		return "CreateMonitoredItemsRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CreateMonitoredItemsResponse_Encoding_DefaultJson:
		return "CreateMonitoredItemsResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MonitoredItemModifyRequest_Encoding_DefaultJson:
		return "MonitoredItemModifyRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MonitoredItemModifyResult_Encoding_DefaultJson:
		return "MonitoredItemModifyResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ModifyMonitoredItemsRequest_Encoding_DefaultJson:
		return "ModifyMonitoredItemsRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ModifyMonitoredItemsResponse_Encoding_DefaultJson:
		return "ModifyMonitoredItemsResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SetMonitoringModeRequest_Encoding_DefaultJson:
		return "SetMonitoringModeRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SetMonitoringModeResponse_Encoding_DefaultJson:
		return "SetMonitoringModeResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SetTriggeringRequest_Encoding_DefaultJson:
		return "SetTriggeringRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SetTriggeringResponse_Encoding_DefaultJson:
		return "SetTriggeringResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteMonitoredItemsRequest_Encoding_DefaultJson:
		return "DeleteMonitoredItemsRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteMonitoredItemsResponse_Encoding_DefaultJson:
		return "DeleteMonitoredItemsResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CreateSubscriptionRequest_Encoding_DefaultJson:
		return "CreateSubscriptionRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CreateSubscriptionResponse_Encoding_DefaultJson:
		return "CreateSubscriptionResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ModifySubscriptionRequest_Encoding_DefaultJson:
		return "ModifySubscriptionRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ModifySubscriptionResponse_Encoding_DefaultJson:
		return "ModifySubscriptionResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SetPublishingModeRequest_Encoding_DefaultJson:
		return "SetPublishingModeRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SetPublishingModeResponse_Encoding_DefaultJson:
		return "SetPublishingModeResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NotificationMessage_Encoding_DefaultJson:
		return "NotificationMessage_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NotificationData_Encoding_DefaultJson:
		return "NotificationData_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataChangeNotification_Encoding_DefaultJson:
		return "DataChangeNotification_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_MonitoredItemNotification_Encoding_DefaultJson:
		return "MonitoredItemNotification_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EventNotificationList_Encoding_DefaultJson:
		return "EventNotificationList_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EventFieldList_Encoding_DefaultJson:
		return "EventFieldList_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryEventFieldList_Encoding_DefaultJson:
		return "HistoryEventFieldList_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_StatusChangeNotification_Encoding_DefaultJson:
		return "StatusChangeNotification_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SubscriptionAcknowledgement_Encoding_DefaultJson:
		return "SubscriptionAcknowledgement_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishRequest_Encoding_DefaultJson:
		return "PublishRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishResponse_Encoding_DefaultJson:
		return "PublishResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RepublishRequest_Encoding_DefaultJson:
		return "RepublishRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RepublishResponse_Encoding_DefaultJson:
		return "RepublishResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TransferResult_Encoding_DefaultJson:
		return "TransferResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TransferSubscriptionsRequest_Encoding_DefaultJson:
		return "TransferSubscriptionsRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TransferSubscriptionsResponse_Encoding_DefaultJson:
		return "TransferSubscriptionsResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteSubscriptionsRequest_Encoding_DefaultJson:
		return "DeleteSubscriptionsRequest_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DeleteSubscriptionsResponse_Encoding_DefaultJson:
		return "DeleteSubscriptionsResponse_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultJson:
		return "BuildInfo_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_RedundantServerDataType_Encoding_DefaultJson:
		return "RedundantServerDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EndpointUrlListDataType_Encoding_DefaultJson:
		return "EndpointUrlListDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NetworkGroupDataType_Encoding_DefaultJson:
		return "NetworkGroupDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson:
		return "SamplingIntervalDiagnosticsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServerDiagnosticsSummaryDataType_Encoding_DefaultJson:
		return "ServerDiagnosticsSummaryDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServerStatusDataType_Encoding_DefaultJson:
		return "ServerStatusDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SessionDiagnosticsDataType_Encoding_DefaultJson:
		return "SessionDiagnosticsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SessionSecurityDiagnosticsDataType_Encoding_DefaultJson:
		return "SessionSecurityDiagnosticsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServiceCounterDataType_Encoding_DefaultJson:
		return "ServiceCounterDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultJson:
		return "StatusResult_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SubscriptionDiagnosticsDataType_Encoding_DefaultJson:
		return "SubscriptionDiagnosticsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ModelChangeStructureDataType_Encoding_DefaultJson:
		return "ModelChangeStructureDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SemanticChangeStructureDataType_Encoding_DefaultJson:
		return "SemanticChangeStructureDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_Range_Encoding_DefaultJson:
		return "Range_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EUInformation_Encoding_DefaultJson:
		return "EUInformation_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ComplexNumberType_Encoding_DefaultJson:
		return "ComplexNumberType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DoubleComplexNumberType_Encoding_DefaultJson:
		return "DoubleComplexNumberType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AxisInformation_Encoding_DefaultJson:
		return "AxisInformation_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_XVType_Encoding_DefaultJson:
		return "XVType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ProgramDiagnosticDataType_Encoding_DefaultJson:
		return "ProgramDiagnosticDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_Annotation_Encoding_DefaultJson:
		return "Annotation_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TestScalarStructure_Encoding_DefaultJson:
		return "TestScalarStructure_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TestArrayStructure_Encoding_DefaultJson:
		return "TestArrayStructure_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TestStructure_Encoding_DefaultJson:
		return "TestStructure_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultBinary:
		return "TestAbstractStructure_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultBinary:
		return "TestConcreteStructure_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultXml:
		return "TestAbstractStructure_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultXml:
		return "TestConcreteStructure_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TestAbstractStructure_Encoding_DefaultJson:
		return "TestAbstractStructure_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultBinary:
		return "SimpleTypeDescription_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultBinary:
		return "UABinaryFileDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TestConcreteStructure_Encoding_DefaultJson:
		return "TestConcreteStructure_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishSubscribe_SecurityGroups:
		return "PublishSubscribe_SecurityGroups"
	case OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupFolderName_Placeholder:
		return "SecurityGroupFolderType_SecurityGroupFolderName_Placeholder"
	case OpcuaNodeIdServicesObject_SecurityGroupFolderType_SecurityGroupName_Placeholder:
		return "SecurityGroupFolderType_SecurityGroupName_Placeholder"
	case OpcuaNodeIdServicesObject_DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields:
		return "DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields"
	case OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultBinary:
		return "BrokerConnectionTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishedDataSetType_ExtensionFields:
		return "PublishedDataSetType_ExtensionFields"
	case OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultXml:
		return "SimpleTypeDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultXml:
		return "UABinaryFileDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_ConfigurationFile:
		return "ServerConfigurationType_ConfigurationFile"
	case OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultXml:
		return "BrokerConnectionTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_StructureDescription_Encoding_DefaultXml:
		return "StructureDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EnumDescription_Encoding_DefaultXml:
		return "EnumDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_Server_ServerCapabilities_RoleSet:
		return "Server_ServerCapabilities_RoleSet"
	case OpcuaNodeIdServicesObject_RoleSetType_RoleName_Placeholder:
		return "RoleSetType_RoleName_Placeholder"
	case OpcuaNodeIdServicesObject_WellKnownRole_Anonymous:
		return "WellKnownRole_Anonymous"
	case OpcuaNodeIdServicesObject_WellKnownRole_AuthenticatedUser:
		return "WellKnownRole_AuthenticatedUser"
	case OpcuaNodeIdServicesObject_WellKnownRole_Observer:
		return "WellKnownRole_Observer"
	case OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultBinary:
		return "EndpointType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultBinary:
		return "DataTypeSchemaHeader_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultBinary:
		return "PublishedDataSetDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultBinary:
		return "PublishedDataSetSourceDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultBinary:
		return "PublishedDataItemsDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_WellKnownRole_Operator:
		return "WellKnownRole_Operator"
	case OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultBinary:
		return "PublishedEventsDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultBinary:
		return "DataSetWriterDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultBinary:
		return "DataSetWriterTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultBinary:
		return "DataSetWriterMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultBinary:
		return "PubSubGroupDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultBinary:
		return "WriterGroupTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_WellKnownRole_Supervisor:
		return "WellKnownRole_Supervisor"
	case OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultBinary:
		return "WriterGroupMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultBinary:
		return "PubSubConnectionDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultBinary:
		return "ConnectionTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SimpleTypeDescription_Encoding_DefaultJson:
		return "SimpleTypeDescription_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultBinary:
		return "ReaderGroupTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultBinary:
		return "ReaderGroupMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultBinary:
		return "DataSetReaderDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_WellKnownRole_SecurityAdmin:
		return "WellKnownRole_SecurityAdmin"
	case OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultBinary:
		return "DataSetReaderTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultBinary:
		return "DataSetReaderMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultBinary:
		return "SubscribedDataSetDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultBinary:
		return "TargetVariablesDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultBinary:
		return "SubscribedDataSetMirrorDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_UABinaryFileDataType_Encoding_DefaultJson:
		return "UABinaryFileDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultBinary:
		return "UadpWriterGroupMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_WellKnownRole_ConfigureAdmin:
		return "WellKnownRole_ConfigureAdmin"
	case OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultBinary:
		return "UadpDataSetWriterMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultBinary:
		return "UadpDataSetReaderMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultBinary:
		return "JsonWriterGroupMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultBinary:
		return "JsonDataSetWriterMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultBinary:
		return "JsonDataSetReaderMessageDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_BrokerConnectionTransportDataType_Encoding_DefaultJson:
		return "BrokerConnectionTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultBinary:
		return "BrokerWriterGroupTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultXml:
		return "IdentityMappingRuleType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary:
		return "BrokerDataSetWriterTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary:
		return "BrokerDataSetReaderTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_IdentityMappingRuleType_Encoding_DefaultBinary:
		return "IdentityMappingRuleType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TemporaryFileTransferType_TransferState_Placeholder:
		return "TemporaryFileTransferType_TransferState_Placeholder"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_Idle:
		return "FileTransferStateMachineType_Idle"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepare:
		return "FileTransferStateMachineType_ReadPrepare"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransfer:
		return "FileTransferStateMachineType_ReadTransfer"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWrite:
		return "FileTransferStateMachineType_ApplyWrite"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_Error:
		return "FileTransferStateMachineType_Error"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToReadPrepare:
		return "FileTransferStateMachineType_IdleToReadPrepare"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToReadTransfer:
		return "FileTransferStateMachineType_ReadPrepareToReadTransfer"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToIdle:
		return "FileTransferStateMachineType_ReadTransferToIdle"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_IdleToApplyWrite:
		return "FileTransferStateMachineType_IdleToApplyWrite"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToIdle:
		return "FileTransferStateMachineType_ApplyWriteToIdle"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadPrepareToError:
		return "FileTransferStateMachineType_ReadPrepareToError"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ReadTransferToError:
		return "FileTransferStateMachineType_ReadTransferToError"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ApplyWriteToError:
		return "FileTransferStateMachineType_ApplyWriteToError"
	case OpcuaNodeIdServicesObject_FileTransferStateMachineType_ErrorToIdle:
		return "FileTransferStateMachineType_ErrorToIdle"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_Status:
		return "PublishSubscribeType_Status"
	case OpcuaNodeIdServicesObject_ServerConfiguration_ConfigurationFile:
		return "ServerConfiguration_ConfigurationFile"
	case OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultXml:
		return "SessionlessInvokeRequestType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SessionlessInvokeRequestType_Encoding_DefaultBinary:
		return "SessionlessInvokeRequestType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_TransportSettings:
		return "PublishSubscribeType_ConnectionName_Placeholder_TransportSettings"
	case OpcuaNodeIdServicesObject_PubSubKeyServiceType_SecurityGroups:
		return "PubSubKeyServiceType_SecurityGroups"
	case OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultXml:
		return "EndpointType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultXml:
		return "DataTypeSchemaHeader_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultXml:
		return "PublishedDataSetDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultXml:
		return "PublishedDataSetSourceDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultXml:
		return "PublishedDataItemsDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultXml:
		return "PublishedEventsDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultXml:
		return "DataSetWriterDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultXml:
		return "DataSetWriterTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_OPCUANamespaceMetadata:
		return "OPCUANamespaceMetadata"
	case OpcuaNodeIdServicesObject_OPCUANamespaceMetadata_NamespaceFile:
		return "OPCUANamespaceMetadata_NamespaceFile"
	case OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultXml:
		return "DataSetWriterMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultXml:
		return "PubSubGroupDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultXml:
		return "WriterGroupTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultXml:
		return "WriterGroupMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultXml:
		return "PubSubConnectionDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultXml:
		return "ConnectionTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultXml:
		return "ReaderGroupTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultXml:
		return "ReaderGroupMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultXml:
		return "DataSetReaderDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultXml:
		return "DataSetReaderTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultXml:
		return "DataSetReaderMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultXml:
		return "SubscribedDataSetDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultXml:
		return "TargetVariablesDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultXml:
		return "SubscribedDataSetMirrorDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultXml:
		return "UadpWriterGroupMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultXml:
		return "UadpDataSetWriterMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultXml:
		return "UadpDataSetReaderMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultXml:
		return "JsonWriterGroupMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultXml:
		return "JsonDataSetWriterMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultXml:
		return "JsonDataSetReaderMessageDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultXml:
		return "BrokerWriterGroupTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultXml:
		return "BrokerDataSetWriterTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultXml:
		return "BrokerDataSetReaderTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_WellKnownRole_Engineer:
		return "WellKnownRole_Engineer"
	case OpcuaNodeIdServicesObject_RolePermissionType_Encoding_DefaultXml:
		return "RolePermissionType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EndpointType_Encoding_DefaultJson:
		return "EndpointType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataTypeSchemaHeader_Encoding_DefaultJson:
		return "DataTypeSchemaHeader_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishedDataSetDataType_Encoding_DefaultJson:
		return "PublishedDataSetDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishedDataSetSourceDataType_Encoding_DefaultJson:
		return "PublishedDataSetSourceDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishedDataItemsDataType_Encoding_DefaultJson:
		return "PublishedDataItemsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishedEventsDataType_Encoding_DefaultJson:
		return "PublishedEventsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetWriterDataType_Encoding_DefaultJson:
		return "DataSetWriterDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetWriterTransportDataType_Encoding_DefaultJson:
		return "DataSetWriterTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetWriterMessageDataType_Encoding_DefaultJson:
		return "DataSetWriterMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubGroupDataType_Encoding_DefaultJson:
		return "PubSubGroupDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_WriterGroupTransportDataType_Encoding_DefaultJson:
		return "WriterGroupTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_WriterGroupMessageDataType_Encoding_DefaultJson:
		return "WriterGroupMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubConnectionDataType_Encoding_DefaultJson:
		return "PubSubConnectionDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ConnectionTransportDataType_Encoding_DefaultJson:
		return "ConnectionTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReaderGroupTransportDataType_Encoding_DefaultJson:
		return "ReaderGroupTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReaderGroupMessageDataType_Encoding_DefaultJson:
		return "ReaderGroupMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetReaderDataType_Encoding_DefaultJson:
		return "DataSetReaderDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetReaderTransportDataType_Encoding_DefaultJson:
		return "DataSetReaderTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DataSetReaderMessageDataType_Encoding_DefaultJson:
		return "DataSetReaderMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_RoleSet:
		return "ServerType_ServerCapabilities_RoleSet"
	case OpcuaNodeIdServicesObject_ServerCapabilitiesType_RoleSet:
		return "ServerCapabilitiesType_RoleSet"
	case OpcuaNodeIdServicesObject_SubscribedDataSetDataType_Encoding_DefaultJson:
		return "SubscribedDataSetDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TargetVariablesDataType_Encoding_DefaultJson:
		return "TargetVariablesDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SubscribedDataSetMirrorDataType_Encoding_DefaultJson:
		return "SubscribedDataSetMirrorDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_FileSystem:
		return "FileSystem"
	case OpcuaNodeIdServicesObject_UadpWriterGroupMessageDataType_Encoding_DefaultJson:
		return "UadpWriterGroupMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_ConfigurationFile"
	case OpcuaNodeIdServicesObject_UadpDataSetWriterMessageDataType_Encoding_DefaultJson:
		return "UadpDataSetWriterMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UadpDataSetReaderMessageDataType_Encoding_DefaultJson:
		return "UadpDataSetReaderMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_JsonWriterGroupMessageDataType_Encoding_DefaultJson:
		return "JsonWriterGroupMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_JsonDataSetWriterMessageDataType_Encoding_DefaultJson:
		return "JsonDataSetWriterMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AlarmConditionType_FirstInGroup:
		return "AlarmConditionType_FirstInGroup"
	case OpcuaNodeIdServicesObject_AlarmConditionType_AlarmGroup_Placeholder:
		return "AlarmConditionType_AlarmGroup_Placeholder"
	case OpcuaNodeIdServicesObject_JsonDataSetReaderMessageDataType_Encoding_DefaultJson:
		return "JsonDataSetReaderMessageDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder:
		return "AlarmGroupType_AlarmConditionInstance_Placeholder"
	case OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState:
		return "AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState"
	case OpcuaNodeIdServicesObject_BrokerWriterGroupTransportDataType_Encoding_DefaultJson:
		return "BrokerWriterGroupTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrokerDataSetWriterTransportDataType_Encoding_DefaultJson:
		return "BrokerDataSetWriterTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BrokerDataSetReaderTransportDataType_Encoding_DefaultJson:
		return "BrokerDataSetReaderTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup:
		return "AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroup"
	case OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultBinary:
		return "BaseConfigurationDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultBinary:
		return "BaseConfigurationRecordDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultBinary:
		return "CertificateGroupDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultBinary:
		return "ConfigurationUpdateTargetType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultBinary:
		return "ApplicationConfigurationDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultBinary:
		return "ApplicationIdentityDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultBinary:
		return "EndpointDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultBinary:
		return "ServerEndpointDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultBinary:
		return "SecuritySettingsDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultBinary:
		return "UserTokenSettingsDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultXml:
		return "BaseConfigurationDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultXml:
		return "BaseConfigurationRecordDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultXml:
		return "CertificateGroupDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultXml:
		return "ConfigurationUpdateTargetType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultXml:
		return "ApplicationConfigurationDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultXml:
		return "ApplicationIdentityDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultXml:
		return "EndpointDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultXml:
		return "ServerEndpointDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultXml:
		return "SecuritySettingsDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultXml:
		return "UserTokenSettingsDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BaseConfigurationDataType_Encoding_DefaultJson:
		return "BaseConfigurationDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_BaseConfigurationRecordDataType_Encoding_DefaultJson:
		return "BaseConfigurationRecordDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CertificateGroupDataType_Encoding_DefaultJson:
		return "CertificateGroupDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ConfigurationUpdateTargetType_Encoding_DefaultJson:
		return "ConfigurationUpdateTargetType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationDataType_Encoding_DefaultJson:
		return "ApplicationConfigurationDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ApplicationIdentityDataType_Encoding_DefaultJson:
		return "ApplicationIdentityDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EndpointDataType_Encoding_DefaultJson:
		return "EndpointDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServerEndpointDataType_Encoding_DefaultJson:
		return "ServerEndpointDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SecuritySettingsDataType_Encoding_DefaultJson:
		return "SecuritySettingsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UserTokenSettingsDataType_Encoding_DefaultJson:
		return "UserTokenSettingsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder"
	case OpcuaNodeIdServicesObject_ManagedApplications:
		return "ManagedApplications"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_MessageSettings"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_TransportSettings:
		return "PubSubConnectionType_TransportSettings"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_TransportSettings:
		return "PubSubConnectionType_WriterGroupName_Placeholder_TransportSettings"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_MessageSettings:
		return "PubSubConnectionType_WriterGroupName_Placeholder_MessageSettings"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_TransportSettings:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_TransportSettings"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_MessageSettings:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_MessageSettings"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder:
		return "PubSubConnectionType_WriterGroupName_Placeholder"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Status:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Status"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder:
		return "PubSubConnectionType_ReaderGroupName_Placeholder"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Status:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Status"
	case OpcuaNodeIdServicesObject_PublishSubscribe_PublishedDataSets:
		return "PublishSubscribe_PublishedDataSets"
	case OpcuaNodeIdServicesObject_PublishSubscribe_Status:
		return "PublishSubscribe_Status"
	case OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics:
		return "PublishSubscribe_Diagnostics"
	case OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_Counters:
		return "PublishSubscribe_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_PublishSubscribe_Diagnostics_LiveValues:
		return "PublishSubscribe_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultBinary:
		return "DatagramConnectionTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultXml:
		return "DatagramConnectionTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DatagramConnectionTransportDataType_Encoding_DefaultJson:
		return "DatagramConnectionTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_KeyCredentialConfigurationFolderType_ServiceName_Placeholder:
		return "KeyCredentialConfigurationFolderType_ServiceName_Placeholder"
	case OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultBinary:
		return "AdditionalParametersType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultXml:
		return "AdditionalParametersType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AdditionalParametersType_Encoding_DefaultJson:
		return "AdditionalParametersType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultBinary:
		return "EphemeralKeyType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultXml:
		return "EphemeralKeyType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EphemeralKeyType_Encoding_DefaultJson:
		return "EphemeralKeyType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DictionaryEntryType_DictionaryEntryName_Placeholder:
		return "DictionaryEntryType_DictionaryEntryName_Placeholder"
	case OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryFolderName_Placeholder:
		return "DictionaryFolderType_DictionaryFolderName_Placeholder"
	case OpcuaNodeIdServicesObject_DictionaryFolderType_DictionaryEntryName_Placeholder:
		return "DictionaryFolderType_DictionaryEntryName_Placeholder"
	case OpcuaNodeIdServicesObject_Dictionaries:
		return "Dictionaries"
	case OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultXml:
		return "GenericAttributeValue_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultXml:
		return "GenericAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_GenericAttributeValue_Encoding_DefaultBinary:
		return "GenericAttributeValue_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_GenericAttributes_Encoding_DefaultBinary:
		return "GenericAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_InterfaceTypes:
		return "InterfaceTypes"
	case OpcuaNodeIdServicesObject_AuthorizationServices:
		return "AuthorizationServices"
	case OpcuaNodeIdServicesObject_WriterGroupType_TransportSettings:
		return "WriterGroupType_TransportSettings"
	case OpcuaNodeIdServicesObject_WriterGroupType_MessageSettings:
		return "WriterGroupType_MessageSettings"
	case OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder:
		return "WriterGroupType_DataSetWriterName_Placeholder"
	case OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_TransportSettings:
		return "WriterGroupType_DataSetWriterName_Placeholder_TransportSettings"
	case OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_MessageSettings:
		return "WriterGroupType_DataSetWriterName_Placeholder_MessageSettings"
	case OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Status:
		return "WriterGroupType_DataSetWriterName_Placeholder_Status"
	case OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics"
	case OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues:
		return "WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics:
		return "WriterGroupType_Diagnostics"
	case OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_Counters:
		return "WriterGroupType_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_WriterGroupType_Diagnostics_LiveValues:
		return "WriterGroupType_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultXml:
		return "DecimalDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DecimalDataType_Encoding_DefaultBinary:
		return "DecimalDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder:
		return "ReaderGroupType_DataSetReaderName_Placeholder"
	case OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_TransportSettings:
		return "ReaderGroupType_DataSetReaderName_Placeholder_TransportSettings"
	case OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_MessageSettings:
		return "ReaderGroupType_DataSetReaderName_Placeholder_MessageSettings"
	case OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Status:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Status"
	case OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics"
	case OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues:
		return "ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_KeyCredentialConfiguration:
		return "KeyCredentialConfiguration"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_TransactionDiagnostics:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_TransactionDiagnostics"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_ConfigurationFile"
	case OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultBinary:
		return "ActionTargetDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultBinary:
		return "PublishedActionDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultBinary:
		return "ActionMethodDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultXml:
		return "ActionTargetDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultXml:
		return "PublishedActionDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultXml:
		return "ActionMethodDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ActionTargetDataType_Encoding_DefaultJson:
		return "ActionTargetDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishedActionDataType_Encoding_DefaultJson:
		return "PublishedActionDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ActionMethodDataType_Encoding_DefaultJson:
		return "ActionMethodDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_WellKnownRole_TrustedApplication:
		return "WellKnownRole_TrustedApplication"
	case OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultBinary:
		return "SortRuleElement_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultBinary:
		return "ReadEventDetailsSorted_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultXml:
		return "SortRuleElement_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultXml:
		return "ReadEventDetailsSorted_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SortRuleElement_Encoding_DefaultJson:
		return "SortRuleElement_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReadEventDetailsSorted_Encoding_DefaultJson:
		return "ReadEventDetailsSorted_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues:
		return "PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics:
		return "PublishSubscribeType_Diagnostics"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_Counters:
		return "PublishSubscribeType_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_Diagnostics_LiveValues:
		return "PublishSubscribeType_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultBinary:
		return "PublishedActionMethodDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultBinary:
		return "RationalNumber_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_Vector_Encoding_DefaultBinary:
		return "Vector_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultBinary:
		return "ThreeDVector_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultBinary:
		return "CartesianCoordinates_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultBinary:
		return "ThreeDCartesianCoordinates_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultBinary:
		return "Orientation_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultBinary:
		return "ThreeDOrientation_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_Frame_Encoding_DefaultBinary:
		return "Frame_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultBinary:
		return "ThreeDFrame_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultXml:
		return "RationalNumber_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_Vector_Encoding_DefaultXml:
		return "Vector_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultXml:
		return "ThreeDVector_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultXml:
		return "CartesianCoordinates_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultXml:
		return "ThreeDCartesianCoordinates_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultXml:
		return "Orientation_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultXml:
		return "ThreeDOrientation_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_Frame_Encoding_DefaultXml:
		return "Frame_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultXml:
		return "ThreeDFrame_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics"
	case OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues:
		return "PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultBinary:
		return "DtlsPubSubConnectionDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultXml:
		return "PublishedActionMethodDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultXml:
		return "DtlsPubSubConnectionDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedActionMethodDataType_Encoding_DefaultJson:
		return "PublishedActionMethodDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DtlsPubSubConnectionDataType_Encoding_DefaultJson:
		return "DtlsPubSubConnectionDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_LLDP:
		return "LLDP"
	case OpcuaNodeIdServicesObject_LLDP_RemoteStatistics:
		return "LLDP_RemoteStatistics"
	case OpcuaNodeIdServicesObject_LLDP_LocalSystemData:
		return "LLDP_LocalSystemData"
	case OpcuaNodeIdServicesObject_LLDP_Ports:
		return "LLDP_Ports"
	case OpcuaNodeIdServicesObject_LldpInformationType_RemoteStatistics:
		return "LldpInformationType_RemoteStatistics"
	case OpcuaNodeIdServicesObject_LldpInformationType_LocalSystemData:
		return "LldpInformationType_LocalSystemData"
	case OpcuaNodeIdServicesObject_LldpInformationType_Ports:
		return "LldpInformationType_Ports"
	case OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder:
		return "LldpInformationType_Ports_LldpPortInformation_Placeholder"
	case OpcuaNodeIdServicesObject_LldpInformationType_Ports_LldpPortInformation_Placeholder_RemoteSystemsData:
		return "LldpInformationType_Ports_LldpPortInformation_Placeholder_RemoteSystemsData"
	case OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData:
		return "LldpPortInformationType_RemoteSystemsData"
	case OpcuaNodeIdServicesObject_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder"
	case OpcuaNodeIdServicesObject_RationalNumber_Encoding_DefaultJson:
		return "RationalNumber_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_Vector_Encoding_DefaultJson:
		return "Vector_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ThreeDVector_Encoding_DefaultJson:
		return "ThreeDVector_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CartesianCoordinates_Encoding_DefaultJson:
		return "CartesianCoordinates_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ThreeDCartesianCoordinates_Encoding_DefaultJson:
		return "ThreeDCartesianCoordinates_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_Orientation_Encoding_DefaultJson:
		return "Orientation_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ThreeDOrientation_Encoding_DefaultJson:
		return "ThreeDOrientation_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_Frame_Encoding_DefaultJson:
		return "Frame_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ThreeDFrame_Encoding_DefaultJson:
		return "ThreeDFrame_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultBinary:
		return "LldpManagementAddressTxPortType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultBinary:
		return "LldpManagementAddressType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultBinary:
		return "LldpTlvType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultXml:
		return "LldpManagementAddressTxPortType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultXml:
		return "LldpManagementAddressType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultXml:
		return "LldpTlvType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues:
		return "PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues:
		return "PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics:
		return "PubSubConnectionType_Diagnostics"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_Counters:
		return "PubSubConnectionType_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_PubSubConnectionType_Diagnostics_LiveValues:
		return "PubSubConnectionType_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_LldpManagementAddressTxPortType_Encoding_DefaultJson:
		return "LldpManagementAddressTxPortType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_LldpManagementAddressType_Encoding_DefaultJson:
		return "LldpManagementAddressType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_LldpTlvType_Encoding_DefaultJson:
		return "LldpTlvType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServerLog:
		return "ServerLog"
	case OpcuaNodeIdServicesObject_Logs:
		return "Logs"
	case OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultBinary:
		return "LogRecord_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultXml:
		return "LogRecord_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_LogRecord_Encoding_DefaultJson:
		return "LogRecord_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_KeyCredentials"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationFolderType_ApplicationName_Placeholder_AuthorizationServices:
		return "ApplicationConfigurationFolderType_ApplicationName_Placeholder_AuthorizationServices"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationType_KeyCredentials:
		return "ApplicationConfigurationType_KeyCredentials"
	case OpcuaNodeIdServicesObject_ApplicationConfigurationType_AuthorizationServices:
		return "ApplicationConfigurationType_AuthorizationServices"
	case OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultBinary:
		return "TestUnion_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultBinary:
		return "TestOptionalFields_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultXml:
		return "TestUnion_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultXml:
		return "TestOptionalFields_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TestUnion_Encoding_DefaultJson:
		return "TestUnion_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TestOptionalFields_Encoding_DefaultJson:
		return "TestOptionalFields_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired:
		return "CertificateGroupType_CertificateExpired"
	case OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_ShelvingState:
		return "CertificateGroupType_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics:
		return "DataSetWriterType_Diagnostics"
	case OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_Counters:
		return "DataSetWriterType_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_DataSetWriterType_Diagnostics_LiveValues:
		return "DataSetWriterType_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics:
		return "DataSetReaderType_Diagnostics"
	case OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_Counters:
		return "DataSetReaderType_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_DataSetReaderType_Diagnostics_LiveValues:
		return "DataSetReaderType_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsType_Counters:
		return "PubSubDiagnosticsType_Counters"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsType_LiveValues:
		return "PubSubDiagnosticsType_LiveValues"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_KeyCredentials"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_AuthorizationServices:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_AuthorizationServices"
	case OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultBinary:
		return "AuthorizationServiceConfigurationDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultBinary:
		return "LogRecordsDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultBinary:
		return "SpanContextDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultBinary:
		return "TraceContextDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultBinary:
		return "NameValuePair_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultXml:
		return "AuthorizationServiceConfigurationDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultXml:
		return "LogRecordsDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultXml:
		return "SpanContextDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultXml:
		return "TraceContextDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultXml:
		return "NameValuePair_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsRootType_LiveValues:
		return "PubSubDiagnosticsRootType_LiveValues"
	case OpcuaNodeIdServicesObject_AuthorizationServiceConfigurationDataType_Encoding_DefaultJson:
		return "AuthorizationServiceConfigurationDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_LogRecordsDataType_Encoding_DefaultJson:
		return "LogRecordsDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SpanContextDataType_Encoding_DefaultJson:
		return "SpanContextDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TraceContextDataType_Encoding_DefaultJson:
		return "TraceContextDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NameValuePair_Encoding_DefaultJson:
		return "NameValuePair_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsConnectionType_LiveValues:
		return "PubSubDiagnosticsConnectionType_LiveValues"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_Counters:
		return "PubSubDiagnosticsWriterGroupType_Counters"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsWriterGroupType_LiveValues:
		return "PubSubDiagnosticsWriterGroupType_LiveValues"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_Counters:
		return "PubSubDiagnosticsReaderGroupType_Counters"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsReaderGroupType_LiveValues:
		return "PubSubDiagnosticsReaderGroupType_LiveValues"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_Counters:
		return "PubSubDiagnosticsDataSetWriterType_Counters"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetWriterType_LiveValues:
		return "PubSubDiagnosticsDataSetWriterType_LiveValues"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_Counters:
		return "PubSubDiagnosticsDataSetReaderType_Counters"
	case OpcuaNodeIdServicesObject_PubSubDiagnosticsDataSetReaderType_LiveValues:
		return "PubSubDiagnosticsDataSetReaderType_LiveValues"
	case OpcuaNodeIdServicesObject_ServerType_ServerCapabilities:
		return "ServerType_ServerCapabilities"
	case OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics:
		return "ServerType_ServerDiagnostics"
	case OpcuaNodeIdServicesObject_ServerType_VendorServerInfo:
		return "ServerType_VendorServerInfo"
	case OpcuaNodeIdServicesObject_ServerType_ServerRedundancy:
		return "ServerType_ServerRedundancy"
	case OpcuaNodeIdServicesObject_CertificateGroupType_CertificateExpired_FirstInGroup:
		return "CertificateGroupType_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate:
		return "CertificateGroupType_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ServerCapabilitiesType_ModellingRules:
		return "ServerCapabilitiesType_ModellingRules"
	case OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_ShelvingState:
		return "CertificateGroupType_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_CertificateGroupType_TrustListOutOfDate_FirstInGroup:
		return "CertificateGroupType_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired:
		return "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState:
		return "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroup:
		return "CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate:
		return "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState:
		return "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup:
		return "CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired:
		return "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState:
		return "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroup:
		return "CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate:
		return "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState:
		return "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup:
		return "CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired:
		return "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState:
		return "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultXml:
		return "SessionlessInvokeResponseType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SessionlessInvokeResponseType_Encoding_DefaultBinary:
		return "SessionlessInvokeResponseType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet:
		return "ReaderGroupType_DataSetReaderName_Placeholder_SubscribedDataSet"
	case OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics:
		return "ReaderGroupType_Diagnostics"
	case OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_Counters:
		return "ReaderGroupType_Diagnostics_Counters"
	case OpcuaNodeIdServicesObject_ReaderGroupType_Diagnostics_LiveValues:
		return "ReaderGroupType_Diagnostics_LiveValues"
	case OpcuaNodeIdServicesObject_ReaderGroupType_TransportSettings:
		return "ReaderGroupType_TransportSettings"
	case OpcuaNodeIdServicesObject_ReaderGroupType_MessageSettings:
		return "ReaderGroupType_MessageSettings"
	case OpcuaNodeIdServicesObject_DataSetWriterType_MessageSettings:
		return "DataSetWriterType_MessageSettings"
	case OpcuaNodeIdServicesObject_DataSetReaderType_MessageSettings:
		return "DataSetReaderType_MessageSettings"
	case OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultBinary:
		return "WriterGroupDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultBinary:
		return "NetworkAddressDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultBinary:
		return "NetworkAddressUrlDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultBinary:
		return "ReaderGroupDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultBinary:
		return "PubSubConfigurationDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultBinary:
		return "DatagramWriterGroupTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultXml:
		return "WriterGroupDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultXml:
		return "NetworkAddressDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultXml:
		return "NetworkAddressUrlDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultXml:
		return "ReaderGroupDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultXml:
		return "PubSubConfigurationDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultXml:
		return "DatagramWriterGroupTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_WriterGroupDataType_Encoding_DefaultJson:
		return "WriterGroupDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NetworkAddressDataType_Encoding_DefaultJson:
		return "NetworkAddressDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_NetworkAddressUrlDataType_Encoding_DefaultJson:
		return "NetworkAddressUrlDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReaderGroupDataType_Encoding_DefaultJson:
		return "ReaderGroupDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubConfigurationDataType_Encoding_DefaultJson:
		return "PubSubConfigurationDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DatagramWriterGroupTransportDataType_Encoding_DefaultJson:
		return "DatagramWriterGroupTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroup:
		return "CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate:
		return "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState:
		return "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup:
		return "CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired:
		return "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState:
		return "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroup:
		return "CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate:
		return "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState:
		return "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroup:
		return "CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired:
		return "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState:
		return "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate:
		return "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState:
		return "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired:
		return "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState:
		return "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate:
		return "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState:
		return "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired:
		return "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState:
		return "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate:
		return "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState:
		return "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_Server:
		return "Server"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup:
		return "ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired:
		return "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState:
		return "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_Server_ServerCapabilities:
		return "Server_ServerCapabilities"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup:
		return "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate:
		return "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_Server_ServerDiagnostics:
		return "Server_ServerDiagnostics"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState:
		return "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup:
		return "ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired:
		return "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_Server_VendorServerInfo:
		return "Server_VendorServerInfo"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState:
		return "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_Server_ServerRedundancy:
		return "Server_ServerRedundancy"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup:
		return "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate:
		return "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState:
		return "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup:
		return "ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired:
		return "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState:
		return "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup:
		return "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate:
		return "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState:
		return "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_AggregateFunction_Interpolative:
		return "AggregateFunction_Interpolative"
	case OpcuaNodeIdServicesObject_AggregateFunction_Average:
		return "AggregateFunction_Average"
	case OpcuaNodeIdServicesObject_AggregateFunction_TimeAverage:
		return "AggregateFunction_TimeAverage"
	case OpcuaNodeIdServicesObject_ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup:
		return "ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_AggregateFunction_Total:
		return "AggregateFunction_Total"
	case OpcuaNodeIdServicesObject_AliasNameCategoryType_Alias_Placeholder:
		return "AliasNameCategoryType_Alias_Placeholder"
	case OpcuaNodeIdServicesObject_AliasNameCategoryType_SubAliasNameCategories_Placeholder:
		return "AliasNameCategoryType_SubAliasNameCategories_Placeholder"
	case OpcuaNodeIdServicesObject_AggregateFunction_Minimum:
		return "AggregateFunction_Minimum"
	case OpcuaNodeIdServicesObject_AggregateFunction_Maximum:
		return "AggregateFunction_Maximum"
	case OpcuaNodeIdServicesObject_Aliases:
		return "Aliases"
	case OpcuaNodeIdServicesObject_TagVariables:
		return "TagVariables"
	case OpcuaNodeIdServicesObject_AggregateFunction_MinimumActualTime:
		return "AggregateFunction_MinimumActualTime"
	case OpcuaNodeIdServicesObject_Topics:
		return "Topics"
	case OpcuaNodeIdServicesObject_AggregateFunction_MaximumActualTime:
		return "AggregateFunction_MaximumActualTime"
	case OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultBinary:
		return "AliasNameDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AggregateFunction_Range:
		return "AggregateFunction_Range"
	case OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultBinary:
		return "ReadAnnotationDataDetails_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultXml:
		return "AliasNameDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultXml:
		return "ReadAnnotationDataDetails_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultBinary:
		return "CurrencyUnitType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AggregateFunction_AnnotationCount:
		return "AggregateFunction_AnnotationCount"
	case OpcuaNodeIdServicesObject_AliasNameDataType_Encoding_DefaultJson:
		return "AliasNameDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReadAnnotationDataDetails_Encoding_DefaultJson:
		return "ReadAnnotationDataDetails_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_OrderedListType_OrderedObject_Placeholder:
		return "OrderedListType_OrderedObject_Placeholder"
	case OpcuaNodeIdServicesObject_AggregateFunction_Count:
		return "AggregateFunction_Count"
	case OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultXml:
		return "CurrencyUnitType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CurrencyUnitType_Encoding_DefaultJson:
		return "CurrencyUnitType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_AggregateFunction_NumberOfTransitions:
		return "AggregateFunction_NumberOfTransitions"
	case OpcuaNodeIdServicesObject_AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder:
		return "AuthorizationServicesConfigurationFolderType_ServiceName_Placeholder"
	case OpcuaNodeIdServicesObject_AggregateFunction_Start:
		return "AggregateFunction_Start"
	case OpcuaNodeIdServicesObject_AggregateFunction_End:
		return "AggregateFunction_End"
	case OpcuaNodeIdServicesObject_AggregateFunction_Delta:
		return "AggregateFunction_Delta"
	case OpcuaNodeIdServicesObject_AggregateFunction_DurationGood:
		return "AggregateFunction_DurationGood"
	case OpcuaNodeIdServicesObject_AggregateFunction_DurationBad:
		return "AggregateFunction_DurationBad"
	case OpcuaNodeIdServicesObject_AggregateFunction_PercentGood:
		return "AggregateFunction_PercentGood"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_SubscribedDataSets:
		return "PublishSubscribeType_SubscribedDataSets"
	case OpcuaNodeIdServicesObject_AggregateFunction_PercentBad:
		return "AggregateFunction_PercentBad"
	case OpcuaNodeIdServicesObject_AggregateFunction_WorstQuality:
		return "AggregateFunction_WorstQuality"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubCapablities:
		return "PublishSubscribeType_PubSubCapablities"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_DataSetClasses:
		return "PublishSubscribeType_DataSetClasses"
	case OpcuaNodeIdServicesObject_PublishSubscribe_SubscribedDataSets:
		return "PublishSubscribe_SubscribedDataSets"
	case OpcuaNodeIdServicesObject_PublishSubscribe_PubSubCapablities:
		return "PublishSubscribe_PubSubCapablities"
	case OpcuaNodeIdServicesObject_PublishSubscribe_DataSetClasses:
		return "PublishSubscribe_DataSetClasses"
	case OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder:
		return "SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder"
	case OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder:
		return "SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder"
	case OpcuaNodeIdServicesObject_SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet:
		return "SubscribedDataSetFolderType_StandaloneSubscribedDataSetName_Placeholder_SubscribedDataSet"
	case OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetType_SubscribedDataSet:
		return "StandaloneSubscribedDataSetType_SubscribedDataSet"
	case OpcuaNodeIdServicesObject_DatagramWriterGroupTransportType_Address:
		return "DatagramWriterGroupTransportType_Address"
	case OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary:
		return "StandaloneSubscribedDataSetRefDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary:
		return "StandaloneSubscribedDataSetDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultBinary:
		return "SecurityGroupDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultBinary:
		return "PubSubConfiguration2DataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultBinary:
		return "QosDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultBinary:
		return "TransmitQosDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultBinary:
		return "TransmitQosPriorityDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultBinary:
		return "ReceiveQosDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultBinary:
		return "ReceiveQosPriorityDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultBinary:
		return "DatagramConnectionTransport2DataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary:
		return "DatagramWriterGroupTransport2DataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary:
		return "DatagramDataSetReaderTransportDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml:
		return "StandaloneSubscribedDataSetRefDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultXml:
		return "StandaloneSubscribedDataSetDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultXml:
		return "SecurityGroupDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultXml:
		return "PubSubConfiguration2DataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultXml:
		return "QosDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultXml:
		return "TransmitQosDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultXml:
		return "TransmitQosPriorityDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultXml:
		return "ReceiveQosDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultXml:
		return "ReceiveQosPriorityDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultXml:
		return "DatagramConnectionTransport2DataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultXml:
		return "DatagramWriterGroupTransport2DataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultXml:
		return "DatagramDataSetReaderTransportDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson:
		return "StandaloneSubscribedDataSetRefDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_StandaloneSubscribedDataSetDataType_Encoding_DefaultJson:
		return "StandaloneSubscribedDataSetDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_SecurityGroupDataType_Encoding_DefaultJson:
		return "SecurityGroupDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubConfiguration2DataType_Encoding_DefaultJson:
		return "PubSubConfiguration2DataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_QosDataType_Encoding_DefaultJson:
		return "QosDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TransmitQosDataType_Encoding_DefaultJson:
		return "TransmitQosDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_TransmitQosPriorityDataType_Encoding_DefaultJson:
		return "TransmitQosPriorityDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReceiveQosDataType_Encoding_DefaultJson:
		return "ReceiveQosDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReceiveQosPriorityDataType_Encoding_DefaultJson:
		return "ReceiveQosPriorityDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_Ready:
		return "ProgramStateMachineType_Ready"
	case OpcuaNodeIdServicesObject_DatagramConnectionTransport2DataType_Encoding_DefaultJson:
		return "DatagramConnectionTransport2DataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DatagramWriterGroupTransport2DataType_Encoding_DefaultJson:
		return "DatagramWriterGroupTransport2DataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportDataType_Encoding_DefaultJson:
		return "DatagramDataSetReaderTransportDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_DatagramDataSetReaderTransportType_Address:
		return "DatagramDataSetReaderTransportType_Address"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_Running:
		return "ProgramStateMachineType_Running"
	case OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultBinary:
		return "ProgramDiagnostic2DataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultXml:
		return "ProgramDiagnostic2DataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_Suspended:
		return "ProgramStateMachineType_Suspended"
	case OpcuaNodeIdServicesObject_ProgramDiagnostic2DataType_Encoding_DefaultJson:
		return "ProgramDiagnostic2DataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_Halted:
		return "ProgramStateMachineType_Halted"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_HaltedToReady:
		return "ProgramStateMachineType_HaltedToReady"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToRunning:
		return "ProgramStateMachineType_ReadyToRunning"
	case OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultBinary:
		return "PortableQualifiedName_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultBinary:
		return "PortableNodeId_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultBinary:
		return "UnsignedRationalNumber_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToHalted:
		return "ProgramStateMachineType_RunningToHalted"
	case OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultXml:
		return "PortableQualifiedName_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultXml:
		return "PortableNodeId_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultXml:
		return "UnsignedRationalNumber_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PortableQualifiedName_Encoding_DefaultJson:
		return "PortableQualifiedName_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PortableNodeId_Encoding_DefaultJson:
		return "PortableNodeId_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UnsignedRationalNumber_Encoding_DefaultJson:
		return "UnsignedRationalNumber_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToReady:
		return "ProgramStateMachineType_RunningToReady"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_RunningToSuspended:
		return "ProgramStateMachineType_RunningToSuspended"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToRunning:
		return "ProgramStateMachineType_SuspendedToRunning"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToHalted:
		return "ProgramStateMachineType_SuspendedToHalted"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_SuspendedToReady:
		return "ProgramStateMachineType_SuspendedToReady"
	case OpcuaNodeIdServicesObject_Resources:
		return "Resources"
	case OpcuaNodeIdServicesObject_Communication:
		return "Communication"
	case OpcuaNodeIdServicesObject_MappingTables:
		return "MappingTables"
	case OpcuaNodeIdServicesObject_NetworkInterfaces:
		return "NetworkInterfaces"
	case OpcuaNodeIdServicesObject_Streams:
		return "Streams"
	case OpcuaNodeIdServicesObject_TalkerStreams:
		return "TalkerStreams"
	case OpcuaNodeIdServicesObject_ListenerStreams:
		return "ListenerStreams"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_ReadyToHalted:
		return "ProgramStateMachineType_ReadyToHalted"
	case OpcuaNodeIdServicesObject_UserManagement:
		return "UserManagement"
	case OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultBinary:
		return "UserManagementDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultXml:
		return "UserManagementDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UserManagementDataType_Encoding_DefaultJson:
		return "UserManagementDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_IetfBaseNetworkInterfaceType_InterfaceName_Placeholder:
		return "IetfBaseNetworkInterfaceType_InterfaceName_Placeholder"
	case OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultBinary:
		return "PriorityMappingEntryType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultXml:
		return "PriorityMappingEntryType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PriorityMappingEntryType_Encoding_DefaultJson:
		return "PriorityMappingEntryType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubKeyServiceType_KeyPushTargets:
		return "PubSubKeyServiceType_KeyPushTargets"
	case OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder:
		return "PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder"
	case OpcuaNodeIdServicesObject_PubSubKeyPushTargetFolderType_PushTargetName_Placeholder:
		return "PubSubKeyPushTargetFolderType_PushTargetName_Placeholder"
	case OpcuaNodeIdServicesObject_PublishSubscribeType_PubSubConfiguration:
		return "PublishSubscribeType_PubSubConfiguration"
	case OpcuaNodeIdServicesObject_PublishSubscribe_KeyPushTargets:
		return "PublishSubscribe_KeyPushTargets"
	case OpcuaNodeIdServicesObject_PublishSubscribe_PubSubConfiguration:
		return "PublishSubscribe_PubSubConfiguration"
	case OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary:
		return "PublishedDataSetCustomSourceDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultBinary:
		return "PubSubKeyPushTargetDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultBinary:
		return "PubSubConfigurationRefDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultBinary:
		return "PubSubConfigurationValueDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultXml:
		return "PublishedDataSetCustomSourceDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultXml:
		return "PubSubKeyPushTargetDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultXml:
		return "PubSubConfigurationRefDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultXml:
		return "PubSubConfigurationValueDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_PublishedDataSetCustomSourceDataType_Encoding_DefaultJson:
		return "PublishedDataSetCustomSourceDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubKeyPushTargetDataType_Encoding_DefaultJson:
		return "PubSubKeyPushTargetDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubConfigurationRefDataType_Encoding_DefaultJson:
		return "PubSubConfigurationRefDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_PubSubConfigurationValueDataType_Encoding_DefaultJson:
		return "PubSubConfigurationValueDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAdmin:
		return "WellKnownRole_SecurityKeyServerAdmin"
	case OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerPush:
		return "WellKnownRole_SecurityKeyServerPush"
	case OpcuaNodeIdServicesObject_WellKnownRole_SecurityKeyServerAccess:
		return "WellKnownRole_SecurityKeyServerAccess"
	case OpcuaNodeIdServicesObject_PubSubKeyPushTargetType_SecurityGroupName_Placeholder:
		return "PubSubKeyPushTargetType_SecurityGroupName_Placeholder"
	case OpcuaNodeIdServicesObject_Node_Encoding_DefaultXml:
		return "Node_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_Node_Encoding_DefaultBinary:
		return "Node_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultXml:
		return "ObjectNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ObjectNode_Encoding_DefaultBinary:
		return "ObjectNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultXml:
		return "ObjectTypeNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ObjectTypeNode_Encoding_DefaultBinary:
		return "ObjectTypeNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultXml:
		return "VariableNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder:
		return "ProvisionableDeviceType_ApplicationName_Placeholder"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList"
	case OpcuaNodeIdServicesObject_VariableNode_Encoding_DefaultBinary:
		return "VariableNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultXml:
		return "VariableTypeNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_VariableTypeNode_Encoding_DefaultBinary:
		return "VariableTypeNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultXml:
		return "ReferenceTypeNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_ServerDiagnosticsType_SessionsDiagnosticsSummary:
		return "ServerDiagnosticsType_SessionsDiagnosticsSummary"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ReferenceTypeNode_Encoding_DefaultBinary:
		return "ReferenceTypeNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ServerCapabilitiesType_AggregateFunctions:
		return "ServerCapabilitiesType_AggregateFunctions"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired"
	case OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultXml:
		return "MethodNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_FirstInGroup"
	case OpcuaNodeIdServicesObject_MethodNode_Encoding_DefaultBinary:
		return "MethodNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_FirstInGroup"
	case OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultXml:
		return "ViewNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ViewNode_Encoding_DefaultBinary:
		return "ViewNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultXml:
		return "DataTypeNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataTypeNode_Encoding_DefaultBinary:
		return "DataTypeNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultXml:
		return "ReferenceNode_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReferenceNode_Encoding_DefaultBinary:
		return "ReferenceNode_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_Unshelved:
		return "ShelvedStateMachineType_Unshelved"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelved:
		return "ShelvedStateMachineType_TimedShelved"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelved:
		return "ShelvedStateMachineType_OneShotShelved"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToTimedShelved:
		return "ShelvedStateMachineType_UnshelvedToTimedShelved"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_UnshelvedToOneShotShelved:
		return "ShelvedStateMachineType_UnshelvedToOneShotShelved"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToUnshelved:
		return "ShelvedStateMachineType_TimedShelvedToUnshelved"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_TimedShelvedToOneShotShelved:
		return "ShelvedStateMachineType_TimedShelvedToOneShotShelved"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToUnshelved:
		return "ShelvedStateMachineType_OneShotShelvedToUnshelved"
	case OpcuaNodeIdServicesObject_ShelvedStateMachineType_OneShotShelvedToTimedShelved:
		return "ShelvedStateMachineType_OneShotShelvedToTimedShelved"
	case OpcuaNodeIdServicesObject_Argument_Encoding_DefaultXml:
		return "Argument_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_Argument_Encoding_DefaultBinary:
		return "Argument_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ProvisionableDevice:
		return "ProvisionableDevice"
	case OpcuaNodeIdServicesObject_Server_ServerCapabilities_ModellingRules:
		return "Server_ServerCapabilities_ModellingRules"
	case OpcuaNodeIdServicesObject_Server_ServerCapabilities_AggregateFunctions:
		return "Server_ServerCapabilities_AggregateFunctions"
	case OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultXml:
		return "StatusResult_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_StatusResult_Encoding_DefaultBinary:
		return "StatusResult_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_EventTypesFolder:
		return "EventTypesFolder"
	case OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultXml:
		return "UserTokenPolicy_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_HistoricalDataConfigurationType_AggregateConfiguration:
		return "HistoricalDataConfigurationType_AggregateConfiguration"
	case OpcuaNodeIdServicesObject_UserTokenPolicy_Encoding_DefaultBinary:
		return "UserTokenPolicy_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DefaultBinary:
		return "DefaultBinary"
	case OpcuaNodeIdServicesObject_DefaultXml:
		return "DefaultXml"
	case OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultXml:
		return "ApplicationDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_ModellingRules:
		return "ServerType_ServerCapabilities_ModellingRules"
	case OpcuaNodeIdServicesObject_ServerType_ServerCapabilities_AggregateFunctions:
		return "ServerType_ServerCapabilities_AggregateFunctions"
	case OpcuaNodeIdServicesObject_ApplicationDescription_Encoding_DefaultBinary:
		return "ApplicationDescription_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ServerType_ServerDiagnostics_SessionsDiagnosticsSummary:
		return "ServerType_ServerDiagnostics_SessionsDiagnosticsSummary"
	case OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultXml:
		return "EndpointDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EndpointDescription_Encoding_DefaultBinary:
		return "EndpointDescription_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultXml:
		return "UserIdentityToken_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_UserIdentityToken_Encoding_DefaultBinary:
		return "UserIdentityToken_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_Locations:
		return "Locations"
	case OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultXml:
		return "AnonymousIdentityToken_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AnonymousIdentityToken_Encoding_DefaultBinary:
		return "AnonymousIdentityToken_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ServerConfigurationType_TransactionDiagnostics:
		return "ServerConfigurationType_TransactionDiagnostics"
	case OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultXml:
		return "UserNameIdentityToken_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ServerConfiguration_TransactionDiagnostics:
		return "ServerConfiguration_TransactionDiagnostics"
	case OpcuaNodeIdServicesObject_ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics:
		return "ProvisionableDeviceType_ApplicationName_Placeholder_TransactionDiagnostics"
	case OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultBinary:
		return "TransactionErrorType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultXml:
		return "TransactionErrorType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_TransactionErrorType_Encoding_DefaultJson:
		return "TransactionErrorType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_UserNameIdentityToken_Encoding_DefaultBinary:
		return "UserNameIdentityToken_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultBinary:
		return "BitFieldDefinition_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultXml:
		return "BitFieldDefinition_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BitFieldDefinition_Encoding_DefaultJson:
		return "BitFieldDefinition_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits:
		return "ServerUnitType_AlternativeUnits"
	case OpcuaNodeIdServicesObject_ServerUnitType_CoherentUnit:
		return "ServerUnitType_CoherentUnit"
	case OpcuaNodeIdServicesObject_QuantityType_ServerUnits:
		return "QuantityType_ServerUnits"
	case OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder"
	case OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_AlternativeUnits:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_AlternativeUnits"
	case OpcuaNodeIdServicesObject_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit"
	case OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder:
		return "QuantitiesFolderType_Quantity_Placeholder"
	case OpcuaNodeIdServicesObject_QuantitiesFolderType_Quantity_Placeholder_ServerUnits:
		return "QuantitiesFolderType_Quantity_Placeholder_ServerUnits"
	case OpcuaNodeIdServicesObject_Quantities:
		return "Quantities"
	case OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultBinary:
		return "AnnotationDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultBinary:
		return "LinearConversionDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultBinary:
		return "QuantityDimension_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultXml:
		return "AnnotationDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultXml:
		return "LinearConversionDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultXml:
		return "QuantityDimension_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AnnotationDataType_Encoding_DefaultJson:
		return "AnnotationDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_LinearConversionDataType_Encoding_DefaultJson:
		return "LinearConversionDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_QuantityDimension_Encoding_DefaultJson:
		return "QuantityDimension_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ServerUnitType_AlternativeUnits_AlternativeUnit_Placeholder:
		return "ServerUnitType_AlternativeUnits_AlternativeUnit_Placeholder"
	case OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultXml:
		return "X509IdentityToken_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_HistoricalEventConfigurationType_EventTypes:
		return "HistoricalEventConfigurationType_EventTypes"
	case OpcuaNodeIdServicesObject_DefaultHAConfiguration:
		return "DefaultHAConfiguration"
	case OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateConfiguration:
		return "DefaultHAConfiguration_AggregateConfiguration"
	case OpcuaNodeIdServicesObject_DefaultHAConfiguration_AggregateFunctions:
		return "DefaultHAConfiguration_AggregateFunctions"
	case OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultBinary:
		return "ReferenceDescriptionDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultBinary:
		return "ReferenceListEntryDataType_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultXml:
		return "ReferenceDescriptionDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultXml:
		return "ReferenceListEntryDataType_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReferenceDescriptionDataType_Encoding_DefaultJson:
		return "ReferenceDescriptionDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_ReferenceListEntryDataType_Encoding_DefaultJson:
		return "ReferenceListEntryDataType_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_X509IdentityToken_Encoding_DefaultBinary:
		return "X509IdentityToken_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DefaultHEConfiguration:
		return "DefaultHEConfiguration"
	case OpcuaNodeIdServicesObject_DefaultHEConfiguration_EventTypes:
		return "DefaultHEConfiguration_EventTypes"
	case OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultBinary:
		return "ReadEventDetails2_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultXml:
		return "ReadEventDetails2_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReadEventDetails2_Encoding_DefaultJson:
		return "ReadEventDetails2_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultBinary:
		return "HistoryModifiedEvent_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultXml:
		return "HistoryModifiedEvent_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_HistoryModifiedEvent_Encoding_DefaultJson:
		return "HistoryModifiedEvent_Encoding_DefaultJson"
	case OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultXml:
		return "EndpointConfiguration_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_EndpointConfiguration_Encoding_DefaultBinary:
		return "EndpointConfiguration_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultXml:
		return "BuildInfo_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BuildInfo_Encoding_DefaultBinary:
		return "BuildInfo_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultXml:
		return "SignedSoftwareCertificate_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SignedSoftwareCertificate_Encoding_DefaultBinary:
		return "SignedSoftwareCertificate_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultXml:
		return "NodeAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_NodeAttributes_Encoding_DefaultBinary:
		return "NodeAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultXml:
		return "ObjectAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ObjectAttributes_Encoding_DefaultBinary:
		return "ObjectAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultXml:
		return "VariableAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_VariableAttributes_Encoding_DefaultBinary:
		return "VariableAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultXml:
		return "MethodAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_MethodAttributes_Encoding_DefaultBinary:
		return "MethodAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultXml:
		return "ObjectTypeAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ObjectTypeAttributes_Encoding_DefaultBinary:
		return "ObjectTypeAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultXml:
		return "VariableTypeAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_VariableTypeAttributes_Encoding_DefaultBinary:
		return "VariableTypeAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultXml:
		return "ReferenceTypeAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReferenceTypeAttributes_Encoding_DefaultBinary:
		return "ReferenceTypeAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_Server_ServerDiagnostics_SessionsDiagnosticsSummary:
		return "Server_ServerDiagnostics_SessionsDiagnosticsSummary"
	case OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultXml:
		return "DataTypeAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DataTypeAttributes_Encoding_DefaultBinary:
		return "DataTypeAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultXml:
		return "ViewAttributes_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ViewAttributes_Encoding_DefaultBinary:
		return "ViewAttributes_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultXml:
		return "AddNodesItem_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AddNodesItem_Encoding_DefaultBinary:
		return "AddNodesItem_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultXml:
		return "AddReferencesItem_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AddReferencesItem_Encoding_DefaultBinary:
		return "AddReferencesItem_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultXml:
		return "DeleteNodesItem_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DeleteNodesItem_Encoding_DefaultBinary:
		return "DeleteNodesItem_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ProgramStateMachineType_FinalResultData:
		return "ProgramStateMachineType_FinalResultData"
	case OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultXml:
		return "DeleteReferencesItem_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DeleteReferencesItem_Encoding_DefaultBinary:
		return "DeleteReferencesItem_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultXml:
		return "RequestHeader_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_RequestHeader_Encoding_DefaultBinary:
		return "RequestHeader_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultXml:
		return "ResponseHeader_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ResponseHeader_Encoding_DefaultBinary:
		return "ResponseHeader_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultXml:
		return "ServiceFault_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ServiceFault_Encoding_DefaultBinary:
		return "ServiceFault_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultXml:
		return "FindServersRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_FindServersRequest_Encoding_DefaultBinary:
		return "FindServersRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultXml:
		return "FindServersResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_FindServersResponse_Encoding_DefaultBinary:
		return "FindServersResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultXml:
		return "GetEndpointsRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_GetEndpointsRequest_Encoding_DefaultBinary:
		return "GetEndpointsRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultXml:
		return "GetEndpointsResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_GetEndpointsResponse_Encoding_DefaultBinary:
		return "GetEndpointsResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultXml:
		return "RegisteredServer_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_RegisteredServer_Encoding_DefaultBinary:
		return "RegisteredServer_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultXml:
		return "RegisterServerRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_RegisterServerRequest_Encoding_DefaultBinary:
		return "RegisterServerRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultXml:
		return "RegisterServerResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_RegisterServerResponse_Encoding_DefaultBinary:
		return "RegisterServerResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultXml:
		return "ChannelSecurityToken_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ChannelSecurityToken_Encoding_DefaultBinary:
		return "ChannelSecurityToken_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultXml:
		return "OpenSecureChannelRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_OpenSecureChannelRequest_Encoding_DefaultBinary:
		return "OpenSecureChannelRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultXml:
		return "OpenSecureChannelResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_OpenSecureChannelResponse_Encoding_DefaultBinary:
		return "OpenSecureChannelResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultXml:
		return "CloseSecureChannelRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CloseSecureChannelRequest_Encoding_DefaultBinary:
		return "CloseSecureChannelRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultXml:
		return "CloseSecureChannelResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CloseSecureChannelResponse_Encoding_DefaultBinary:
		return "CloseSecureChannelResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultXml:
		return "SignatureData_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_SignatureData_Encoding_DefaultBinary:
		return "SignatureData_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultXml:
		return "CreateSessionRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CreateSessionRequest_Encoding_DefaultBinary:
		return "CreateSessionRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultXml:
		return "CreateSessionResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CreateSessionResponse_Encoding_DefaultBinary:
		return "CreateSessionResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultXml:
		return "ActivateSessionRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ActivateSessionRequest_Encoding_DefaultBinary:
		return "ActivateSessionRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultXml:
		return "ActivateSessionResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ActivateSessionResponse_Encoding_DefaultBinary:
		return "ActivateSessionResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultXml:
		return "CloseSessionRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CloseSessionRequest_Encoding_DefaultBinary:
		return "CloseSessionRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultXml:
		return "CloseSessionResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CloseSessionResponse_Encoding_DefaultBinary:
		return "CloseSessionResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultXml:
		return "CancelRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CancelRequest_Encoding_DefaultBinary:
		return "CancelRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultXml:
		return "CancelResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_CancelResponse_Encoding_DefaultBinary:
		return "CancelResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultXml:
		return "AddNodesResult_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AddNodesResult_Encoding_DefaultBinary:
		return "AddNodesResult_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultXml:
		return "AddNodesRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AddNodesRequest_Encoding_DefaultBinary:
		return "AddNodesRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultXml:
		return "AddNodesResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AddNodesResponse_Encoding_DefaultBinary:
		return "AddNodesResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultXml:
		return "AddReferencesRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AddReferencesRequest_Encoding_DefaultBinary:
		return "AddReferencesRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultXml:
		return "AddReferencesResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_AddReferencesResponse_Encoding_DefaultBinary:
		return "AddReferencesResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultXml:
		return "DeleteNodesRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DeleteNodesRequest_Encoding_DefaultBinary:
		return "DeleteNodesRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultXml:
		return "DeleteNodesResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DeleteNodesResponse_Encoding_DefaultBinary:
		return "DeleteNodesResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultXml:
		return "DeleteReferencesRequest_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DeleteReferencesRequest_Encoding_DefaultBinary:
		return "DeleteReferencesRequest_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultXml:
		return "DeleteReferencesResponse_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_DeleteReferencesResponse_Encoding_DefaultBinary:
		return "DeleteReferencesResponse_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultXml:
		return "ViewDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ViewDescription_Encoding_DefaultBinary:
		return "ViewDescription_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultXml:
		return "BrowseDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_BrowseDescription_Encoding_DefaultBinary:
		return "BrowseDescription_Encoding_DefaultBinary"
	case OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultXml:
		return "ReferenceDescription_Encoding_DefaultXml"
	case OpcuaNodeIdServicesObject_ReferenceDescription_Encoding_DefaultBinary:
		return "ReferenceDescription_Encoding_Defau