/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NetworkAddressUrlDataType is the corresponding interface of NetworkAddressUrlDataType
type NetworkAddressUrlDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetNetworkInterface returns NetworkInterface (property field)
	GetNetworkInterface() PascalString
	// GetUrl returns Url (property field)
	GetUrl() PascalString
	// IsNetworkAddressUrlDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNetworkAddressUrlDataType()
	// CreateBuilder creates a NetworkAddressUrlDataTypeBuilder
	CreateNetworkAddressUrlDataTypeBuilder() NetworkAddressUrlDataTypeBuilder
}

// _NetworkAddressUrlDataType is the data-structure of this message
type _NetworkAddressUrlDataType struct {
	ExtensionObjectDefinitionContract
	NetworkInterface PascalString
	Url              PascalString
}

var _ NetworkAddressUrlDataType = (*_NetworkAddressUrlDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_NetworkAddressUrlDataType)(nil)

// NewNetworkAddressUrlDataType factory function for _NetworkAddressUrlDataType
func NewNetworkAddressUrlDataType(networkInterface PascalString, url PascalString) *_NetworkAddressUrlDataType {
	if networkInterface == nil {
		panic("networkInterface of type PascalString for NetworkAddressUrlDataType must not be nil")
	}
	if url == nil {
		panic("url of type PascalString for NetworkAddressUrlDataType must not be nil")
	}
	_result := &_NetworkAddressUrlDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		NetworkInterface:                  networkInterface,
		Url:                               url,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NetworkAddressUrlDataTypeBuilder is a builder for NetworkAddressUrlDataType
type NetworkAddressUrlDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(networkInterface PascalString, url PascalString) NetworkAddressUrlDataTypeBuilder
	// WithNetworkInterface adds NetworkInterface (property field)
	WithNetworkInterface(PascalString) NetworkAddressUrlDataTypeBuilder
	// WithNetworkInterfaceBuilder adds NetworkInterface (property field) which is build by the builder
	WithNetworkInterfaceBuilder(func(PascalStringBuilder) PascalStringBuilder) NetworkAddressUrlDataTypeBuilder
	// WithUrl adds Url (property field)
	WithUrl(PascalString) NetworkAddressUrlDataTypeBuilder
	// WithUrlBuilder adds Url (property field) which is build by the builder
	WithUrlBuilder(func(PascalStringBuilder) PascalStringBuilder) NetworkAddressUrlDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the NetworkAddressUrlDataType or returns an error if something is wrong
	Build() (NetworkAddressUrlDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NetworkAddressUrlDataType
}

// NewNetworkAddressUrlDataTypeBuilder() creates a NetworkAddressUrlDataTypeBuilder
func NewNetworkAddressUrlDataTypeBuilder() NetworkAddressUrlDataTypeBuilder {
	return &_NetworkAddressUrlDataTypeBuilder{_NetworkAddressUrlDataType: new(_NetworkAddressUrlDataType)}
}

type _NetworkAddressUrlDataTypeBuilder struct {
	*_NetworkAddressUrlDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (NetworkAddressUrlDataTypeBuilder) = (*_NetworkAddressUrlDataTypeBuilder)(nil)

func (b *_NetworkAddressUrlDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._NetworkAddressUrlDataType
}

func (b *_NetworkAddressUrlDataTypeBuilder) WithMandatoryFields(networkInterface PascalString, url PascalString) NetworkAddressUrlDataTypeBuilder {
	return b.WithNetworkInterface(networkInterface).WithUrl(url)
}

func (b *_NetworkAddressUrlDataTypeBuilder) WithNetworkInterface(networkInterface PascalString) NetworkAddressUrlDataTypeBuilder {
	b.NetworkInterface = networkInterface
	return b
}

func (b *_NetworkAddressUrlDataTypeBuilder) WithNetworkInterfaceBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) NetworkAddressUrlDataTypeBuilder {
	builder := builderSupplier(b.NetworkInterface.CreatePascalStringBuilder())
	var err error
	b.NetworkInterface, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_NetworkAddressUrlDataTypeBuilder) WithUrl(url PascalString) NetworkAddressUrlDataTypeBuilder {
	b.Url = url
	return b
}

func (b *_NetworkAddressUrlDataTypeBuilder) WithUrlBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) NetworkAddressUrlDataTypeBuilder {
	builder := builderSupplier(b.Url.CreatePascalStringBuilder())
	var err error
	b.Url, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_NetworkAddressUrlDataTypeBuilder) Build() (NetworkAddressUrlDataType, error) {
	if b.NetworkInterface == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'networkInterface' not set"))
	}
	if b.Url == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'url' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._NetworkAddressUrlDataType.deepCopy(), nil
}

func (b *_NetworkAddressUrlDataTypeBuilder) MustBuild() NetworkAddressUrlDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NetworkAddressUrlDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_NetworkAddressUrlDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_NetworkAddressUrlDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateNetworkAddressUrlDataTypeBuilder().(*_NetworkAddressUrlDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateNetworkAddressUrlDataTypeBuilder creates a NetworkAddressUrlDataTypeBuilder
func (b *_NetworkAddressUrlDataType) CreateNetworkAddressUrlDataTypeBuilder() NetworkAddressUrlDataTypeBuilder {
	if b == nil {
		return NewNetworkAddressUrlDataTypeBuilder()
	}
	return &_NetworkAddressUrlDataTypeBuilder{_NetworkAddressUrlDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NetworkAddressUrlDataType) GetExtensionId() int32 {
	return int32(15512)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NetworkAddressUrlDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NetworkAddressUrlDataType) GetNetworkInterface() PascalString {
	return m.NetworkInterface
}

func (m *_NetworkAddressUrlDataType) GetUrl() PascalString {
	return m.Url
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNetworkAddressUrlDataType(structType any) NetworkAddressUrlDataType {
	if casted, ok := structType.(NetworkAddressUrlDataType); ok {
		return casted
	}
	if casted, ok := structType.(*NetworkAddressUrlDataType); ok {
		return *casted
	}
	return nil
}

func (m *_NetworkAddressUrlDataType) GetTypeName() string {
	return "NetworkAddressUrlDataType"
}

func (m *_NetworkAddressUrlDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (networkInterface)
	lengthInBits += m.NetworkInterface.GetLengthInBits(ctx)

	// Simple field (url)
	lengthInBits += m.Url.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_NetworkAddressUrlDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NetworkAddressUrlDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__networkAddressUrlDataType NetworkAddressUrlDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NetworkAddressUrlDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NetworkAddressUrlDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	networkInterface, err := ReadSimpleField[PascalString](ctx, "networkInterface", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkInterface' field"))
	}
	m.NetworkInterface = networkInterface

	url, err := ReadSimpleField[PascalString](ctx, "url", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'url' field"))
	}
	m.Url = url

	if closeErr := readBuffer.CloseContext("NetworkAddressUrlDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NetworkAddressUrlDataType")
	}

	return m, nil
}

func (m *_NetworkAddressUrlDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NetworkAddressUrlDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NetworkAddressUrlDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NetworkAddressUrlDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "networkInterface", m.GetNetworkInterface(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'networkInterface' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "url", m.GetUrl(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'url' field")
		}

		if popErr := writeBuffer.PopContext("NetworkAddressUrlDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NetworkAddressUrlDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NetworkAddressUrlDataType) IsNetworkAddressUrlDataType() {}

func (m *_NetworkAddressUrlDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NetworkAddressUrlDataType) deepCopy() *_NetworkAddressUrlDataType {
	if m == nil {
		return nil
	}
	_NetworkAddressUrlDataTypeCopy := &_NetworkAddressUrlDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.NetworkInterface),
		utils.DeepCopy[PascalString](m.Url),
	}
	_NetworkAddressUrlDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _NetworkAddressUrlDataTypeCopy
}

func (m *_NetworkAddressUrlDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
