/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LogRecordsDataType is the corresponding interface of LogRecordsDataType
type LogRecordsDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetLogRecordArray returns LogRecordArray (property field)
	GetLogRecordArray() []LogRecord
	// IsLogRecordsDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLogRecordsDataType()
	// CreateBuilder creates a LogRecordsDataTypeBuilder
	CreateLogRecordsDataTypeBuilder() LogRecordsDataTypeBuilder
}

// _LogRecordsDataType is the data-structure of this message
type _LogRecordsDataType struct {
	ExtensionObjectDefinitionContract
	LogRecordArray []LogRecord
}

var _ LogRecordsDataType = (*_LogRecordsDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_LogRecordsDataType)(nil)

// NewLogRecordsDataType factory function for _LogRecordsDataType
func NewLogRecordsDataType(logRecordArray []LogRecord) *_LogRecordsDataType {
	_result := &_LogRecordsDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		LogRecordArray:                    logRecordArray,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LogRecordsDataTypeBuilder is a builder for LogRecordsDataType
type LogRecordsDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(logRecordArray []LogRecord) LogRecordsDataTypeBuilder
	// WithLogRecordArray adds LogRecordArray (property field)
	WithLogRecordArray(...LogRecord) LogRecordsDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the LogRecordsDataType or returns an error if something is wrong
	Build() (LogRecordsDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LogRecordsDataType
}

// NewLogRecordsDataTypeBuilder() creates a LogRecordsDataTypeBuilder
func NewLogRecordsDataTypeBuilder() LogRecordsDataTypeBuilder {
	return &_LogRecordsDataTypeBuilder{_LogRecordsDataType: new(_LogRecordsDataType)}
}

type _LogRecordsDataTypeBuilder struct {
	*_LogRecordsDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (LogRecordsDataTypeBuilder) = (*_LogRecordsDataTypeBuilder)(nil)

func (b *_LogRecordsDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._LogRecordsDataType
}

func (b *_LogRecordsDataTypeBuilder) WithMandatoryFields(logRecordArray []LogRecord) LogRecordsDataTypeBuilder {
	return b.WithLogRecordArray(logRecordArray...)
}

func (b *_LogRecordsDataTypeBuilder) WithLogRecordArray(logRecordArray ...LogRecord) LogRecordsDataTypeBuilder {
	b.LogRecordArray = logRecordArray
	return b
}

func (b *_LogRecordsDataTypeBuilder) Build() (LogRecordsDataType, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._LogRecordsDataType.deepCopy(), nil
}

func (b *_LogRecordsDataTypeBuilder) MustBuild() LogRecordsDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LogRecordsDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_LogRecordsDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_LogRecordsDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateLogRecordsDataTypeBuilder().(*_LogRecordsDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateLogRecordsDataTypeBuilder creates a LogRecordsDataTypeBuilder
func (b *_LogRecordsDataType) CreateLogRecordsDataTypeBuilder() LogRecordsDataTypeBuilder {
	if b == nil {
		return NewLogRecordsDataTypeBuilder()
	}
	return &_LogRecordsDataTypeBuilder{_LogRecordsDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LogRecordsDataType) GetExtensionId() int32 {
	return int32(19747)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LogRecordsDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LogRecordsDataType) GetLogRecordArray() []LogRecord {
	return m.LogRecordArray
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLogRecordsDataType(structType any) LogRecordsDataType {
	if casted, ok := structType.(LogRecordsDataType); ok {
		return casted
	}
	if casted, ok := structType.(*LogRecordsDataType); ok {
		return *casted
	}
	return nil
}

func (m *_LogRecordsDataType) GetTypeName() string {
	return "LogRecordsDataType"
}

func (m *_LogRecordsDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Implicit Field (noOfLogRecordArray)
	lengthInBits += 32

	// Array field
	if len(m.LogRecordArray) > 0 {
		for _curItem, element := range m.LogRecordArray {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.LogRecordArray), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_LogRecordsDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LogRecordsDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__logRecordsDataType LogRecordsDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LogRecordsDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LogRecordsDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	noOfLogRecordArray, err := ReadImplicitField[int32](ctx, "noOfLogRecordArray", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfLogRecordArray' field"))
	}
	_ = noOfLogRecordArray

	logRecordArray, err := ReadCountArrayField[LogRecord](ctx, "logRecordArray", ReadComplex[LogRecord](ExtensionObjectDefinitionParseWithBufferProducer[LogRecord]((int32)(int32(19363))), readBuffer), uint64(noOfLogRecordArray))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'logRecordArray' field"))
	}
	m.LogRecordArray = logRecordArray

	if closeErr := readBuffer.CloseContext("LogRecordsDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LogRecordsDataType")
	}

	return m, nil
}

func (m *_LogRecordsDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LogRecordsDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LogRecordsDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LogRecordsDataType")
		}
		noOfLogRecordArray := int32(utils.InlineIf(bool((m.GetLogRecordArray()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetLogRecordArray()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfLogRecordArray", noOfLogRecordArray, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfLogRecordArray' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "logRecordArray", m.GetLogRecordArray(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'logRecordArray' field")
		}

		if popErr := writeBuffer.PopContext("LogRecordsDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LogRecordsDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LogRecordsDataType) IsLogRecordsDataType() {}

func (m *_LogRecordsDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LogRecordsDataType) deepCopy() *_LogRecordsDataType {
	if m == nil {
		return nil
	}
	_LogRecordsDataTypeCopy := &_LogRecordsDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopySlice[LogRecord, LogRecord](m.LogRecordArray),
	}
	_LogRecordsDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _LogRecordsDataTypeCopy
}

func (m *_LogRecordsDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
