/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// KeyValuePair is the corresponding interface of KeyValuePair
type KeyValuePair interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetKey returns Key (property field)
	GetKey() QualifiedName
	// GetValue returns Value (property field)
	GetValue() Variant
	// IsKeyValuePair is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsKeyValuePair()
	// CreateBuilder creates a KeyValuePairBuilder
	CreateKeyValuePairBuilder() KeyValuePairBuilder
}

// _KeyValuePair is the data-structure of this message
type _KeyValuePair struct {
	ExtensionObjectDefinitionContract
	Key   QualifiedName
	Value Variant
}

var _ KeyValuePair = (*_KeyValuePair)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_KeyValuePair)(nil)

// NewKeyValuePair factory function for _KeyValuePair
func NewKeyValuePair(key QualifiedName, value Variant) *_KeyValuePair {
	if key == nil {
		panic("key of type QualifiedName for KeyValuePair must not be nil")
	}
	if value == nil {
		panic("value of type Variant for KeyValuePair must not be nil")
	}
	_result := &_KeyValuePair{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Key:                               key,
		Value:                             value,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// KeyValuePairBuilder is a builder for KeyValuePair
type KeyValuePairBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(key QualifiedName, value Variant) KeyValuePairBuilder
	// WithKey adds Key (property field)
	WithKey(QualifiedName) KeyValuePairBuilder
	// WithKeyBuilder adds Key (property field) which is build by the builder
	WithKeyBuilder(func(QualifiedNameBuilder) QualifiedNameBuilder) KeyValuePairBuilder
	// WithValue adds Value (property field)
	WithValue(Variant) KeyValuePairBuilder
	// WithValueBuilder adds Value (property field) which is build by the builder
	WithValueBuilder(func(VariantBuilder) VariantBuilder) KeyValuePairBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the KeyValuePair or returns an error if something is wrong
	Build() (KeyValuePair, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() KeyValuePair
}

// NewKeyValuePairBuilder() creates a KeyValuePairBuilder
func NewKeyValuePairBuilder() KeyValuePairBuilder {
	return &_KeyValuePairBuilder{_KeyValuePair: new(_KeyValuePair)}
}

type _KeyValuePairBuilder struct {
	*_KeyValuePair

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (KeyValuePairBuilder) = (*_KeyValuePairBuilder)(nil)

func (b *_KeyValuePairBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._KeyValuePair
}

func (b *_KeyValuePairBuilder) WithMandatoryFields(key QualifiedName, value Variant) KeyValuePairBuilder {
	return b.WithKey(key).WithValue(value)
}

func (b *_KeyValuePairBuilder) WithKey(key QualifiedName) KeyValuePairBuilder {
	b.Key = key
	return b
}

func (b *_KeyValuePairBuilder) WithKeyBuilder(builderSupplier func(QualifiedNameBuilder) QualifiedNameBuilder) KeyValuePairBuilder {
	builder := builderSupplier(b.Key.CreateQualifiedNameBuilder())
	var err error
	b.Key, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "QualifiedNameBuilder failed"))
	}
	return b
}

func (b *_KeyValuePairBuilder) WithValue(value Variant) KeyValuePairBuilder {
	b.Value = value
	return b
}

func (b *_KeyValuePairBuilder) WithValueBuilder(builderSupplier func(VariantBuilder) VariantBuilder) KeyValuePairBuilder {
	builder := builderSupplier(b.Value.CreateVariantBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_KeyValuePairBuilder) Build() (KeyValuePair, error) {
	if b.Key == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'key' not set"))
	}
	if b.Value == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'value' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._KeyValuePair.deepCopy(), nil
}

func (b *_KeyValuePairBuilder) MustBuild() KeyValuePair {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_KeyValuePairBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_KeyValuePairBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_KeyValuePairBuilder) DeepCopy() any {
	_copy := b.CreateKeyValuePairBuilder().(*_KeyValuePairBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateKeyValuePairBuilder creates a KeyValuePairBuilder
func (b *_KeyValuePair) CreateKeyValuePairBuilder() KeyValuePairBuilder {
	if b == nil {
		return NewKeyValuePairBuilder()
	}
	return &_KeyValuePairBuilder{_KeyValuePair: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_KeyValuePair) GetExtensionId() int32 {
	return int32(14535)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_KeyValuePair) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_KeyValuePair) GetKey() QualifiedName {
	return m.Key
}

func (m *_KeyValuePair) GetValue() Variant {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastKeyValuePair(structType any) KeyValuePair {
	if casted, ok := structType.(KeyValuePair); ok {
		return casted
	}
	if casted, ok := structType.(*KeyValuePair); ok {
		return *casted
	}
	return nil
}

func (m *_KeyValuePair) GetTypeName() string {
	return "KeyValuePair"
}

func (m *_KeyValuePair) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (key)
	lengthInBits += m.Key.GetLengthInBits(ctx)

	// Simple field (value)
	lengthInBits += m.Value.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_KeyValuePair) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_KeyValuePair) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__keyValuePair KeyValuePair, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("KeyValuePair"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for KeyValuePair")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	key, err := ReadSimpleField[QualifiedName](ctx, "key", ReadComplex[QualifiedName](QualifiedNameParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'key' field"))
	}
	m.Key = key

	value, err := ReadSimpleField[Variant](ctx, "value", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("KeyValuePair"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for KeyValuePair")
	}

	return m, nil
}

func (m *_KeyValuePair) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_KeyValuePair) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("KeyValuePair"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for KeyValuePair")
		}

		if err := WriteSimpleField[QualifiedName](ctx, "key", m.GetKey(), WriteComplex[QualifiedName](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'key' field")
		}

		if err := WriteSimpleField[Variant](ctx, "value", m.GetValue(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'value' field")
		}

		if popErr := writeBuffer.PopContext("KeyValuePair"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for KeyValuePair")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_KeyValuePair) IsKeyValuePair() {}

func (m *_KeyValuePair) DeepCopy() any {
	return m.deepCopy()
}

func (m *_KeyValuePair) deepCopy() *_KeyValuePair {
	if m == nil {
		return nil
	}
	_KeyValuePairCopy := &_KeyValuePair{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[QualifiedName](m.Key),
		utils.DeepCopy[Variant](m.Value),
	}
	_KeyValuePairCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _KeyValuePairCopy
}

func (m *_KeyValuePair) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
