/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonDataSetMessage is the corresponding interface of JsonDataSetMessage
type JsonDataSetMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetDataSetWriterId returns DataSetWriterId (property field)
	GetDataSetWriterId() uint16
	// GetDataSetWriterName returns DataSetWriterName (property field)
	GetDataSetWriterName() PascalString
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() PascalString
	// GetWriterGroupName returns WriterGroupName (property field)
	GetWriterGroupName() PascalString
	// GetSequenceNumber returns SequenceNumber (property field)
	GetSequenceNumber() uint32
	// GetMetaDataVersion returns MetaDataVersion (property field)
	GetMetaDataVersion() ConfigurationVersionDataType
	// GetMinorVersion returns MinorVersion (property field)
	GetMinorVersion() uint32
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetStatus returns Status (property field)
	GetStatus() StatusCode
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetPayload returns Payload (property field)
	GetPayload() ExtensionObject
	// IsJsonDataSetMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonDataSetMessage()
	// CreateBuilder creates a JsonDataSetMessageBuilder
	CreateJsonDataSetMessageBuilder() JsonDataSetMessageBuilder
}

// _JsonDataSetMessage is the data-structure of this message
type _JsonDataSetMessage struct {
	ExtensionObjectDefinitionContract
	DataSetWriterId   uint16
	DataSetWriterName PascalString
	PublisherId       PascalString
	WriterGroupName   PascalString
	SequenceNumber    uint32
	MetaDataVersion   ConfigurationVersionDataType
	MinorVersion      uint32
	Timestamp         int64
	Status            StatusCode
	MessageType       PascalString
	Payload           ExtensionObject
}

var _ JsonDataSetMessage = (*_JsonDataSetMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonDataSetMessage)(nil)

// NewJsonDataSetMessage factory function for _JsonDataSetMessage
func NewJsonDataSetMessage(dataSetWriterId uint16, dataSetWriterName PascalString, publisherId PascalString, writerGroupName PascalString, sequenceNumber uint32, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, status StatusCode, messageType PascalString, payload ExtensionObject) *_JsonDataSetMessage {
	if dataSetWriterName == nil {
		panic("dataSetWriterName of type PascalString for JsonDataSetMessage must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type PascalString for JsonDataSetMessage must not be nil")
	}
	if writerGroupName == nil {
		panic("writerGroupName of type PascalString for JsonDataSetMessage must not be nil")
	}
	if metaDataVersion == nil {
		panic("metaDataVersion of type ConfigurationVersionDataType for JsonDataSetMessage must not be nil")
	}
	if status == nil {
		panic("status of type StatusCode for JsonDataSetMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonDataSetMessage must not be nil")
	}
	if payload == nil {
		panic("payload of type ExtensionObject for JsonDataSetMessage must not be nil")
	}
	_result := &_JsonDataSetMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		DataSetWriterId:                   dataSetWriterId,
		DataSetWriterName:                 dataSetWriterName,
		PublisherId:                       publisherId,
		WriterGroupName:                   writerGroupName,
		SequenceNumber:                    sequenceNumber,
		MetaDataVersion:                   metaDataVersion,
		MinorVersion:                      minorVersion,
		Timestamp:                         timestamp,
		Status:                            status,
		MessageType:                       messageType,
		Payload:                           payload,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonDataSetMessageBuilder is a builder for JsonDataSetMessage
type JsonDataSetMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataSetWriterId uint16, dataSetWriterName PascalString, publisherId PascalString, writerGroupName PascalString, sequenceNumber uint32, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, status StatusCode, messageType PascalString, payload ExtensionObject) JsonDataSetMessageBuilder
	// WithDataSetWriterId adds DataSetWriterId (property field)
	WithDataSetWriterId(uint16) JsonDataSetMessageBuilder
	// WithDataSetWriterName adds DataSetWriterName (property field)
	WithDataSetWriterName(PascalString) JsonDataSetMessageBuilder
	// WithDataSetWriterNameBuilder adds DataSetWriterName (property field) which is build by the builder
	WithDataSetWriterNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMessageBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(PascalString) JsonDataSetMessageBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMessageBuilder
	// WithWriterGroupName adds WriterGroupName (property field)
	WithWriterGroupName(PascalString) JsonDataSetMessageBuilder
	// WithWriterGroupNameBuilder adds WriterGroupName (property field) which is build by the builder
	WithWriterGroupNameBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMessageBuilder
	// WithSequenceNumber adds SequenceNumber (property field)
	WithSequenceNumber(uint32) JsonDataSetMessageBuilder
	// WithMetaDataVersion adds MetaDataVersion (property field)
	WithMetaDataVersion(ConfigurationVersionDataType) JsonDataSetMessageBuilder
	// WithMetaDataVersionBuilder adds MetaDataVersion (property field) which is build by the builder
	WithMetaDataVersionBuilder(func(ConfigurationVersionDataTypeBuilder) ConfigurationVersionDataTypeBuilder) JsonDataSetMessageBuilder
	// WithMinorVersion adds MinorVersion (property field)
	WithMinorVersion(uint32) JsonDataSetMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonDataSetMessageBuilder
	// WithStatus adds Status (property field)
	WithStatus(StatusCode) JsonDataSetMessageBuilder
	// WithStatusBuilder adds Status (property field) which is build by the builder
	WithStatusBuilder(func(StatusCodeBuilder) StatusCodeBuilder) JsonDataSetMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonDataSetMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMessageBuilder
	// WithPayload adds Payload (property field)
	WithPayload(ExtensionObject) JsonDataSetMessageBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) JsonDataSetMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonDataSetMessage or returns an error if something is wrong
	Build() (JsonDataSetMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonDataSetMessage
}

// NewJsonDataSetMessageBuilder() creates a JsonDataSetMessageBuilder
func NewJsonDataSetMessageBuilder() JsonDataSetMessageBuilder {
	return &_JsonDataSetMessageBuilder{_JsonDataSetMessage: new(_JsonDataSetMessage)}
}

type _JsonDataSetMessageBuilder struct {
	*_JsonDataSetMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (JsonDataSetMessageBuilder) = (*_JsonDataSetMessageBuilder)(nil)

func (b *_JsonDataSetMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonDataSetMessage
}

func (b *_JsonDataSetMessageBuilder) WithMandatoryFields(dataSetWriterId uint16, dataSetWriterName PascalString, publisherId PascalString, writerGroupName PascalString, sequenceNumber uint32, metaDataVersion ConfigurationVersionDataType, minorVersion uint32, timestamp int64, status StatusCode, messageType PascalString, payload ExtensionObject) JsonDataSetMessageBuilder {
	return b.WithDataSetWriterId(dataSetWriterId).WithDataSetWriterName(dataSetWriterName).WithPublisherId(publisherId).WithWriterGroupName(writerGroupName).WithSequenceNumber(sequenceNumber).WithMetaDataVersion(metaDataVersion).WithMinorVersion(minorVersion).WithTimestamp(timestamp).WithStatus(status).WithMessageType(messageType).WithPayload(payload)
}

func (b *_JsonDataSetMessageBuilder) WithDataSetWriterId(dataSetWriterId uint16) JsonDataSetMessageBuilder {
	b.DataSetWriterId = dataSetWriterId
	return b
}

func (b *_JsonDataSetMessageBuilder) WithDataSetWriterName(dataSetWriterName PascalString) JsonDataSetMessageBuilder {
	b.DataSetWriterName = dataSetWriterName
	return b
}

func (b *_JsonDataSetMessageBuilder) WithDataSetWriterNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMessageBuilder {
	builder := builderSupplier(b.DataSetWriterName.CreatePascalStringBuilder())
	var err error
	b.DataSetWriterName, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMessageBuilder) WithPublisherId(publisherId PascalString) JsonDataSetMessageBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_JsonDataSetMessageBuilder) WithPublisherIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMessageBuilder {
	builder := builderSupplier(b.PublisherId.CreatePascalStringBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMessageBuilder) WithWriterGroupName(writerGroupName PascalString) JsonDataSetMessageBuilder {
	b.WriterGroupName = writerGroupName
	return b
}

func (b *_JsonDataSetMessageBuilder) WithWriterGroupNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMessageBuilder {
	builder := builderSupplier(b.WriterGroupName.CreatePascalStringBuilder())
	var err error
	b.WriterGroupName, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMessageBuilder) WithSequenceNumber(sequenceNumber uint32) JsonDataSetMessageBuilder {
	b.SequenceNumber = sequenceNumber
	return b
}

func (b *_JsonDataSetMessageBuilder) WithMetaDataVersion(metaDataVersion ConfigurationVersionDataType) JsonDataSetMessageBuilder {
	b.MetaDataVersion = metaDataVersion
	return b
}

func (b *_JsonDataSetMessageBuilder) WithMetaDataVersionBuilder(builderSupplier func(ConfigurationVersionDataTypeBuilder) ConfigurationVersionDataTypeBuilder) JsonDataSetMessageBuilder {
	builder := builderSupplier(b.MetaDataVersion.CreateConfigurationVersionDataTypeBuilder())
	var err error
	b.MetaDataVersion, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ConfigurationVersionDataTypeBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMessageBuilder) WithMinorVersion(minorVersion uint32) JsonDataSetMessageBuilder {
	b.MinorVersion = minorVersion
	return b
}

func (b *_JsonDataSetMessageBuilder) WithTimestamp(timestamp int64) JsonDataSetMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonDataSetMessageBuilder) WithStatus(status StatusCode) JsonDataSetMessageBuilder {
	b.Status = status
	return b
}

func (b *_JsonDataSetMessageBuilder) WithStatusBuilder(builderSupplier func(StatusCodeBuilder) StatusCodeBuilder) JsonDataSetMessageBuilder {
	builder := builderSupplier(b.Status.CreateStatusCodeBuilder())
	var err error
	b.Status, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "StatusCodeBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMessageBuilder) WithMessageType(messageType PascalString) JsonDataSetMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonDataSetMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonDataSetMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMessageBuilder) WithPayload(payload ExtensionObject) JsonDataSetMessageBuilder {
	b.Payload = payload
	return b
}

func (b *_JsonDataSetMessageBuilder) WithPayloadBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) JsonDataSetMessageBuilder {
	builder := builderSupplier(b.Payload.CreateExtensionObjectBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_JsonDataSetMessageBuilder) Build() (JsonDataSetMessage, error) {
	if b.DataSetWriterName == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dataSetWriterName' not set"))
	}
	if b.PublisherId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'publisherId' not set"))
	}
	if b.WriterGroupName == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'writerGroupName' not set"))
	}
	if b.MetaDataVersion == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'metaDataVersion' not set"))
	}
	if b.Status == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'status' not set"))
	}
	if b.MessageType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageType' not set"))
	}
	if b.Payload == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'payload' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._JsonDataSetMessage.deepCopy(), nil
}

func (b *_JsonDataSetMessageBuilder) MustBuild() JsonDataSetMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonDataSetMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonDataSetMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonDataSetMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonDataSetMessageBuilder().(*_JsonDataSetMessageBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateJsonDataSetMessageBuilder creates a JsonDataSetMessageBuilder
func (b *_JsonDataSetMessage) CreateJsonDataSetMessageBuilder() JsonDataSetMessageBuilder {
	if b == nil {
		return NewJsonDataSetMessageBuilder()
	}
	return &_JsonDataSetMessageBuilder{_JsonDataSetMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonDataSetMessage) GetExtensionId() int32 {
	return int32(19314)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonDataSetMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonDataSetMessage) GetDataSetWriterId() uint16 {
	return m.DataSetWriterId
}

func (m *_JsonDataSetMessage) GetDataSetWriterName() PascalString {
	return m.DataSetWriterName
}

func (m *_JsonDataSetMessage) GetPublisherId() PascalString {
	return m.PublisherId
}

func (m *_JsonDataSetMessage) GetWriterGroupName() PascalString {
	return m.WriterGroupName
}

func (m *_JsonDataSetMessage) GetSequenceNumber() uint32 {
	return m.SequenceNumber
}

func (m *_JsonDataSetMessage) GetMetaDataVersion() ConfigurationVersionDataType {
	return m.MetaDataVersion
}

func (m *_JsonDataSetMessage) GetMinorVersion() uint32 {
	return m.MinorVersion
}

func (m *_JsonDataSetMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonDataSetMessage) GetStatus() StatusCode {
	return m.Status
}

func (m *_JsonDataSetMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonDataSetMessage) GetPayload() ExtensionObject {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonDataSetMessage(structType any) JsonDataSetMessage {
	if casted, ok := structType.(JsonDataSetMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonDataSetMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonDataSetMessage) GetTypeName() string {
	return "JsonDataSetMessage"
}

func (m *_JsonDataSetMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (dataSetWriterId)
	lengthInBits += 16

	// Simple field (dataSetWriterName)
	lengthInBits += m.DataSetWriterName.GetLengthInBits(ctx)

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (writerGroupName)
	lengthInBits += m.WriterGroupName.GetLengthInBits(ctx)

	// Simple field (sequenceNumber)
	lengthInBits += 32

	// Simple field (metaDataVersion)
	lengthInBits += m.MetaDataVersion.GetLengthInBits(ctx)

	// Simple field (minorVersion)
	lengthInBits += 32

	// Simple field (timestamp)
	lengthInBits += 64

	// Simple field (status)
	lengthInBits += m.Status.GetLengthInBits(ctx)

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_JsonDataSetMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonDataSetMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonDataSetMessage JsonDataSetMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonDataSetMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonDataSetMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataSetWriterId, err := ReadSimpleField(ctx, "dataSetWriterId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterId' field"))
	}
	m.DataSetWriterId = dataSetWriterId

	dataSetWriterName, err := ReadSimpleField[PascalString](ctx, "dataSetWriterName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterName' field"))
	}
	m.DataSetWriterName = dataSetWriterName

	publisherId, err := ReadSimpleField[PascalString](ctx, "publisherId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	writerGroupName, err := ReadSimpleField[PascalString](ctx, "writerGroupName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writerGroupName' field"))
	}
	m.WriterGroupName = writerGroupName

	sequenceNumber, err := ReadSimpleField(ctx, "sequenceNumber", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sequenceNumber' field"))
	}
	m.SequenceNumber = sequenceNumber

	metaDataVersion, err := ReadSimpleField[ConfigurationVersionDataType](ctx, "metaDataVersion", ReadComplex[ConfigurationVersionDataType](ExtensionObjectDefinitionParseWithBufferProducer[ConfigurationVersionDataType]((int32)(int32(14595))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'metaDataVersion' field"))
	}
	m.MetaDataVersion = metaDataVersion

	minorVersion, err := ReadSimpleField(ctx, "minorVersion", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'minorVersion' field"))
	}
	m.MinorVersion = minorVersion

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	status, err := ReadSimpleField[StatusCode](ctx, "status", ReadComplex[StatusCode](StatusCodeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'status' field"))
	}
	m.Status = status

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	payload, err := ReadSimpleField[ExtensionObject](ctx, "payload", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	if closeErr := readBuffer.CloseContext("JsonDataSetMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonDataSetMessage")
	}

	return m, nil
}

func (m *_JsonDataSetMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonDataSetMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonDataSetMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonDataSetMessage")
		}

		if err := WriteSimpleField[uint16](ctx, "dataSetWriterId", m.GetDataSetWriterId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "dataSetWriterName", m.GetDataSetWriterName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterName' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "publisherId", m.GetPublisherId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "writerGroupName", m.GetWriterGroupName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'writerGroupName' field")
		}

		if err := WriteSimpleField[uint32](ctx, "sequenceNumber", m.GetSequenceNumber(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'sequenceNumber' field")
		}

		if err := WriteSimpleField[ConfigurationVersionDataType](ctx, "metaDataVersion", m.GetMetaDataVersion(), WriteComplex[ConfigurationVersionDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'metaDataVersion' field")
		}

		if err := WriteSimpleField[uint32](ctx, "minorVersion", m.GetMinorVersion(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'minorVersion' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[StatusCode](ctx, "status", m.GetStatus(), WriteComplex[StatusCode](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'status' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "payload", m.GetPayload(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}

		if popErr := writeBuffer.PopContext("JsonDataSetMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonDataSetMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonDataSetMessage) IsJsonDataSetMessage() {}

func (m *_JsonDataSetMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonDataSetMessage) deepCopy() *_JsonDataSetMessage {
	if m == nil {
		return nil
	}
	_JsonDataSetMessageCopy := &_JsonDataSetMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.DataSetWriterId,
		utils.DeepCopy[PascalString](m.DataSetWriterName),
		utils.DeepCopy[PascalString](m.PublisherId),
		utils.DeepCopy[PascalString](m.WriterGroupName),
		m.SequenceNumber,
		utils.DeepCopy[ConfigurationVersionDataType](m.MetaDataVersion),
		m.MinorVersion,
		m.Timestamp,
		utils.DeepCopy[StatusCode](m.Status),
		utils.DeepCopy[PascalString](m.MessageType),
		utils.DeepCopy[ExtensionObject](m.Payload),
	}
	_JsonDataSetMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonDataSetMessageCopy
}

func (m *_JsonDataSetMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
