/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonActionResponderMessage is the corresponding interface of JsonActionResponderMessage
type JsonActionResponderMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetMessageId returns MessageId (property field)
	GetMessageId() PascalString
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() PascalString
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetConnection returns Connection (property field)
	GetConnection() PubSubConnectionDataType
	// IsJsonActionResponderMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonActionResponderMessage()
	// CreateBuilder creates a JsonActionResponderMessageBuilder
	CreateJsonActionResponderMessageBuilder() JsonActionResponderMessageBuilder
}

// _JsonActionResponderMessage is the data-structure of this message
type _JsonActionResponderMessage struct {
	ExtensionObjectDefinitionContract
	MessageId   PascalString
	MessageType PascalString
	PublisherId PascalString
	Timestamp   int64
	Connection  PubSubConnectionDataType
}

var _ JsonActionResponderMessage = (*_JsonActionResponderMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonActionResponderMessage)(nil)

// NewJsonActionResponderMessage factory function for _JsonActionResponderMessage
func NewJsonActionResponderMessage(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, connection PubSubConnectionDataType) *_JsonActionResponderMessage {
	if messageId == nil {
		panic("messageId of type PascalString for JsonActionResponderMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonActionResponderMessage must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type PascalString for JsonActionResponderMessage must not be nil")
	}
	if connection == nil {
		panic("connection of type PubSubConnectionDataType for JsonActionResponderMessage must not be nil")
	}
	_result := &_JsonActionResponderMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		MessageId:                         messageId,
		MessageType:                       messageType,
		PublisherId:                       publisherId,
		Timestamp:                         timestamp,
		Connection:                        connection,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonActionResponderMessageBuilder is a builder for JsonActionResponderMessage
type JsonActionResponderMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, connection PubSubConnectionDataType) JsonActionResponderMessageBuilder
	// WithMessageId adds MessageId (property field)
	WithMessageId(PascalString) JsonActionResponderMessageBuilder
	// WithMessageIdBuilder adds MessageId (property field) which is build by the builder
	WithMessageIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionResponderMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonActionResponderMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionResponderMessageBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(PascalString) JsonActionResponderMessageBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionResponderMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonActionResponderMessageBuilder
	// WithConnection adds Connection (property field)
	WithConnection(PubSubConnectionDataType) JsonActionResponderMessageBuilder
	// WithConnectionBuilder adds Connection (property field) which is build by the builder
	WithConnectionBuilder(func(PubSubConnectionDataTypeBuilder) PubSubConnectionDataTypeBuilder) JsonActionResponderMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonActionResponderMessage or returns an error if something is wrong
	Build() (JsonActionResponderMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonActionResponderMessage
}

// NewJsonActionResponderMessageBuilder() creates a JsonActionResponderMessageBuilder
func NewJsonActionResponderMessageBuilder() JsonActionResponderMessageBuilder {
	return &_JsonActionResponderMessageBuilder{_JsonActionResponderMessage: new(_JsonActionResponderMessage)}
}

type _JsonActionResponderMessageBuilder struct {
	*_JsonActionResponderMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (JsonActionResponderMessageBuilder) = (*_JsonActionResponderMessageBuilder)(nil)

func (b *_JsonActionResponderMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonActionResponderMessage
}

func (b *_JsonActionResponderMessageBuilder) WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, connection PubSubConnectionDataType) JsonActionResponderMessageBuilder {
	return b.WithMessageId(messageId).WithMessageType(messageType).WithPublisherId(publisherId).WithTimestamp(timestamp).WithConnection(connection)
}

func (b *_JsonActionResponderMessageBuilder) WithMessageId(messageId PascalString) JsonActionResponderMessageBuilder {
	b.MessageId = messageId
	return b
}

func (b *_JsonActionResponderMessageBuilder) WithMessageIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionResponderMessageBuilder {
	builder := builderSupplier(b.MessageId.CreatePascalStringBuilder())
	var err error
	b.MessageId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponderMessageBuilder) WithMessageType(messageType PascalString) JsonActionResponderMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonActionResponderMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionResponderMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponderMessageBuilder) WithPublisherId(publisherId PascalString) JsonActionResponderMessageBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_JsonActionResponderMessageBuilder) WithPublisherIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionResponderMessageBuilder {
	builder := builderSupplier(b.PublisherId.CreatePascalStringBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponderMessageBuilder) WithTimestamp(timestamp int64) JsonActionResponderMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonActionResponderMessageBuilder) WithConnection(connection PubSubConnectionDataType) JsonActionResponderMessageBuilder {
	b.Connection = connection
	return b
}

func (b *_JsonActionResponderMessageBuilder) WithConnectionBuilder(builderSupplier func(PubSubConnectionDataTypeBuilder) PubSubConnectionDataTypeBuilder) JsonActionResponderMessageBuilder {
	builder := builderSupplier(b.Connection.CreatePubSubConnectionDataTypeBuilder())
	var err error
	b.Connection, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PubSubConnectionDataTypeBuilder failed"))
	}
	return b
}

func (b *_JsonActionResponderMessageBuilder) Build() (JsonActionResponderMessage, error) {
	if b.MessageId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageId' not set"))
	}
	if b.MessageType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageType' not set"))
	}
	if b.PublisherId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'publisherId' not set"))
	}
	if b.Connection == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'connection' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._JsonActionResponderMessage.deepCopy(), nil
}

func (b *_JsonActionResponderMessageBuilder) MustBuild() JsonActionResponderMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonActionResponderMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonActionResponderMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonActionResponderMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonActionResponderMessageBuilder().(*_JsonActionResponderMessageBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateJsonActionResponderMessageBuilder creates a JsonActionResponderMessageBuilder
func (b *_JsonActionResponderMessage) CreateJsonActionResponderMessageBuilder() JsonActionResponderMessageBuilder {
	if b == nil {
		return NewJsonActionResponderMessageBuilder()
	}
	return &_JsonActionResponderMessageBuilder{_JsonActionResponderMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonActionResponderMessage) GetExtensionId() int32 {
	return int32(19321)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonActionResponderMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonActionResponderMessage) GetMessageId() PascalString {
	return m.MessageId
}

func (m *_JsonActionResponderMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonActionResponderMessage) GetPublisherId() PascalString {
	return m.PublisherId
}

func (m *_JsonActionResponderMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonActionResponderMessage) GetConnection() PubSubConnectionDataType {
	return m.Connection
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonActionResponderMessage(structType any) JsonActionResponderMessage {
	if casted, ok := structType.(JsonActionResponderMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonActionResponderMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonActionResponderMessage) GetTypeName() string {
	return "JsonActionResponderMessage"
}

func (m *_JsonActionResponderMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (messageId)
	lengthInBits += m.MessageId.GetLengthInBits(ctx)

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += 64

	// Simple field (connection)
	lengthInBits += m.Connection.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_JsonActionResponderMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonActionResponderMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonActionResponderMessage JsonActionResponderMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonActionResponderMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonActionResponderMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	messageId, err := ReadSimpleField[PascalString](ctx, "messageId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageId' field"))
	}
	m.MessageId = messageId

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	publisherId, err := ReadSimpleField[PascalString](ctx, "publisherId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	connection, err := ReadSimpleField[PubSubConnectionDataType](ctx, "connection", ReadComplex[PubSubConnectionDataType](ExtensionObjectDefinitionParseWithBufferProducer[PubSubConnectionDataType]((int32)(int32(15619))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'connection' field"))
	}
	m.Connection = connection

	if closeErr := readBuffer.CloseContext("JsonActionResponderMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonActionResponderMessage")
	}

	return m, nil
}

func (m *_JsonActionResponderMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonActionResponderMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonActionResponderMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonActionResponderMessage")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageId", m.GetMessageId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "publisherId", m.GetPublisherId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[PubSubConnectionDataType](ctx, "connection", m.GetConnection(), WriteComplex[PubSubConnectionDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'connection' field")
		}

		if popErr := writeBuffer.PopContext("JsonActionResponderMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonActionResponderMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonActionResponderMessage) IsJsonActionResponderMessage() {}

func (m *_JsonActionResponderMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonActionResponderMessage) deepCopy() *_JsonActionResponderMessage {
	if m == nil {
		return nil
	}
	_JsonActionResponderMessageCopy := &_JsonActionResponderMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.MessageId),
		utils.DeepCopy[PascalString](m.MessageType),
		utils.DeepCopy[PascalString](m.PublisherId),
		m.Timestamp,
		utils.DeepCopy[PubSubConnectionDataType](m.Connection),
	}
	_JsonActionResponderMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonActionResponderMessageCopy
}

func (m *_JsonActionResponderMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
