/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// JsonActionNetworkMessage is the corresponding interface of JsonActionNetworkMessage
type JsonActionNetworkMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetMessageId returns MessageId (property field)
	GetMessageId() PascalString
	// GetMessageType returns MessageType (property field)
	GetMessageType() PascalString
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() PascalString
	// GetTimestamp returns Timestamp (property field)
	GetTimestamp() int64
	// GetResponseAddress returns ResponseAddress (property field)
	GetResponseAddress() PascalString
	// GetCorrelationData returns CorrelationData (property field)
	GetCorrelationData() PascalByteString
	// GetRequestorId returns RequestorId (property field)
	GetRequestorId() PascalString
	// GetTimeoutHint returns TimeoutHint (property field)
	GetTimeoutHint() float64
	// GetMessages returns Messages (property field)
	GetMessages() []ExtensionObject
	// IsJsonActionNetworkMessage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsJsonActionNetworkMessage()
	// CreateBuilder creates a JsonActionNetworkMessageBuilder
	CreateJsonActionNetworkMessageBuilder() JsonActionNetworkMessageBuilder
}

// _JsonActionNetworkMessage is the data-structure of this message
type _JsonActionNetworkMessage struct {
	ExtensionObjectDefinitionContract
	MessageId       PascalString
	MessageType     PascalString
	PublisherId     PascalString
	Timestamp       int64
	ResponseAddress PascalString
	CorrelationData PascalByteString
	RequestorId     PascalString
	TimeoutHint     float64
	Messages        []ExtensionObject
}

var _ JsonActionNetworkMessage = (*_JsonActionNetworkMessage)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_JsonActionNetworkMessage)(nil)

// NewJsonActionNetworkMessage factory function for _JsonActionNetworkMessage
func NewJsonActionNetworkMessage(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, responseAddress PascalString, correlationData PascalByteString, requestorId PascalString, timeoutHint float64, messages []ExtensionObject) *_JsonActionNetworkMessage {
	if messageId == nil {
		panic("messageId of type PascalString for JsonActionNetworkMessage must not be nil")
	}
	if messageType == nil {
		panic("messageType of type PascalString for JsonActionNetworkMessage must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type PascalString for JsonActionNetworkMessage must not be nil")
	}
	if responseAddress == nil {
		panic("responseAddress of type PascalString for JsonActionNetworkMessage must not be nil")
	}
	if correlationData == nil {
		panic("correlationData of type PascalByteString for JsonActionNetworkMessage must not be nil")
	}
	if requestorId == nil {
		panic("requestorId of type PascalString for JsonActionNetworkMessage must not be nil")
	}
	_result := &_JsonActionNetworkMessage{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		MessageId:                         messageId,
		MessageType:                       messageType,
		PublisherId:                       publisherId,
		Timestamp:                         timestamp,
		ResponseAddress:                   responseAddress,
		CorrelationData:                   correlationData,
		RequestorId:                       requestorId,
		TimeoutHint:                       timeoutHint,
		Messages:                          messages,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// JsonActionNetworkMessageBuilder is a builder for JsonActionNetworkMessage
type JsonActionNetworkMessageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, responseAddress PascalString, correlationData PascalByteString, requestorId PascalString, timeoutHint float64, messages []ExtensionObject) JsonActionNetworkMessageBuilder
	// WithMessageId adds MessageId (property field)
	WithMessageId(PascalString) JsonActionNetworkMessageBuilder
	// WithMessageIdBuilder adds MessageId (property field) which is build by the builder
	WithMessageIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder
	// WithMessageType adds MessageType (property field)
	WithMessageType(PascalString) JsonActionNetworkMessageBuilder
	// WithMessageTypeBuilder adds MessageType (property field) which is build by the builder
	WithMessageTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(PascalString) JsonActionNetworkMessageBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder
	// WithTimestamp adds Timestamp (property field)
	WithTimestamp(int64) JsonActionNetworkMessageBuilder
	// WithResponseAddress adds ResponseAddress (property field)
	WithResponseAddress(PascalString) JsonActionNetworkMessageBuilder
	// WithResponseAddressBuilder adds ResponseAddress (property field) which is build by the builder
	WithResponseAddressBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder
	// WithCorrelationData adds CorrelationData (property field)
	WithCorrelationData(PascalByteString) JsonActionNetworkMessageBuilder
	// WithCorrelationDataBuilder adds CorrelationData (property field) which is build by the builder
	WithCorrelationDataBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) JsonActionNetworkMessageBuilder
	// WithRequestorId adds RequestorId (property field)
	WithRequestorId(PascalString) JsonActionNetworkMessageBuilder
	// WithRequestorIdBuilder adds RequestorId (property field) which is build by the builder
	WithRequestorIdBuilder(func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder
	// WithTimeoutHint adds TimeoutHint (property field)
	WithTimeoutHint(float64) JsonActionNetworkMessageBuilder
	// WithMessages adds Messages (property field)
	WithMessages(...ExtensionObject) JsonActionNetworkMessageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the JsonActionNetworkMessage or returns an error if something is wrong
	Build() (JsonActionNetworkMessage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() JsonActionNetworkMessage
}

// NewJsonActionNetworkMessageBuilder() creates a JsonActionNetworkMessageBuilder
func NewJsonActionNetworkMessageBuilder() JsonActionNetworkMessageBuilder {
	return &_JsonActionNetworkMessageBuilder{_JsonActionNetworkMessage: new(_JsonActionNetworkMessage)}
}

type _JsonActionNetworkMessageBuilder struct {
	*_JsonActionNetworkMessage

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (JsonActionNetworkMessageBuilder) = (*_JsonActionNetworkMessageBuilder)(nil)

func (b *_JsonActionNetworkMessageBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._JsonActionNetworkMessage
}

func (b *_JsonActionNetworkMessageBuilder) WithMandatoryFields(messageId PascalString, messageType PascalString, publisherId PascalString, timestamp int64, responseAddress PascalString, correlationData PascalByteString, requestorId PascalString, timeoutHint float64, messages []ExtensionObject) JsonActionNetworkMessageBuilder {
	return b.WithMessageId(messageId).WithMessageType(messageType).WithPublisherId(publisherId).WithTimestamp(timestamp).WithResponseAddress(responseAddress).WithCorrelationData(correlationData).WithRequestorId(requestorId).WithTimeoutHint(timeoutHint).WithMessages(messages...)
}

func (b *_JsonActionNetworkMessageBuilder) WithMessageId(messageId PascalString) JsonActionNetworkMessageBuilder {
	b.MessageId = messageId
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithMessageIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder {
	builder := builderSupplier(b.MessageId.CreatePascalStringBuilder())
	var err error
	b.MessageId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithMessageType(messageType PascalString) JsonActionNetworkMessageBuilder {
	b.MessageType = messageType
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithMessageTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder {
	builder := builderSupplier(b.MessageType.CreatePascalStringBuilder())
	var err error
	b.MessageType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithPublisherId(publisherId PascalString) JsonActionNetworkMessageBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithPublisherIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder {
	builder := builderSupplier(b.PublisherId.CreatePascalStringBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithTimestamp(timestamp int64) JsonActionNetworkMessageBuilder {
	b.Timestamp = timestamp
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithResponseAddress(responseAddress PascalString) JsonActionNetworkMessageBuilder {
	b.ResponseAddress = responseAddress
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithResponseAddressBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder {
	builder := builderSupplier(b.ResponseAddress.CreatePascalStringBuilder())
	var err error
	b.ResponseAddress, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithCorrelationData(correlationData PascalByteString) JsonActionNetworkMessageBuilder {
	b.CorrelationData = correlationData
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithCorrelationDataBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) JsonActionNetworkMessageBuilder {
	builder := builderSupplier(b.CorrelationData.CreatePascalByteStringBuilder())
	var err error
	b.CorrelationData, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithRequestorId(requestorId PascalString) JsonActionNetworkMessageBuilder {
	b.RequestorId = requestorId
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithRequestorIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) JsonActionNetworkMessageBuilder {
	builder := builderSupplier(b.RequestorId.CreatePascalStringBuilder())
	var err error
	b.RequestorId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithTimeoutHint(timeoutHint float64) JsonActionNetworkMessageBuilder {
	b.TimeoutHint = timeoutHint
	return b
}

func (b *_JsonActionNetworkMessageBuilder) WithMessages(messages ...ExtensionObject) JsonActionNetworkMessageBuilder {
	b.Messages = messages
	return b
}

func (b *_JsonActionNetworkMessageBuilder) Build() (JsonActionNetworkMessage, error) {
	if b.MessageId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageId' not set"))
	}
	if b.MessageType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageType' not set"))
	}
	if b.PublisherId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'publisherId' not set"))
	}
	if b.ResponseAddress == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'responseAddress' not set"))
	}
	if b.CorrelationData == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'correlationData' not set"))
	}
	if b.RequestorId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'requestorId' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._JsonActionNetworkMessage.deepCopy(), nil
}

func (b *_JsonActionNetworkMessageBuilder) MustBuild() JsonActionNetworkMessage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_JsonActionNetworkMessageBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_JsonActionNetworkMessageBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_JsonActionNetworkMessageBuilder) DeepCopy() any {
	_copy := b.CreateJsonActionNetworkMessageBuilder().(*_JsonActionNetworkMessageBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateJsonActionNetworkMessageBuilder creates a JsonActionNetworkMessageBuilder
func (b *_JsonActionNetworkMessage) CreateJsonActionNetworkMessageBuilder() JsonActionNetworkMessageBuilder {
	if b == nil {
		return NewJsonActionNetworkMessageBuilder()
	}
	return &_JsonActionNetworkMessageBuilder{_JsonActionNetworkMessage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_JsonActionNetworkMessage) GetExtensionId() int32 {
	return int32(19322)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_JsonActionNetworkMessage) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_JsonActionNetworkMessage) GetMessageId() PascalString {
	return m.MessageId
}

func (m *_JsonActionNetworkMessage) GetMessageType() PascalString {
	return m.MessageType
}

func (m *_JsonActionNetworkMessage) GetPublisherId() PascalString {
	return m.PublisherId
}

func (m *_JsonActionNetworkMessage) GetTimestamp() int64 {
	return m.Timestamp
}

func (m *_JsonActionNetworkMessage) GetResponseAddress() PascalString {
	return m.ResponseAddress
}

func (m *_JsonActionNetworkMessage) GetCorrelationData() PascalByteString {
	return m.CorrelationData
}

func (m *_JsonActionNetworkMessage) GetRequestorId() PascalString {
	return m.RequestorId
}

func (m *_JsonActionNetworkMessage) GetTimeoutHint() float64 {
	return m.TimeoutHint
}

func (m *_JsonActionNetworkMessage) GetMessages() []ExtensionObject {
	return m.Messages
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastJsonActionNetworkMessage(structType any) JsonActionNetworkMessage {
	if casted, ok := structType.(JsonActionNetworkMessage); ok {
		return casted
	}
	if casted, ok := structType.(*JsonActionNetworkMessage); ok {
		return *casted
	}
	return nil
}

func (m *_JsonActionNetworkMessage) GetTypeName() string {
	return "JsonActionNetworkMessage"
}

func (m *_JsonActionNetworkMessage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (messageId)
	lengthInBits += m.MessageId.GetLengthInBits(ctx)

	// Simple field (messageType)
	lengthInBits += m.MessageType.GetLengthInBits(ctx)

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (timestamp)
	lengthInBits += 64

	// Simple field (responseAddress)
	lengthInBits += m.ResponseAddress.GetLengthInBits(ctx)

	// Simple field (correlationData)
	lengthInBits += m.CorrelationData.GetLengthInBits(ctx)

	// Simple field (requestorId)
	lengthInBits += m.RequestorId.GetLengthInBits(ctx)

	// Simple field (timeoutHint)
	lengthInBits += 64

	// Implicit Field (noOfMessages)
	lengthInBits += 32

	// Array field
	if len(m.Messages) > 0 {
		for _curItem, element := range m.Messages {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.Messages), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_JsonActionNetworkMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_JsonActionNetworkMessage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__jsonActionNetworkMessage JsonActionNetworkMessage, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("JsonActionNetworkMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for JsonActionNetworkMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	messageId, err := ReadSimpleField[PascalString](ctx, "messageId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageId' field"))
	}
	m.MessageId = messageId

	messageType, err := ReadSimpleField[PascalString](ctx, "messageType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageType' field"))
	}
	m.MessageType = messageType

	publisherId, err := ReadSimpleField[PascalString](ctx, "publisherId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	timestamp, err := ReadSimpleField(ctx, "timestamp", ReadSignedLong(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timestamp' field"))
	}
	m.Timestamp = timestamp

	responseAddress, err := ReadSimpleField[PascalString](ctx, "responseAddress", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'responseAddress' field"))
	}
	m.ResponseAddress = responseAddress

	correlationData, err := ReadSimpleField[PascalByteString](ctx, "correlationData", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'correlationData' field"))
	}
	m.CorrelationData = correlationData

	requestorId, err := ReadSimpleField[PascalString](ctx, "requestorId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'requestorId' field"))
	}
	m.RequestorId = requestorId

	timeoutHint, err := ReadSimpleField(ctx, "timeoutHint", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'timeoutHint' field"))
	}
	m.TimeoutHint = timeoutHint

	noOfMessages, err := ReadImplicitField[int32](ctx, "noOfMessages", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfMessages' field"))
	}
	_ = noOfMessages

	messages, err := ReadCountArrayField[ExtensionObject](ctx, "messages", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer), uint64(noOfMessages))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messages' field"))
	}
	m.Messages = messages

	if closeErr := readBuffer.CloseContext("JsonActionNetworkMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for JsonActionNetworkMessage")
	}

	return m, nil
}

func (m *_JsonActionNetworkMessage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_JsonActionNetworkMessage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("JsonActionNetworkMessage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for JsonActionNetworkMessage")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageId", m.GetMessageId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "messageType", m.GetMessageType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "publisherId", m.GetPublisherId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[int64](ctx, "timestamp", m.GetTimestamp(), WriteSignedLong(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timestamp' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "responseAddress", m.GetResponseAddress(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'responseAddress' field")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "correlationData", m.GetCorrelationData(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'correlationData' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "requestorId", m.GetRequestorId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'requestorId' field")
		}

		if err := WriteSimpleField[float64](ctx, "timeoutHint", m.GetTimeoutHint(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'timeoutHint' field")
		}
		noOfMessages := int32(utils.InlineIf(bool((m.GetMessages()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetMessages()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfMessages", noOfMessages, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfMessages' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "messages", m.GetMessages(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'messages' field")
		}

		if popErr := writeBuffer.PopContext("JsonActionNetworkMessage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for JsonActionNetworkMessage")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_JsonActionNetworkMessage) IsJsonActionNetworkMessage() {}

func (m *_JsonActionNetworkMessage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_JsonActionNetworkMessage) deepCopy() *_JsonActionNetworkMessage {
	if m == nil {
		return nil
	}
	_JsonActionNetworkMessageCopy := &_JsonActionNetworkMessage{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.MessageId),
		utils.DeepCopy[PascalString](m.MessageType),
		utils.DeepCopy[PascalString](m.PublisherId),
		m.Timestamp,
		utils.DeepCopy[PascalString](m.ResponseAddress),
		utils.DeepCopy[PascalByteString](m.CorrelationData),
		utils.DeepCopy[PascalString](m.RequestorId),
		m.TimeoutHint,
		utils.DeepCopySlice[ExtensionObject, ExtensionObject](m.Messages),
	}
	_JsonActionNetworkMessageCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _JsonActionNetworkMessageCopy
}

func (m *_JsonActionNetworkMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
