/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ImagePNG is the corresponding interface of ImagePNG
type ImagePNG interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsImagePNG is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsImagePNG()
	// CreateBuilder creates a ImagePNGBuilder
	CreateImagePNGBuilder() ImagePNGBuilder
}

// _ImagePNG is the data-structure of this message
type _ImagePNG struct {
}

var _ ImagePNG = (*_ImagePNG)(nil)

// NewImagePNG factory function for _ImagePNG
func NewImagePNG() *_ImagePNG {
	return &_ImagePNG{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ImagePNGBuilder is a builder for ImagePNG
type ImagePNGBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ImagePNGBuilder
	// Build builds the ImagePNG or returns an error if something is wrong
	Build() (ImagePNG, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ImagePNG
}

// NewImagePNGBuilder() creates a ImagePNGBuilder
func NewImagePNGBuilder() ImagePNGBuilder {
	return &_ImagePNGBuilder{_ImagePNG: new(_ImagePNG)}
}

type _ImagePNGBuilder struct {
	*_ImagePNG

	err *utils.MultiError
}

var _ (ImagePNGBuilder) = (*_ImagePNGBuilder)(nil)

func (b *_ImagePNGBuilder) WithMandatoryFields() ImagePNGBuilder {
	return b
}

func (b *_ImagePNGBuilder) Build() (ImagePNG, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ImagePNG.deepCopy(), nil
}

func (b *_ImagePNGBuilder) MustBuild() ImagePNG {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ImagePNGBuilder) DeepCopy() any {
	_copy := b.CreateImagePNGBuilder().(*_ImagePNGBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateImagePNGBuilder creates a ImagePNGBuilder
func (b *_ImagePNG) CreateImagePNGBuilder() ImagePNGBuilder {
	if b == nil {
		return NewImagePNGBuilder()
	}
	return &_ImagePNGBuilder{_ImagePNG: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastImagePNG(structType any) ImagePNG {
	if casted, ok := structType.(ImagePNG); ok {
		return casted
	}
	if casted, ok := structType.(*ImagePNG); ok {
		return *casted
	}
	return nil
}

func (m *_ImagePNG) GetTypeName() string {
	return "ImagePNG"
}

func (m *_ImagePNG) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_ImagePNG) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ImagePNGParse(ctx context.Context, theBytes []byte) (ImagePNG, error) {
	return ImagePNGParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ImagePNGParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ImagePNG, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ImagePNG, error) {
		return ImagePNGParseWithBuffer(ctx, readBuffer)
	}
}

func ImagePNGParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ImagePNG, error) {
	v, err := (&_ImagePNG{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ImagePNG) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__imagePNG ImagePNG, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ImagePNG"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ImagePNG")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ImagePNG"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ImagePNG")
	}

	return m, nil
}

func (m *_ImagePNG) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ImagePNG) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ImagePNG"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ImagePNG")
	}

	if popErr := writeBuffer.PopContext("ImagePNG"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ImagePNG")
	}
	return nil
}

func (m *_ImagePNG) IsImagePNG() {}

func (m *_ImagePNG) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ImagePNG) deepCopy() *_ImagePNG {
	if m == nil {
		return nil
	}
	_ImagePNGCopy := &_ImagePNG{}
	return _ImagePNGCopy
}

func (m *_ImagePNG) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
