/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// FieldTargetDataType is the corresponding interface of FieldTargetDataType
type FieldTargetDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetDataSetFieldId returns DataSetFieldId (property field)
	GetDataSetFieldId() GuidValue
	// GetReceiverIndexRange returns ReceiverIndexRange (property field)
	GetReceiverIndexRange() PascalString
	// GetTargetNodeId returns TargetNodeId (property field)
	GetTargetNodeId() NodeId
	// GetAttributeId returns AttributeId (property field)
	GetAttributeId() uint32
	// GetWriteIndexRange returns WriteIndexRange (property field)
	GetWriteIndexRange() PascalString
	// GetOverrideValueHandling returns OverrideValueHandling (property field)
	GetOverrideValueHandling() OverrideValueHandling
	// GetOverrideValue returns OverrideValue (property field)
	GetOverrideValue() Variant
	// IsFieldTargetDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsFieldTargetDataType()
	// CreateBuilder creates a FieldTargetDataTypeBuilder
	CreateFieldTargetDataTypeBuilder() FieldTargetDataTypeBuilder
}

// _FieldTargetDataType is the data-structure of this message
type _FieldTargetDataType struct {
	ExtensionObjectDefinitionContract
	DataSetFieldId        GuidValue
	ReceiverIndexRange    PascalString
	TargetNodeId          NodeId
	AttributeId           uint32
	WriteIndexRange       PascalString
	OverrideValueHandling OverrideValueHandling
	OverrideValue         Variant
}

var _ FieldTargetDataType = (*_FieldTargetDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_FieldTargetDataType)(nil)

// NewFieldTargetDataType factory function for _FieldTargetDataType
func NewFieldTargetDataType(dataSetFieldId GuidValue, receiverIndexRange PascalString, targetNodeId NodeId, attributeId uint32, writeIndexRange PascalString, overrideValueHandling OverrideValueHandling, overrideValue Variant) *_FieldTargetDataType {
	if dataSetFieldId == nil {
		panic("dataSetFieldId of type GuidValue for FieldTargetDataType must not be nil")
	}
	if receiverIndexRange == nil {
		panic("receiverIndexRange of type PascalString for FieldTargetDataType must not be nil")
	}
	if targetNodeId == nil {
		panic("targetNodeId of type NodeId for FieldTargetDataType must not be nil")
	}
	if writeIndexRange == nil {
		panic("writeIndexRange of type PascalString for FieldTargetDataType must not be nil")
	}
	if overrideValue == nil {
		panic("overrideValue of type Variant for FieldTargetDataType must not be nil")
	}
	_result := &_FieldTargetDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		DataSetFieldId:                    dataSetFieldId,
		ReceiverIndexRange:                receiverIndexRange,
		TargetNodeId:                      targetNodeId,
		AttributeId:                       attributeId,
		WriteIndexRange:                   writeIndexRange,
		OverrideValueHandling:             overrideValueHandling,
		OverrideValue:                     overrideValue,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// FieldTargetDataTypeBuilder is a builder for FieldTargetDataType
type FieldTargetDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataSetFieldId GuidValue, receiverIndexRange PascalString, targetNodeId NodeId, attributeId uint32, writeIndexRange PascalString, overrideValueHandling OverrideValueHandling, overrideValue Variant) FieldTargetDataTypeBuilder
	// WithDataSetFieldId adds DataSetFieldId (property field)
	WithDataSetFieldId(GuidValue) FieldTargetDataTypeBuilder
	// WithDataSetFieldIdBuilder adds DataSetFieldId (property field) which is build by the builder
	WithDataSetFieldIdBuilder(func(GuidValueBuilder) GuidValueBuilder) FieldTargetDataTypeBuilder
	// WithReceiverIndexRange adds ReceiverIndexRange (property field)
	WithReceiverIndexRange(PascalString) FieldTargetDataTypeBuilder
	// WithReceiverIndexRangeBuilder adds ReceiverIndexRange (property field) which is build by the builder
	WithReceiverIndexRangeBuilder(func(PascalStringBuilder) PascalStringBuilder) FieldTargetDataTypeBuilder
	// WithTargetNodeId adds TargetNodeId (property field)
	WithTargetNodeId(NodeId) FieldTargetDataTypeBuilder
	// WithTargetNodeIdBuilder adds TargetNodeId (property field) which is build by the builder
	WithTargetNodeIdBuilder(func(NodeIdBuilder) NodeIdBuilder) FieldTargetDataTypeBuilder
	// WithAttributeId adds AttributeId (property field)
	WithAttributeId(uint32) FieldTargetDataTypeBuilder
	// WithWriteIndexRange adds WriteIndexRange (property field)
	WithWriteIndexRange(PascalString) FieldTargetDataTypeBuilder
	// WithWriteIndexRangeBuilder adds WriteIndexRange (property field) which is build by the builder
	WithWriteIndexRangeBuilder(func(PascalStringBuilder) PascalStringBuilder) FieldTargetDataTypeBuilder
	// WithOverrideValueHandling adds OverrideValueHandling (property field)
	WithOverrideValueHandling(OverrideValueHandling) FieldTargetDataTypeBuilder
	// WithOverrideValue adds OverrideValue (property field)
	WithOverrideValue(Variant) FieldTargetDataTypeBuilder
	// WithOverrideValueBuilder adds OverrideValue (property field) which is build by the builder
	WithOverrideValueBuilder(func(VariantBuilder) VariantBuilder) FieldTargetDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the FieldTargetDataType or returns an error if something is wrong
	Build() (FieldTargetDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() FieldTargetDataType
}

// NewFieldTargetDataTypeBuilder() creates a FieldTargetDataTypeBuilder
func NewFieldTargetDataTypeBuilder() FieldTargetDataTypeBuilder {
	return &_FieldTargetDataTypeBuilder{_FieldTargetDataType: new(_FieldTargetDataType)}
}

type _FieldTargetDataTypeBuilder struct {
	*_FieldTargetDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (FieldTargetDataTypeBuilder) = (*_FieldTargetDataTypeBuilder)(nil)

func (b *_FieldTargetDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._FieldTargetDataType
}

func (b *_FieldTargetDataTypeBuilder) WithMandatoryFields(dataSetFieldId GuidValue, receiverIndexRange PascalString, targetNodeId NodeId, attributeId uint32, writeIndexRange PascalString, overrideValueHandling OverrideValueHandling, overrideValue Variant) FieldTargetDataTypeBuilder {
	return b.WithDataSetFieldId(dataSetFieldId).WithReceiverIndexRange(receiverIndexRange).WithTargetNodeId(targetNodeId).WithAttributeId(attributeId).WithWriteIndexRange(writeIndexRange).WithOverrideValueHandling(overrideValueHandling).WithOverrideValue(overrideValue)
}

func (b *_FieldTargetDataTypeBuilder) WithDataSetFieldId(dataSetFieldId GuidValue) FieldTargetDataTypeBuilder {
	b.DataSetFieldId = dataSetFieldId
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithDataSetFieldIdBuilder(builderSupplier func(GuidValueBuilder) GuidValueBuilder) FieldTargetDataTypeBuilder {
	builder := builderSupplier(b.DataSetFieldId.CreateGuidValueBuilder())
	var err error
	b.DataSetFieldId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "GuidValueBuilder failed"))
	}
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithReceiverIndexRange(receiverIndexRange PascalString) FieldTargetDataTypeBuilder {
	b.ReceiverIndexRange = receiverIndexRange
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithReceiverIndexRangeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) FieldTargetDataTypeBuilder {
	builder := builderSupplier(b.ReceiverIndexRange.CreatePascalStringBuilder())
	var err error
	b.ReceiverIndexRange, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithTargetNodeId(targetNodeId NodeId) FieldTargetDataTypeBuilder {
	b.TargetNodeId = targetNodeId
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithTargetNodeIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) FieldTargetDataTypeBuilder {
	builder := builderSupplier(b.TargetNodeId.CreateNodeIdBuilder())
	var err error
	b.TargetNodeId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithAttributeId(attributeId uint32) FieldTargetDataTypeBuilder {
	b.AttributeId = attributeId
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithWriteIndexRange(writeIndexRange PascalString) FieldTargetDataTypeBuilder {
	b.WriteIndexRange = writeIndexRange
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithWriteIndexRangeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) FieldTargetDataTypeBuilder {
	builder := builderSupplier(b.WriteIndexRange.CreatePascalStringBuilder())
	var err error
	b.WriteIndexRange, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithOverrideValueHandling(overrideValueHandling OverrideValueHandling) FieldTargetDataTypeBuilder {
	b.OverrideValueHandling = overrideValueHandling
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithOverrideValue(overrideValue Variant) FieldTargetDataTypeBuilder {
	b.OverrideValue = overrideValue
	return b
}

func (b *_FieldTargetDataTypeBuilder) WithOverrideValueBuilder(builderSupplier func(VariantBuilder) VariantBuilder) FieldTargetDataTypeBuilder {
	builder := builderSupplier(b.OverrideValue.CreateVariantBuilder())
	var err error
	b.OverrideValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_FieldTargetDataTypeBuilder) Build() (FieldTargetDataType, error) {
	if b.DataSetFieldId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dataSetFieldId' not set"))
	}
	if b.ReceiverIndexRange == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'receiverIndexRange' not set"))
	}
	if b.TargetNodeId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'targetNodeId' not set"))
	}
	if b.WriteIndexRange == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'writeIndexRange' not set"))
	}
	if b.OverrideValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'overrideValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._FieldTargetDataType.deepCopy(), nil
}

func (b *_FieldTargetDataTypeBuilder) MustBuild() FieldTargetDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_FieldTargetDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_FieldTargetDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_FieldTargetDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateFieldTargetDataTypeBuilder().(*_FieldTargetDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateFieldTargetDataTypeBuilder creates a FieldTargetDataTypeBuilder
func (b *_FieldTargetDataType) CreateFieldTargetDataTypeBuilder() FieldTargetDataTypeBuilder {
	if b == nil {
		return NewFieldTargetDataTypeBuilder()
	}
	return &_FieldTargetDataTypeBuilder{_FieldTargetDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_FieldTargetDataType) GetExtensionId() int32 {
	return int32(14746)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_FieldTargetDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_FieldTargetDataType) GetDataSetFieldId() GuidValue {
	return m.DataSetFieldId
}

func (m *_FieldTargetDataType) GetReceiverIndexRange() PascalString {
	return m.ReceiverIndexRange
}

func (m *_FieldTargetDataType) GetTargetNodeId() NodeId {
	return m.TargetNodeId
}

func (m *_FieldTargetDataType) GetAttributeId() uint32 {
	return m.AttributeId
}

func (m *_FieldTargetDataType) GetWriteIndexRange() PascalString {
	return m.WriteIndexRange
}

func (m *_FieldTargetDataType) GetOverrideValueHandling() OverrideValueHandling {
	return m.OverrideValueHandling
}

func (m *_FieldTargetDataType) GetOverrideValue() Variant {
	return m.OverrideValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastFieldTargetDataType(structType any) FieldTargetDataType {
	if casted, ok := structType.(FieldTargetDataType); ok {
		return casted
	}
	if casted, ok := structType.(*FieldTargetDataType); ok {
		return *casted
	}
	return nil
}

func (m *_FieldTargetDataType) GetTypeName() string {
	return "FieldTargetDataType"
}

func (m *_FieldTargetDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (dataSetFieldId)
	lengthInBits += m.DataSetFieldId.GetLengthInBits(ctx)

	// Simple field (receiverIndexRange)
	lengthInBits += m.ReceiverIndexRange.GetLengthInBits(ctx)

	// Simple field (targetNodeId)
	lengthInBits += m.TargetNodeId.GetLengthInBits(ctx)

	// Simple field (attributeId)
	lengthInBits += 32

	// Simple field (writeIndexRange)
	lengthInBits += m.WriteIndexRange.GetLengthInBits(ctx)

	// Simple field (overrideValueHandling)
	lengthInBits += 32

	// Simple field (overrideValue)
	lengthInBits += m.OverrideValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_FieldTargetDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_FieldTargetDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__fieldTargetDataType FieldTargetDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("FieldTargetDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for FieldTargetDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataSetFieldId, err := ReadSimpleField[GuidValue](ctx, "dataSetFieldId", ReadComplex[GuidValue](GuidValueParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetFieldId' field"))
	}
	m.DataSetFieldId = dataSetFieldId

	receiverIndexRange, err := ReadSimpleField[PascalString](ctx, "receiverIndexRange", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'receiverIndexRange' field"))
	}
	m.ReceiverIndexRange = receiverIndexRange

	targetNodeId, err := ReadSimpleField[NodeId](ctx, "targetNodeId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'targetNodeId' field"))
	}
	m.TargetNodeId = targetNodeId

	attributeId, err := ReadSimpleField(ctx, "attributeId", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'attributeId' field"))
	}
	m.AttributeId = attributeId

	writeIndexRange, err := ReadSimpleField[PascalString](ctx, "writeIndexRange", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writeIndexRange' field"))
	}
	m.WriteIndexRange = writeIndexRange

	overrideValueHandling, err := ReadEnumField[OverrideValueHandling](ctx, "overrideValueHandling", "OverrideValueHandling", ReadEnum(OverrideValueHandlingByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'overrideValueHandling' field"))
	}
	m.OverrideValueHandling = overrideValueHandling

	overrideValue, err := ReadSimpleField[Variant](ctx, "overrideValue", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'overrideValue' field"))
	}
	m.OverrideValue = overrideValue

	if closeErr := readBuffer.CloseContext("FieldTargetDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for FieldTargetDataType")
	}

	return m, nil
}

func (m *_FieldTargetDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_FieldTargetDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("FieldTargetDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for FieldTargetDataType")
		}

		if err := WriteSimpleField[GuidValue](ctx, "dataSetFieldId", m.GetDataSetFieldId(), WriteComplex[GuidValue](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetFieldId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "receiverIndexRange", m.GetReceiverIndexRange(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'receiverIndexRange' field")
		}

		if err := WriteSimpleField[NodeId](ctx, "targetNodeId", m.GetTargetNodeId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'targetNodeId' field")
		}

		if err := WriteSimpleField[uint32](ctx, "attributeId", m.GetAttributeId(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'attributeId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "writeIndexRange", m.GetWriteIndexRange(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'writeIndexRange' field")
		}

		if err := WriteSimpleEnumField[OverrideValueHandling](ctx, "overrideValueHandling", "OverrideValueHandling", m.GetOverrideValueHandling(), WriteEnum[OverrideValueHandling, uint32](OverrideValueHandling.GetValue, OverrideValueHandling.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'overrideValueHandling' field")
		}

		if err := WriteSimpleField[Variant](ctx, "overrideValue", m.GetOverrideValue(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'overrideValue' field")
		}

		if popErr := writeBuffer.PopContext("FieldTargetDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for FieldTargetDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_FieldTargetDataType) IsFieldTargetDataType() {}

func (m *_FieldTargetDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_FieldTargetDataType) deepCopy() *_FieldTargetDataType {
	if m == nil {
		return nil
	}
	_FieldTargetDataTypeCopy := &_FieldTargetDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[GuidValue](m.DataSetFieldId),
		utils.DeepCopy[PascalString](m.ReceiverIndexRange),
		utils.DeepCopy[NodeId](m.TargetNodeId),
		m.AttributeId,
		utils.DeepCopy[PascalString](m.WriteIndexRange),
		m.OverrideValueHandling,
		utils.DeepCopy[Variant](m.OverrideValue),
	}
	_FieldTargetDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _FieldTargetDataTypeCopy
}

func (m *_FieldTargetDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
