/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DatagramWriterGroupTransport2DataType is the corresponding interface of DatagramWriterGroupTransport2DataType
type DatagramWriterGroupTransport2DataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetMessageRepeatCount returns MessageRepeatCount (property field)
	GetMessageRepeatCount() uint8
	// GetMessageRepeatDelay returns MessageRepeatDelay (property field)
	GetMessageRepeatDelay() float64
	// GetAddress returns Address (property field)
	GetAddress() ExtensionObject
	// GetQosCategory returns QosCategory (property field)
	GetQosCategory() PascalString
	// GetDatagramQos returns DatagramQos (property field)
	GetDatagramQos() []ExtensionObject
	// GetDiscoveryAnnounceRate returns DiscoveryAnnounceRate (property field)
	GetDiscoveryAnnounceRate() uint32
	// GetTopic returns Topic (property field)
	GetTopic() PascalString
	// IsDatagramWriterGroupTransport2DataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDatagramWriterGroupTransport2DataType()
	// CreateBuilder creates a DatagramWriterGroupTransport2DataTypeBuilder
	CreateDatagramWriterGroupTransport2DataTypeBuilder() DatagramWriterGroupTransport2DataTypeBuilder
}

// _DatagramWriterGroupTransport2DataType is the data-structure of this message
type _DatagramWriterGroupTransport2DataType struct {
	ExtensionObjectDefinitionContract
	MessageRepeatCount    uint8
	MessageRepeatDelay    float64
	Address               ExtensionObject
	QosCategory           PascalString
	DatagramQos           []ExtensionObject
	DiscoveryAnnounceRate uint32
	Topic                 PascalString
}

var _ DatagramWriterGroupTransport2DataType = (*_DatagramWriterGroupTransport2DataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DatagramWriterGroupTransport2DataType)(nil)

// NewDatagramWriterGroupTransport2DataType factory function for _DatagramWriterGroupTransport2DataType
func NewDatagramWriterGroupTransport2DataType(messageRepeatCount uint8, messageRepeatDelay float64, address ExtensionObject, qosCategory PascalString, datagramQos []ExtensionObject, discoveryAnnounceRate uint32, topic PascalString) *_DatagramWriterGroupTransport2DataType {
	if address == nil {
		panic("address of type ExtensionObject for DatagramWriterGroupTransport2DataType must not be nil")
	}
	if qosCategory == nil {
		panic("qosCategory of type PascalString for DatagramWriterGroupTransport2DataType must not be nil")
	}
	if topic == nil {
		panic("topic of type PascalString for DatagramWriterGroupTransport2DataType must not be nil")
	}
	_result := &_DatagramWriterGroupTransport2DataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		MessageRepeatCount:                messageRepeatCount,
		MessageRepeatDelay:                messageRepeatDelay,
		Address:                           address,
		QosCategory:                       qosCategory,
		DatagramQos:                       datagramQos,
		DiscoveryAnnounceRate:             discoveryAnnounceRate,
		Topic:                             topic,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DatagramWriterGroupTransport2DataTypeBuilder is a builder for DatagramWriterGroupTransport2DataType
type DatagramWriterGroupTransport2DataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(messageRepeatCount uint8, messageRepeatDelay float64, address ExtensionObject, qosCategory PascalString, datagramQos []ExtensionObject, discoveryAnnounceRate uint32, topic PascalString) DatagramWriterGroupTransport2DataTypeBuilder
	// WithMessageRepeatCount adds MessageRepeatCount (property field)
	WithMessageRepeatCount(uint8) DatagramWriterGroupTransport2DataTypeBuilder
	// WithMessageRepeatDelay adds MessageRepeatDelay (property field)
	WithMessageRepeatDelay(float64) DatagramWriterGroupTransport2DataTypeBuilder
	// WithAddress adds Address (property field)
	WithAddress(ExtensionObject) DatagramWriterGroupTransport2DataTypeBuilder
	// WithAddressBuilder adds Address (property field) which is build by the builder
	WithAddressBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) DatagramWriterGroupTransport2DataTypeBuilder
	// WithQosCategory adds QosCategory (property field)
	WithQosCategory(PascalString) DatagramWriterGroupTransport2DataTypeBuilder
	// WithQosCategoryBuilder adds QosCategory (property field) which is build by the builder
	WithQosCategoryBuilder(func(PascalStringBuilder) PascalStringBuilder) DatagramWriterGroupTransport2DataTypeBuilder
	// WithDatagramQos adds DatagramQos (property field)
	WithDatagramQos(...ExtensionObject) DatagramWriterGroupTransport2DataTypeBuilder
	// WithDiscoveryAnnounceRate adds DiscoveryAnnounceRate (property field)
	WithDiscoveryAnnounceRate(uint32) DatagramWriterGroupTransport2DataTypeBuilder
	// WithTopic adds Topic (property field)
	WithTopic(PascalString) DatagramWriterGroupTransport2DataTypeBuilder
	// WithTopicBuilder adds Topic (property field) which is build by the builder
	WithTopicBuilder(func(PascalStringBuilder) PascalStringBuilder) DatagramWriterGroupTransport2DataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DatagramWriterGroupTransport2DataType or returns an error if something is wrong
	Build() (DatagramWriterGroupTransport2DataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DatagramWriterGroupTransport2DataType
}

// NewDatagramWriterGroupTransport2DataTypeBuilder() creates a DatagramWriterGroupTransport2DataTypeBuilder
func NewDatagramWriterGroupTransport2DataTypeBuilder() DatagramWriterGroupTransport2DataTypeBuilder {
	return &_DatagramWriterGroupTransport2DataTypeBuilder{_DatagramWriterGroupTransport2DataType: new(_DatagramWriterGroupTransport2DataType)}
}

type _DatagramWriterGroupTransport2DataTypeBuilder struct {
	*_DatagramWriterGroupTransport2DataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (DatagramWriterGroupTransport2DataTypeBuilder) = (*_DatagramWriterGroupTransport2DataTypeBuilder)(nil)

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DatagramWriterGroupTransport2DataType
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithMandatoryFields(messageRepeatCount uint8, messageRepeatDelay float64, address ExtensionObject, qosCategory PascalString, datagramQos []ExtensionObject, discoveryAnnounceRate uint32, topic PascalString) DatagramWriterGroupTransport2DataTypeBuilder {
	return b.WithMessageRepeatCount(messageRepeatCount).WithMessageRepeatDelay(messageRepeatDelay).WithAddress(address).WithQosCategory(qosCategory).WithDatagramQos(datagramQos...).WithDiscoveryAnnounceRate(discoveryAnnounceRate).WithTopic(topic)
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithMessageRepeatCount(messageRepeatCount uint8) DatagramWriterGroupTransport2DataTypeBuilder {
	b.MessageRepeatCount = messageRepeatCount
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithMessageRepeatDelay(messageRepeatDelay float64) DatagramWriterGroupTransport2DataTypeBuilder {
	b.MessageRepeatDelay = messageRepeatDelay
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithAddress(address ExtensionObject) DatagramWriterGroupTransport2DataTypeBuilder {
	b.Address = address
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithAddressBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) DatagramWriterGroupTransport2DataTypeBuilder {
	builder := builderSupplier(b.Address.CreateExtensionObjectBuilder())
	var err error
	b.Address, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithQosCategory(qosCategory PascalString) DatagramWriterGroupTransport2DataTypeBuilder {
	b.QosCategory = qosCategory
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithQosCategoryBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) DatagramWriterGroupTransport2DataTypeBuilder {
	builder := builderSupplier(b.QosCategory.CreatePascalStringBuilder())
	var err error
	b.QosCategory, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithDatagramQos(datagramQos ...ExtensionObject) DatagramWriterGroupTransport2DataTypeBuilder {
	b.DatagramQos = datagramQos
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithDiscoveryAnnounceRate(discoveryAnnounceRate uint32) DatagramWriterGroupTransport2DataTypeBuilder {
	b.DiscoveryAnnounceRate = discoveryAnnounceRate
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithTopic(topic PascalString) DatagramWriterGroupTransport2DataTypeBuilder {
	b.Topic = topic
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) WithTopicBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) DatagramWriterGroupTransport2DataTypeBuilder {
	builder := builderSupplier(b.Topic.CreatePascalStringBuilder())
	var err error
	b.Topic, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) Build() (DatagramWriterGroupTransport2DataType, error) {
	if b.Address == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'address' not set"))
	}
	if b.QosCategory == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'qosCategory' not set"))
	}
	if b.Topic == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'topic' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._DatagramWriterGroupTransport2DataType.deepCopy(), nil
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) MustBuild() DatagramWriterGroupTransport2DataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DatagramWriterGroupTransport2DataTypeBuilder) DeepCopy() any {
	_copy := b.CreateDatagramWriterGroupTransport2DataTypeBuilder().(*_DatagramWriterGroupTransport2DataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateDatagramWriterGroupTransport2DataTypeBuilder creates a DatagramWriterGroupTransport2DataTypeBuilder
func (b *_DatagramWriterGroupTransport2DataType) CreateDatagramWriterGroupTransport2DataTypeBuilder() DatagramWriterGroupTransport2DataTypeBuilder {
	if b == nil {
		return NewDatagramWriterGroupTransport2DataTypeBuilder()
	}
	return &_DatagramWriterGroupTransport2DataTypeBuilder{_DatagramWriterGroupTransport2DataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DatagramWriterGroupTransport2DataType) GetExtensionId() int32 {
	return int32(23615)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DatagramWriterGroupTransport2DataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DatagramWriterGroupTransport2DataType) GetMessageRepeatCount() uint8 {
	return m.MessageRepeatCount
}

func (m *_DatagramWriterGroupTransport2DataType) GetMessageRepeatDelay() float64 {
	return m.MessageRepeatDelay
}

func (m *_DatagramWriterGroupTransport2DataType) GetAddress() ExtensionObject {
	return m.Address
}

func (m *_DatagramWriterGroupTransport2DataType) GetQosCategory() PascalString {
	return m.QosCategory
}

func (m *_DatagramWriterGroupTransport2DataType) GetDatagramQos() []ExtensionObject {
	return m.DatagramQos
}

func (m *_DatagramWriterGroupTransport2DataType) GetDiscoveryAnnounceRate() uint32 {
	return m.DiscoveryAnnounceRate
}

func (m *_DatagramWriterGroupTransport2DataType) GetTopic() PascalString {
	return m.Topic
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDatagramWriterGroupTransport2DataType(structType any) DatagramWriterGroupTransport2DataType {
	if casted, ok := structType.(DatagramWriterGroupTransport2DataType); ok {
		return casted
	}
	if casted, ok := structType.(*DatagramWriterGroupTransport2DataType); ok {
		return *casted
	}
	return nil
}

func (m *_DatagramWriterGroupTransport2DataType) GetTypeName() string {
	return "DatagramWriterGroupTransport2DataType"
}

func (m *_DatagramWriterGroupTransport2DataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (messageRepeatCount)
	lengthInBits += 8

	// Simple field (messageRepeatDelay)
	lengthInBits += 64

	// Simple field (address)
	lengthInBits += m.Address.GetLengthInBits(ctx)

	// Simple field (qosCategory)
	lengthInBits += m.QosCategory.GetLengthInBits(ctx)

	// Implicit Field (noOfDatagramQos)
	lengthInBits += 32

	// Array field
	if len(m.DatagramQos) > 0 {
		for _curItem, element := range m.DatagramQos {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DatagramQos), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (discoveryAnnounceRate)
	lengthInBits += 32

	// Simple field (topic)
	lengthInBits += m.Topic.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_DatagramWriterGroupTransport2DataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DatagramWriterGroupTransport2DataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__datagramWriterGroupTransport2DataType DatagramWriterGroupTransport2DataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DatagramWriterGroupTransport2DataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DatagramWriterGroupTransport2DataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	messageRepeatCount, err := ReadSimpleField(ctx, "messageRepeatCount", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageRepeatCount' field"))
	}
	m.MessageRepeatCount = messageRepeatCount

	messageRepeatDelay, err := ReadSimpleField(ctx, "messageRepeatDelay", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageRepeatDelay' field"))
	}
	m.MessageRepeatDelay = messageRepeatDelay

	address, err := ReadSimpleField[ExtensionObject](ctx, "address", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	qosCategory, err := ReadSimpleField[PascalString](ctx, "qosCategory", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'qosCategory' field"))
	}
	m.QosCategory = qosCategory

	noOfDatagramQos, err := ReadImplicitField[int32](ctx, "noOfDatagramQos", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfDatagramQos' field"))
	}
	_ = noOfDatagramQos

	datagramQos, err := ReadCountArrayField[ExtensionObject](ctx, "datagramQos", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer), uint64(noOfDatagramQos))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'datagramQos' field"))
	}
	m.DatagramQos = datagramQos

	discoveryAnnounceRate, err := ReadSimpleField(ctx, "discoveryAnnounceRate", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'discoveryAnnounceRate' field"))
	}
	m.DiscoveryAnnounceRate = discoveryAnnounceRate

	topic, err := ReadSimpleField[PascalString](ctx, "topic", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'topic' field"))
	}
	m.Topic = topic

	if closeErr := readBuffer.CloseContext("DatagramWriterGroupTransport2DataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DatagramWriterGroupTransport2DataType")
	}

	return m, nil
}

func (m *_DatagramWriterGroupTransport2DataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DatagramWriterGroupTransport2DataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DatagramWriterGroupTransport2DataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DatagramWriterGroupTransport2DataType")
		}

		if err := WriteSimpleField[uint8](ctx, "messageRepeatCount", m.GetMessageRepeatCount(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageRepeatCount' field")
		}

		if err := WriteSimpleField[float64](ctx, "messageRepeatDelay", m.GetMessageRepeatDelay(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageRepeatDelay' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "address", m.GetAddress(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'address' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "qosCategory", m.GetQosCategory(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'qosCategory' field")
		}
		noOfDatagramQos := int32(utils.InlineIf(bool((m.GetDatagramQos()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetDatagramQos()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfDatagramQos", noOfDatagramQos, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfDatagramQos' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "datagramQos", m.GetDatagramQos(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'datagramQos' field")
		}

		if err := WriteSimpleField[uint32](ctx, "discoveryAnnounceRate", m.GetDiscoveryAnnounceRate(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'discoveryAnnounceRate' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "topic", m.GetTopic(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'topic' field")
		}

		if popErr := writeBuffer.PopContext("DatagramWriterGroupTransport2DataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DatagramWriterGroupTransport2DataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DatagramWriterGroupTransport2DataType) IsDatagramWriterGroupTransport2DataType() {}

func (m *_DatagramWriterGroupTransport2DataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DatagramWriterGroupTransport2DataType) deepCopy() *_DatagramWriterGroupTransport2DataType {
	if m == nil {
		return nil
	}
	_DatagramWriterGroupTransport2DataTypeCopy := &_DatagramWriterGroupTransport2DataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.MessageRepeatCount,
		m.MessageRepeatDelay,
		utils.DeepCopy[ExtensionObject](m.Address),
		utils.DeepCopy[PascalString](m.QosCategory),
		utils.DeepCopySlice[ExtensionObject, ExtensionObject](m.DatagramQos),
		m.DiscoveryAnnounceRate,
		utils.DeepCopy[PascalString](m.Topic),
	}
	_DatagramWriterGroupTransport2DataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DatagramWriterGroupTransport2DataTypeCopy
}

func (m *_DatagramWriterGroupTransport2DataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
