/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DataValue is the corresponding interface of DataValue
type DataValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetServerPicosecondsSpecified returns ServerPicosecondsSpecified (property field)
	GetServerPicosecondsSpecified() bool
	// GetSourcePicosecondsSpecified returns SourcePicosecondsSpecified (property field)
	GetSourcePicosecondsSpecified() bool
	// GetServerTimestampSpecified returns ServerTimestampSpecified (property field)
	GetServerTimestampSpecified() bool
	// GetSourceTimestampSpecified returns SourceTimestampSpecified (property field)
	GetSourceTimestampSpecified() bool
	// GetStatusCodeSpecified returns StatusCodeSpecified (property field)
	GetStatusCodeSpecified() bool
	// GetValueSpecified returns ValueSpecified (property field)
	GetValueSpecified() bool
	// GetValue returns Value (property field)
	GetValue() Variant
	// GetStatusCode returns StatusCode (property field)
	GetStatusCode() StatusCode
	// GetSourceTimestamp returns SourceTimestamp (property field)
	GetSourceTimestamp() *int64
	// GetSourcePicoseconds returns SourcePicoseconds (property field)
	GetSourcePicoseconds() *uint16
	// GetServerTimestamp returns ServerTimestamp (property field)
	GetServerTimestamp() *int64
	// GetServerPicoseconds returns ServerPicoseconds (property field)
	GetServerPicoseconds() *uint16
	// IsDataValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDataValue()
	// CreateBuilder creates a DataValueBuilder
	CreateDataValueBuilder() DataValueBuilder
}

// _DataValue is the data-structure of this message
type _DataValue struct {
	ServerPicosecondsSpecified bool
	SourcePicosecondsSpecified bool
	ServerTimestampSpecified   bool
	SourceTimestampSpecified   bool
	StatusCodeSpecified        bool
	ValueSpecified             bool
	Value                      Variant
	StatusCode                 StatusCode
	SourceTimestamp            *int64
	SourcePicoseconds          *uint16
	ServerTimestamp            *int64
	ServerPicoseconds          *uint16
	// Reserved Fields
	reservedField0 *uint8
}

var _ DataValue = (*_DataValue)(nil)

// NewDataValue factory function for _DataValue
func NewDataValue(serverPicosecondsSpecified bool, sourcePicosecondsSpecified bool, serverTimestampSpecified bool, sourceTimestampSpecified bool, statusCodeSpecified bool, valueSpecified bool, value Variant, statusCode StatusCode, sourceTimestamp *int64, sourcePicoseconds *uint16, serverTimestamp *int64, serverPicoseconds *uint16) *_DataValue {
	return &_DataValue{ServerPicosecondsSpecified: serverPicosecondsSpecified, SourcePicosecondsSpecified: sourcePicosecondsSpecified, ServerTimestampSpecified: serverTimestampSpecified, SourceTimestampSpecified: sourceTimestampSpecified, StatusCodeSpecified: statusCodeSpecified, ValueSpecified: valueSpecified, Value: value, StatusCode: statusCode, SourceTimestamp: sourceTimestamp, SourcePicoseconds: sourcePicoseconds, ServerTimestamp: serverTimestamp, ServerPicoseconds: serverPicoseconds}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DataValueBuilder is a builder for DataValue
type DataValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(serverPicosecondsSpecified bool, sourcePicosecondsSpecified bool, serverTimestampSpecified bool, sourceTimestampSpecified bool, statusCodeSpecified bool, valueSpecified bool) DataValueBuilder
	// WithServerPicosecondsSpecified adds ServerPicosecondsSpecified (property field)
	WithServerPicosecondsSpecified(bool) DataValueBuilder
	// WithSourcePicosecondsSpecified adds SourcePicosecondsSpecified (property field)
	WithSourcePicosecondsSpecified(bool) DataValueBuilder
	// WithServerTimestampSpecified adds ServerTimestampSpecified (property field)
	WithServerTimestampSpecified(bool) DataValueBuilder
	// WithSourceTimestampSpecified adds SourceTimestampSpecified (property field)
	WithSourceTimestampSpecified(bool) DataValueBuilder
	// WithStatusCodeSpecified adds StatusCodeSpecified (property field)
	WithStatusCodeSpecified(bool) DataValueBuilder
	// WithValueSpecified adds ValueSpecified (property field)
	WithValueSpecified(bool) DataValueBuilder
	// WithValue adds Value (property field)
	WithOptionalValue(Variant) DataValueBuilder
	// WithOptionalValueBuilder adds Value (property field) which is build by the builder
	WithOptionalValueBuilder(func(VariantBuilder) VariantBuilder) DataValueBuilder
	// WithStatusCode adds StatusCode (property field)
	WithOptionalStatusCode(StatusCode) DataValueBuilder
	// WithOptionalStatusCodeBuilder adds StatusCode (property field) which is build by the builder
	WithOptionalStatusCodeBuilder(func(StatusCodeBuilder) StatusCodeBuilder) DataValueBuilder
	// WithSourceTimestamp adds SourceTimestamp (property field)
	WithOptionalSourceTimestamp(int64) DataValueBuilder
	// WithSourcePicoseconds adds SourcePicoseconds (property field)
	WithOptionalSourcePicoseconds(uint16) DataValueBuilder
	// WithServerTimestamp adds ServerTimestamp (property field)
	WithOptionalServerTimestamp(int64) DataValueBuilder
	// WithServerPicoseconds adds ServerPicoseconds (property field)
	WithOptionalServerPicoseconds(uint16) DataValueBuilder
	// Build builds the DataValue or returns an error if something is wrong
	Build() (DataValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DataValue
}

// NewDataValueBuilder() creates a DataValueBuilder
func NewDataValueBuilder() DataValueBuilder {
	return &_DataValueBuilder{_DataValue: new(_DataValue)}
}

type _DataValueBuilder struct {
	*_DataValue

	err *utils.MultiError
}

var _ (DataValueBuilder) = (*_DataValueBuilder)(nil)

func (b *_DataValueBuilder) WithMandatoryFields(serverPicosecondsSpecified bool, sourcePicosecondsSpecified bool, serverTimestampSpecified bool, sourceTimestampSpecified bool, statusCodeSpecified bool, valueSpecified bool) DataValueBuilder {
	return b.WithServerPicosecondsSpecified(serverPicosecondsSpecified).WithSourcePicosecondsSpecified(sourcePicosecondsSpecified).WithServerTimestampSpecified(serverTimestampSpecified).WithSourceTimestampSpecified(sourceTimestampSpecified).WithStatusCodeSpecified(statusCodeSpecified).WithValueSpecified(valueSpecified)
}

func (b *_DataValueBuilder) WithServerPicosecondsSpecified(serverPicosecondsSpecified bool) DataValueBuilder {
	b.ServerPicosecondsSpecified = serverPicosecondsSpecified
	return b
}

func (b *_DataValueBuilder) WithSourcePicosecondsSpecified(sourcePicosecondsSpecified bool) DataValueBuilder {
	b.SourcePicosecondsSpecified = sourcePicosecondsSpecified
	return b
}

func (b *_DataValueBuilder) WithServerTimestampSpecified(serverTimestampSpecified bool) DataValueBuilder {
	b.ServerTimestampSpecified = serverTimestampSpecified
	return b
}

func (b *_DataValueBuilder) WithSourceTimestampSpecified(sourceTimestampSpecified bool) DataValueBuilder {
	b.SourceTimestampSpecified = sourceTimestampSpecified
	return b
}

func (b *_DataValueBuilder) WithStatusCodeSpecified(statusCodeSpecified bool) DataValueBuilder {
	b.StatusCodeSpecified = statusCodeSpecified
	return b
}

func (b *_DataValueBuilder) WithValueSpecified(valueSpecified bool) DataValueBuilder {
	b.ValueSpecified = valueSpecified
	return b
}

func (b *_DataValueBuilder) WithOptionalValue(value Variant) DataValueBuilder {
	b.Value = value
	return b
}

func (b *_DataValueBuilder) WithOptionalValueBuilder(builderSupplier func(VariantBuilder) VariantBuilder) DataValueBuilder {
	builder := builderSupplier(b.Value.CreateVariantBuilder())
	var err error
	b.Value, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_DataValueBuilder) WithOptionalStatusCode(statusCode StatusCode) DataValueBuilder {
	b.StatusCode = statusCode
	return b
}

func (b *_DataValueBuilder) WithOptionalStatusCodeBuilder(builderSupplier func(StatusCodeBuilder) StatusCodeBuilder) DataValueBuilder {
	builder := builderSupplier(b.StatusCode.CreateStatusCodeBuilder())
	var err error
	b.StatusCode, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "StatusCodeBuilder failed"))
	}
	return b
}

func (b *_DataValueBuilder) WithOptionalSourceTimestamp(sourceTimestamp int64) DataValueBuilder {
	b.SourceTimestamp = &sourceTimestamp
	return b
}

func (b *_DataValueBuilder) WithOptionalSourcePicoseconds(sourcePicoseconds uint16) DataValueBuilder {
	b.SourcePicoseconds = &sourcePicoseconds
	return b
}

func (b *_DataValueBuilder) WithOptionalServerTimestamp(serverTimestamp int64) DataValueBuilder {
	b.ServerTimestamp = &serverTimestamp
	return b
}

func (b *_DataValueBuilder) WithOptionalServerPicoseconds(serverPicoseconds uint16) DataValueBuilder {
	b.ServerPicoseconds = &serverPicoseconds
	return b
}

func (b *_DataValueBuilder) Build() (DataValue, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._DataValue.deepCopy(), nil
}

func (b *_DataValueBuilder) MustBuild() DataValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DataValueBuilder) DeepCopy() any {
	_copy := b.CreateDataValueBuilder().(*_DataValueBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateDataValueBuilder creates a DataValueBuilder
func (b *_DataValue) CreateDataValueBuilder() DataValueBuilder {
	if b == nil {
		return NewDataValueBuilder()
	}
	return &_DataValueBuilder{_DataValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DataValue) GetServerPicosecondsSpecified() bool {
	return m.ServerPicosecondsSpecified
}

func (m *_DataValue) GetSourcePicosecondsSpecified() bool {
	return m.SourcePicosecondsSpecified
}

func (m *_DataValue) GetServerTimestampSpecified() bool {
	return m.ServerTimestampSpecified
}

func (m *_DataValue) GetSourceTimestampSpecified() bool {
	return m.SourceTimestampSpecified
}

func (m *_DataValue) GetStatusCodeSpecified() bool {
	return m.StatusCodeSpecified
}

func (m *_DataValue) GetValueSpecified() bool {
	return m.ValueSpecified
}

func (m *_DataValue) GetValue() Variant {
	return m.Value
}

func (m *_DataValue) GetStatusCode() StatusCode {
	return m.StatusCode
}

func (m *_DataValue) GetSourceTimestamp() *int64 {
	return m.SourceTimestamp
}

func (m *_DataValue) GetSourcePicoseconds() *uint16 {
	return m.SourcePicoseconds
}

func (m *_DataValue) GetServerTimestamp() *int64 {
	return m.ServerTimestamp
}

func (m *_DataValue) GetServerPicoseconds() *uint16 {
	return m.ServerPicoseconds
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDataValue(structType any) DataValue {
	if casted, ok := structType.(DataValue); ok {
		return casted
	}
	if casted, ok := structType.(*DataValue); ok {
		return *casted
	}
	return nil
}

func (m *_DataValue) GetTypeName() string {
	return "DataValue"
}

func (m *_DataValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 2

	// Simple field (serverPicosecondsSpecified)
	lengthInBits += 1

	// Simple field (sourcePicosecondsSpecified)
	lengthInBits += 1

	// Simple field (serverTimestampSpecified)
	lengthInBits += 1

	// Simple field (sourceTimestampSpecified)
	lengthInBits += 1

	// Simple field (statusCodeSpecified)
	lengthInBits += 1

	// Simple field (valueSpecified)
	lengthInBits += 1

	// Optional Field (value)
	if m.Value != nil {
		lengthInBits += m.Value.GetLengthInBits(ctx)
	}

	// Optional Field (statusCode)
	if m.StatusCode != nil {
		lengthInBits += m.StatusCode.GetLengthInBits(ctx)
	}

	// Optional Field (sourceTimestamp)
	if m.SourceTimestamp != nil {
		lengthInBits += 64
	}

	// Optional Field (sourcePicoseconds)
	if m.SourcePicoseconds != nil {
		lengthInBits += 16
	}

	// Optional Field (serverTimestamp)
	if m.ServerTimestamp != nil {
		lengthInBits += 64
	}

	// Optional Field (serverPicoseconds)
	if m.ServerPicoseconds != nil {
		lengthInBits += 16
	}

	return lengthInBits
}

func (m *_DataValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DataValueParse(ctx context.Context, theBytes []byte) (DataValue, error) {
	return DataValueParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func DataValueParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (DataValue, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (DataValue, error) {
		return DataValueParseWithBuffer(ctx, readBuffer)
	}
}

func DataValueParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (DataValue, error) {
	v, err := (&_DataValue{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_DataValue) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__dataValue DataValue, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DataValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(2)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	serverPicosecondsSpecified, err := ReadSimpleField(ctx, "serverPicosecondsSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverPicosecondsSpecified' field"))
	}
	m.ServerPicosecondsSpecified = serverPicosecondsSpecified

	sourcePicosecondsSpecified, err := ReadSimpleField(ctx, "sourcePicosecondsSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sourcePicosecondsSpecified' field"))
	}
	m.SourcePicosecondsSpecified = sourcePicosecondsSpecified

	serverTimestampSpecified, err := ReadSimpleField(ctx, "serverTimestampSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverTimestampSpecified' field"))
	}
	m.ServerTimestampSpecified = serverTimestampSpecified

	sourceTimestampSpecified, err := ReadSimpleField(ctx, "sourceTimestampSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sourceTimestampSpecified' field"))
	}
	m.SourceTimestampSpecified = sourceTimestampSpecified

	statusCodeSpecified, err := ReadSimpleField(ctx, "statusCodeSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'statusCodeSpecified' field"))
	}
	m.StatusCodeSpecified = statusCodeSpecified

	valueSpecified, err := ReadSimpleField(ctx, "valueSpecified", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'valueSpecified' field"))
	}
	m.ValueSpecified = valueSpecified

	var value Variant
	_value, err := ReadOptionalField[Variant](ctx, "value", ReadComplex[Variant](VariantParseWithBuffer, readBuffer), valueSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	if _value != nil {
		value = *_value
		m.Value = value
	}

	var statusCode StatusCode
	_statusCode, err := ReadOptionalField[StatusCode](ctx, "statusCode", ReadComplex[StatusCode](StatusCodeParseWithBuffer, readBuffer), statusCodeSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'statusCode' field"))
	}
	if _statusCode != nil {
		statusCode = *_statusCode
		m.StatusCode = statusCode
	}

	var sourceTimestamp *int64
	sourceTimestamp, err = ReadOptionalField[int64](ctx, "sourceTimestamp", ReadSignedLong(readBuffer, uint8(64)), sourceTimestampSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sourceTimestamp' field"))
	}
	m.SourceTimestamp = sourceTimestamp

	var sourcePicoseconds *uint16
	sourcePicoseconds, err = ReadOptionalField[uint16](ctx, "sourcePicoseconds", ReadUnsignedShort(readBuffer, uint8(16)), sourcePicosecondsSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sourcePicoseconds' field"))
	}
	m.SourcePicoseconds = sourcePicoseconds

	var serverTimestamp *int64
	serverTimestamp, err = ReadOptionalField[int64](ctx, "serverTimestamp", ReadSignedLong(readBuffer, uint8(64)), serverTimestampSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverTimestamp' field"))
	}
	m.ServerTimestamp = serverTimestamp

	var serverPicoseconds *uint16
	serverPicoseconds, err = ReadOptionalField[uint16](ctx, "serverPicoseconds", ReadUnsignedShort(readBuffer, uint8(16)), serverPicosecondsSpecified)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serverPicoseconds' field"))
	}
	m.ServerPicoseconds = serverPicoseconds

	if closeErr := readBuffer.CloseContext("DataValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataValue")
	}

	return m, nil
}

func (m *_DataValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("DataValue"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for DataValue")
	}

	if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 2)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 1")
	}

	if err := WriteSimpleField[bool](ctx, "serverPicosecondsSpecified", m.GetServerPicosecondsSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'serverPicosecondsSpecified' field")
	}

	if err := WriteSimpleField[bool](ctx, "sourcePicosecondsSpecified", m.GetSourcePicosecondsSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'sourcePicosecondsSpecified' field")
	}

	if err := WriteSimpleField[bool](ctx, "serverTimestampSpecified", m.GetServerTimestampSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'serverTimestampSpecified' field")
	}

	if err := WriteSimpleField[bool](ctx, "sourceTimestampSpecified", m.GetSourceTimestampSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'sourceTimestampSpecified' field")
	}

	if err := WriteSimpleField[bool](ctx, "statusCodeSpecified", m.GetStatusCodeSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'statusCodeSpecified' field")
	}

	if err := WriteSimpleField[bool](ctx, "valueSpecified", m.GetValueSpecified(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'valueSpecified' field")
	}

	if err := WriteOptionalField[Variant](ctx, "value", GetRef(m.GetValue()), WriteComplex[Variant](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if err := WriteOptionalField[StatusCode](ctx, "statusCode", GetRef(m.GetStatusCode()), WriteComplex[StatusCode](writeBuffer), true); err != nil {
		return errors.Wrap(err, "Error serializing 'statusCode' field")
	}

	if err := WriteOptionalField[int64](ctx, "sourceTimestamp", m.GetSourceTimestamp(), WriteSignedLong(writeBuffer, 64), true); err != nil {
		return errors.Wrap(err, "Error serializing 'sourceTimestamp' field")
	}

	if err := WriteOptionalField[uint16](ctx, "sourcePicoseconds", m.GetSourcePicoseconds(), WriteUnsignedShort(writeBuffer, 16), true); err != nil {
		return errors.Wrap(err, "Error serializing 'sourcePicoseconds' field")
	}

	if err := WriteOptionalField[int64](ctx, "serverTimestamp", m.GetServerTimestamp(), WriteSignedLong(writeBuffer, 64), true); err != nil {
		return errors.Wrap(err, "Error serializing 'serverTimestamp' field")
	}

	if err := WriteOptionalField[uint16](ctx, "serverPicoseconds", m.GetServerPicoseconds(), WriteUnsignedShort(writeBuffer, 16), true); err != nil {
		return errors.Wrap(err, "Error serializing 'serverPicoseconds' field")
	}

	if popErr := writeBuffer.PopContext("DataValue"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for DataValue")
	}
	return nil
}

func (m *_DataValue) IsDataValue() {}

func (m *_DataValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DataValue) deepCopy() *_DataValue {
	if m == nil {
		return nil
	}
	_DataValueCopy := &_DataValue{
		m.ServerPicosecondsSpecified,
		m.SourcePicosecondsSpecified,
		m.ServerTimestampSpecified,
		m.SourceTimestampSpecified,
		m.StatusCodeSpecified,
		m.ValueSpecified,
		utils.DeepCopy[Variant](m.Value),
		utils.DeepCopy[StatusCode](m.StatusCode),
		utils.CopyPtr[int64](m.SourceTimestamp),
		utils.CopyPtr[uint16](m.SourcePicoseconds),
		utils.CopyPtr[int64](m.ServerTimestamp),
		utils.CopyPtr[uint16](m.ServerPicoseconds),
		m.reservedField0,
	}
	return _DataValueCopy
}

func (m *_DataValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
