/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DataTypeDescription is the corresponding interface of DataTypeDescription
type DataTypeDescription interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetDataTypeId returns DataTypeId (property field)
	GetDataTypeId() NodeId
	// GetName returns Name (property field)
	GetName() QualifiedName
	// IsDataTypeDescription is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDataTypeDescription()
	// CreateBuilder creates a DataTypeDescriptionBuilder
	CreateDataTypeDescriptionBuilder() DataTypeDescriptionBuilder
}

// _DataTypeDescription is the data-structure of this message
type _DataTypeDescription struct {
	ExtensionObjectDefinitionContract
	DataTypeId NodeId
	Name       QualifiedName
}

var _ DataTypeDescription = (*_DataTypeDescription)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DataTypeDescription)(nil)

// NewDataTypeDescription factory function for _DataTypeDescription
func NewDataTypeDescription(dataTypeId NodeId, name QualifiedName) *_DataTypeDescription {
	if dataTypeId == nil {
		panic("dataTypeId of type NodeId for DataTypeDescription must not be nil")
	}
	if name == nil {
		panic("name of type QualifiedName for DataTypeDescription must not be nil")
	}
	_result := &_DataTypeDescription{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		DataTypeId:                        dataTypeId,
		Name:                              name,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DataTypeDescriptionBuilder is a builder for DataTypeDescription
type DataTypeDescriptionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dataTypeId NodeId, name QualifiedName) DataTypeDescriptionBuilder
	// WithDataTypeId adds DataTypeId (property field)
	WithDataTypeId(NodeId) DataTypeDescriptionBuilder
	// WithDataTypeIdBuilder adds DataTypeId (property field) which is build by the builder
	WithDataTypeIdBuilder(func(NodeIdBuilder) NodeIdBuilder) DataTypeDescriptionBuilder
	// WithName adds Name (property field)
	WithName(QualifiedName) DataTypeDescriptionBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(QualifiedNameBuilder) QualifiedNameBuilder) DataTypeDescriptionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DataTypeDescription or returns an error if something is wrong
	Build() (DataTypeDescription, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DataTypeDescription
}

// NewDataTypeDescriptionBuilder() creates a DataTypeDescriptionBuilder
func NewDataTypeDescriptionBuilder() DataTypeDescriptionBuilder {
	return &_DataTypeDescriptionBuilder{_DataTypeDescription: new(_DataTypeDescription)}
}

type _DataTypeDescriptionBuilder struct {
	*_DataTypeDescription

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (DataTypeDescriptionBuilder) = (*_DataTypeDescriptionBuilder)(nil)

func (b *_DataTypeDescriptionBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DataTypeDescription
}

func (b *_DataTypeDescriptionBuilder) WithMandatoryFields(dataTypeId NodeId, name QualifiedName) DataTypeDescriptionBuilder {
	return b.WithDataTypeId(dataTypeId).WithName(name)
}

func (b *_DataTypeDescriptionBuilder) WithDataTypeId(dataTypeId NodeId) DataTypeDescriptionBuilder {
	b.DataTypeId = dataTypeId
	return b
}

func (b *_DataTypeDescriptionBuilder) WithDataTypeIdBuilder(builderSupplier func(NodeIdBuilder) NodeIdBuilder) DataTypeDescriptionBuilder {
	builder := builderSupplier(b.DataTypeId.CreateNodeIdBuilder())
	var err error
	b.DataTypeId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NodeIdBuilder failed"))
	}
	return b
}

func (b *_DataTypeDescriptionBuilder) WithName(name QualifiedName) DataTypeDescriptionBuilder {
	b.Name = name
	return b
}

func (b *_DataTypeDescriptionBuilder) WithNameBuilder(builderSupplier func(QualifiedNameBuilder) QualifiedNameBuilder) DataTypeDescriptionBuilder {
	builder := builderSupplier(b.Name.CreateQualifiedNameBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "QualifiedNameBuilder failed"))
	}
	return b
}

func (b *_DataTypeDescriptionBuilder) Build() (DataTypeDescription, error) {
	if b.DataTypeId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dataTypeId' not set"))
	}
	if b.Name == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'name' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._DataTypeDescription.deepCopy(), nil
}

func (b *_DataTypeDescriptionBuilder) MustBuild() DataTypeDescription {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DataTypeDescriptionBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DataTypeDescriptionBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DataTypeDescriptionBuilder) DeepCopy() any {
	_copy := b.CreateDataTypeDescriptionBuilder().(*_DataTypeDescriptionBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateDataTypeDescriptionBuilder creates a DataTypeDescriptionBuilder
func (b *_DataTypeDescription) CreateDataTypeDescriptionBuilder() DataTypeDescriptionBuilder {
	if b == nil {
		return NewDataTypeDescriptionBuilder()
	}
	return &_DataTypeDescriptionBuilder{_DataTypeDescription: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DataTypeDescription) GetExtensionId() int32 {
	return int32(14527)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DataTypeDescription) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DataTypeDescription) GetDataTypeId() NodeId {
	return m.DataTypeId
}

func (m *_DataTypeDescription) GetName() QualifiedName {
	return m.Name
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDataTypeDescription(structType any) DataTypeDescription {
	if casted, ok := structType.(DataTypeDescription); ok {
		return casted
	}
	if casted, ok := structType.(*DataTypeDescription); ok {
		return *casted
	}
	return nil
}

func (m *_DataTypeDescription) GetTypeName() string {
	return "DataTypeDescription"
}

func (m *_DataTypeDescription) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (dataTypeId)
	lengthInBits += m.DataTypeId.GetLengthInBits(ctx)

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_DataTypeDescription) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DataTypeDescription) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__dataTypeDescription DataTypeDescription, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DataTypeDescription"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataTypeDescription")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dataTypeId, err := ReadSimpleField[NodeId](ctx, "dataTypeId", ReadComplex[NodeId](NodeIdParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataTypeId' field"))
	}
	m.DataTypeId = dataTypeId

	name, err := ReadSimpleField[QualifiedName](ctx, "name", ReadComplex[QualifiedName](QualifiedNameParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	if closeErr := readBuffer.CloseContext("DataTypeDescription"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataTypeDescription")
	}

	return m, nil
}

func (m *_DataTypeDescription) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataTypeDescription) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DataTypeDescription"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DataTypeDescription")
		}

		if err := WriteSimpleField[NodeId](ctx, "dataTypeId", m.GetDataTypeId(), WriteComplex[NodeId](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataTypeId' field")
		}

		if err := WriteSimpleField[QualifiedName](ctx, "name", m.GetName(), WriteComplex[QualifiedName](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}

		if popErr := writeBuffer.PopContext("DataTypeDescription"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DataTypeDescription")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DataTypeDescription) IsDataTypeDescription() {}

func (m *_DataTypeDescription) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DataTypeDescription) deepCopy() *_DataTypeDescription {
	if m == nil {
		return nil
	}
	_DataTypeDescriptionCopy := &_DataTypeDescription{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[NodeId](m.DataTypeId),
		utils.DeepCopy[QualifiedName](m.Name),
	}
	_DataTypeDescriptionCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DataTypeDescriptionCopy
}

func (m *_DataTypeDescription) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
