/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// DataSetReaderDataType is the corresponding interface of DataSetReaderDataType
type DataSetReaderDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetEnabled returns Enabled (property field)
	GetEnabled() bool
	// GetPublisherId returns PublisherId (property field)
	GetPublisherId() Variant
	// GetWriterGroupId returns WriterGroupId (property field)
	GetWriterGroupId() uint16
	// GetDataSetWriterId returns DataSetWriterId (property field)
	GetDataSetWriterId() uint16
	// GetDataSetMetaData returns DataSetMetaData (property field)
	GetDataSetMetaData() DataSetMetaDataType
	// GetDataSetFieldContentMask returns DataSetFieldContentMask (property field)
	GetDataSetFieldContentMask() DataSetFieldContentMask
	// GetMessageReceiveTimeout returns MessageReceiveTimeout (property field)
	GetMessageReceiveTimeout() float64
	// GetKeyFrameCount returns KeyFrameCount (property field)
	GetKeyFrameCount() uint32
	// GetHeaderLayoutUri returns HeaderLayoutUri (property field)
	GetHeaderLayoutUri() PascalString
	// GetSecurityMode returns SecurityMode (property field)
	GetSecurityMode() MessageSecurityMode
	// GetSecurityGroupId returns SecurityGroupId (property field)
	GetSecurityGroupId() PascalString
	// GetSecurityKeyServices returns SecurityKeyServices (property field)
	GetSecurityKeyServices() []EndpointDescription
	// GetDataSetReaderProperties returns DataSetReaderProperties (property field)
	GetDataSetReaderProperties() []KeyValuePair
	// GetTransportSettings returns TransportSettings (property field)
	GetTransportSettings() ExtensionObject
	// GetMessageSettings returns MessageSettings (property field)
	GetMessageSettings() ExtensionObject
	// GetSubscribedDataSet returns SubscribedDataSet (property field)
	GetSubscribedDataSet() ExtensionObject
	// IsDataSetReaderDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsDataSetReaderDataType()
	// CreateBuilder creates a DataSetReaderDataTypeBuilder
	CreateDataSetReaderDataTypeBuilder() DataSetReaderDataTypeBuilder
}

// _DataSetReaderDataType is the data-structure of this message
type _DataSetReaderDataType struct {
	ExtensionObjectDefinitionContract
	Name                    PascalString
	Enabled                 bool
	PublisherId             Variant
	WriterGroupId           uint16
	DataSetWriterId         uint16
	DataSetMetaData         DataSetMetaDataType
	DataSetFieldContentMask DataSetFieldContentMask
	MessageReceiveTimeout   float64
	KeyFrameCount           uint32
	HeaderLayoutUri         PascalString
	SecurityMode            MessageSecurityMode
	SecurityGroupId         PascalString
	SecurityKeyServices     []EndpointDescription
	DataSetReaderProperties []KeyValuePair
	TransportSettings       ExtensionObject
	MessageSettings         ExtensionObject
	SubscribedDataSet       ExtensionObject
	// Reserved Fields
	reservedField0 *uint8
}

var _ DataSetReaderDataType = (*_DataSetReaderDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_DataSetReaderDataType)(nil)

// NewDataSetReaderDataType factory function for _DataSetReaderDataType
func NewDataSetReaderDataType(name PascalString, enabled bool, publisherId Variant, writerGroupId uint16, dataSetWriterId uint16, dataSetMetaData DataSetMetaDataType, dataSetFieldContentMask DataSetFieldContentMask, messageReceiveTimeout float64, keyFrameCount uint32, headerLayoutUri PascalString, securityMode MessageSecurityMode, securityGroupId PascalString, securityKeyServices []EndpointDescription, dataSetReaderProperties []KeyValuePair, transportSettings ExtensionObject, messageSettings ExtensionObject, subscribedDataSet ExtensionObject) *_DataSetReaderDataType {
	if name == nil {
		panic("name of type PascalString for DataSetReaderDataType must not be nil")
	}
	if publisherId == nil {
		panic("publisherId of type Variant for DataSetReaderDataType must not be nil")
	}
	if dataSetMetaData == nil {
		panic("dataSetMetaData of type DataSetMetaDataType for DataSetReaderDataType must not be nil")
	}
	if headerLayoutUri == nil {
		panic("headerLayoutUri of type PascalString for DataSetReaderDataType must not be nil")
	}
	if securityGroupId == nil {
		panic("securityGroupId of type PascalString for DataSetReaderDataType must not be nil")
	}
	if transportSettings == nil {
		panic("transportSettings of type ExtensionObject for DataSetReaderDataType must not be nil")
	}
	if messageSettings == nil {
		panic("messageSettings of type ExtensionObject for DataSetReaderDataType must not be nil")
	}
	if subscribedDataSet == nil {
		panic("subscribedDataSet of type ExtensionObject for DataSetReaderDataType must not be nil")
	}
	_result := &_DataSetReaderDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		Enabled:                           enabled,
		PublisherId:                       publisherId,
		WriterGroupId:                     writerGroupId,
		DataSetWriterId:                   dataSetWriterId,
		DataSetMetaData:                   dataSetMetaData,
		DataSetFieldContentMask:           dataSetFieldContentMask,
		MessageReceiveTimeout:             messageReceiveTimeout,
		KeyFrameCount:                     keyFrameCount,
		HeaderLayoutUri:                   headerLayoutUri,
		SecurityMode:                      securityMode,
		SecurityGroupId:                   securityGroupId,
		SecurityKeyServices:               securityKeyServices,
		DataSetReaderProperties:           dataSetReaderProperties,
		TransportSettings:                 transportSettings,
		MessageSettings:                   messageSettings,
		SubscribedDataSet:                 subscribedDataSet,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// DataSetReaderDataTypeBuilder is a builder for DataSetReaderDataType
type DataSetReaderDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, enabled bool, publisherId Variant, writerGroupId uint16, dataSetWriterId uint16, dataSetMetaData DataSetMetaDataType, dataSetFieldContentMask DataSetFieldContentMask, messageReceiveTimeout float64, keyFrameCount uint32, headerLayoutUri PascalString, securityMode MessageSecurityMode, securityGroupId PascalString, securityKeyServices []EndpointDescription, dataSetReaderProperties []KeyValuePair, transportSettings ExtensionObject, messageSettings ExtensionObject, subscribedDataSet ExtensionObject) DataSetReaderDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) DataSetReaderDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) DataSetReaderDataTypeBuilder
	// WithEnabled adds Enabled (property field)
	WithEnabled(bool) DataSetReaderDataTypeBuilder
	// WithPublisherId adds PublisherId (property field)
	WithPublisherId(Variant) DataSetReaderDataTypeBuilder
	// WithPublisherIdBuilder adds PublisherId (property field) which is build by the builder
	WithPublisherIdBuilder(func(VariantBuilder) VariantBuilder) DataSetReaderDataTypeBuilder
	// WithWriterGroupId adds WriterGroupId (property field)
	WithWriterGroupId(uint16) DataSetReaderDataTypeBuilder
	// WithDataSetWriterId adds DataSetWriterId (property field)
	WithDataSetWriterId(uint16) DataSetReaderDataTypeBuilder
	// WithDataSetMetaData adds DataSetMetaData (property field)
	WithDataSetMetaData(DataSetMetaDataType) DataSetReaderDataTypeBuilder
	// WithDataSetMetaDataBuilder adds DataSetMetaData (property field) which is build by the builder
	WithDataSetMetaDataBuilder(func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) DataSetReaderDataTypeBuilder
	// WithDataSetFieldContentMask adds DataSetFieldContentMask (property field)
	WithDataSetFieldContentMask(DataSetFieldContentMask) DataSetReaderDataTypeBuilder
	// WithMessageReceiveTimeout adds MessageReceiveTimeout (property field)
	WithMessageReceiveTimeout(float64) DataSetReaderDataTypeBuilder
	// WithKeyFrameCount adds KeyFrameCount (property field)
	WithKeyFrameCount(uint32) DataSetReaderDataTypeBuilder
	// WithHeaderLayoutUri adds HeaderLayoutUri (property field)
	WithHeaderLayoutUri(PascalString) DataSetReaderDataTypeBuilder
	// WithHeaderLayoutUriBuilder adds HeaderLayoutUri (property field) which is build by the builder
	WithHeaderLayoutUriBuilder(func(PascalStringBuilder) PascalStringBuilder) DataSetReaderDataTypeBuilder
	// WithSecurityMode adds SecurityMode (property field)
	WithSecurityMode(MessageSecurityMode) DataSetReaderDataTypeBuilder
	// WithSecurityGroupId adds SecurityGroupId (property field)
	WithSecurityGroupId(PascalString) DataSetReaderDataTypeBuilder
	// WithSecurityGroupIdBuilder adds SecurityGroupId (property field) which is build by the builder
	WithSecurityGroupIdBuilder(func(PascalStringBuilder) PascalStringBuilder) DataSetReaderDataTypeBuilder
	// WithSecurityKeyServices adds SecurityKeyServices (property field)
	WithSecurityKeyServices(...EndpointDescription) DataSetReaderDataTypeBuilder
	// WithDataSetReaderProperties adds DataSetReaderProperties (property field)
	WithDataSetReaderProperties(...KeyValuePair) DataSetReaderDataTypeBuilder
	// WithTransportSettings adds TransportSettings (property field)
	WithTransportSettings(ExtensionObject) DataSetReaderDataTypeBuilder
	// WithTransportSettingsBuilder adds TransportSettings (property field) which is build by the builder
	WithTransportSettingsBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) DataSetReaderDataTypeBuilder
	// WithMessageSettings adds MessageSettings (property field)
	WithMessageSettings(ExtensionObject) DataSetReaderDataTypeBuilder
	// WithMessageSettingsBuilder adds MessageSettings (property field) which is build by the builder
	WithMessageSettingsBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) DataSetReaderDataTypeBuilder
	// WithSubscribedDataSet adds SubscribedDataSet (property field)
	WithSubscribedDataSet(ExtensionObject) DataSetReaderDataTypeBuilder
	// WithSubscribedDataSetBuilder adds SubscribedDataSet (property field) which is build by the builder
	WithSubscribedDataSetBuilder(func(ExtensionObjectBuilder) ExtensionObjectBuilder) DataSetReaderDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the DataSetReaderDataType or returns an error if something is wrong
	Build() (DataSetReaderDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() DataSetReaderDataType
}

// NewDataSetReaderDataTypeBuilder() creates a DataSetReaderDataTypeBuilder
func NewDataSetReaderDataTypeBuilder() DataSetReaderDataTypeBuilder {
	return &_DataSetReaderDataTypeBuilder{_DataSetReaderDataType: new(_DataSetReaderDataType)}
}

type _DataSetReaderDataTypeBuilder struct {
	*_DataSetReaderDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (DataSetReaderDataTypeBuilder) = (*_DataSetReaderDataTypeBuilder)(nil)

func (b *_DataSetReaderDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._DataSetReaderDataType
}

func (b *_DataSetReaderDataTypeBuilder) WithMandatoryFields(name PascalString, enabled bool, publisherId Variant, writerGroupId uint16, dataSetWriterId uint16, dataSetMetaData DataSetMetaDataType, dataSetFieldContentMask DataSetFieldContentMask, messageReceiveTimeout float64, keyFrameCount uint32, headerLayoutUri PascalString, securityMode MessageSecurityMode, securityGroupId PascalString, securityKeyServices []EndpointDescription, dataSetReaderProperties []KeyValuePair, transportSettings ExtensionObject, messageSettings ExtensionObject, subscribedDataSet ExtensionObject) DataSetReaderDataTypeBuilder {
	return b.WithName(name).WithEnabled(enabled).WithPublisherId(publisherId).WithWriterGroupId(writerGroupId).WithDataSetWriterId(dataSetWriterId).WithDataSetMetaData(dataSetMetaData).WithDataSetFieldContentMask(dataSetFieldContentMask).WithMessageReceiveTimeout(messageReceiveTimeout).WithKeyFrameCount(keyFrameCount).WithHeaderLayoutUri(headerLayoutUri).WithSecurityMode(securityMode).WithSecurityGroupId(securityGroupId).WithSecurityKeyServices(securityKeyServices...).WithDataSetReaderProperties(dataSetReaderProperties...).WithTransportSettings(transportSettings).WithMessageSettings(messageSettings).WithSubscribedDataSet(subscribedDataSet)
}

func (b *_DataSetReaderDataTypeBuilder) WithName(name PascalString) DataSetReaderDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) DataSetReaderDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithEnabled(enabled bool) DataSetReaderDataTypeBuilder {
	b.Enabled = enabled
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithPublisherId(publisherId Variant) DataSetReaderDataTypeBuilder {
	b.PublisherId = publisherId
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithPublisherIdBuilder(builderSupplier func(VariantBuilder) VariantBuilder) DataSetReaderDataTypeBuilder {
	builder := builderSupplier(b.PublisherId.CreateVariantBuilder())
	var err error
	b.PublisherId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "VariantBuilder failed"))
	}
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithWriterGroupId(writerGroupId uint16) DataSetReaderDataTypeBuilder {
	b.WriterGroupId = writerGroupId
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithDataSetWriterId(dataSetWriterId uint16) DataSetReaderDataTypeBuilder {
	b.DataSetWriterId = dataSetWriterId
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithDataSetMetaData(dataSetMetaData DataSetMetaDataType) DataSetReaderDataTypeBuilder {
	b.DataSetMetaData = dataSetMetaData
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithDataSetMetaDataBuilder(builderSupplier func(DataSetMetaDataTypeBuilder) DataSetMetaDataTypeBuilder) DataSetReaderDataTypeBuilder {
	builder := builderSupplier(b.DataSetMetaData.CreateDataSetMetaDataTypeBuilder())
	var err error
	b.DataSetMetaData, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "DataSetMetaDataTypeBuilder failed"))
	}
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithDataSetFieldContentMask(dataSetFieldContentMask DataSetFieldContentMask) DataSetReaderDataTypeBuilder {
	b.DataSetFieldContentMask = dataSetFieldContentMask
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithMessageReceiveTimeout(messageReceiveTimeout float64) DataSetReaderDataTypeBuilder {
	b.MessageReceiveTimeout = messageReceiveTimeout
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithKeyFrameCount(keyFrameCount uint32) DataSetReaderDataTypeBuilder {
	b.KeyFrameCount = keyFrameCount
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithHeaderLayoutUri(headerLayoutUri PascalString) DataSetReaderDataTypeBuilder {
	b.HeaderLayoutUri = headerLayoutUri
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithHeaderLayoutUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) DataSetReaderDataTypeBuilder {
	builder := builderSupplier(b.HeaderLayoutUri.CreatePascalStringBuilder())
	var err error
	b.HeaderLayoutUri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithSecurityMode(securityMode MessageSecurityMode) DataSetReaderDataTypeBuilder {
	b.SecurityMode = securityMode
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithSecurityGroupId(securityGroupId PascalString) DataSetReaderDataTypeBuilder {
	b.SecurityGroupId = securityGroupId
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithSecurityGroupIdBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) DataSetReaderDataTypeBuilder {
	builder := builderSupplier(b.SecurityGroupId.CreatePascalStringBuilder())
	var err error
	b.SecurityGroupId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithSecurityKeyServices(securityKeyServices ...EndpointDescription) DataSetReaderDataTypeBuilder {
	b.SecurityKeyServices = securityKeyServices
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithDataSetReaderProperties(dataSetReaderProperties ...KeyValuePair) DataSetReaderDataTypeBuilder {
	b.DataSetReaderProperties = dataSetReaderProperties
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithTransportSettings(transportSettings ExtensionObject) DataSetReaderDataTypeBuilder {
	b.TransportSettings = transportSettings
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithTransportSettingsBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) DataSetReaderDataTypeBuilder {
	builder := builderSupplier(b.TransportSettings.CreateExtensionObjectBuilder())
	var err error
	b.TransportSettings, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithMessageSettings(messageSettings ExtensionObject) DataSetReaderDataTypeBuilder {
	b.MessageSettings = messageSettings
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithMessageSettingsBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) DataSetReaderDataTypeBuilder {
	builder := builderSupplier(b.MessageSettings.CreateExtensionObjectBuilder())
	var err error
	b.MessageSettings, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithSubscribedDataSet(subscribedDataSet ExtensionObject) DataSetReaderDataTypeBuilder {
	b.SubscribedDataSet = subscribedDataSet
	return b
}

func (b *_DataSetReaderDataTypeBuilder) WithSubscribedDataSetBuilder(builderSupplier func(ExtensionObjectBuilder) ExtensionObjectBuilder) DataSetReaderDataTypeBuilder {
	builder := builderSupplier(b.SubscribedDataSet.CreateExtensionObjectBuilder())
	var err error
	b.SubscribedDataSet, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ExtensionObjectBuilder failed"))
	}
	return b
}

func (b *_DataSetReaderDataTypeBuilder) Build() (DataSetReaderDataType, error) {
	if b.Name == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'name' not set"))
	}
	if b.PublisherId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'publisherId' not set"))
	}
	if b.DataSetMetaData == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dataSetMetaData' not set"))
	}
	if b.HeaderLayoutUri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'headerLayoutUri' not set"))
	}
	if b.SecurityGroupId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'securityGroupId' not set"))
	}
	if b.TransportSettings == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'transportSettings' not set"))
	}
	if b.MessageSettings == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'messageSettings' not set"))
	}
	if b.SubscribedDataSet == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'subscribedDataSet' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._DataSetReaderDataType.deepCopy(), nil
}

func (b *_DataSetReaderDataTypeBuilder) MustBuild() DataSetReaderDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_DataSetReaderDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_DataSetReaderDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_DataSetReaderDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateDataSetReaderDataTypeBuilder().(*_DataSetReaderDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateDataSetReaderDataTypeBuilder creates a DataSetReaderDataTypeBuilder
func (b *_DataSetReaderDataType) CreateDataSetReaderDataTypeBuilder() DataSetReaderDataTypeBuilder {
	if b == nil {
		return NewDataSetReaderDataTypeBuilder()
	}
	return &_DataSetReaderDataTypeBuilder{_DataSetReaderDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DataSetReaderDataType) GetExtensionId() int32 {
	return int32(15625)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DataSetReaderDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DataSetReaderDataType) GetName() PascalString {
	return m.Name
}

func (m *_DataSetReaderDataType) GetEnabled() bool {
	return m.Enabled
}

func (m *_DataSetReaderDataType) GetPublisherId() Variant {
	return m.PublisherId
}

func (m *_DataSetReaderDataType) GetWriterGroupId() uint16 {
	return m.WriterGroupId
}

func (m *_DataSetReaderDataType) GetDataSetWriterId() uint16 {
	return m.DataSetWriterId
}

func (m *_DataSetReaderDataType) GetDataSetMetaData() DataSetMetaDataType {
	return m.DataSetMetaData
}

func (m *_DataSetReaderDataType) GetDataSetFieldContentMask() DataSetFieldContentMask {
	return m.DataSetFieldContentMask
}

func (m *_DataSetReaderDataType) GetMessageReceiveTimeout() float64 {
	return m.MessageReceiveTimeout
}

func (m *_DataSetReaderDataType) GetKeyFrameCount() uint32 {
	return m.KeyFrameCount
}

func (m *_DataSetReaderDataType) GetHeaderLayoutUri() PascalString {
	return m.HeaderLayoutUri
}

func (m *_DataSetReaderDataType) GetSecurityMode() MessageSecurityMode {
	return m.SecurityMode
}

func (m *_DataSetReaderDataType) GetSecurityGroupId() PascalString {
	return m.SecurityGroupId
}

func (m *_DataSetReaderDataType) GetSecurityKeyServices() []EndpointDescription {
	return m.SecurityKeyServices
}

func (m *_DataSetReaderDataType) GetDataSetReaderProperties() []KeyValuePair {
	return m.DataSetReaderProperties
}

func (m *_DataSetReaderDataType) GetTransportSettings() ExtensionObject {
	return m.TransportSettings
}

func (m *_DataSetReaderDataType) GetMessageSettings() ExtensionObject {
	return m.MessageSettings
}

func (m *_DataSetReaderDataType) GetSubscribedDataSet() ExtensionObject {
	return m.SubscribedDataSet
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastDataSetReaderDataType(structType any) DataSetReaderDataType {
	if casted, ok := structType.(DataSetReaderDataType); ok {
		return casted
	}
	if casted, ok := structType.(*DataSetReaderDataType); ok {
		return *casted
	}
	return nil
}

func (m *_DataSetReaderDataType) GetTypeName() string {
	return "DataSetReaderDataType"
}

func (m *_DataSetReaderDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Reserved Field (reserved)
	lengthInBits += 7

	// Simple field (enabled)
	lengthInBits += 1

	// Simple field (publisherId)
	lengthInBits += m.PublisherId.GetLengthInBits(ctx)

	// Simple field (writerGroupId)
	lengthInBits += 16

	// Simple field (dataSetWriterId)
	lengthInBits += 16

	// Simple field (dataSetMetaData)
	lengthInBits += m.DataSetMetaData.GetLengthInBits(ctx)

	// Simple field (dataSetFieldContentMask)
	lengthInBits += 32

	// Simple field (messageReceiveTimeout)
	lengthInBits += 64

	// Simple field (keyFrameCount)
	lengthInBits += 32

	// Simple field (headerLayoutUri)
	lengthInBits += m.HeaderLayoutUri.GetLengthInBits(ctx)

	// Simple field (securityMode)
	lengthInBits += 32

	// Simple field (securityGroupId)
	lengthInBits += m.SecurityGroupId.GetLengthInBits(ctx)

	// Implicit Field (noOfSecurityKeyServices)
	lengthInBits += 32

	// Array field
	if len(m.SecurityKeyServices) > 0 {
		for _curItem, element := range m.SecurityKeyServices {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.SecurityKeyServices), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfDataSetReaderProperties)
	lengthInBits += 32

	// Array field
	if len(m.DataSetReaderProperties) > 0 {
		for _curItem, element := range m.DataSetReaderProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DataSetReaderProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (transportSettings)
	lengthInBits += m.TransportSettings.GetLengthInBits(ctx)

	// Simple field (messageSettings)
	lengthInBits += m.MessageSettings.GetLengthInBits(ctx)

	// Simple field (subscribedDataSet)
	lengthInBits += m.SubscribedDataSet.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_DataSetReaderDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_DataSetReaderDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__dataSetReaderDataType DataSetReaderDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("DataSetReaderDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataSetReaderDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(7)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	enabled, err := ReadSimpleField(ctx, "enabled", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enabled' field"))
	}
	m.Enabled = enabled

	publisherId, err := ReadSimpleField[Variant](ctx, "publisherId", ReadComplex[Variant](VariantParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publisherId' field"))
	}
	m.PublisherId = publisherId

	writerGroupId, err := ReadSimpleField(ctx, "writerGroupId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'writerGroupId' field"))
	}
	m.WriterGroupId = writerGroupId

	dataSetWriterId, err := ReadSimpleField(ctx, "dataSetWriterId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetWriterId' field"))
	}
	m.DataSetWriterId = dataSetWriterId

	dataSetMetaData, err := ReadSimpleField[DataSetMetaDataType](ctx, "dataSetMetaData", ReadComplex[DataSetMetaDataType](ExtensionObjectDefinitionParseWithBufferProducer[DataSetMetaDataType]((int32)(int32(14525))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetMetaData' field"))
	}
	m.DataSetMetaData = dataSetMetaData

	dataSetFieldContentMask, err := ReadEnumField[DataSetFieldContentMask](ctx, "dataSetFieldContentMask", "DataSetFieldContentMask", ReadEnum(DataSetFieldContentMaskByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetFieldContentMask' field"))
	}
	m.DataSetFieldContentMask = dataSetFieldContentMask

	messageReceiveTimeout, err := ReadSimpleField(ctx, "messageReceiveTimeout", ReadDouble(readBuffer, uint8(64)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageReceiveTimeout' field"))
	}
	m.MessageReceiveTimeout = messageReceiveTimeout

	keyFrameCount, err := ReadSimpleField(ctx, "keyFrameCount", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'keyFrameCount' field"))
	}
	m.KeyFrameCount = keyFrameCount

	headerLayoutUri, err := ReadSimpleField[PascalString](ctx, "headerLayoutUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'headerLayoutUri' field"))
	}
	m.HeaderLayoutUri = headerLayoutUri

	securityMode, err := ReadEnumField[MessageSecurityMode](ctx, "securityMode", "MessageSecurityMode", ReadEnum(MessageSecurityModeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityMode' field"))
	}
	m.SecurityMode = securityMode

	securityGroupId, err := ReadSimpleField[PascalString](ctx, "securityGroupId", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityGroupId' field"))
	}
	m.SecurityGroupId = securityGroupId

	noOfSecurityKeyServices, err := ReadImplicitField[int32](ctx, "noOfSecurityKeyServices", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfSecurityKeyServices' field"))
	}
	_ = noOfSecurityKeyServices

	securityKeyServices, err := ReadCountArrayField[EndpointDescription](ctx, "securityKeyServices", ReadComplex[EndpointDescription](ExtensionObjectDefinitionParseWithBufferProducer[EndpointDescription]((int32)(int32(314))), readBuffer), uint64(noOfSecurityKeyServices))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityKeyServices' field"))
	}
	m.SecurityKeyServices = securityKeyServices

	noOfDataSetReaderProperties, err := ReadImplicitField[int32](ctx, "noOfDataSetReaderProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfDataSetReaderProperties' field"))
	}
	_ = noOfDataSetReaderProperties

	dataSetReaderProperties, err := ReadCountArrayField[KeyValuePair](ctx, "dataSetReaderProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfDataSetReaderProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dataSetReaderProperties' field"))
	}
	m.DataSetReaderProperties = dataSetReaderProperties

	transportSettings, err := ReadSimpleField[ExtensionObject](ctx, "transportSettings", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transportSettings' field"))
	}
	m.TransportSettings = transportSettings

	messageSettings, err := ReadSimpleField[ExtensionObject](ctx, "messageSettings", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'messageSettings' field"))
	}
	m.MessageSettings = messageSettings

	subscribedDataSet, err := ReadSimpleField[ExtensionObject](ctx, "subscribedDataSet", ReadComplex[ExtensionObject](ExtensionObjectParseWithBufferProducer[ExtensionObject]((bool)(bool(true))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'subscribedDataSet' field"))
	}
	m.SubscribedDataSet = subscribedDataSet

	if closeErr := readBuffer.CloseContext("DataSetReaderDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataSetReaderDataType")
	}

	return m, nil
}

func (m *_DataSetReaderDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataSetReaderDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DataSetReaderDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DataSetReaderDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 7)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[bool](ctx, "enabled", m.GetEnabled(), WriteBoolean(writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'enabled' field")
		}

		if err := WriteSimpleField[Variant](ctx, "publisherId", m.GetPublisherId(), WriteComplex[Variant](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publisherId' field")
		}

		if err := WriteSimpleField[uint16](ctx, "writerGroupId", m.GetWriterGroupId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'writerGroupId' field")
		}

		if err := WriteSimpleField[uint16](ctx, "dataSetWriterId", m.GetDataSetWriterId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetWriterId' field")
		}

		if err := WriteSimpleField[DataSetMetaDataType](ctx, "dataSetMetaData", m.GetDataSetMetaData(), WriteComplex[DataSetMetaDataType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetMetaData' field")
		}

		if err := WriteSimpleEnumField[DataSetFieldContentMask](ctx, "dataSetFieldContentMask", "DataSetFieldContentMask", m.GetDataSetFieldContentMask(), WriteEnum[DataSetFieldContentMask, uint32](DataSetFieldContentMask.GetValue, DataSetFieldContentMask.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetFieldContentMask' field")
		}

		if err := WriteSimpleField[float64](ctx, "messageReceiveTimeout", m.GetMessageReceiveTimeout(), WriteDouble(writeBuffer, 64)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageReceiveTimeout' field")
		}

		if err := WriteSimpleField[uint32](ctx, "keyFrameCount", m.GetKeyFrameCount(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'keyFrameCount' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "headerLayoutUri", m.GetHeaderLayoutUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'headerLayoutUri' field")
		}

		if err := WriteSimpleEnumField[MessageSecurityMode](ctx, "securityMode", "MessageSecurityMode", m.GetSecurityMode(), WriteEnum[MessageSecurityMode, uint32](MessageSecurityMode.GetValue, MessageSecurityMode.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'securityMode' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "securityGroupId", m.GetSecurityGroupId(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'securityGroupId' field")
		}
		noOfSecurityKeyServices := int32(utils.InlineIf(bool((m.GetSecurityKeyServices()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetSecurityKeyServices()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfSecurityKeyServices", noOfSecurityKeyServices, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfSecurityKeyServices' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "securityKeyServices", m.GetSecurityKeyServices(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'securityKeyServices' field")
		}
		noOfDataSetReaderProperties := int32(utils.InlineIf(bool((m.GetDataSetReaderProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetDataSetReaderProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfDataSetReaderProperties", noOfDataSetReaderProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfDataSetReaderProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "dataSetReaderProperties", m.GetDataSetReaderProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'dataSetReaderProperties' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "transportSettings", m.GetTransportSettings(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'transportSettings' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "messageSettings", m.GetMessageSettings(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'messageSettings' field")
		}

		if err := WriteSimpleField[ExtensionObject](ctx, "subscribedDataSet", m.GetSubscribedDataSet(), WriteComplex[ExtensionObject](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'subscribedDataSet' field")
		}

		if popErr := writeBuffer.PopContext("DataSetReaderDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DataSetReaderDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DataSetReaderDataType) IsDataSetReaderDataType() {}

func (m *_DataSetReaderDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_DataSetReaderDataType) deepCopy() *_DataSetReaderDataType {
	if m == nil {
		return nil
	}
	_DataSetReaderDataTypeCopy := &_DataSetReaderDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		m.Enabled,
		utils.DeepCopy[Variant](m.PublisherId),
		m.WriterGroupId,
		m.DataSetWriterId,
		utils.DeepCopy[DataSetMetaDataType](m.DataSetMetaData),
		m.DataSetFieldContentMask,
		m.MessageReceiveTimeout,
		m.KeyFrameCount,
		utils.DeepCopy[PascalString](m.HeaderLayoutUri),
		m.SecurityMode,
		utils.DeepCopy[PascalString](m.SecurityGroupId),
		utils.DeepCopySlice[EndpointDescription, EndpointDescription](m.SecurityKeyServices),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.DataSetReaderProperties),
		utils.DeepCopy[ExtensionObject](m.TransportSettings),
		utils.DeepCopy[ExtensionObject](m.MessageSettings),
		utils.DeepCopy[ExtensionObject](m.SubscribedDataSet),
		m.reservedField0,
	}
	_DataSetReaderDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _DataSetReaderDataTypeCopy
}

func (m *_DataSetReaderDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
