/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AnnotationDataType is the corresponding interface of AnnotationDataType
type AnnotationDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetAnnotation returns Annotation (property field)
	GetAnnotation() PascalString
	// GetDiscipline returns Discipline (property field)
	GetDiscipline() PascalString
	// GetUri returns Uri (property field)
	GetUri() PascalString
	// IsAnnotationDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAnnotationDataType()
	// CreateBuilder creates a AnnotationDataTypeBuilder
	CreateAnnotationDataTypeBuilder() AnnotationDataTypeBuilder
}

// _AnnotationDataType is the data-structure of this message
type _AnnotationDataType struct {
	ExtensionObjectDefinitionContract
	Annotation PascalString
	Discipline PascalString
	Uri        PascalString
}

var _ AnnotationDataType = (*_AnnotationDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_AnnotationDataType)(nil)

// NewAnnotationDataType factory function for _AnnotationDataType
func NewAnnotationDataType(annotation PascalString, discipline PascalString, uri PascalString) *_AnnotationDataType {
	if annotation == nil {
		panic("annotation of type PascalString for AnnotationDataType must not be nil")
	}
	if discipline == nil {
		panic("discipline of type PascalString for AnnotationDataType must not be nil")
	}
	if uri == nil {
		panic("uri of type PascalString for AnnotationDataType must not be nil")
	}
	_result := &_AnnotationDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Annotation:                        annotation,
		Discipline:                        discipline,
		Uri:                               uri,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AnnotationDataTypeBuilder is a builder for AnnotationDataType
type AnnotationDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(annotation PascalString, discipline PascalString, uri PascalString) AnnotationDataTypeBuilder
	// WithAnnotation adds Annotation (property field)
	WithAnnotation(PascalString) AnnotationDataTypeBuilder
	// WithAnnotationBuilder adds Annotation (property field) which is build by the builder
	WithAnnotationBuilder(func(PascalStringBuilder) PascalStringBuilder) AnnotationDataTypeBuilder
	// WithDiscipline adds Discipline (property field)
	WithDiscipline(PascalString) AnnotationDataTypeBuilder
	// WithDisciplineBuilder adds Discipline (property field) which is build by the builder
	WithDisciplineBuilder(func(PascalStringBuilder) PascalStringBuilder) AnnotationDataTypeBuilder
	// WithUri adds Uri (property field)
	WithUri(PascalString) AnnotationDataTypeBuilder
	// WithUriBuilder adds Uri (property field) which is build by the builder
	WithUriBuilder(func(PascalStringBuilder) PascalStringBuilder) AnnotationDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the AnnotationDataType or returns an error if something is wrong
	Build() (AnnotationDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AnnotationDataType
}

// NewAnnotationDataTypeBuilder() creates a AnnotationDataTypeBuilder
func NewAnnotationDataTypeBuilder() AnnotationDataTypeBuilder {
	return &_AnnotationDataTypeBuilder{_AnnotationDataType: new(_AnnotationDataType)}
}

type _AnnotationDataTypeBuilder struct {
	*_AnnotationDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (AnnotationDataTypeBuilder) = (*_AnnotationDataTypeBuilder)(nil)

func (b *_AnnotationDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._AnnotationDataType
}

func (b *_AnnotationDataTypeBuilder) WithMandatoryFields(annotation PascalString, discipline PascalString, uri PascalString) AnnotationDataTypeBuilder {
	return b.WithAnnotation(annotation).WithDiscipline(discipline).WithUri(uri)
}

func (b *_AnnotationDataTypeBuilder) WithAnnotation(annotation PascalString) AnnotationDataTypeBuilder {
	b.Annotation = annotation
	return b
}

func (b *_AnnotationDataTypeBuilder) WithAnnotationBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) AnnotationDataTypeBuilder {
	builder := builderSupplier(b.Annotation.CreatePascalStringBuilder())
	var err error
	b.Annotation, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_AnnotationDataTypeBuilder) WithDiscipline(discipline PascalString) AnnotationDataTypeBuilder {
	b.Discipline = discipline
	return b
}

func (b *_AnnotationDataTypeBuilder) WithDisciplineBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) AnnotationDataTypeBuilder {
	builder := builderSupplier(b.Discipline.CreatePascalStringBuilder())
	var err error
	b.Discipline, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_AnnotationDataTypeBuilder) WithUri(uri PascalString) AnnotationDataTypeBuilder {
	b.Uri = uri
	return b
}

func (b *_AnnotationDataTypeBuilder) WithUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) AnnotationDataTypeBuilder {
	builder := builderSupplier(b.Uri.CreatePascalStringBuilder())
	var err error
	b.Uri, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_AnnotationDataTypeBuilder) Build() (AnnotationDataType, error) {
	if b.Annotation == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'annotation' not set"))
	}
	if b.Discipline == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'discipline' not set"))
	}
	if b.Uri == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'uri' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AnnotationDataType.deepCopy(), nil
}

func (b *_AnnotationDataTypeBuilder) MustBuild() AnnotationDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AnnotationDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_AnnotationDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_AnnotationDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateAnnotationDataTypeBuilder().(*_AnnotationDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAnnotationDataTypeBuilder creates a AnnotationDataTypeBuilder
func (b *_AnnotationDataType) CreateAnnotationDataTypeBuilder() AnnotationDataTypeBuilder {
	if b == nil {
		return NewAnnotationDataTypeBuilder()
	}
	return &_AnnotationDataTypeBuilder{_AnnotationDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AnnotationDataType) GetExtensionId() int32 {
	return int32(32436)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AnnotationDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AnnotationDataType) GetAnnotation() PascalString {
	return m.Annotation
}

func (m *_AnnotationDataType) GetDiscipline() PascalString {
	return m.Discipline
}

func (m *_AnnotationDataType) GetUri() PascalString {
	return m.Uri
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAnnotationDataType(structType any) AnnotationDataType {
	if casted, ok := structType.(AnnotationDataType); ok {
		return casted
	}
	if casted, ok := structType.(*AnnotationDataType); ok {
		return *casted
	}
	return nil
}

func (m *_AnnotationDataType) GetTypeName() string {
	return "AnnotationDataType"
}

func (m *_AnnotationDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (annotation)
	lengthInBits += m.Annotation.GetLengthInBits(ctx)

	// Simple field (discipline)
	lengthInBits += m.Discipline.GetLengthInBits(ctx)

	// Simple field (uri)
	lengthInBits += m.Uri.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_AnnotationDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AnnotationDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__annotationDataType AnnotationDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AnnotationDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AnnotationDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	annotation, err := ReadSimpleField[PascalString](ctx, "annotation", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'annotation' field"))
	}
	m.Annotation = annotation

	discipline, err := ReadSimpleField[PascalString](ctx, "discipline", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'discipline' field"))
	}
	m.Discipline = discipline

	uri, err := ReadSimpleField[PascalString](ctx, "uri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'uri' field"))
	}
	m.Uri = uri

	if closeErr := readBuffer.CloseContext("AnnotationDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AnnotationDataType")
	}

	return m, nil
}

func (m *_AnnotationDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AnnotationDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AnnotationDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AnnotationDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "annotation", m.GetAnnotation(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'annotation' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "discipline", m.GetDiscipline(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'discipline' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "uri", m.GetUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'uri' field")
		}

		if popErr := writeBuffer.PopContext("AnnotationDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AnnotationDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AnnotationDataType) IsAnnotationDataType() {}

func (m *_AnnotationDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AnnotationDataType) deepCopy() *_AnnotationDataType {
	if m == nil {
		return nil
	}
	_AnnotationDataTypeCopy := &_AnnotationDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Annotation),
		utils.DeepCopy[PascalString](m.Discipline),
		utils.DeepCopy[PascalString](m.Uri),
	}
	_AnnotationDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _AnnotationDataTypeCopy
}

func (m *_AnnotationDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
