/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ActionTargetDataType is the corresponding interface of ActionTargetDataType
type ActionTargetDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetActionTargetId returns ActionTargetId (property field)
	GetActionTargetId() uint16
	// GetName returns Name (property field)
	GetName() PascalString
	// GetDescription returns Description (property field)
	GetDescription() LocalizedText
	// IsActionTargetDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsActionTargetDataType()
	// CreateBuilder creates a ActionTargetDataTypeBuilder
	CreateActionTargetDataTypeBuilder() ActionTargetDataTypeBuilder
}

// _ActionTargetDataType is the data-structure of this message
type _ActionTargetDataType struct {
	ExtensionObjectDefinitionContract
	ActionTargetId uint16
	Name           PascalString
	Description    LocalizedText
}

var _ ActionTargetDataType = (*_ActionTargetDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ActionTargetDataType)(nil)

// NewActionTargetDataType factory function for _ActionTargetDataType
func NewActionTargetDataType(actionTargetId uint16, name PascalString, description LocalizedText) *_ActionTargetDataType {
	if name == nil {
		panic("name of type PascalString for ActionTargetDataType must not be nil")
	}
	if description == nil {
		panic("description of type LocalizedText for ActionTargetDataType must not be nil")
	}
	_result := &_ActionTargetDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		ActionTargetId:                    actionTargetId,
		Name:                              name,
		Description:                       description,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ActionTargetDataTypeBuilder is a builder for ActionTargetDataType
type ActionTargetDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(actionTargetId uint16, name PascalString, description LocalizedText) ActionTargetDataTypeBuilder
	// WithActionTargetId adds ActionTargetId (property field)
	WithActionTargetId(uint16) ActionTargetDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) ActionTargetDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) ActionTargetDataTypeBuilder
	// WithDescription adds Description (property field)
	WithDescription(LocalizedText) ActionTargetDataTypeBuilder
	// WithDescriptionBuilder adds Description (property field) which is build by the builder
	WithDescriptionBuilder(func(LocalizedTextBuilder) LocalizedTextBuilder) ActionTargetDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ActionTargetDataType or returns an error if something is wrong
	Build() (ActionTargetDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ActionTargetDataType
}

// NewActionTargetDataTypeBuilder() creates a ActionTargetDataTypeBuilder
func NewActionTargetDataTypeBuilder() ActionTargetDataTypeBuilder {
	return &_ActionTargetDataTypeBuilder{_ActionTargetDataType: new(_ActionTargetDataType)}
}

type _ActionTargetDataTypeBuilder struct {
	*_ActionTargetDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	err *utils.MultiError
}

var _ (ActionTargetDataTypeBuilder) = (*_ActionTargetDataTypeBuilder)(nil)

func (b *_ActionTargetDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ActionTargetDataType
}

func (b *_ActionTargetDataTypeBuilder) WithMandatoryFields(actionTargetId uint16, name PascalString, description LocalizedText) ActionTargetDataTypeBuilder {
	return b.WithActionTargetId(actionTargetId).WithName(name).WithDescription(description)
}

func (b *_ActionTargetDataTypeBuilder) WithActionTargetId(actionTargetId uint16) ActionTargetDataTypeBuilder {
	b.ActionTargetId = actionTargetId
	return b
}

func (b *_ActionTargetDataTypeBuilder) WithName(name PascalString) ActionTargetDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_ActionTargetDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ActionTargetDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ActionTargetDataTypeBuilder) WithDescription(description LocalizedText) ActionTargetDataTypeBuilder {
	b.Description = description
	return b
}

func (b *_ActionTargetDataTypeBuilder) WithDescriptionBuilder(builderSupplier func(LocalizedTextBuilder) LocalizedTextBuilder) ActionTargetDataTypeBuilder {
	builder := builderSupplier(b.Description.CreateLocalizedTextBuilder())
	var err error
	b.Description, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "LocalizedTextBuilder failed"))
	}
	return b
}

func (b *_ActionTargetDataTypeBuilder) Build() (ActionTargetDataType, error) {
	if b.Name == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'name' not set"))
	}
	if b.Description == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'description' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ActionTargetDataType.deepCopy(), nil
}

func (b *_ActionTargetDataTypeBuilder) MustBuild() ActionTargetDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ActionTargetDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ActionTargetDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ActionTargetDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateActionTargetDataTypeBuilder().(*_ActionTargetDataTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateActionTargetDataTypeBuilder creates a ActionTargetDataTypeBuilder
func (b *_ActionTargetDataType) CreateActionTargetDataTypeBuilder() ActionTargetDataTypeBuilder {
	if b == nil {
		return NewActionTargetDataTypeBuilder()
	}
	return &_ActionTargetDataTypeBuilder{_ActionTargetDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ActionTargetDataType) GetExtensionId() int32 {
	return int32(18595)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ActionTargetDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ActionTargetDataType) GetActionTargetId() uint16 {
	return m.ActionTargetId
}

func (m *_ActionTargetDataType) GetName() PascalString {
	return m.Name
}

func (m *_ActionTargetDataType) GetDescription() LocalizedText {
	return m.Description
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastActionTargetDataType(structType any) ActionTargetDataType {
	if casted, ok := structType.(ActionTargetDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ActionTargetDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ActionTargetDataType) GetTypeName() string {
	return "ActionTargetDataType"
}

func (m *_ActionTargetDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (actionTargetId)
	lengthInBits += 16

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ActionTargetDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ActionTargetDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__actionTargetDataType ActionTargetDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ActionTargetDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ActionTargetDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	actionTargetId, err := ReadSimpleField(ctx, "actionTargetId", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actionTargetId' field"))
	}
	m.ActionTargetId = actionTargetId

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	description, err := ReadSimpleField[LocalizedText](ctx, "description", ReadComplex[LocalizedText](LocalizedTextParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'description' field"))
	}
	m.Description = description

	if closeErr := readBuffer.CloseContext("ActionTargetDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ActionTargetDataType")
	}

	return m, nil
}

func (m *_ActionTargetDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ActionTargetDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ActionTargetDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ActionTargetDataType")
		}

		if err := WriteSimpleField[uint16](ctx, "actionTargetId", m.GetActionTargetId(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'actionTargetId' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}

		if err := WriteSimpleField[LocalizedText](ctx, "description", m.GetDescription(), WriteComplex[LocalizedText](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'description' field")
		}

		if popErr := writeBuffer.PopContext("ActionTargetDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ActionTargetDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ActionTargetDataType) IsActionTargetDataType() {}

func (m *_ActionTargetDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ActionTargetDataType) deepCopy() *_ActionTargetDataType {
	if m == nil {
		return nil
	}
	_ActionTargetDataTypeCopy := &_ActionTargetDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.ActionTargetId,
		utils.DeepCopy[PascalString](m.Name),
		utils.DeepCopy[LocalizedText](m.Description),
	}
	_ActionTargetDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ActionTargetDataTypeCopy
}

func (m *_ActionTargetDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
