/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/codegen"
	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ModbusRtuADU is the corresponding interface of ModbusRtuADU
type ModbusRtuADU interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ModbusADU
	// GetAddress returns Address (property field)
	GetAddress() uint8
	// GetPdu returns Pdu (property field)
	GetPdu() ModbusPDU
	// IsModbusRtuADU is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsModbusRtuADU()
	// CreateBuilder creates a ModbusRtuADUBuilder
	CreateModbusRtuADUBuilder() ModbusRtuADUBuilder
}

// _ModbusRtuADU is the data-structure of this message
type _ModbusRtuADU struct {
	ModbusADUContract
	Address uint8
	Pdu     ModbusPDU
}

var _ ModbusRtuADU = (*_ModbusRtuADU)(nil)
var _ ModbusADURequirements = (*_ModbusRtuADU)(nil)

// NewModbusRtuADU factory function for _ModbusRtuADU
func NewModbusRtuADU(address uint8, pdu ModbusPDU, response bool) *_ModbusRtuADU {
	if pdu == nil {
		panic("pdu of type ModbusPDU for ModbusRtuADU must not be nil")
	}
	_result := &_ModbusRtuADU{
		ModbusADUContract: NewModbusADU(response),
		Address:           address,
		Pdu:               pdu,
	}
	_result.ModbusADUContract.(*_ModbusADU)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ModbusRtuADUBuilder is a builder for ModbusRtuADU
type ModbusRtuADUBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(address uint8, pdu ModbusPDU) ModbusRtuADUBuilder
	// WithAddress adds Address (property field)
	WithAddress(uint8) ModbusRtuADUBuilder
	// WithPdu adds Pdu (property field)
	WithPdu(ModbusPDU) ModbusRtuADUBuilder
	// WithPduBuilder adds Pdu (property field) which is build by the builder
	WithPduBuilder(func(ModbusPDUBuilder) ModbusPDUBuilder) ModbusRtuADUBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ModbusADUBuilder
	// Build builds the ModbusRtuADU or returns an error if something is wrong
	Build() (ModbusRtuADU, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ModbusRtuADU
}

// NewModbusRtuADUBuilder() creates a ModbusRtuADUBuilder
func NewModbusRtuADUBuilder() ModbusRtuADUBuilder {
	return &_ModbusRtuADUBuilder{_ModbusRtuADU: new(_ModbusRtuADU)}
}

type _ModbusRtuADUBuilder struct {
	*_ModbusRtuADU

	parentBuilder *_ModbusADUBuilder

	err *utils.MultiError
}

var _ (ModbusRtuADUBuilder) = (*_ModbusRtuADUBuilder)(nil)

func (b *_ModbusRtuADUBuilder) setParent(contract ModbusADUContract) {
	b.ModbusADUContract = contract
	contract.(*_ModbusADU)._SubType = b._ModbusRtuADU
}

func (b *_ModbusRtuADUBuilder) WithMandatoryFields(address uint8, pdu ModbusPDU) ModbusRtuADUBuilder {
	return b.WithAddress(address).WithPdu(pdu)
}

func (b *_ModbusRtuADUBuilder) WithAddress(address uint8) ModbusRtuADUBuilder {
	b.Address = address
	return b
}

func (b *_ModbusRtuADUBuilder) WithPdu(pdu ModbusPDU) ModbusRtuADUBuilder {
	b.Pdu = pdu
	return b
}

func (b *_ModbusRtuADUBuilder) WithPduBuilder(builderSupplier func(ModbusPDUBuilder) ModbusPDUBuilder) ModbusRtuADUBuilder {
	builder := builderSupplier(b.Pdu.CreateModbusPDUBuilder())
	var err error
	b.Pdu, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ModbusPDUBuilder failed"))
	}
	return b
}

func (b *_ModbusRtuADUBuilder) Build() (ModbusRtuADU, error) {
	if b.Pdu == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'pdu' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ModbusRtuADU.deepCopy(), nil
}

func (b *_ModbusRtuADUBuilder) MustBuild() ModbusRtuADU {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ModbusRtuADUBuilder) Done() ModbusADUBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewModbusADUBuilder().(*_ModbusADUBuilder)
	}
	return b.parentBuilder
}

func (b *_ModbusRtuADUBuilder) buildForModbusADU() (ModbusADU, error) {
	return b.Build()
}

func (b *_ModbusRtuADUBuilder) DeepCopy() any {
	_copy := b.CreateModbusRtuADUBuilder().(*_ModbusRtuADUBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateModbusRtuADUBuilder creates a ModbusRtuADUBuilder
func (b *_ModbusRtuADU) CreateModbusRtuADUBuilder() ModbusRtuADUBuilder {
	if b == nil {
		return NewModbusRtuADUBuilder()
	}
	return &_ModbusRtuADUBuilder{_ModbusRtuADU: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ModbusRtuADU) GetDriverType() DriverType {
	return DriverType_MODBUS_RTU
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ModbusRtuADU) GetParent() ModbusADUContract {
	return m.ModbusADUContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ModbusRtuADU) GetAddress() uint8 {
	return m.Address
}

func (m *_ModbusRtuADU) GetPdu() ModbusPDU {
	return m.Pdu
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastModbusRtuADU(structType any) ModbusRtuADU {
	if casted, ok := structType.(ModbusRtuADU); ok {
		return casted
	}
	if casted, ok := structType.(*ModbusRtuADU); ok {
		return *casted
	}
	return nil
}

func (m *_ModbusRtuADU) GetTypeName() string {
	return "ModbusRtuADU"
}

func (m *_ModbusRtuADU) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ModbusADUContract.(*_ModbusADU).getLengthInBits(ctx))

	// Simple field (address)
	lengthInBits += 8

	// Simple field (pdu)
	lengthInBits += m.Pdu.GetLengthInBits(ctx)

	// Checksum Field (checksum)
	lengthInBits += 16

	return lengthInBits
}

func (m *_ModbusRtuADU) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ModbusRtuADU) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ModbusADU, driverType DriverType, response bool) (__modbusRtuADU ModbusRtuADU, err error) {
	m.ModbusADUContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ModbusRtuADU"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ModbusRtuADU")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	address, err := ReadSimpleField(ctx, "address", ReadUnsignedByte(readBuffer, uint8(8)), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	pdu, err := ReadSimpleField[ModbusPDU](ctx, "pdu", ReadComplex[ModbusPDU](ModbusPDUParseWithBufferProducer[ModbusPDU]((bool)(response)), readBuffer), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'pdu' field"))
	}
	m.Pdu = pdu

	crc, err := ReadChecksumField[uint16](ctx, "crc", ReadUnsignedShort(readBuffer, uint8(16)), RtuCrcCheck(ctx, address, pdu), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'crc' field"))
	}
	_ = crc

	if closeErr := readBuffer.CloseContext("ModbusRtuADU"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ModbusRtuADU")
	}

	return m, nil
}

func (m *_ModbusRtuADU) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))), utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ModbusRtuADU) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ModbusRtuADU"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ModbusRtuADU")
		}

		if err := WriteSimpleField[uint8](ctx, "address", m.GetAddress(), WriteUnsignedByte(writeBuffer, 8), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'address' field")
		}

		if err := WriteSimpleField[ModbusPDU](ctx, "pdu", m.GetPdu(), WriteComplex[ModbusPDU](writeBuffer), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'pdu' field")
		}

		if err := WriteChecksumField[uint16](ctx, "crc", RtuCrcCheck(ctx, m.GetAddress(), m.GetPdu()), WriteUnsignedShort(writeBuffer, 16), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'crc' field")
		}

		if popErr := writeBuffer.PopContext("ModbusRtuADU"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ModbusRtuADU")
		}
		return nil
	}
	return m.ModbusADUContract.(*_ModbusADU).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ModbusRtuADU) IsModbusRtuADU() {}

func (m *_ModbusRtuADU) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ModbusRtuADU) deepCopy() *_ModbusRtuADU {
	if m == nil {
		return nil
	}
	_ModbusRtuADUCopy := &_ModbusRtuADU{
		m.ModbusADUContract.(*_ModbusADU).deepCopy(),
		m.Address,
		utils.DeepCopy[ModbusPDU](m.Pdu),
	}
	_ModbusRtuADUCopy.ModbusADUContract.(*_ModbusADU)._SubType = m
	return _ModbusRtuADUCopy
}

func (m *_ModbusRtuADU) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
