/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ModbusPDUMaskWriteHoldingRegisterRequest is the corresponding interface of ModbusPDUMaskWriteHoldingRegisterRequest
type ModbusPDUMaskWriteHoldingRegisterRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ModbusPDU
	// GetReferenceAddress returns ReferenceAddress (property field)
	GetReferenceAddress() uint16
	// GetAndMask returns AndMask (property field)
	GetAndMask() uint16
	// GetOrMask returns OrMask (property field)
	GetOrMask() uint16
	// IsModbusPDUMaskWriteHoldingRegisterRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsModbusPDUMaskWriteHoldingRegisterRequest()
	// CreateBuilder creates a ModbusPDUMaskWriteHoldingRegisterRequestBuilder
	CreateModbusPDUMaskWriteHoldingRegisterRequestBuilder() ModbusPDUMaskWriteHoldingRegisterRequestBuilder
}

// _ModbusPDUMaskWriteHoldingRegisterRequest is the data-structure of this message
type _ModbusPDUMaskWriteHoldingRegisterRequest struct {
	ModbusPDUContract
	ReferenceAddress uint16
	AndMask          uint16
	OrMask           uint16
}

var _ ModbusPDUMaskWriteHoldingRegisterRequest = (*_ModbusPDUMaskWriteHoldingRegisterRequest)(nil)
var _ ModbusPDURequirements = (*_ModbusPDUMaskWriteHoldingRegisterRequest)(nil)

// NewModbusPDUMaskWriteHoldingRegisterRequest factory function for _ModbusPDUMaskWriteHoldingRegisterRequest
func NewModbusPDUMaskWriteHoldingRegisterRequest(referenceAddress uint16, andMask uint16, orMask uint16) *_ModbusPDUMaskWriteHoldingRegisterRequest {
	_result := &_ModbusPDUMaskWriteHoldingRegisterRequest{
		ModbusPDUContract: NewModbusPDU(),
		ReferenceAddress:  referenceAddress,
		AndMask:           andMask,
		OrMask:            orMask,
	}
	_result.ModbusPDUContract.(*_ModbusPDU)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ModbusPDUMaskWriteHoldingRegisterRequestBuilder is a builder for ModbusPDUMaskWriteHoldingRegisterRequest
type ModbusPDUMaskWriteHoldingRegisterRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(referenceAddress uint16, andMask uint16, orMask uint16) ModbusPDUMaskWriteHoldingRegisterRequestBuilder
	// WithReferenceAddress adds ReferenceAddress (property field)
	WithReferenceAddress(uint16) ModbusPDUMaskWriteHoldingRegisterRequestBuilder
	// WithAndMask adds AndMask (property field)
	WithAndMask(uint16) ModbusPDUMaskWriteHoldingRegisterRequestBuilder
	// WithOrMask adds OrMask (property field)
	WithOrMask(uint16) ModbusPDUMaskWriteHoldingRegisterRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ModbusPDUBuilder
	// Build builds the ModbusPDUMaskWriteHoldingRegisterRequest or returns an error if something is wrong
	Build() (ModbusPDUMaskWriteHoldingRegisterRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ModbusPDUMaskWriteHoldingRegisterRequest
}

// NewModbusPDUMaskWriteHoldingRegisterRequestBuilder() creates a ModbusPDUMaskWriteHoldingRegisterRequestBuilder
func NewModbusPDUMaskWriteHoldingRegisterRequestBuilder() ModbusPDUMaskWriteHoldingRegisterRequestBuilder {
	return &_ModbusPDUMaskWriteHoldingRegisterRequestBuilder{_ModbusPDUMaskWriteHoldingRegisterRequest: new(_ModbusPDUMaskWriteHoldingRegisterRequest)}
}

type _ModbusPDUMaskWriteHoldingRegisterRequestBuilder struct {
	*_ModbusPDUMaskWriteHoldingRegisterRequest

	parentBuilder *_ModbusPDUBuilder

	err *utils.MultiError
}

var _ (ModbusPDUMaskWriteHoldingRegisterRequestBuilder) = (*_ModbusPDUMaskWriteHoldingRegisterRequestBuilder)(nil)

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) setParent(contract ModbusPDUContract) {
	b.ModbusPDUContract = contract
	contract.(*_ModbusPDU)._SubType = b._ModbusPDUMaskWriteHoldingRegisterRequest
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) WithMandatoryFields(referenceAddress uint16, andMask uint16, orMask uint16) ModbusPDUMaskWriteHoldingRegisterRequestBuilder {
	return b.WithReferenceAddress(referenceAddress).WithAndMask(andMask).WithOrMask(orMask)
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) WithReferenceAddress(referenceAddress uint16) ModbusPDUMaskWriteHoldingRegisterRequestBuilder {
	b.ReferenceAddress = referenceAddress
	return b
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) WithAndMask(andMask uint16) ModbusPDUMaskWriteHoldingRegisterRequestBuilder {
	b.AndMask = andMask
	return b
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) WithOrMask(orMask uint16) ModbusPDUMaskWriteHoldingRegisterRequestBuilder {
	b.OrMask = orMask
	return b
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) Build() (ModbusPDUMaskWriteHoldingRegisterRequest, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ModbusPDUMaskWriteHoldingRegisterRequest.deepCopy(), nil
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) MustBuild() ModbusPDUMaskWriteHoldingRegisterRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) Done() ModbusPDUBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewModbusPDUBuilder().(*_ModbusPDUBuilder)
	}
	return b.parentBuilder
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) buildForModbusPDU() (ModbusPDU, error) {
	return b.Build()
}

func (b *_ModbusPDUMaskWriteHoldingRegisterRequestBuilder) DeepCopy() any {
	_copy := b.CreateModbusPDUMaskWriteHoldingRegisterRequestBuilder().(*_ModbusPDUMaskWriteHoldingRegisterRequestBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateModbusPDUMaskWriteHoldingRegisterRequestBuilder creates a ModbusPDUMaskWriteHoldingRegisterRequestBuilder
func (b *_ModbusPDUMaskWriteHoldingRegisterRequest) CreateModbusPDUMaskWriteHoldingRegisterRequestBuilder() ModbusPDUMaskWriteHoldingRegisterRequestBuilder {
	if b == nil {
		return NewModbusPDUMaskWriteHoldingRegisterRequestBuilder()
	}
	return &_ModbusPDUMaskWriteHoldingRegisterRequestBuilder{_ModbusPDUMaskWriteHoldingRegisterRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetErrorFlag() bool {
	return bool(false)
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetFunctionFlag() uint8 {
	return 0x16
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetResponse() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetParent() ModbusPDUContract {
	return m.ModbusPDUContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetReferenceAddress() uint16 {
	return m.ReferenceAddress
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetAndMask() uint16 {
	return m.AndMask
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetOrMask() uint16 {
	return m.OrMask
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastModbusPDUMaskWriteHoldingRegisterRequest(structType any) ModbusPDUMaskWriteHoldingRegisterRequest {
	if casted, ok := structType.(ModbusPDUMaskWriteHoldingRegisterRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ModbusPDUMaskWriteHoldingRegisterRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetTypeName() string {
	return "ModbusPDUMaskWriteHoldingRegisterRequest"
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ModbusPDUContract.(*_ModbusPDU).getLengthInBits(ctx))

	// Simple field (referenceAddress)
	lengthInBits += 16

	// Simple field (andMask)
	lengthInBits += 16

	// Simple field (orMask)
	lengthInBits += 16

	return lengthInBits
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ModbusPDU, response bool) (__modbusPDUMaskWriteHoldingRegisterRequest ModbusPDUMaskWriteHoldingRegisterRequest, err error) {
	m.ModbusPDUContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ModbusPDUMaskWriteHoldingRegisterRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ModbusPDUMaskWriteHoldingRegisterRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	referenceAddress, err := ReadSimpleField(ctx, "referenceAddress", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'referenceAddress' field"))
	}
	m.ReferenceAddress = referenceAddress

	andMask, err := ReadSimpleField(ctx, "andMask", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'andMask' field"))
	}
	m.AndMask = andMask

	orMask, err := ReadSimpleField(ctx, "orMask", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'orMask' field"))
	}
	m.OrMask = orMask

	if closeErr := readBuffer.CloseContext("ModbusPDUMaskWriteHoldingRegisterRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ModbusPDUMaskWriteHoldingRegisterRequest")
	}

	return m, nil
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ModbusPDUMaskWriteHoldingRegisterRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ModbusPDUMaskWriteHoldingRegisterRequest")
		}

		if err := WriteSimpleField[uint16](ctx, "referenceAddress", m.GetReferenceAddress(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'referenceAddress' field")
		}

		if err := WriteSimpleField[uint16](ctx, "andMask", m.GetAndMask(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'andMask' field")
		}

		if err := WriteSimpleField[uint16](ctx, "orMask", m.GetOrMask(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'orMask' field")
		}

		if popErr := writeBuffer.PopContext("ModbusPDUMaskWriteHoldingRegisterRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ModbusPDUMaskWriteHoldingRegisterRequest")
		}
		return nil
	}
	return m.ModbusPDUContract.(*_ModbusPDU).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) IsModbusPDUMaskWriteHoldingRegisterRequest() {}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) deepCopy() *_ModbusPDUMaskWriteHoldingRegisterRequest {
	if m == nil {
		return nil
	}
	_ModbusPDUMaskWriteHoldingRegisterRequestCopy := &_ModbusPDUMaskWriteHoldingRegisterRequest{
		m.ModbusPDUContract.(*_ModbusPDU).deepCopy(),
		m.ReferenceAddress,
		m.AndMask,
		m.OrMask,
	}
	_ModbusPDUMaskWriteHoldingRegisterRequestCopy.ModbusPDUContract.(*_ModbusPDU)._SubType = m
	return _ModbusPDUMaskWriteHoldingRegisterRequestCopy
}

func (m *_ModbusPDUMaskWriteHoldingRegisterRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
