/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ModbusErrorCode is an enum
type ModbusErrorCode uint8

type IModbusErrorCode interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	ModbusErrorCode_ILLEGAL_FUNCTION                        ModbusErrorCode = 1
	ModbusErrorCode_ILLEGAL_DATA_ADDRESS                    ModbusErrorCode = 2
	ModbusErrorCode_ILLEGAL_DATA_VALUE                      ModbusErrorCode = 3
	ModbusErrorCode_SLAVE_DEVICE_FAILURE                    ModbusErrorCode = 4
	ModbusErrorCode_ACKNOWLEDGE                             ModbusErrorCode = 5
	ModbusErrorCode_SLAVE_DEVICE_BUSY                       ModbusErrorCode = 6
	ModbusErrorCode_NEGATIVE_ACKNOWLEDGE                    ModbusErrorCode = 7
	ModbusErrorCode_MEMORY_PARITY_ERROR                     ModbusErrorCode = 8
	ModbusErrorCode_GATEWAY_PATH_UNAVAILABLE                ModbusErrorCode = 10
	ModbusErrorCode_GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND ModbusErrorCode = 11
)

var ModbusErrorCodeValues []ModbusErrorCode

func init() {
	_ = errors.New
	ModbusErrorCodeValues = []ModbusErrorCode{
		ModbusErrorCode_ILLEGAL_FUNCTION,
		ModbusErrorCode_ILLEGAL_DATA_ADDRESS,
		ModbusErrorCode_ILLEGAL_DATA_VALUE,
		ModbusErrorCode_SLAVE_DEVICE_FAILURE,
		ModbusErrorCode_ACKNOWLEDGE,
		ModbusErrorCode_SLAVE_DEVICE_BUSY,
		ModbusErrorCode_NEGATIVE_ACKNOWLEDGE,
		ModbusErrorCode_MEMORY_PARITY_ERROR,
		ModbusErrorCode_GATEWAY_PATH_UNAVAILABLE,
		ModbusErrorCode_GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND,
	}
}

func ModbusErrorCodeByValue(value uint8) (enum ModbusErrorCode, ok bool) {
	switch value {
	case 1:
		return ModbusErrorCode_ILLEGAL_FUNCTION, true
	case 10:
		return ModbusErrorCode_GATEWAY_PATH_UNAVAILABLE, true
	case 11:
		return ModbusErrorCode_GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND, true
	case 2:
		return ModbusErrorCode_ILLEGAL_DATA_ADDRESS, true
	case 3:
		return ModbusErrorCode_ILLEGAL_DATA_VALUE, true
	case 4:
		return ModbusErrorCode_SLAVE_DEVICE_FAILURE, true
	case 5:
		return ModbusErrorCode_ACKNOWLEDGE, true
	case 6:
		return ModbusErrorCode_SLAVE_DEVICE_BUSY, true
	case 7:
		return ModbusErrorCode_NEGATIVE_ACKNOWLEDGE, true
	case 8:
		return ModbusErrorCode_MEMORY_PARITY_ERROR, true
	}
	return 0, false
}

func ModbusErrorCodeByName(value string) (enum ModbusErrorCode, ok bool) {
	switch value {
	case "ILLEGAL_FUNCTION":
		return ModbusErrorCode_ILLEGAL_FUNCTION, true
	case "GATEWAY_PATH_UNAVAILABLE":
		return ModbusErrorCode_GATEWAY_PATH_UNAVAILABLE, true
	case "GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND":
		return ModbusErrorCode_GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND, true
	case "ILLEGAL_DATA_ADDRESS":
		return ModbusErrorCode_ILLEGAL_DATA_ADDRESS, true
	case "ILLEGAL_DATA_VALUE":
		return ModbusErrorCode_ILLEGAL_DATA_VALUE, true
	case "SLAVE_DEVICE_FAILURE":
		return ModbusErrorCode_SLAVE_DEVICE_FAILURE, true
	case "ACKNOWLEDGE":
		return ModbusErrorCode_ACKNOWLEDGE, true
	case "SLAVE_DEVICE_BUSY":
		return ModbusErrorCode_SLAVE_DEVICE_BUSY, true
	case "NEGATIVE_ACKNOWLEDGE":
		return ModbusErrorCode_NEGATIVE_ACKNOWLEDGE, true
	case "MEMORY_PARITY_ERROR":
		return ModbusErrorCode_MEMORY_PARITY_ERROR, true
	}
	return 0, false
}

func ModbusErrorCodeKnows(value uint8) bool {
	for _, typeValue := range ModbusErrorCodeValues {
		if uint8(typeValue) == value {
			return true
		}
	}
	return false
}

func CastModbusErrorCode(structType any) ModbusErrorCode {
	castFunc := func(typ any) ModbusErrorCode {
		if sModbusErrorCode, ok := typ.(ModbusErrorCode); ok {
			return sModbusErrorCode
		}
		return 0
	}
	return castFunc(structType)
}

func (m ModbusErrorCode) GetLengthInBits(ctx context.Context) uint16 {
	return 8
}

func (m ModbusErrorCode) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ModbusErrorCodeParse(ctx context.Context, theBytes []byte) (ModbusErrorCode, error) {
	return ModbusErrorCodeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ModbusErrorCodeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ModbusErrorCode, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("ModbusErrorCode", 8)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ModbusErrorCode")
	}
	if enum, ok := ModbusErrorCodeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for ModbusErrorCode")
		return ModbusErrorCode(val), nil
	} else {
		return enum, nil
	}
}

func (e ModbusErrorCode) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e ModbusErrorCode) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint8("ModbusErrorCode", 8, uint8(uint8(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e ModbusErrorCode) GetValue() uint8 {
	return uint8(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ModbusErrorCode) PLC4XEnumName() string {
	switch e {
	case ModbusErrorCode_ILLEGAL_FUNCTION:
		return "ILLEGAL_FUNCTION"
	case ModbusErrorCode_GATEWAY_PATH_UNAVAILABLE:
		return "GATEWAY_PATH_UNAVAILABLE"
	case ModbusErrorCode_GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND:
		return "GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND"
	case ModbusErrorCode_ILLEGAL_DATA_ADDRESS:
		return "ILLEGAL_DATA_ADDRESS"
	case ModbusErrorCode_ILLEGAL_DATA_VALUE:
		return "ILLEGAL_DATA_VALUE"
	case ModbusErrorCode_SLAVE_DEVICE_FAILURE:
		return "SLAVE_DEVICE_FAILURE"
	case ModbusErrorCode_ACKNOWLEDGE:
		return "ACKNOWLEDGE"
	case ModbusErrorCode_SLAVE_DEVICE_BUSY:
		return "SLAVE_DEVICE_BUSY"
	case ModbusErrorCode_NEGATIVE_ACKNOWLEDGE:
		return "NEGATIVE_ACKNOWLEDGE"
	case ModbusErrorCode_MEMORY_PARITY_ERROR:
		return "MEMORY_PARITY_ERROR"
	}
	return fmt.Sprintf("Unknown(%v)", uint8(e))
}

func (e ModbusErrorCode) String() string {
	return e.PLC4XEnumName()
}
