/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TDataConnectedInd is the corresponding interface of TDataConnectedInd
type TDataConnectedInd interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CEMI
	// IsTDataConnectedInd is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTDataConnectedInd()
	// CreateBuilder creates a TDataConnectedIndBuilder
	CreateTDataConnectedIndBuilder() TDataConnectedIndBuilder
}

// _TDataConnectedInd is the data-structure of this message
type _TDataConnectedInd struct {
	CEMIContract
}

var _ TDataConnectedInd = (*_TDataConnectedInd)(nil)
var _ CEMIRequirements = (*_TDataConnectedInd)(nil)

// NewTDataConnectedInd factory function for _TDataConnectedInd
func NewTDataConnectedInd(size uint16) *_TDataConnectedInd {
	_result := &_TDataConnectedInd{
		CEMIContract: NewCEMI(size),
	}
	_result.CEMIContract.(*_CEMI)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TDataConnectedIndBuilder is a builder for TDataConnectedInd
type TDataConnectedIndBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() TDataConnectedIndBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CEMIBuilder
	// Build builds the TDataConnectedInd or returns an error if something is wrong
	Build() (TDataConnectedInd, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TDataConnectedInd
}

// NewTDataConnectedIndBuilder() creates a TDataConnectedIndBuilder
func NewTDataConnectedIndBuilder() TDataConnectedIndBuilder {
	return &_TDataConnectedIndBuilder{_TDataConnectedInd: new(_TDataConnectedInd)}
}

type _TDataConnectedIndBuilder struct {
	*_TDataConnectedInd

	parentBuilder *_CEMIBuilder

	err *utils.MultiError
}

var _ (TDataConnectedIndBuilder) = (*_TDataConnectedIndBuilder)(nil)

func (b *_TDataConnectedIndBuilder) setParent(contract CEMIContract) {
	b.CEMIContract = contract
	contract.(*_CEMI)._SubType = b._TDataConnectedInd
}

func (b *_TDataConnectedIndBuilder) WithMandatoryFields() TDataConnectedIndBuilder {
	return b
}

func (b *_TDataConnectedIndBuilder) Build() (TDataConnectedInd, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._TDataConnectedInd.deepCopy(), nil
}

func (b *_TDataConnectedIndBuilder) MustBuild() TDataConnectedInd {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TDataConnectedIndBuilder) Done() CEMIBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCEMIBuilder().(*_CEMIBuilder)
	}
	return b.parentBuilder
}

func (b *_TDataConnectedIndBuilder) buildForCEMI() (CEMI, error) {
	return b.Build()
}

func (b *_TDataConnectedIndBuilder) DeepCopy() any {
	_copy := b.CreateTDataConnectedIndBuilder().(*_TDataConnectedIndBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateTDataConnectedIndBuilder creates a TDataConnectedIndBuilder
func (b *_TDataConnectedInd) CreateTDataConnectedIndBuilder() TDataConnectedIndBuilder {
	if b == nil {
		return NewTDataConnectedIndBuilder()
	}
	return &_TDataConnectedIndBuilder{_TDataConnectedInd: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_TDataConnectedInd) GetMessageCode() uint8 {
	return 0x89
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TDataConnectedInd) GetParent() CEMIContract {
	return m.CEMIContract
}

// Deprecated: use the interface for direct cast
func CastTDataConnectedInd(structType any) TDataConnectedInd {
	if casted, ok := structType.(TDataConnectedInd); ok {
		return casted
	}
	if casted, ok := structType.(*TDataConnectedInd); ok {
		return *casted
	}
	return nil
}

func (m *_TDataConnectedInd) GetTypeName() string {
	return "TDataConnectedInd"
}

func (m *_TDataConnectedInd) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CEMIContract.(*_CEMI).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_TDataConnectedInd) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_TDataConnectedInd) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CEMI, size uint16) (__tDataConnectedInd TDataConnectedInd, err error) {
	m.CEMIContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TDataConnectedInd"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TDataConnectedInd")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("TDataConnectedInd"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TDataConnectedInd")
	}

	return m, nil
}

func (m *_TDataConnectedInd) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TDataConnectedInd) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TDataConnectedInd"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TDataConnectedInd")
		}

		if popErr := writeBuffer.PopContext("TDataConnectedInd"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TDataConnectedInd")
		}
		return nil
	}
	return m.CEMIContract.(*_CEMI).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TDataConnectedInd) IsTDataConnectedInd() {}

func (m *_TDataConnectedInd) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TDataConnectedInd) deepCopy() *_TDataConnectedInd {
	if m == nil {
		return nil
	}
	_TDataConnectedIndCopy := &_TDataConnectedInd{
		m.CEMIContract.(*_CEMI).deepCopy(),
	}
	_TDataConnectedIndCopy.CEMIContract.(*_CEMI)._SubType = m
	return _TDataConnectedIndCopy
}

func (m *_TDataConnectedInd) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
