/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LRawInd is the corresponding interface of LRawInd
type LRawInd interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CEMI
	// IsLRawInd is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLRawInd()
	// CreateBuilder creates a LRawIndBuilder
	CreateLRawIndBuilder() LRawIndBuilder
}

// _LRawInd is the data-structure of this message
type _LRawInd struct {
	CEMIContract
}

var _ LRawInd = (*_LRawInd)(nil)
var _ CEMIRequirements = (*_LRawInd)(nil)

// NewLRawInd factory function for _LRawInd
func NewLRawInd(size uint16) *_LRawInd {
	_result := &_LRawInd{
		CEMIContract: NewCEMI(size),
	}
	_result.CEMIContract.(*_CEMI)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LRawIndBuilder is a builder for LRawInd
type LRawIndBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() LRawIndBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CEMIBuilder
	// Build builds the LRawInd or returns an error if something is wrong
	Build() (LRawInd, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LRawInd
}

// NewLRawIndBuilder() creates a LRawIndBuilder
func NewLRawIndBuilder() LRawIndBuilder {
	return &_LRawIndBuilder{_LRawInd: new(_LRawInd)}
}

type _LRawIndBuilder struct {
	*_LRawInd

	parentBuilder *_CEMIBuilder

	err *utils.MultiError
}

var _ (LRawIndBuilder) = (*_LRawIndBuilder)(nil)

func (b *_LRawIndBuilder) setParent(contract CEMIContract) {
	b.CEMIContract = contract
	contract.(*_CEMI)._SubType = b._LRawInd
}

func (b *_LRawIndBuilder) WithMandatoryFields() LRawIndBuilder {
	return b
}

func (b *_LRawIndBuilder) Build() (LRawInd, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._LRawInd.deepCopy(), nil
}

func (b *_LRawIndBuilder) MustBuild() LRawInd {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LRawIndBuilder) Done() CEMIBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCEMIBuilder().(*_CEMIBuilder)
	}
	return b.parentBuilder
}

func (b *_LRawIndBuilder) buildForCEMI() (CEMI, error) {
	return b.Build()
}

func (b *_LRawIndBuilder) DeepCopy() any {
	_copy := b.CreateLRawIndBuilder().(*_LRawIndBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateLRawIndBuilder creates a LRawIndBuilder
func (b *_LRawInd) CreateLRawIndBuilder() LRawIndBuilder {
	if b == nil {
		return NewLRawIndBuilder()
	}
	return &_LRawIndBuilder{_LRawInd: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LRawInd) GetMessageCode() uint8 {
	return 0x2D
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LRawInd) GetParent() CEMIContract {
	return m.CEMIContract
}

// Deprecated: use the interface for direct cast
func CastLRawInd(structType any) LRawInd {
	if casted, ok := structType.(LRawInd); ok {
		return casted
	}
	if casted, ok := structType.(*LRawInd); ok {
		return *casted
	}
	return nil
}

func (m *_LRawInd) GetTypeName() string {
	return "LRawInd"
}

func (m *_LRawInd) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CEMIContract.(*_CEMI).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_LRawInd) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LRawInd) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CEMI, size uint16) (__lRawInd LRawInd, err error) {
	m.CEMIContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LRawInd"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LRawInd")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("LRawInd"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LRawInd")
	}

	return m, nil
}

func (m *_LRawInd) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LRawInd) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LRawInd"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LRawInd")
		}

		if popErr := writeBuffer.PopContext("LRawInd"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LRawInd")
		}
		return nil
	}
	return m.CEMIContract.(*_CEMI).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LRawInd) IsLRawInd() {}

func (m *_LRawInd) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LRawInd) deepCopy() *_LRawInd {
	if m == nil {
		return nil
	}
	_LRawIndCopy := &_LRawInd{
		m.CEMIContract.(*_CEMI).deepCopy(),
	}
	_LRawIndCopy.CEMIContract.(*_CEMI)._SubType = m
	return _LRawIndCopy
}

func (m *_LRawInd) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
