/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LPollData is the corresponding interface of LPollData
type LPollData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	LDataFrame
	// GetSourceAddress returns SourceAddress (property field)
	GetSourceAddress() KnxAddress
	// GetTargetAddress returns TargetAddress (property field)
	GetTargetAddress() []byte
	// GetNumberExpectedPollData returns NumberExpectedPollData (property field)
	GetNumberExpectedPollData() uint8
	// IsLPollData is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLPollData()
	// CreateBuilder creates a LPollDataBuilder
	CreateLPollDataBuilder() LPollDataBuilder
}

// _LPollData is the data-structure of this message
type _LPollData struct {
	LDataFrameContract
	SourceAddress          KnxAddress
	TargetAddress          []byte
	NumberExpectedPollData uint8
	// Reserved Fields
	reservedField0 *uint8
}

var _ LPollData = (*_LPollData)(nil)
var _ LDataFrameRequirements = (*_LPollData)(nil)

// NewLPollData factory function for _LPollData
func NewLPollData(frameType bool, notRepeated bool, priority CEMIPriority, acknowledgeRequested bool, errorFlag bool, sourceAddress KnxAddress, targetAddress []byte, numberExpectedPollData uint8) *_LPollData {
	if sourceAddress == nil {
		panic("sourceAddress of type KnxAddress for LPollData must not be nil")
	}
	_result := &_LPollData{
		LDataFrameContract:     NewLDataFrame(frameType, notRepeated, priority, acknowledgeRequested, errorFlag),
		SourceAddress:          sourceAddress,
		TargetAddress:          targetAddress,
		NumberExpectedPollData: numberExpectedPollData,
	}
	_result.LDataFrameContract.(*_LDataFrame)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LPollDataBuilder is a builder for LPollData
type LPollDataBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(sourceAddress KnxAddress, targetAddress []byte, numberExpectedPollData uint8) LPollDataBuilder
	// WithSourceAddress adds SourceAddress (property field)
	WithSourceAddress(KnxAddress) LPollDataBuilder
	// WithSourceAddressBuilder adds SourceAddress (property field) which is build by the builder
	WithSourceAddressBuilder(func(KnxAddressBuilder) KnxAddressBuilder) LPollDataBuilder
	// WithTargetAddress adds TargetAddress (property field)
	WithTargetAddress(...byte) LPollDataBuilder
	// WithNumberExpectedPollData adds NumberExpectedPollData (property field)
	WithNumberExpectedPollData(uint8) LPollDataBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() LDataFrameBuilder
	// Build builds the LPollData or returns an error if something is wrong
	Build() (LPollData, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LPollData
}

// NewLPollDataBuilder() creates a LPollDataBuilder
func NewLPollDataBuilder() LPollDataBuilder {
	return &_LPollDataBuilder{_LPollData: new(_LPollData)}
}

type _LPollDataBuilder struct {
	*_LPollData

	parentBuilder *_LDataFrameBuilder

	err *utils.MultiError
}

var _ (LPollDataBuilder) = (*_LPollDataBuilder)(nil)

func (b *_LPollDataBuilder) setParent(contract LDataFrameContract) {
	b.LDataFrameContract = contract
	contract.(*_LDataFrame)._SubType = b._LPollData
}

func (b *_LPollDataBuilder) WithMandatoryFields(sourceAddress KnxAddress, targetAddress []byte, numberExpectedPollData uint8) LPollDataBuilder {
	return b.WithSourceAddress(sourceAddress).WithTargetAddress(targetAddress...).WithNumberExpectedPollData(numberExpectedPollData)
}

func (b *_LPollDataBuilder) WithSourceAddress(sourceAddress KnxAddress) LPollDataBuilder {
	b.SourceAddress = sourceAddress
	return b
}

func (b *_LPollDataBuilder) WithSourceAddressBuilder(builderSupplier func(KnxAddressBuilder) KnxAddressBuilder) LPollDataBuilder {
	builder := builderSupplier(b.SourceAddress.CreateKnxAddressBuilder())
	var err error
	b.SourceAddress, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "KnxAddressBuilder failed"))
	}
	return b
}

func (b *_LPollDataBuilder) WithTargetAddress(targetAddress ...byte) LPollDataBuilder {
	b.TargetAddress = targetAddress
	return b
}

func (b *_LPollDataBuilder) WithNumberExpectedPollData(numberExpectedPollData uint8) LPollDataBuilder {
	b.NumberExpectedPollData = numberExpectedPollData
	return b
}

func (b *_LPollDataBuilder) Build() (LPollData, error) {
	if b.SourceAddress == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'sourceAddress' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._LPollData.deepCopy(), nil
}

func (b *_LPollDataBuilder) MustBuild() LPollData {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LPollDataBuilder) Done() LDataFrameBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewLDataFrameBuilder().(*_LDataFrameBuilder)
	}
	return b.parentBuilder
}

func (b *_LPollDataBuilder) buildForLDataFrame() (LDataFrame, error) {
	return b.Build()
}

func (b *_LPollDataBuilder) DeepCopy() any {
	_copy := b.CreateLPollDataBuilder().(*_LPollDataBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateLPollDataBuilder creates a LPollDataBuilder
func (b *_LPollData) CreateLPollDataBuilder() LPollDataBuilder {
	if b == nil {
		return NewLPollDataBuilder()
	}
	return &_LPollDataBuilder{_LPollData: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LPollData) GetNotAckFrame() bool {
	return bool(true)
}

func (m *_LPollData) GetPolling() bool {
	return bool(true)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LPollData) GetParent() LDataFrameContract {
	return m.LDataFrameContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LPollData) GetSourceAddress() KnxAddress {
	return m.SourceAddress
}

func (m *_LPollData) GetTargetAddress() []byte {
	return m.TargetAddress
}

func (m *_LPollData) GetNumberExpectedPollData() uint8 {
	return m.NumberExpectedPollData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLPollData(structType any) LPollData {
	if casted, ok := structType.(LPollData); ok {
		return casted
	}
	if casted, ok := structType.(*LPollData); ok {
		return *casted
	}
	return nil
}

func (m *_LPollData) GetTypeName() string {
	return "LPollData"
}

func (m *_LPollData) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.LDataFrameContract.(*_LDataFrame).getLengthInBits(ctx))

	// Simple field (sourceAddress)
	lengthInBits += m.SourceAddress.GetLengthInBits(ctx)

	// Array field
	if len(m.TargetAddress) > 0 {
		lengthInBits += 8 * uint16(len(m.TargetAddress))
	}

	// Reserved Field (reserved)
	lengthInBits += 4

	// Simple field (numberExpectedPollData)
	lengthInBits += 6

	return lengthInBits
}

func (m *_LPollData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LPollData) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_LDataFrame) (__lPollData LPollData, err error) {
	m.LDataFrameContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LPollData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LPollData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	sourceAddress, err := ReadSimpleField[KnxAddress](ctx, "sourceAddress", ReadComplex[KnxAddress](KnxAddressParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sourceAddress' field"))
	}
	m.SourceAddress = sourceAddress

	targetAddress, err := readBuffer.ReadByteArray("targetAddress", int(int32(2)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'targetAddress' field"))
	}
	m.TargetAddress = targetAddress

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(4)), uint8(0x00))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	numberExpectedPollData, err := ReadSimpleField(ctx, "numberExpectedPollData", ReadUnsignedByte(readBuffer, uint8(6)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberExpectedPollData' field"))
	}
	m.NumberExpectedPollData = numberExpectedPollData

	if closeErr := readBuffer.CloseContext("LPollData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LPollData")
	}

	return m, nil
}

func (m *_LPollData) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LPollData) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LPollData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LPollData")
		}

		if err := WriteSimpleField[KnxAddress](ctx, "sourceAddress", m.GetSourceAddress(), WriteComplex[KnxAddress](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'sourceAddress' field")
		}

		if err := WriteByteArrayField(ctx, "targetAddress", m.GetTargetAddress(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'targetAddress' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 4)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[uint8](ctx, "numberExpectedPollData", m.GetNumberExpectedPollData(), WriteUnsignedByte(writeBuffer, 6)); err != nil {
			return errors.Wrap(err, "Error serializing 'numberExpectedPollData' field")
		}

		if popErr := writeBuffer.PopContext("LPollData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LPollData")
		}
		return nil
	}
	return m.LDataFrameContract.(*_LDataFrame).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LPollData) IsLPollData() {}

func (m *_LPollData) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LPollData) deepCopy() *_LPollData {
	if m == nil {
		return nil
	}
	_LPollDataCopy := &_LPollData{
		m.LDataFrameContract.(*_LDataFrame).deepCopy(),
		utils.DeepCopy[KnxAddress](m.SourceAddress),
		utils.DeepCopySlice[byte, byte](m.TargetAddress),
		m.NumberExpectedPollData,
		m.reservedField0,
	}
	_LPollDataCopy.LDataFrameContract.(*_LDataFrame)._SubType = m
	return _LPollDataCopy
}

func (m *_LPollData) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
