/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtReadRoutingTableResponse is the corresponding interface of ApduDataExtReadRoutingTableResponse
type ApduDataExtReadRoutingTableResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduDataExt
	// IsApduDataExtReadRoutingTableResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataExtReadRoutingTableResponse()
	// CreateBuilder creates a ApduDataExtReadRoutingTableResponseBuilder
	CreateApduDataExtReadRoutingTableResponseBuilder() ApduDataExtReadRoutingTableResponseBuilder
}

// _ApduDataExtReadRoutingTableResponse is the data-structure of this message
type _ApduDataExtReadRoutingTableResponse struct {
	ApduDataExtContract
}

var _ ApduDataExtReadRoutingTableResponse = (*_ApduDataExtReadRoutingTableResponse)(nil)
var _ ApduDataExtRequirements = (*_ApduDataExtReadRoutingTableResponse)(nil)

// NewApduDataExtReadRoutingTableResponse factory function for _ApduDataExtReadRoutingTableResponse
func NewApduDataExtReadRoutingTableResponse(length uint8) *_ApduDataExtReadRoutingTableResponse {
	_result := &_ApduDataExtReadRoutingTableResponse{
		ApduDataExtContract: NewApduDataExt(length),
	}
	_result.ApduDataExtContract.(*_ApduDataExt)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataExtReadRoutingTableResponseBuilder is a builder for ApduDataExtReadRoutingTableResponse
type ApduDataExtReadRoutingTableResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() ApduDataExtReadRoutingTableResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataExtBuilder
	// Build builds the ApduDataExtReadRoutingTableResponse or returns an error if something is wrong
	Build() (ApduDataExtReadRoutingTableResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataExtReadRoutingTableResponse
}

// NewApduDataExtReadRoutingTableResponseBuilder() creates a ApduDataExtReadRoutingTableResponseBuilder
func NewApduDataExtReadRoutingTableResponseBuilder() ApduDataExtReadRoutingTableResponseBuilder {
	return &_ApduDataExtReadRoutingTableResponseBuilder{_ApduDataExtReadRoutingTableResponse: new(_ApduDataExtReadRoutingTableResponse)}
}

type _ApduDataExtReadRoutingTableResponseBuilder struct {
	*_ApduDataExtReadRoutingTableResponse

	parentBuilder *_ApduDataExtBuilder

	err *utils.MultiError
}

var _ (ApduDataExtReadRoutingTableResponseBuilder) = (*_ApduDataExtReadRoutingTableResponseBuilder)(nil)

func (b *_ApduDataExtReadRoutingTableResponseBuilder) setParent(contract ApduDataExtContract) {
	b.ApduDataExtContract = contract
	contract.(*_ApduDataExt)._SubType = b._ApduDataExtReadRoutingTableResponse
}

func (b *_ApduDataExtReadRoutingTableResponseBuilder) WithMandatoryFields() ApduDataExtReadRoutingTableResponseBuilder {
	return b
}

func (b *_ApduDataExtReadRoutingTableResponseBuilder) Build() (ApduDataExtReadRoutingTableResponse, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApduDataExtReadRoutingTableResponse.deepCopy(), nil
}

func (b *_ApduDataExtReadRoutingTableResponseBuilder) MustBuild() ApduDataExtReadRoutingTableResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataExtReadRoutingTableResponseBuilder) Done() ApduDataExtBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataExtBuilder().(*_ApduDataExtBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataExtReadRoutingTableResponseBuilder) buildForApduDataExt() (ApduDataExt, error) {
	return b.Build()
}

func (b *_ApduDataExtReadRoutingTableResponseBuilder) DeepCopy() any {
	_copy := b.CreateApduDataExtReadRoutingTableResponseBuilder().(*_ApduDataExtReadRoutingTableResponseBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApduDataExtReadRoutingTableResponseBuilder creates a ApduDataExtReadRoutingTableResponseBuilder
func (b *_ApduDataExtReadRoutingTableResponse) CreateApduDataExtReadRoutingTableResponseBuilder() ApduDataExtReadRoutingTableResponseBuilder {
	if b == nil {
		return NewApduDataExtReadRoutingTableResponseBuilder()
	}
	return &_ApduDataExtReadRoutingTableResponseBuilder{_ApduDataExtReadRoutingTableResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtReadRoutingTableResponse) GetExtApciType() uint8 {
	return 0x02
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtReadRoutingTableResponse) GetParent() ApduDataExtContract {
	return m.ApduDataExtContract
}

// Deprecated: use the interface for direct cast
func CastApduDataExtReadRoutingTableResponse(structType any) ApduDataExtReadRoutingTableResponse {
	if casted, ok := structType.(ApduDataExtReadRoutingTableResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtReadRoutingTableResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtReadRoutingTableResponse) GetTypeName() string {
	return "ApduDataExtReadRoutingTableResponse"
}

func (m *_ApduDataExtReadRoutingTableResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataExtContract.(*_ApduDataExt).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_ApduDataExtReadRoutingTableResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataExtReadRoutingTableResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduDataExt, length uint8) (__apduDataExtReadRoutingTableResponse ApduDataExtReadRoutingTableResponse, err error) {
	m.ApduDataExtContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtReadRoutingTableResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtReadRoutingTableResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtReadRoutingTableResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtReadRoutingTableResponse")
	}

	return m, nil
}

func (m *_ApduDataExtReadRoutingTableResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataExtReadRoutingTableResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtReadRoutingTableResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtReadRoutingTableResponse")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtReadRoutingTableResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtReadRoutingTableResponse")
		}
		return nil
	}
	return m.ApduDataExtContract.(*_ApduDataExt).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataExtReadRoutingTableResponse) IsApduDataExtReadRoutingTableResponse() {}

func (m *_ApduDataExtReadRoutingTableResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataExtReadRoutingTableResponse) deepCopy() *_ApduDataExtReadRoutingTableResponse {
	if m == nil {
		return nil
	}
	_ApduDataExtReadRoutingTableResponseCopy := &_ApduDataExtReadRoutingTableResponse{
		m.ApduDataExtContract.(*_ApduDataExt).deepCopy(),
	}
	_ApduDataExtReadRoutingTableResponseCopy.ApduDataExtContract.(*_ApduDataExt)._SubType = m
	return _ApduDataExtReadRoutingTableResponseCopy
}

func (m *_ApduDataExtReadRoutingTableResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
